/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.controller;

import com.ebaiyihui.medical.core.exception.OutreachException;
import com.ebaiyihui.medical.core.service.RefundService;
import com.ebaiyihui.medical.pojo.vo.OutreachRequest;
import com.ebaiyihui.medical.pojo.vo.OutreachResponse;
import com.ebaiyihui.medical.pojo.vo.RefundReqVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u95e8\u8bca\u3001\u4f4f\u9662\u9000\u6b3eapi"})
@RequestMapping(value={"/api/v1/refund"})
public class RefundController {
    private static final Logger log = LoggerFactory.getLogger(RefundController.class);
    @Autowired
    private RefundService refundService;

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e", notes="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e")
    @PostMapping(value={"/outpatientRefundForHis"})
    public OutreachResponse<String> outpatientRefundForHis(@Valid @RequestBody OutreachRequest<RefundReqVO> refundRequest, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return OutreachResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutreachResponse refundResponse = null;
        try {
            refundResponse = this.refundService.outpatientRefundForHis(refundRequest);
        }
        catch (OutreachException e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u4f4f\u9662\u9884\u7f34\u91d1\u9000\u6b3e", notes="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u4f4f\u9662\u9884\u7f34\u91d1\u9000\u6b3e")
    @PostMapping(value={"/inHospitalRefundForHis"})
    public OutreachResponse<String> inHospitalRefundForHis(@Valid @RequestBody OutreachRequest<RefundReqVO> refundRequest, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return OutreachResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutreachResponse refundResponse = null;
        try {
            refundResponse = this.refundService.inHospitalRefundForHis(refundRequest);
        }
        catch (OutreachException e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }
}

