/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medical.core.dto.DailyBillDetailDTO;
import com.ebaiyihui.medical.core.enums.BusinessOrderStatusEnum;
import com.ebaiyihui.medical.core.enums.BusinessTypeEnum;
import com.ebaiyihui.medical.core.enums.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.medical.core.enums.TransTypeEnum;
import com.ebaiyihui.medical.core.exception.BillException;
import com.ebaiyihui.medical.core.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.medical.core.model.InpatientDepositDetailEntity;
import com.ebaiyihui.medical.core.model.OpBusinessOrderEntity;
import com.ebaiyihui.medical.core.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.medical.core.service.BillService;
import com.ebaiyihui.medical.core.utils.DateUtils;
import com.ebaiyihui.medical.core.vo.repsvo.BillRespVo;
import com.ebaiyihui.medical.pojo.vo.DailyBillDetailItemsResVO;
import com.ebaiyihui.medical.pojo.vo.DailyBillDetailReqVO;
import com.ebaiyihui.medical.pojo.vo.TotalDailyBillDetailResVO;
import com.ebaiyihui.medical.pojo.vo.TotalDailyBillReqVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BillServiceImpl
implements BillService {
    private static final Logger log = LoggerFactory.getLogger(BillServiceImpl.class);
    public static final String PAY_BILL = "0";
    public static final String REFUND_BILL = "1";
    public static final String INHOSP_BUSINNESS_TYPE = "3";
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;

    public List<BillRespVo> getBillByReceptId(List<String> receptIdList) throws BillException {
        List opBusinessOrderEntities = this.opBusinessOrderEntityMapper.selectByReceptIds(receptIdList);
        ArrayList<String> outPatientIdList = new ArrayList<String>();
        HashMap<String, String> receptIdAndOutPatientIdMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty((Collection)opBusinessOrderEntities)) {
            log.error("\u6839\u636ereceptIdList\u67e5\u8be2opBusinessOrderEntities\u4e3a\u7a7a\uff0c\u67e5\u8be2\u53c2\u6570\u4e3a:[{}]", (Object)JSON.toJSONString(receptIdList));
            throw new BillException("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        for (OpBusinessOrderEntity opBusinessOrderEntity : opBusinessOrderEntities) {
            String outPatientId = opBusinessOrderEntity.getOutPatientId();
            if (StringUtils.isEmpty((Object)outPatientId)) continue;
            outPatientIdList.add(outPatientId);
            receptIdAndOutPatientIdMap.put(opBusinessOrderEntity.getReceiptId(), outPatientId);
        }
        if (CollectionUtils.isEmpty(outPatientIdList)) {
            log.error("\u6839\u636ereceptIdList\u67e5\u8be2\u83b7\u53d6outPatientIdList\u4e3a\u7a7a\uff0c\u67e5\u8be2\u53c2\u6570\u4e3a:[{}]", (Object)JSON.toJSONString(receptIdList));
            throw new BillException("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        List opRechargePaymentOrderEntities = this.opRechargePaymentOrderEntityMapper.selectByOutPatientIds(outPatientIdList);
        if (CollectionUtils.isEmpty((Collection)opRechargePaymentOrderEntities)) {
            log.error("\u6839\u636eoutPatientIdList\u67e5\u8be2\u7b2c\u4e09\u65b9\u652f\u4ed8\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff0creceptIdList\u4e3a:{},outPatientIdList\u4e3a:{}", (Object)JSON.toJSONString(receptIdList), (Object)JSON.toJSONString(outPatientIdList));
            throw new BillException("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        HashMap<String, String> outPatientIdAndPayBillNoMap = new HashMap<String, String>();
        for (OpRechargePaymentOrderEntity opRechargePaymentOrderEntity : opRechargePaymentOrderEntities) {
            String payBillNo = opRechargePaymentOrderEntity.getPayBillNo();
            if (StringUtils.isEmpty((Object)payBillNo)) continue;
            outPatientIdAndPayBillNoMap.put(opRechargePaymentOrderEntity.getOutPatientId(), payBillNo);
        }
        ArrayList<BillRespVo> billRespVoList = new ArrayList<BillRespVo>();
        for (String receptId : receptIdList) {
            String outPatientId = null;
            String payBillNo = null;
            if (receptIdAndOutPatientIdMap.containsKey(receptId)) {
                outPatientId = (String)receptIdAndOutPatientIdMap.get(receptId);
            }
            if (outPatientIdAndPayBillNoMap.containsKey(outPatientId)) {
                payBillNo = (String)outPatientIdAndPayBillNoMap.get(outPatientId);
            }
            if (StringUtils.isEmpty(payBillNo)) continue;
            BillRespVo billRespVo = new BillRespVo();
            billRespVo.setReceiptId(receptId);
            billRespVo.setPayBillNo(payBillNo);
            billRespVo.setBusinessType(BusinessTypeEnum.OUTPATIENT.getValue());
            billRespVoList.add(billRespVo);
        }
        log.info("\u6839\u636ereceptIdList\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString(billRespVoList));
        return billRespVoList;
    }

    public BaseResponse<List<BillRespVo>> hospitalReconciliation(List<String> receiptIdList) {
        List billRespVoList = this.inpatientDepositDetailEntityMapper.findByReceiptId(receiptIdList);
        for (BillRespVo billRespVo : billRespVoList) {
            billRespVo.setBusinessType(BusinessTypeEnum.HOSPITAL.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)billRespVoList)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u4f4f\u9662\u8bb0\u5f55");
        }
        return BaseResponse.success((Object)billRespVoList);
    }

    public TotalDailyBillDetailResVO getOutPatientTotalBill(TotalDailyBillReqVO totalDailyBillReqVO) {
        List OpBusinessOrderEntityList = this.opBusinessOrderEntityMapper.getByCreateTimeAndStatus(totalDailyBillReqVO.getBgDate(), totalDailyBillReqVO.getEdDate());
        TotalDailyBillDetailResVO totalDailyBillDetailResVO = new TotalDailyBillDetailResVO();
        BigDecimal totalMoney = BigDecimal.ZERO;
        BigDecimal refundMoney = BigDecimal.ZERO;
        BigDecimal actualMoney = BigDecimal.ZERO;
        for (OpBusinessOrderEntity opBusinessOrderEntity : OpBusinessOrderEntityList) {
            totalMoney = totalMoney.add(opBusinessOrderEntity.getMoney());
            if (opBusinessOrderEntity.getStatus().equals(BusinessOrderStatusEnum.REFUND.getValue())) {
                refundMoney = refundMoney.add(opBusinessOrderEntity.getMoney());
            }
            if (!opBusinessOrderEntity.getStatus().equals(BusinessOrderStatusEnum.PAID.getValue())) continue;
            actualMoney = actualMoney.add(opBusinessOrderEntity.getMoney());
        }
        totalDailyBillDetailResVO.setTransDate(DateUtils.getCurrentDateToString());
        totalDailyBillDetailResVO.setTransType(TransTypeEnum.OUTPATIENT.getValue());
        totalDailyBillDetailResVO.setBusinessDesc(TransTypeEnum.OUTPATIENT.getDisplay());
        totalDailyBillDetailResVO.setTotalAmount(String.valueOf(totalMoney));
        totalDailyBillDetailResVO.setRefundMoney(String.valueOf(refundMoney));
        totalDailyBillDetailResVO.setActualMoney(String.valueOf(actualMoney));
        return totalDailyBillDetailResVO;
    }

    public TotalDailyBillDetailResVO getInHospTotalBill(TotalDailyBillReqVO totalDailyBillReqVO) {
        List depositDetailEntityList = this.inpatientDepositDetailEntityMapper.selectByCreateTime(totalDailyBillReqVO.getBgDate(), totalDailyBillReqVO.getEdDate());
        TotalDailyBillDetailResVO totalDailyBillDetailResVO = new TotalDailyBillDetailResVO();
        BigDecimal totalMoney = BigDecimal.ZERO;
        BigDecimal refundMoney = BigDecimal.ZERO;
        BigDecimal actualMoney = BigDecimal.ZERO;
        for (InpatientDepositDetailEntity depositDetailEntity : depositDetailEntityList) {
            totalMoney = totalMoney.add(depositDetailEntity.getMoney());
            if (depositDetailEntity.getStatus().equals(InpatientDepositDetailStatusEnum.REFUND.getValue())) {
                refundMoney = refundMoney.add(depositDetailEntity.getMoney());
            }
            if (!depositDetailEntity.getStatus().equals(InpatientDepositDetailStatusEnum.PAID.getValue())) continue;
            actualMoney = actualMoney.add(depositDetailEntity.getMoney());
        }
        totalDailyBillDetailResVO.setTransDate(DateUtils.getCurrentDateToString());
        totalDailyBillDetailResVO.setTransType(TransTypeEnum.INHOSPITAL.getValue());
        totalDailyBillDetailResVO.setBusinessDesc(TransTypeEnum.INHOSPITAL.getDisplay());
        totalDailyBillDetailResVO.setTotalAmount(String.valueOf(totalMoney));
        totalDailyBillDetailResVO.setRefundMoney(String.valueOf(refundMoney));
        totalDailyBillDetailResVO.setActualMoney(String.valueOf(actualMoney));
        return totalDailyBillDetailResVO;
    }

    public List<DailyBillDetailItemsResVO> getOutPatientDetailBill(DailyBillDetailReqVO dailyBillDetailReqVO) {
        ArrayList<DailyBillDetailItemsResVO> detailItemsResVOList = new ArrayList<DailyBillDetailItemsResVO>();
        List detailBill = this.opBusinessOrderEntityMapper.getDetailBillByCreateTime(dailyBillDetailReqVO.getTransDate());
        for (DailyBillDetailDTO orderEntity : detailBill) {
            DailyBillDetailItemsResVO dailyBillDetailItemsResVO = new DailyBillDetailItemsResVO();
            if (orderEntity.getStatus().equals(BusinessOrderStatusEnum.PAID.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(orderEntity.getOrderNo());
                dailyBillDetailItemsResVO.setReceiptId(orderEntity.getReceiptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(orderEntity.getBankTranSerNo());
                dailyBillDetailItemsResVO.setAmount(orderEntity.getAmount());
                dailyBillDetailItemsResVO.setTradeType(PAY_BILL);
                dailyBillDetailItemsResVO.setTransDate(orderEntity.getPayDate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.OUTPATIENT.getValue());
            }
            if (orderEntity.getStatus().equals(BusinessOrderStatusEnum.REFUND.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(orderEntity.getOrderNo());
                dailyBillDetailItemsResVO.setReceiptId(orderEntity.getReceiptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(orderEntity.getBankTranSerNo());
                dailyBillDetailItemsResVO.setAmount(orderEntity.getAmount());
                dailyBillDetailItemsResVO.setTradeType(REFUND_BILL);
                dailyBillDetailItemsResVO.setTransDate(orderEntity.getRefundDate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.OUTPATIENT.getValue());
            }
            detailItemsResVOList.add(dailyBillDetailItemsResVO);
        }
        return detailItemsResVOList;
    }

    public List<DailyBillDetailItemsResVO> getInHospDetailBill(DailyBillDetailReqVO dailyBillDetailReqVO) {
        ArrayList<DailyBillDetailItemsResVO> detailItemsResVOList = new ArrayList<DailyBillDetailItemsResVO>();
        List detailBill = this.inpatientDepositDetailEntityMapper.getDetailBillByCreateTime(dailyBillDetailReqVO.getTransDate());
        for (DailyBillDetailDTO orderEntity : detailBill) {
            DailyBillDetailItemsResVO dailyBillDetailItemsResVO = new DailyBillDetailItemsResVO();
            if (orderEntity.getStatus().equals(InpatientDepositDetailStatusEnum.PAID.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(orderEntity.getOrderNo());
                dailyBillDetailItemsResVO.setReceiptId(orderEntity.getReceiptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(orderEntity.getBankTranSerNo());
                dailyBillDetailItemsResVO.setAmount(orderEntity.getAmount());
                dailyBillDetailItemsResVO.setTradeType(PAY_BILL);
                dailyBillDetailItemsResVO.setTransDate(orderEntity.getPayDate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.INHOSPITAL.getValue());
            }
            if (orderEntity.getStatus().equals(InpatientDepositDetailStatusEnum.REFUND.getValue())) {
                dailyBillDetailItemsResVO.setOrderNo(orderEntity.getOrderNo());
                dailyBillDetailItemsResVO.setReceiptId(orderEntity.getReceiptId());
                dailyBillDetailItemsResVO.setBankTranSerNo(orderEntity.getBankTranSerNo());
                dailyBillDetailItemsResVO.setAmount(orderEntity.getAmount());
                dailyBillDetailItemsResVO.setTradeType(REFUND_BILL);
                dailyBillDetailItemsResVO.setTransDate(orderEntity.getRefundDate());
                dailyBillDetailItemsResVO.setTransType(TransTypeEnum.INHOSPITAL.getValue());
            }
            detailItemsResVOList.add(dailyBillDetailItemsResVO);
        }
        return detailItemsResVOList;
    }
}

