/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.service.impl;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoResItem;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillReqVo;
import com.ebaiyihui.medical.core.common.constant.OrganCodeConstant;
import com.ebaiyihui.medical.core.enums.BusinessOrderStatusEnum;
import com.ebaiyihui.medical.core.enums.ChannelEnum;
import com.ebaiyihui.medical.core.enums.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.medical.core.enums.OutReachOrderStatusEnum;
import com.ebaiyihui.medical.core.enums.TransTypeEnum;
import com.ebaiyihui.medical.core.exception.BillException;
import com.ebaiyihui.medical.core.exception.OutreachException;
import com.ebaiyihui.medical.core.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.medical.core.model.InpatientDepositDetailEntity;
import com.ebaiyihui.medical.core.model.InpatientPayorderEntity;
import com.ebaiyihui.medical.core.model.OpBusinessOrderEntity;
import com.ebaiyihui.medical.core.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.medical.core.service.OrderService;
import com.ebaiyihui.medical.core.utils.DateUtils;
import com.ebaiyihui.medical.core.utils.SnowflakeIdWorker;
import com.ebaiyihui.medical.core.vo.repsvo.CheckOrderResVo;
import com.ebaiyihui.medical.core.vo.repsvo.OrderRecordResVo;
import com.ebaiyihui.medical.core.vo.reqvo.CheckOrderReqVo;
import com.ebaiyihui.medical.core.vo.reqvo.OrderRecordReqVo;
import com.ebaiyihui.medical.pojo.vo.OutreachRequest;
import com.ebaiyihui.medical.pojo.vo.OutreachResponse;
import com.ebaiyihui.medical.pojo.vo.QueryOrderReqVO;
import com.ebaiyihui.medical.pojo.vo.QueryOrderResVO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    public static final String GET_REAL_TIME_HIS_BILL_INFO = "getRealTimeHisBillInfo";
    public static final String REFUND_FLAG = "1";
    public static final String NOT_REFUND_FLAG = "0";
    public static final List<String> ORDER_STATUS_LIST = Arrays.asList("1", "3", "8", "9", "10", "11", "12");
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OrganCodeConstant organCodeConstant;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper depositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper payorderEntityMapper;

    public PageResult<OrderRecordResVo> getOutPatientOrderList(OrderRecordReqVo orderRecordReqVo) {
        PageResult pageResult = new PageResult();
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        String orderStatusReq = REFUND_FLAG.equals(orderRecordReqVo.getOrderStatus()) ? "'" + StringUtils.join((Collection)ORDER_STATUS_LIST, (String)"','") + "'" : orderRecordReqVo.getOrderStatus();
        orderRecordReqVo.setOrderStatus(orderStatusReq);
        Page page = this.opBusinessOrderEntityMapper.selectByOrderRecordReqVo(orderRecordReqVo);
        List orderRecordResVoList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        for (OrderRecordResVo orderRecordResVo : orderRecordResVoList) {
            String orderStatus = String.valueOf(orderRecordResVo.getOrderStatus());
            if (ORDER_STATUS_LIST.contains(orderStatus)) {
                orderStatus = REFUND_FLAG;
            }
            orderRecordResVo.setOrderStatus(Integer.valueOf(Integer.parseInt(orderStatus)));
        }
        pageResult.setContent(orderRecordResVoList);
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        return pageResult;
    }

    public PageResult<OrderRecordResVo> getInHospOrderList(OrderRecordReqVo orderRecordReqVo) {
        return null;
    }

    public CheckOrderResVo checkOrderWhetherRefund(CheckOrderReqVo checkOrderReqVo) throws BillException {
        CheckOrderResVo checkOrderResVo = new CheckOrderResVo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(checkOrderReqVo.getOutPatientId());
        if (null == opBusinessOrderEntity) {
            throw new BillException("\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        checkOrderResVo.setPatientName(opBusinessOrderEntity.getPatientName());
        checkOrderResVo.setReceiptId(opBusinessOrderEntity.getReceiptId());
        checkOrderResVo.setPatientIdCard(opBusinessOrderEntity.getIdCard());
        checkOrderResVo.setPayBillNo(checkOrderReqVo.getPayBillNo());
        checkOrderResVo.setRemark(opBusinessOrderEntity.getRemark());
        Integer orderStatus = opBusinessOrderEntity.getStatus();
        if (ORDER_STATUS_LIST.contains(orderStatus)) {
            orderStatus = 1;
        }
        checkOrderResVo.setOrderStatus(orderStatus);
        checkOrderReqVo.setPayBillNo(opBusinessOrderEntity.getReceiptId());
        checkOrderReqVo.setStartDate(DateUtils.dateToSimpleString((Date)opBusinessOrderEntity.getCreateTime()));
        checkOrderReqVo.setEndDate(DateUtils.dateToSimpleString((Date)new Date()));
        List items = this.buildGetRealTimeHisBillReq(checkOrderReqVo);
        if (CollectionUtils.isEmpty((Collection)items)) {
            checkOrderResVo.setRefundFlag(REFUND_FLAG);
            return checkOrderResVo;
        }
        if (items.size() > 1) {
            checkOrderResVo.setRechargeMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
            checkOrderResVo.setDeductMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
        }
        checkOrderResVo.setRefundFlag(NOT_REFUND_FLAG);
        checkOrderResVo.setRechargeMoney(((GetRealTimeHisBillInfoResItem)items.get(0)).getMoney());
        return checkOrderResVo;
    }

    private List<GetRealTimeHisBillInfoResItem> buildGetRealTimeHisBillReq(CheckOrderReqVo checkOrderReqVo) throws BillException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetRealTimeHisBillReqVo getRealTimeHisBillReqVo = new GetRealTimeHisBillReqVo();
        getRealTimeHisBillReqVo.setTransType(checkOrderReqVo.getTransType());
        getRealTimeHisBillReqVo.setBeginTime(checkOrderReqVo.getStartDate());
        getRealTimeHisBillReqVo.setEndTime(checkOrderReqVo.getEndDate());
        getRealTimeHisBillReqVo.setSerialNo(checkOrderReqVo.getPayBillNo());
        gatewayRequest.setBody((Object)getRealTimeHisBillReqVo);
        gatewayRequest.setKeyWord(GET_REAL_TIME_HIS_BILL_INFO);
        gatewayRequest.setOrganCode(this.organCodeConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setChannel(ChannelEnum.MANAGER.getValue());
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getDisplay());
        log.info("\u9a8c\u8bc1\u662f\u5426\u53ef\u9000\u6b3e \u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.hisBillApi.getRealTimeHisBillInfo(gatewayRequest);
        log.info("\u9a8c\u8bc1\u662f\u5426\u53ef\u9000\u6b3e \u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        if (!REFUND_FLAG.equals(gatewayResponse.getCode())) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        GetRealTimeHisBillInfoRes getRealTimeHisBillInfoRes = (GetRealTimeHisBillInfoRes)gatewayResponse.getData();
        return getRealTimeHisBillInfoRes.getItems();
    }

    public OutreachResponse<QueryOrderResVO> outpatientOrderForHis(OutreachRequest<QueryOrderReqVO> queryOrderReqVO) throws OutreachException {
        QueryOrderReqVO body = (QueryOrderReqVO)queryOrderReqVO.getBody();
        if (null == body) {
            log.error("outpatientOrderForHis->\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8bf7\u6c42body\u4e3a\u7a7a\uff01");
        }
        QueryOrderResVO queryOrderResVO = new QueryOrderResVO();
        if (StringUtils.isNotBlank((String)body.getOrderNo())) {
            OpBusinessOrderEntity businessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(body.getOrderNo());
            if (null == businessOrderEntity) {
                log.error("outpatientOrderForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2orderNo\u4e3a:{}", (Object)body.getOrderNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            OpRechargePaymentOrderEntity rechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(body.getOrderNo());
            if (null == rechargePaymentOrderEntity) {
                log.error("outpatientOrderForHis->\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2orderNo\u4e3a:{}", (Object)body.getOrderNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            this.buildOutpatientOrderQueryOrderResVO(queryOrderResVO, businessOrderEntity, rechargePaymentOrderEntity);
        } else if (StringUtils.isNotBlank((String)body.getTradeNo())) {
            List paymentOrderEntityList = this.opRechargePaymentOrderEntityMapper.selectByPayBillNo(body.getTradeNo());
            if (CollectionUtils.isEmpty((Collection)paymentOrderEntityList)) {
                log.error("outpatientOrderForHis->\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u5931\u8d25, \u67e5\u8be2tradeNo\u4e3a{}", (Object)body.getTradeNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            OpRechargePaymentOrderEntity paymentOrderEntity = (OpRechargePaymentOrderEntity)paymentOrderEntityList.get(0);
            OpBusinessOrderEntity businessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(paymentOrderEntity.getOutPatientId());
            if (null == businessOrderEntity) {
                log.error("outpatientOrderForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2tradeNo\u4e3a:{}", (Object)body.getTradeNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            this.buildOutpatientOrderQueryOrderResVO(queryOrderResVO, businessOrderEntity, paymentOrderEntity);
        } else {
            log.error("outpatientOrderForHis->\u7f34\u8d39\u8ba2\u5355\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570orderNo\u548ctrandeNo\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            throw new OutreachException("\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570orderNo\u548ctradeNo\u4e3a\u7a7a\uff01");
        }
        OutreachResponse response = OutreachResponse.success((Object)queryOrderResVO);
        response.setTransactionId(queryOrderReqVO.getHead().getTransactionId());
        response.setTransDate(queryOrderReqVO.getHead().getTransDate());
        response.setTransTime(queryOrderReqVO.getHead().getTransTime());
        return response;
    }

    public OutreachResponse<QueryOrderResVO> inPatientDepositOrderForHis(OutreachRequest<QueryOrderReqVO> outreachRequest) throws OutreachException {
        QueryOrderReqVO body = (QueryOrderReqVO)outreachRequest.getBody();
        if (null == body) {
            log.error("inPatientDepositOrderForHis->\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8bf7\u6c42body\u4e3a\u7a7a\uff01");
        }
        QueryOrderResVO queryOrderResVO = new QueryOrderResVO();
        if (StringUtils.isNotBlank((String)body.getOrderNo())) {
            InpatientDepositDetailEntity depositDetailEntity = this.depositDetailEntityMapper.selectByOrderSeq(body.getOrderNo());
            if (null == depositDetailEntity) {
                log.error("inPatientDepositOrderForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2orderNo\u4e3a:{}", (Object)body.getOrderNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            InpatientPayorderEntity payorderEntity = this.payorderEntityMapper.selectByInpatientDepositId(depositDetailEntity.getId());
            if (null == payorderEntity) {
                log.error("inPatientDepositOrderForHis->\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2orderNo\u4e3a:{}", (Object)body.getOrderNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            this.buildInpatientDepositQueryOrderResVO(queryOrderResVO, depositDetailEntity, payorderEntity);
        } else if (StringUtils.isNotBlank((String)body.getTradeNo())) {
            List payorderEntityList = this.payorderEntityMapper.selectByPayBillNo(body.getTradeNo());
            if (CollectionUtils.isEmpty((Collection)payorderEntityList)) {
                log.error("outpatientOrderForHis->\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u5931\u8d25, \u67e5\u8be2tradeNo\u4e3a{}", (Object)body.getTradeNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            InpatientPayorderEntity payorderEntity = (InpatientPayorderEntity)payorderEntityList.get(0);
            InpatientDepositDetailEntity depositDetailEntity = this.depositDetailEntityMapper.selectByPrimaryKey(payorderEntity.getInpatientDepositId());
            if (null == depositDetailEntity) {
                log.error("inPatientDepositOrderForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2tradeNo\u4e3a:{}", (Object)body.getTradeNo());
                return OutreachResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            this.buildInpatientDepositQueryOrderResVO(queryOrderResVO, depositDetailEntity, payorderEntity);
        } else {
            log.error("inPatientDepositOrderForHis->\u7f34\u8d39\u8ba2\u5355\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570orderNo\u548ctrandeNo\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            throw new OutreachException("\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570orderNo\u548ctradeNo\u4e3a\u7a7a\uff01");
        }
        OutreachResponse response = OutreachResponse.success((Object)queryOrderResVO);
        response.setTransactionId(outreachRequest.getHead().getTransactionId());
        response.setTransDate(outreachRequest.getHead().getTransDate());
        response.setTransTime(outreachRequest.getHead().getTransTime());
        return response;
    }

    private void buildOutpatientOrderQueryOrderResVO(QueryOrderResVO queryOrderResVO, OpBusinessOrderEntity businessOrderEntity, OpRechargePaymentOrderEntity rechargePaymentOrderEntity) throws OutreachException {
        if (null == OutReachOrderStatusEnum.getDisplay((Integer)businessOrderEntity.getStatus())) {
            log.error("outpatientOrderForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u5230\u7684orderStatus\u4e3a:{}", (Object)BusinessOrderStatusEnum.getDisplay((Integer)businessOrderEntity.getStatus()));
            throw new OutreachException("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u72b6\u6001\u7684\u8d26\u5355");
        }
        queryOrderResVO.setOrderStatus(String.valueOf(OutReachOrderStatusEnum.getDisplay((Integer)businessOrderEntity.getStatus())));
        queryOrderResVO.setOrderNo(businessOrderEntity.getOutPatientId());
        queryOrderResVO.setTradeNo(rechargePaymentOrderEntity.getPayBillNo());
        queryOrderResVO.setTransType(TransTypeEnum.OUTPATIENT.getValue());
        queryOrderResVO.setPayChannel(rechargePaymentOrderEntity.getPaymentSeq());
        if (businessOrderEntity.getStatus() == BusinessOrderStatusEnum.REFUND.getValue()) {
            queryOrderResVO.setRefundAmount(String.valueOf(rechargePaymentOrderEntity.getDealMoney()));
            queryOrderResVO.setRefundTime(DateUtils.dateToFullString((Date)rechargePaymentOrderEntity.getPaymentTime()));
        }
        queryOrderResVO.setPayAmount(String.valueOf(rechargePaymentOrderEntity.getDealMoney()));
        queryOrderResVO.setPayTime(DateUtils.dateToFullString((Date)rechargePaymentOrderEntity.getPaymentTime()));
    }

    private void buildInpatientDepositQueryOrderResVO(QueryOrderResVO queryOrderResVO, InpatientDepositDetailEntity depositDetailEntity, InpatientPayorderEntity payorderEntity) throws OutreachException {
        if (null == OutReachOrderStatusEnum.getDisplay((Integer)depositDetailEntity.getStatus().intValue())) {
            log.error("outpatientOrderForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u5230\u7684orderStatus\u4e3a:{}", (Object)BusinessOrderStatusEnum.getDisplay((Integer)depositDetailEntity.getStatus().intValue()));
            throw new OutreachException("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u72b6\u6001\u7684\u8d26\u5355");
        }
        queryOrderResVO.setOrderStatus(String.valueOf(OutReachOrderStatusEnum.getDisplay((Integer)depositDetailEntity.getStatus().intValue())));
        queryOrderResVO.setOrderNo(depositDetailEntity.getOrderSeq());
        queryOrderResVO.setTransType(TransTypeEnum.INHOSPITAL.getValue());
        queryOrderResVO.setTradeNo(payorderEntity.getPayBillNo());
        queryOrderResVO.setPayChannel(payorderEntity.getPaymentSeq());
        if (depositDetailEntity.getStatus().intValue() == InpatientDepositDetailStatusEnum.REFUND.getValue().intValue()) {
            queryOrderResVO.setRefundAmount(String.valueOf(payorderEntity.getDealMoney()));
            queryOrderResVO.setRefundTime(DateUtils.dateToFullString((Date)payorderEntity.getPaymentTime()));
        }
        queryOrderResVO.setPayAmount(String.valueOf(payorderEntity.getDealMoney()));
        queryOrderResVO.setPayTime(DateUtils.dateToFullString((Date)payorderEntity.getPaymentTime()));
    }
}

