/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.client.ICardServiceFeginClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.medical.core.common.constant.OrganCodeConstant;
import com.ebaiyihui.medical.core.dto.PayItemDatasDTO;
import com.ebaiyihui.medical.core.enums.AdmStatusEnum;
import com.ebaiyihui.medical.core.enums.BusinessOrderStatusEnum;
import com.ebaiyihui.medical.core.enums.ChannelEnum;
import com.ebaiyihui.medical.core.enums.ItemTypeEnum;
import com.ebaiyihui.medical.core.enums.OrderTypeEnum;
import com.ebaiyihui.medical.core.enums.OrganCodeEnum;
import com.ebaiyihui.medical.core.enums.ServiceCodeEnum;
import com.ebaiyihui.medical.core.exception.OutpatientPaymentException;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.medical.core.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.medical.core.model.OpBusinessOrderEntity;
import com.ebaiyihui.medical.core.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.medical.core.service.OutpatientPaymentService;
import com.ebaiyihui.medical.core.utils.HttpKit;
import com.ebaiyihui.medical.core.utils.SnowflakeIdWorker;
import com.ebaiyihui.medical.core.vo.repsvo.GetAdmissionRespVO;
import com.ebaiyihui.medical.core.vo.repsvo.GetPayInfoRespVO;
import com.ebaiyihui.medical.core.vo.repsvo.GetPayItemRespVO;
import com.ebaiyihui.medical.core.vo.repsvo.ItemTypeVo;
import com.ebaiyihui.medical.core.vo.repsvo.OutpatientPaymentOrderDetailRespVO;
import com.ebaiyihui.medical.core.vo.repsvo.OutpatientPaymentOrderRespVO;
import com.ebaiyihui.medical.core.vo.repsvo.PayItemResVo;
import com.ebaiyihui.medical.core.vo.repsvo.PaySuccessInfoRespVO;
import com.ebaiyihui.medical.core.vo.reqvo.CreateOutpatientPaymentReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.GetPayItemReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.OutpatientPayReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.OutpatientPaymentOrderDetailReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.OutpatientPaymentOrderReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.OutpatientPaymentReqVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final byte OUTPATIENT_DEPARTMENT = 1;
    public static final byte EMERGENCY_TREATMENT = 2;
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    public static final String WECHAT = "WECHAT";
    public static final String ALIPAY = "ALIPAY";
    @Value(value="${paymentUrl}")
    private String paymentUrl;
    @Value(value="${mchCode}")
    private String mchCode;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ICardServiceFeginClient cardServiceFeginClient;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private OrganCodeConstant organCodeConstant;

    public List<GetAdmissionRespVO> getAdmission(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        GatewayRequest gatewayRequest = this.buildGetAdmissionGatewayReq(getAdmissionReqVO);
        log.info("OutpatientPaymentServiceImpl.getAdmission->\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
        List getAdmissionItemsList = this.getAdmission(gatewayRequest);
        return this.buildOutpatientPaymentRespVOList(getAdmissionItemsList, getAdmissionReqVO.getCardId());
    }

    private List<GetAdmissionItems> getAdmission(GatewayRequest<GetAdmissionReq> gatewayRequest) throws OutpatientPaymentException {
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getAdmission(gatewayRequest);
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868:" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (null == gatewayResponse.getData()) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        GetAdmissionRes getAdmissionRes = (GetAdmissionRes)gatewayResponse.getData();
        if (null == getAdmissionRes.getItems() || getAdmissionRes.getItems().isEmpty()) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
        }
        return getAdmissionRes.getItems();
    }

    private List<GetAdmissionRespVO> buildOutpatientPaymentRespVOList(List<GetAdmissionItems> getAdmissionItemsList, String cardId) {
        if (CollectionUtils.isEmpty(getAdmissionItemsList)) {
            return new ArrayList<GetAdmissionRespVO>();
        }
        List<GetAdmissionRespVO> listOutpatientPaymentRespVOs = getAdmissionItemsList.stream().filter(getAdmissionItems -> AdmStatusEnum.BEING_ADM.getValue().intValue() == Integer.valueOf(getAdmissionItems.getAdmStatus()).intValue()).map(getAdmissionItems -> {
            GetAdmissionRespVO getAdmissionRespVO = new GetAdmissionRespVO();
            BeanUtils.copyProperties((Object)getAdmissionItems, (Object)getAdmissionRespVO);
            getAdmissionRespVO.setCardId(cardId);
            getAdmissionRespVO.setPayStatus("0");
            return getAdmissionRespVO;
        }).collect(Collectors.toList());
        return listOutpatientPaymentRespVOs;
    }

    private GatewayRequest<GetAdmissionReq> buildGetAdmissionGatewayReq(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(getAdmissionReqVO.getCardId());
        if (null == cardDetail) {
            throw new OutpatientPaymentException("\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25");
        }
        GetAdmissionReq getAdmissionReq = new GetAdmissionReq();
        getAdmissionReq.setBgDate(getAdmissionReqVO.getBgDate());
        getAdmissionReq.setEdDate(getAdmissionReqVO.getEdDate());
        getAdmissionReq.setCardNo(cardDetail.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("getAdmission");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.organCodeConstant.getOrganCode());
        gatewayRequest.setBody((Object)getAdmissionReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public GetPayItemRespVO getPayItem(GetPayItemReqVO getPayItemReqVO) throws OutpatientPaymentException {
        GetPayItemRespVO getPayItemRespVO = new GetPayItemRespVO();
        GatewayRequest gatewayRequest = this.buildPayItemGatewayReq(getPayItemReqVO);
        log.info("OutpatientPaymentServiceImpl.getPayItem->\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
        List payItemResDatasList = this.payItem(gatewayRequest);
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(getPayItemReqVO.getCardId());
        String outPatientId = String.valueOf(this.snowflakeIdWorker.nextId());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
        getPayItemRespVO.setOutPatientId(outPatientId);
        this.buildPayItemDatasRespVO(outPatientId, getPayItemReqVO, getPayItemRespVO, payItemResDatasList, cardDetailsInfoRespVO);
        PayItemDatasDTO payItemDatasDTO = this.buildPayItemDatasDTOForRedis(outPatientId, getPayItemReqVO, payItemResDatasList, cardDetailsInfoRespVO);
        String payItemDatasDTOStr = JSON.toJSONString((Object)payItemDatasDTO);
        this.jedisCluster.set(outPatientId, payItemDatasDTOStr);
        this.jedisCluster.expire(outPatientId, 7200);
        return getPayItemRespVO;
    }

    private List<PayItemResDatas> payItem(GatewayRequest<PayItemReq> gatewayRequest) throws OutpatientPaymentException {
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.payItem(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (null == gatewayResponse.getData()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        PayItemRes payItemRes = (PayItemRes)gatewayResponse.getData();
        if (null == payItemRes.getDatas() || payItemRes.getDatas().isEmpty()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
        }
        return payItemRes.getDatas();
    }

    private void buildPayItemDatasRespVO(String outPatientId, GetPayItemReqVO getPayItemReqVO, GetPayItemRespVO getPayItemRespVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        getPayItemRespVO.setOutPatientId(outPatientId);
        getPayItemRespVO.setName(cardDetailsInfoRespVO.getPatientName());
        getPayItemRespVO.setSex(cardDetailsInfoRespVO.getGender().toString());
        getPayItemRespVO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        getPayItemRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        getPayItemRespVO.setAmount(amount.toString());
        getPayItemRespVO.setPayItemResVoList(payItemResVos);
        getPayItemRespVO.setCardNo(getPayItemReqVO.getCardNo());
        getPayItemRespVO.setDeptName(getPayItemReqVO.getDeptName());
        getPayItemRespVO.setDocName(getPayItemReqVO.getDocName());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
    }

    private List<PayItemResVo> buildPayItemResVoList(List<PayItemResDatas> payItemResDatasList, String admId) {
        List treatmentPayList;
        PayItemResVo treatmentPayItemResVo;
        ArrayList<PayItemResVo> payItemResList = new ArrayList<PayItemResVo>();
        List payItemResDatasListFilterByAdmId = payItemResDatasList.stream().filter(e -> e.getAdmId().equals(admId)).collect(Collectors.toList());
        List drugsPayList = payItemResDatasListFilterByAdmId.stream().filter(e -> "0".equals(e.getItemType())).collect(Collectors.toList());
        PayItemResVo drugsPayItemResVo = this.buildPayItemResVo(drugsPayList);
        if (null != drugsPayItemResVo) {
            payItemResList.add(drugsPayItemResVo);
        }
        if (null != (treatmentPayItemResVo = this.buildPayItemResVo(treatmentPayList = payItemResDatasListFilterByAdmId.stream().filter(e -> "1".equals(e.getItemType())).collect(Collectors.toList())))) {
            payItemResList.add(treatmentPayItemResVo);
        }
        return payItemResList;
    }

    private PayItemResVo buildPayItemResVo(List<PayItemResDatas> payList) {
        if (!CollectionUtils.isEmpty(payList)) {
            PayItemResVo payItemResVo = new PayItemResVo();
            BigDecimal amount = BigDecimal.ZERO;
            ArrayList items = new ArrayList();
            for (PayItemResDatas payItemResDatas : payList) {
                amount = amount.add(new BigDecimal(payItemResDatas.getAmount()));
                items.addAll(payItemResDatas.getItems());
            }
            payItemResVo.setItemType(payList.get(0).getItemType());
            payItemResVo.setItems(items);
            payItemResVo.setAmount(amount.toString());
            return payItemResVo;
        }
        return null;
    }

    private PayItemDatasDTO buildPayItemDatasDTOForRedis(String outPatientId, GetPayItemReqVO getPayItemReqVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        PayItemDatasDTO payItemDatasDTO = new PayItemDatasDTO();
        payItemDatasDTO.setIdCard(cardDetailsInfoRespVO.getCredNo());
        payItemDatasDTO.setUserId(getPayItemReqVO.getUserId());
        payItemDatasDTO.setOutPatientId(outPatientId);
        payItemDatasDTO.setPatientId(cardDetailsInfoRespVO.getPatientId());
        payItemDatasDTO.setPatientOrganId(getPayItemReqVO.getPatientId());
        payItemDatasDTO.setCardId(cardDetailsInfoRespVO.getCardId());
        payItemDatasDTO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        payItemDatasDTO.setAdmDate(getPayItemReqVO.getAdmDate());
        payItemDatasDTO.setAdmType(getPayItemReqVO.getAdmType());
        payItemDatasDTO.setName(cardDetailsInfoRespVO.getPatientName());
        payItemDatasDTO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        payItemDatasDTO.setSex(cardDetailsInfoRespVO.getGender().toString());
        payItemDatasDTO.setAdmId(getPayItemReqVO.getAdmId());
        payItemDatasDTO.setDeptName(getPayItemReqVO.getDeptName());
        payItemDatasDTO.setDeptCode(getPayItemReqVO.getDeptCode());
        payItemDatasDTO.setDocName(getPayItemReqVO.getDocName());
        payItemDatasDTO.setDocCode(getPayItemReqVO.getDocCode());
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        payItemDatasDTO.setAmount(amount.toString());
        payItemDatasDTO.setPayItemResVoList(payItemResVos);
        payItemDatasDTO.setOrganCode(cardDetailsInfoRespVO.getOrganCode());
        return payItemDatasDTO;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) throws OutpatientPaymentException {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        log.info("\u83b7\u53d6\u5c31\u8bca\u5361\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cardDetailsInfoReqVO));
        BaseResponse resp = this.cardServiceFeginClient.getCardDetail(cardDetailsInfoReqVO);
        log.info("\u83b7\u53d6\u5c31\u8bca\u5361\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)resp));
        if (resp == null) {
            log.error("\u5361\u7c7b\u578b\u540d\u79f0\u67e5\u8be2 buildPayItemDatasRespVO -> cardService\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(resp.getMsg());
        }
        if (resp.getData() == null) {
            log.error("\u5361\u7c7b\u578b\u540d\u79f0\u67e5\u8be2 buildPayItemDatasRespVO -> cardService\u8bf7\u6c42\u6570\u636e\u5f02\u5e38");
            throw new OutpatientPaymentException(resp.getMsg());
        }
        return (CardDetailsInfoRespVO)resp.getData();
    }

    private GatewayRequest<PayItemReq> buildPayItemGatewayReq(GetPayItemReqVO getPayItemReqVO) {
        PayItemReq payItemReq = new PayItemReq();
        payItemReq.setAdmId(getPayItemReqVO.getAdmId());
        payItemReq.setCardNo(getPayItemReqVO.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("payItem");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getPayItemReqVO.getChannelCode()));
        gatewayRequest.setChannel(getPayItemReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.organCodeConstant.getOrganCode());
        gatewayRequest.setBody((Object)payItemReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public String createOutpatientPayment(CreateOutpatientPaymentReqVO createOutpatientPaymentReqVO) {
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0ckey\u4e3a\uff1a{}", (Object)createOutpatientPaymentReqVO.getOutPatientId());
        String payItemDatasDTOStr = this.jedisCluster.get(createOutpatientPaymentReqVO.getOutPatientId());
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0c\u83b7\u53d6\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)payItemDatasDTOStr);
        PayItemDatasDTO payItemDatasDTO = (PayItemDatasDTO)JSON.parseObject((String)payItemDatasDTOStr, PayItemDatasDTO.class);
        Date createDate = new Date();
        String outPatientId = String.valueOf(this.snowflakeIdWorker.nextId());
        OpBusinessOrderEntity opBusinessOrderEntity = this.buildOpBusinessOrderEntity(createDate, payItemDatasDTO, createOutpatientPaymentReqVO, outPatientId);
        log.info("\u7f34\u8d39\u521b\u5efa\u8ba2\u5355\uff1a" + opBusinessOrderEntity.toString());
        this.opBusinessOrderEntityMapper.insertSelective(opBusinessOrderEntity);
        List opBusinessOrderDetailEntityList = this.buildOpBusinessOrderDetailEntity(createDate, payItemDatasDTO, createOutpatientPaymentReqVO, outPatientId);
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntityList) {
            this.opBusinessOrderDetailEntityMapper.insertSelective(opBusinessOrderDetailEntity);
        }
        return outPatientId;
    }

    private OpBusinessOrderEntity buildOpBusinessOrderEntity(Date createDate, PayItemDatasDTO payItemDatasDTO, CreateOutpatientPaymentReqVO createOutpatientPaymentReqVO, String id) {
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setCreateTime(createDate);
        opBusinessOrderEntity.setUpdateTime(createDate);
        opBusinessOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opBusinessOrderEntity.setOutPatientId(id);
        opBusinessOrderEntity.setOrganCode(createOutpatientPaymentReqVO.getHospitalId());
        opBusinessOrderEntity.setOrganName(createOutpatientPaymentReqVO.getHospitalName());
        opBusinessOrderEntity.setAdmId(payItemDatasDTO.getAdmId());
        opBusinessOrderEntity.setAdmTime(payItemDatasDTO.getAdmDate());
        if ("E".equals(payItemDatasDTO.getAdmType())) {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)2));
        } else {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)1));
        }
        opBusinessOrderEntity.setDeptName(payItemDatasDTO.getDeptName());
        opBusinessOrderEntity.setDeptCode(payItemDatasDTO.getDeptCode());
        opBusinessOrderEntity.setDocName(payItemDatasDTO.getDocName());
        opBusinessOrderEntity.setDocCode(payItemDatasDTO.getDocCode());
        opBusinessOrderEntity.setPatientId(payItemDatasDTO.getPatientId());
        opBusinessOrderEntity.setPatientOrganId(payItemDatasDTO.getPatientOrganId());
        opBusinessOrderEntity.setPatientName(payItemDatasDTO.getName());
        opBusinessOrderEntity.setPatientGender(Integer.valueOf(Integer.parseInt(payItemDatasDTO.getSex())));
        opBusinessOrderEntity.setPatientAge(payItemDatasDTO.getAge());
        opBusinessOrderEntity.setCardNo(payItemDatasDTO.getCardNo());
        opBusinessOrderEntity.setCardId(payItemDatasDTO.getCardId());
        opBusinessOrderEntity.setIdCard(payItemDatasDTO.getIdCard());
        opBusinessOrderEntity.setUserId(payItemDatasDTO.getUserId());
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.NOT_PAY.getValue());
        opBusinessOrderEntity.setMoney(new BigDecimal(payItemDatasDTO.getAmount()));
        return opBusinessOrderEntity;
    }

    private List<OpBusinessOrderDetailEntity> buildOpBusinessOrderDetailEntity(Date createDate, PayItemDatasDTO payItemDatasDTO, CreateOutpatientPaymentReqVO createOutpatientPaymentReqVO, String id) {
        ArrayList<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntityList = new ArrayList<OpBusinessOrderDetailEntity>();
        List payItemResVoList = payItemDatasDTO.getPayItemResVoList();
        for (PayItemResVo payItemResVo : payItemResVoList) {
            List items = payItemResVo.getItems();
            for (PayItemResItems payItemResItems : items) {
                OpBusinessOrderDetailEntity opBusinessOrderDetailEntity = new OpBusinessOrderDetailEntity();
                opBusinessOrderDetailEntity.setCreateTime(createDate);
                opBusinessOrderDetailEntity.setUpdateTime(createDate);
                opBusinessOrderDetailEntity.setOrganCode(createOutpatientPaymentReqVO.getHospitalId());
                opBusinessOrderDetailEntity.setOrganName(createOutpatientPaymentReqVO.getHospitalName());
                opBusinessOrderDetailEntity.setOutPatientId(id);
                opBusinessOrderDetailEntity.setItemName(payItemResItems.getDesc());
                opBusinessOrderDetailEntity.setItemType(payItemResItems.getItemType());
                opBusinessOrderDetailEntity.setItemId(payItemResItems.getItemTypeNo());
                opBusinessOrderDetailEntity.setQuantity(Double.valueOf(Double.parseDouble(payItemResItems.getQty())));
                opBusinessOrderDetailEntity.setUnit(payItemResItems.getUnit());
                opBusinessOrderDetailEntity.setPrice(new BigDecimal(payItemResItems.getPrice()));
                opBusinessOrderDetailEntity.setMoney(new BigDecimal(payItemResItems.getSum()));
                opBusinessOrderDetailEntity.setPrescriptionNo(payItemResItems.getPrescriptionNo());
                opBusinessOrderDetailEntityList.add(opBusinessOrderDetailEntity);
            }
        }
        return opBusinessOrderDetailEntityList;
    }

    public OutpatientPaymentOrderDetailRespVO getOutpatientSucssessDetail(OutpatientPaymentOrderDetailReqVO outpatientPaymentOrderDetailReqVO) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderEntity) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
        }
        List opBusinessOrderDetailEntitiesList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderDetailEntitiesList) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
        }
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(opBusinessOrderEntity.getCardId());
        OutpatientPaymentOrderDetailRespVO outpatientPaymentOrderDetailRespVO = new OutpatientPaymentOrderDetailRespVO();
        outpatientPaymentOrderDetailRespVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        outpatientPaymentOrderDetailRespVO.setName(opBusinessOrderEntity.getPatientName());
        outpatientPaymentOrderDetailRespVO.setSex(opBusinessOrderEntity.getPatientGender().toString());
        outpatientPaymentOrderDetailRespVO.setAge(opBusinessOrderEntity.getPatientAge());
        outpatientPaymentOrderDetailRespVO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        outpatientPaymentOrderDetailRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        List payItemResVos = this.buidPayItemResVoList(opBusinessOrderDetailEntitiesList);
        outpatientPaymentOrderDetailRespVO.setPayItemResVoList(payItemResVos);
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        outpatientPaymentOrderDetailRespVO.setAmount(amount.toString());
        outpatientPaymentOrderDetailRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        outpatientPaymentOrderDetailRespVO.setDocName(opBusinessOrderEntity.getDocName());
        outpatientPaymentOrderDetailRespVO.setAdmId(opBusinessOrderEntity.getAdmId());
        return outpatientPaymentOrderDetailRespVO;
    }

    private List<PayItemResVo> buidPayItemResVoList(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        List treatmentPayList;
        PayItemResVo treatmentPayItemResVo;
        ArrayList<PayItemResVo> payItemResVoList = new ArrayList<PayItemResVo>();
        List drugsPayList = opBusinessOrderDetailList.stream().filter(e -> "0".equals(e.getItemType())).collect(Collectors.toList());
        PayItemResVo drugsPayItemResVo = this.buildPayItemResVoForDetail(drugsPayList);
        if (null != drugsPayItemResVo) {
            payItemResVoList.add(drugsPayItemResVo);
        }
        if (null != (treatmentPayItemResVo = this.buildPayItemResVoForDetail(treatmentPayList = opBusinessOrderDetailList.stream().filter(e -> "1".equals(e.getItemType())).collect(Collectors.toList())))) {
            payItemResVoList.add(treatmentPayItemResVo);
        }
        return payItemResVoList;
    }

    private PayItemResVo buildPayItemResVoForDetail(List<OpBusinessOrderDetailEntity> payItemList) {
        if (!CollectionUtils.isEmpty(payItemList)) {
            List items = this.buildPayItemResItems(payItemList);
            if (CollectionUtils.isEmpty((Collection)items)) {
                return null;
            }
            BigDecimal amount = BigDecimal.ZERO;
            for (PayItemResItems payItemResItems : items) {
                amount = amount.add(new BigDecimal(payItemResItems.getSum()));
            }
            PayItemResVo payItemResVo = new PayItemResVo();
            payItemResVo.setAmount(amount.toString());
            payItemResVo.setItems(items);
            payItemResVo.setItemType(((PayItemResItems)items.get(0)).getItemType());
            return payItemResVo;
        }
        return null;
    }

    private List<PayItemResItems> buildPayItemResItems(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntitiesList) {
        ArrayList<PayItemResItems> payItemResItemsList = new ArrayList<PayItemResItems>();
        if (null == opBusinessOrderDetailEntitiesList || opBusinessOrderDetailEntitiesList.isEmpty()) {
            return payItemResItemsList;
        }
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntitiesList) {
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setId(opBusinessOrderDetailEntity.getItemId());
            payItemResItems.setDesc(opBusinessOrderDetailEntity.getItemName());
            payItemResItems.setUnit(opBusinessOrderDetailEntity.getUnit());
            payItemResItems.setPrice(opBusinessOrderDetailEntity.getPrice().toString());
            payItemResItems.setQty(opBusinessOrderDetailEntity.getQuantity().toString());
            payItemResItems.setSum(opBusinessOrderDetailEntity.getMoney().toString());
            payItemResItems.setItemType(opBusinessOrderDetailEntity.getItemType());
            payItemResItemsList.add(payItemResItems);
        }
        return payItemResItemsList;
    }

    public GetPayInfoRespVO getPayInfo(String outPatientId) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity) {
            throw new OutpatientPaymentException("\u83b7\u53d6\u5f85\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        GetPayInfoRespVO getPayInfoRespVO = new GetPayInfoRespVO();
        getPayInfoRespVO.setAmount(opBusinessOrderEntity.getMoney().toString());
        getPayInfoRespVO.setCreateTime(opBusinessOrderEntity.getCreateTime().getTime());
        getPayInfoRespVO.setOutPatientId(outPatientId);
        return getPayInfoRespVO;
    }

    public BaseResponse<String> outpatientPayment(OutpatientPaymentReqVO outpatientPaymentReqVO) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        if (BusinessOrderStatusEnum.PAID.getValue().equals(opBusinessOrderEntity.getStatus())) {
            log.info("OutpatientPaymentServiceImpl.outpatientPayment->\u5df2\u652f\u4ed8");
            throw new OutpatientPaymentException("\u8be5\u6761\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrder = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(opBusinessOrderEntity, outpatientPaymentReqVO);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
        BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        opBusinessOrderEntity.setChannelCode(outpatientPaymentReqVO.getChannelCode());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        if (null != opRechargePaymentOrder) {
            return baseResponse;
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.buildOpRechargePaymentOrderEntity(outpatientPaymentReqVO, opBusinessOrderEntity);
        this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntity);
        return baseResponse;
    }

    private OutpatientPayReqVO buildOutpatientPayReqVO(OpBusinessOrderEntity opBusinessOrderEntity, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        OutpatientPayReqVO outpatientPayReqVO = new OutpatientPayReqVO();
        outpatientPayReqVO.setActuallyAmount(new BigDecimal("0.01"));
        outpatientPayReqVO.setMchCode(OrganCodeEnum.getDisplay((String)outpatientPaymentReqVO.getOrganCode()));
        outpatientPayReqVO.setOutTradeNo(outpatientPaymentReqVO.getOutPatientId());
        outpatientPayReqVO.setPayChannel(outpatientPaymentReqVO.getPayChannel());
        outpatientPayReqVO.setPayType(outpatientPaymentReqVO.getPayType());
        outpatientPayReqVO.setProductInfo("\u95e8\u8bca\u7f34\u8d39");
        outpatientPayReqVO.setServiceCode(ServiceCodeEnum.OUTPATIENT.getValue());
        outpatientPayReqVO.setTotalAmount(new BigDecimal("0.01"));
        outpatientPayReqVO.setUserSign(outpatientPaymentReqVO.getOpenId());
        return outpatientPayReqVO;
    }

    private OpRechargePaymentOrderEntity buildOpRechargePaymentOrderEntity(OutpatientPaymentReqVO outpatientPaymentReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = new OpRechargePaymentOrderEntity();
        Date date = new Date();
        opRechargePaymentOrderEntity.setCreateTime(date);
        opRechargePaymentOrderEntity.setUpdateTime(date);
        opRechargePaymentOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opRechargePaymentOrderEntity.setOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        opRechargePaymentOrderEntity.setOrderType(Byte.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue().byteValue()));
        opRechargePaymentOrderEntity.setDealMoney(opBusinessOrderEntity.getMoney());
        opRechargePaymentOrderEntity.setBizSysSeq(ServiceCodeEnum.OUTPATIENT.getValue());
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)0));
        opRechargePaymentOrderEntity.setMerchantSeq(this.mchCode);
        opRechargePaymentOrderEntity.setPaymentSeq(outpatientPaymentReqVO.getPayChannel());
        opRechargePaymentOrderEntity.setUserId(outpatientPaymentReqVO.getUserId());
        return opRechargePaymentOrderEntity;
    }

    private BaseResponse<String> payCreateOrder(OutpatientPayReqVO outpatientPayReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.paymentUrl, (String)JSON.toJSONString((Object)outpatientPayReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("OutpatientPaymentServiceImpl.payCreateOrder->\u53d1\u8d77\u652f\u4ed8\u8fd4\u56de\u53c2\u6570baseResponse: " + baseResponse);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("OutpatientPaymentServiceImpl.payCreateOrder\u95e8\u8bca\u7f34\u8d39\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }

    public PaySuccessInfoRespVO getPaySuccessInfo(String outPatientId) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        List opBusinessOrderDetailList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity || null == opRechargePaymentOrderEntity || CollectionUtils.isEmpty((Collection)opBusinessOrderDetailList)) {
            throw new OutpatientPaymentException();
        }
        return this.buildPaySuccessInfoRespVO(opBusinessOrderEntity, opRechargePaymentOrderEntity, opBusinessOrderDetailList);
    }

    private PaySuccessInfoRespVO buildPaySuccessInfoRespVO(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        PaySuccessInfoRespVO paySuccessInfoRespVO = new PaySuccessInfoRespVO();
        paySuccessInfoRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        paySuccessInfoRespVO.setDocName(opBusinessOrderEntity.getDocName());
        paySuccessInfoRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        paySuccessInfoRespVO.setAmount(opRechargePaymentOrderEntity.getDealMoney().toString());
        paySuccessInfoRespVO.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        paySuccessInfoRespVO.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        TreeSet<String> itemType = new TreeSet<String>();
        for (OpBusinessOrderDetailEntity opBusinessOrderDetail : opBusinessOrderDetailList) {
            if (StringUtils.isEmpty((Object)opBusinessOrderDetail.getItemType())) continue;
            itemType.add(opBusinessOrderDetail.getItemType());
        }
        if (!CollectionUtils.isEmpty(itemType)) {
            ArrayList<ItemTypeVo> list = new ArrayList<ItemTypeVo>();
            for (String key : itemType) {
                ItemTypeVo itemTypeVo = new ItemTypeVo();
                if (ItemTypeEnum.MEDICAL_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.MEDICAL_PAY.getDisplay());
                }
                if (ItemTypeEnum.DIAGNOSIS_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.DIAGNOSIS_PAY.getDisplay());
                }
                list.add(itemTypeVo);
            }
            paySuccessInfoRespVO.setItemType(list);
        }
        if (opRechargePaymentOrderEntity.getPaymentSeq() != null && WECHAT.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u5fae\u4fe1\u652f\u4ed8");
        } else if (opRechargePaymentOrderEntity.getPaymentSeq() != null && ALIPAY.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u652f\u4ed8\u5b9d\u652f\u4ed8");
        }
        return paySuccessInfoRespVO;
    }

    public List<OutpatientPaymentOrderRespVO> getOutpatientPaymentOrder(OutpatientPaymentOrderReqVO outpatientPaymentOrderReqVO) throws OutpatientPaymentException {
        ArrayList<OutpatientPaymentOrderRespVO> outpatientPaymentOrderRespVOList = new ArrayList<OutpatientPaymentOrderRespVO>();
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(outpatientPaymentOrderReqVO.getCardId());
        if (null == cardDetail) {
            throw new OutpatientPaymentException("\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setUserId(outpatientPaymentOrderReqVO.getUserId());
        opBusinessOrderEntity.setCardNo(outpatientPaymentOrderReqVO.getCardNo());
        List opBusinessOrderEntities = this.opBusinessOrderEntityMapper.selectByCardNoAndUserId(opBusinessOrderEntity);
        if (null == opBusinessOrderEntities || opBusinessOrderEntities.isEmpty()) {
            return outpatientPaymentOrderRespVOList;
        }
        for (OpBusinessOrderEntity opBusinessOrder : opBusinessOrderEntities) {
            OutpatientPaymentOrderRespVO outpatientPaymentOrderRespVO = new OutpatientPaymentOrderRespVO();
            outpatientPaymentOrderRespVO.setCreateTime(opBusinessOrder.getCreateTime().getTime());
            outpatientPaymentOrderRespVO.setDeptName(opBusinessOrder.getDeptName());
            outpatientPaymentOrderRespVO.setDocName(opBusinessOrder.getDocName());
            outpatientPaymentOrderRespVO.setOutPatientId(opBusinessOrder.getOutPatientId());
            outpatientPaymentOrderRespVO.setPayStatus(opBusinessOrder.getStatus().toString());
            outpatientPaymentOrderRespVOList.add(outpatientPaymentOrderRespVO);
        }
        return outpatientPaymentOrderRespVOList;
    }
}

