/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.dto.UcConfigurationDTO;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.medical.core.common.constant.OrganCodeConstant;
import com.ebaiyihui.medical.core.dto.InHospDepostPayCallDTO;
import com.ebaiyihui.medical.core.enums.BusinessOrderStatusEnum;
import com.ebaiyihui.medical.core.enums.ChannelEnum;
import com.ebaiyihui.medical.core.exception.InHospitalException;
import com.ebaiyihui.medical.core.exception.OutpatientPaymentException;
import com.ebaiyihui.medical.core.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpGuideEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.medical.core.model.InpatientDepositDetailEntity;
import com.ebaiyihui.medical.core.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.medical.core.model.OpBusinessOrderEntity;
import com.ebaiyihui.medical.core.model.OpGuideEntity;
import com.ebaiyihui.medical.core.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.medical.core.service.InHospitalService;
import com.ebaiyihui.medical.core.service.PayCallBackService;
import com.ebaiyihui.medical.core.utils.DateUtils;
import com.ebaiyihui.medical.core.utils.HttpKit;
import com.ebaiyihui.medical.core.utils.SnowflakeIdWorker;
import com.ebaiyihui.medical.core.vo.repsvo.PushConfigurationDetailVO;
import com.ebaiyihui.medical.core.vo.reqvo.ResponseNotifyRestVo;
import com.ebaiyihui.push.WechatMessageApiClient;
import com.ebaiyihui.push.pojo.wechat.PushSubscribeMessageReqVO;
import com.ebaiyihui.usercenter.client.NodeAccountClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    public static final String OUTPATIENT_PAID_SUCCESS_MSG = "\u7f34\u8d39\u6210\u529f";
    public static final String TEMPLATECODE = "pay_success_notify";
    public static final String WX_PUSHTYPE = "weChatApplets";
    @Value(value="${organCode}")
    private String organCode;
    @Value(value="${appCode}")
    private String appCode;
    @Value(value="${wx.wechatpushUrl}")
    private String wechatpushUrl;
    @Value(value="${wx.pushConfigUrl}")
    private String pushConfigUrl;
    @Autowired
    private OrganCodeConstant organCodeConstant;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private WechatMessageApiClient wechatMessageApiClient;
    @Autowired
    private NodeAccountClient nodeAccountClient;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;

    public void outpatientPaymentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws OutpatientPaymentException {
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        opRechargePaymentOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        opRechargePaymentOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        GatewayRequest gatewayRequest = this.buildComfirmPayNewReq(opBusinessOrderEntity, opRechargePaymentOrderEntity, responseNotifyRestVo);
        GatewayResponse gatewayResponse = this.comfirmPayNew(gatewayRequest);
        String receiptId = ((ComfirmPayNewRes)gatewayResponse.getData()).getReceiptId();
        opBusinessOrderEntity.setReceiptId(receiptId);
        if (ChannelEnum.USER_APPLETS.getValue().equals(opBusinessOrderEntity.getChannelCode())) {
            log.info("=========\u5c0f\u7a0b\u5e8f\u63a8\u9001\u5f00\u59cb==========");
            this.taskExecutor.execute(() -> {
                PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.buildOutPatientPushTemplateMsgVO(opBusinessOrderEntity, responseNotifyRestVo.getPayTime());
                if (null == pushSubscribeMessageReqVO) {
                    log.info("==========\u6784\u5efa\u5c0f\u7a0b\u5e8f\u63a8\u9001\u53c2\u6570\u4e3a\u7a7a\uff0c\u63a8\u9001\u5931\u8d25=========");
                    return;
                }
                log.info("==============\u5f00\u59cb\u5c0f\u7a0b\u5e8f\u63a8\u9001============\u8bf7\u6c42\u53c2\u6570{}", (Object)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
                BaseResponse response = this.pushSubscribeMessage(pushSubscribeMessageReqVO);
                log.info("==============\u5c0f\u7a0b\u5e8f\u63a8\u9001\u7ed3\u675f============pushTemplateMessageReqVO{}", (Object)response.toString());
            });
        }
        OpGuideEntity opGuideEntity = this.buildOpGuideEntity(opBusinessOrderEntity, gatewayResponse);
        this.opGuideEntityMapper.insert(opGuideEntity);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
    }

    private OpGuideEntity buildOpGuideEntity(OpBusinessOrderEntity opBusinessOrderEntity, GatewayResponse<ComfirmPayNewRes> gatewayResponse) {
        OpGuideEntity opGuideEntity = new OpGuideEntity();
        Date now = new Date();
        opGuideEntity.setGuideInfoId(String.valueOf(this.snowflakeIdWorker.nextId()));
        opGuideEntity.setGuideInfo(((ComfirmPayNewRes)gatewayResponse.getData()).getRemark());
        opGuideEntity.setCreateTime(now);
        opGuideEntity.setUpdateTime(now);
        opGuideEntity.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        opGuideEntity.setAdmId(opBusinessOrderEntity.getAdmId());
        opGuideEntity.setPatientId(opBusinessOrderEntity.getPatientId());
        opGuideEntity.setPatientOrganId(opBusinessOrderEntity.getPatientOrganId());
        opGuideEntity.setCardNo(opBusinessOrderEntity.getCardNo());
        opGuideEntity.setCardId(opBusinessOrderEntity.getCardId());
        opGuideEntity.setUserId(opBusinessOrderEntity.getUserId());
        opGuideEntity.setOrganCode(opBusinessOrderEntity.getOrganCode());
        opGuideEntity.setOrganName(opBusinessOrderEntity.getOrganName());
        return opGuideEntity;
    }

    public void inHospDepositPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(responseNotifyRestVo.getOutTradeNo());
        InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
        inHospDepostPayCallDTO.setPayTime(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        inHospDepostPayCallDTO.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
        inHospDepostPayCallDTO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
        inHospDepostPayCallDTO.setInpatientIepositId(String.valueOf(inpatientDepositDetailEntity.getId()));
        inHospDepostPayCallDTO.setBankTradeNo("");
        inHospDepostPayCallDTO.setMerchantId(responseNotifyRestVo.getMchId());
        inHospDepostPayCallDTO.setPaymentSeq(responseNotifyRestVo.getPayChannel());
        inHospDepostPayCallDTO.setPayBillNo(responseNotifyRestVo.getTradeNo());
        inHospDepostPayCallDTO.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        this.inpatientDepositDetailEntityMapper.updateByOrderSeq(inHospDepostPayCallDTO);
        this.inpatientPayorderEntityMapper.updateByInpatientDepositId(inHospDepostPayCallDTO);
        DepositRes depositRes = this.inHospitalService.InHospDeposit(inpatientDepositDetailEntity, responseNotifyRestVo);
        inHospDepostPayCallDTO.setReceiptId(depositRes.getReceiptId());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
        this.inpatientDepositDetailEntityMapper.updateByOrderSeqToHisPaid(inHospDepostPayCallDTO);
    }

    private GatewayResponse<ComfirmPayNewRes> comfirmPayNew(GatewayRequest<ComfirmPayNewReq> gatewayRequest) throws OutpatientPaymentException {
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(gatewayRequest);
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 gatewayResponse ->{}" + gatewayResponse.toString() + gatewayResponse.getCode() + gatewayResponse.getMsg() + gatewayResponse.getData());
        if (gatewayResponse == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        log.info("gatewayResponse.getData():" + ((ComfirmPayNewRes)gatewayResponse.getData()).toString());
        ComfirmPayNewRes comfirmPayNewRes = (ComfirmPayNewRes)gatewayResponse.getData();
        if (null == comfirmPayNewRes) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
            throw new OutpatientPaymentException("his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
        }
        return gatewayResponse;
    }

    private GatewayRequest<ComfirmPayNewReq> buildComfirmPayNewReq(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setId(opBusinessOrderEntity.getAdmId());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setPaychannel(opRechargePaymentOrderEntity.getPaymentSeq());
        comfirmPayNewReq.setFlowNo(opBusinessOrderEntity.getOutPatientId());
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        comfirmPayNewReqMsg.setPayment(opRechargePaymentOrderEntity.getDealMoney().toString());
        comfirmPayNewReqMsg.setAccdate(DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime()));
        comfirmPayNewReqMsg.setPosid(responseNotifyRestVo.getMchId());
        comfirmPayNewReqMsg.setSuccess("Y");
        comfirmPayNewReqMsg.setUsrmsg("");
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        comfirmPayNewReq.setPatientId(opBusinessOrderEntity.getPatientOrganId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        ArrayList<String> prescriptionNoList = new ArrayList<String>();
        List opBusinessOrderDetailEntityList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(opBusinessOrderEntity.getOutPatientId());
        if (!CollectionUtils.isEmpty((Collection)opBusinessOrderDetailEntityList)) {
            for (OpBusinessOrderDetailEntity entity : opBusinessOrderDetailEntityList) {
                prescriptionNoList.add(entity.getPrescriptionNo() + "," + entity.getItemId());
            }
            comfirmPayNewReq.setPrescriptionNos(String.join((CharSequence)"|", prescriptionNoList));
        }
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)opBusinessOrderEntity.getChannelCode()));
        gatewayRequest.setChannel(opBusinessOrderEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.organCodeConstant.getOrganCode());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private PushSubscribeMessageReqVO buildOutPatientPushTemplateMsgVO(OpBusinessOrderEntity opBusinessOrderEntity, Date payTime) {
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        Map data = this.getOutPatientPushTemplateData(opBusinessOrderEntity, payTime);
        String wxOpenid = this.getWxOpenid(opBusinessOrderEntity.getUserId());
        if (StringUtils.isEmpty((CharSequence)wxOpenid)) {
            log.error("======\u4ece\u7528\u6237\u4e2d\u5fc3\u83b7\u53d6openid\u5931\u8d25======");
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.getPushConfig();
        if (null == pushConfig && StringUtils.isEmpty((CharSequence)pushConfig.getClientCode())) {
            log.error("======\u83b7\u53d6\u63a8\u9001\u914d\u7f6e\u5931\u8d25======");
            return null;
        }
        pushSubscribeMessageReqVO.setOpenId(wxOpenid);
        pushSubscribeMessageReqVO.setTemplateCode(TEMPLATECODE);
        pushSubscribeMessageReqVO.setData(data);
        pushSubscribeMessageReqVO.setClientCode(pushConfig.getClientCode());
        return pushSubscribeMessageReqVO;
    }

    private Map<String, Map<String, Object>> getOutPatientPushTemplateData(OpBusinessOrderEntity opBusinessOrderEntity, Date payTime) {
        LinkedHashMap<String, Map<String, Object>> pushTemplateDataMap = new LinkedHashMap<String, Map<String, Object>>();
        HashMap<String, String> admPatient = new HashMap<String, String>();
        admPatient.put("value", opBusinessOrderEntity.getPatientName());
        pushTemplateDataMap.put("*\u5c31\u8bca\u4eba ", admPatient);
        HashMap<String, String> serviceTime = new HashMap<String, String>();
        serviceTime.put("value", DateUtils.dateToYMDFullString((Date)payTime));
        pushTemplateDataMap.put("*\u7f34\u8d39\u65e5\u671f ", serviceTime);
        HashMap<String, String> money = new HashMap<String, String>();
        money.put("value", "\uffe5" + opBusinessOrderEntity.getMoney().toString() + "\u5143");
        pushTemplateDataMap.put("*\u7f34\u8d39\u91d1\u989d ", money);
        HashMap<String, String> receiptId = new HashMap<String, String>();
        receiptId.put("value", opBusinessOrderEntity.getReceiptId());
        pushTemplateDataMap.put("*\u8ba2\u5355\u53f7 ", receiptId);
        HashMap<String, String> remark = new HashMap<String, String>();
        remark.put("value", OUTPATIENT_PAID_SUCCESS_MSG);
        pushTemplateDataMap.put("*\u5907\u6ce8 ", remark);
        return pushTemplateDataMap;
    }

    private String getWxOpenid(String userId) {
        UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
        ucWxAuthReqVo.setUserId(userId);
        ucWxAuthReqVo.setStatus(Short.valueOf((short)1));
        ucWxAuthReqVo.setUserType(Short.valueOf((short)0));
        log.info("\u8c03\u7528\u8282\u70b9\u7528\u6237\u670d\u52a1 ---  \u8bf7\u6c42\u53c2\u6570\uff1a" + ucWxAuthReqVo.toString());
        BaseResponse baseResponse = this.nodeAccountClient.getWxAuthByCondition(ucWxAuthReqVo);
        log.info("\u8c03\u7528\u8282\u70b9\u7528\u6237\u670d\u52a1 ---  \u8fd4\u56de\u53c2\u6570\uff1a" + baseResponse.toString());
        if (baseResponse.isSuccess()) {
            UcWxAuthRespVo ucWxAuthRespVo = (UcWxAuthRespVo)baseResponse.getData();
            return ucWxAuthRespVo.getWxOpenid();
        }
        return null;
    }

    private BaseResponse<String> pushSubscribeMessage(PushSubscribeMessageReqVO pushSubscribeMessageReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.wechatpushUrl, (String)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private PushConfigurationDetailVO getPushConfig() {
        PushConfigurationDetailVO configurationDetailVO = new PushConfigurationDetailVO();
        UcConfigurationDTO ucConfigurationDTO = new UcConfigurationDTO();
        ucConfigurationDTO.setType(WX_PUSHTYPE);
        ucConfigurationDTO.setAppCode(this.appCode);
        String body = null;
        try {
            body = HttpKit.jsonPost((String)this.pushConfigUrl, (String)JSON.toJSONString((Object)ucConfigurationDTO));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
        log.info("\u83b7\u53d6\u63a8\u9001\u914d\u7f6e\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
        if (!baseResponse.isSuccess()) {
            log.error("\u63a8\u9001\u8fd4\u56de\u503cbaseResponse\u4e3a\u7a7a");
            return null;
        }
        UcConfigurationVO ucConfigurationVO = (UcConfigurationVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)baseResponse.getData()), UcConfigurationVO.class);
        String configuration = ucConfigurationVO.getClientCode();
        log.info("configuration :{}", (Object)JSON.toJSONString((Object)configuration));
        PushConfigurationDetailVO pushConfigurationDetailVO = (PushConfigurationDetailVO)JSONObject.parseObject((String)configuration, PushConfigurationDetailVO.class);
        log.info(" json\u8f6cobj ==pushConfigurationDetailVO :{}", (Object)JSON.toJSONString((Object)pushConfigurationDetailVO));
        return pushConfigurationDetailVO;
    }
}

