/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.medical.core.common.constant.OrganCodeConstant;
import com.ebaiyihui.medical.core.enums.BusinessOrderStatusEnum;
import com.ebaiyihui.medical.core.enums.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.medical.core.enums.PayStatusEnum;
import com.ebaiyihui.medical.core.enums.RefundTypeEnum;
import com.ebaiyihui.medical.core.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.medical.core.model.InpatientDepositDetailEntity;
import com.ebaiyihui.medical.core.model.InpatientPayorderEntity;
import com.ebaiyihui.medical.core.model.OpBusinessOrderEntity;
import com.ebaiyihui.medical.core.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.medical.core.service.RefundCallBackService;
import com.ebaiyihui.medical.core.utils.DateUtils;
import com.ebaiyihui.medical.core.utils.SnowflakeIdWorker;
import com.ebaiyihui.medical.core.vo.reqvo.ResponseRefundNotifyRestVo;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class RefundCallBackServiceImpl
implements RefundCallBackService {
    private static final Logger log = LoggerFactory.getLogger(RefundCallBackServiceImpl.class);
    public static final String HIS_SUCCESS = "1";
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private OrganCodeConstant organCodeConstant;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private JedisCluster jedisCluster;

    public void outpatientRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) {
        String redisKey;
        String refundSerialNo;
        Date now = new Date();
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setUpdateTime(now);
        opBusinessOrderEntity.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.REFUND.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opRechargePaymentOrderEntity.setUpdateTime(now);
        opRechargePaymentOrderEntity.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.HAS_PAY_OR_REFUND.getValue().intValue()));
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        if (opRechargePaymentOrderEntity.getRefundType().equals(RefundTypeEnum.HIS_REFUND.getValue()) && StringUtils.isNotEmpty((String)(refundSerialNo = this.jedisCluster.get(redisKey = responseNotifyRestVo.getOutTradeNo() + "_" + "hisRefund")))) {
            log.info("\u67e5\u8be2\u5230his\u9000\u6b3e\u6d41\u6c34\u53f7\uff1a" + refundSerialNo);
            this.outPatientRepeatCallBackHis(responseNotifyRestVo, opBusinessOrderEntity, opRechargePaymentOrderEntity, refundSerialNo);
        }
    }

    public void inHospitalRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) {
        String redisKey;
        String refundSerialNo;
        Date now = new Date();
        String orderseq = responseNotifyRestVo.getOutTradeNo();
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderseq);
        inpatientDepositDetailEntity.setUpdateTime(now);
        inpatientDepositDetailEntity.setRemark("\u4f4f\u9662\u9884\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        inpatientDepositDetailEntity.setStatus(Byte.valueOf((byte)InpatientDepositDetailStatusEnum.REFUND.getValue().intValue()));
        this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
        inpatientPayorderEntity.setUpdateTime(now);
        inpatientPayorderEntity.setRemark("\u4f4f\u9662\u9884\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        inpatientPayorderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.HAS_PAY_OR_REFUND.getValue().intValue()));
        this.inpatientPayorderEntityMapper.updateByPrimaryKey(inpatientPayorderEntity);
        if (inpatientPayorderEntity.getRefundType().equals(RefundTypeEnum.HIS_REFUND.getValue()) && StringUtils.isNotEmpty((String)(refundSerialNo = this.jedisCluster.get(redisKey = responseNotifyRestVo.getOutTradeNo() + "_" + "hisRefund")))) {
            log.info("\u67e5\u8be2\u5230his\u9000\u6b3e\u6d41\u6c34\u53f7\uff1a" + refundSerialNo);
            this.inHospRepeatCallBackHis(responseNotifyRestVo, inpatientDepositDetailEntity, inpatientPayorderEntity.getPayBillNo(), refundSerialNo);
        }
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RefundCallBackReq refundCallBackReq = new RefundCallBackReq();
        refundCallBackReq.setFlowNo(orderNo);
        refundCallBackReq.setRefundTrandNo(responseRefundNotifyRestVo.getRefundNo());
        refundCallBackReq.setMoney(String.valueOf(responseRefundNotifyRestVo.getRefundMoney()));
        refundCallBackReq.setPayType(responseRefundNotifyRestVo.getPayChannel());
        refundCallBackReq.setTrandNo(trandNo);
        refundCallBackReq.setRefundTime(DateUtils.dateToFullString((Date)responseRefundNotifyRestVo.getRefundTime()));
        refundCallBackReq.setRefundSerialNo(refundSerialNo);
        gatewayRequest.setBody((Object)refundCallBackReq);
        gatewayRequest.setChannel(responseRefundNotifyRestVo.getPayChannel());
        gatewayRequest.setOrganCode(this.organCodeConstant.getOrganCode());
        gatewayRequest.setKeyWord("refundResult");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse refundCallBack = this.hisBillApi.refundCallBack(gatewayRequest);
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        return refundCallBack.isSuccess() && HIS_SUCCESS.equals(((RefundCallBackRes)refundCallBack.getData()).getState());
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }
}

