/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medical.core.enums.BusinessOrderStatusEnum;
import com.ebaiyihui.medical.core.enums.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.medical.core.enums.OrderTypeEnum;
import com.ebaiyihui.medical.core.enums.PayStatusEnum;
import com.ebaiyihui.medical.core.enums.RefundTypeEnum;
import com.ebaiyihui.medical.core.exception.OutreachException;
import com.ebaiyihui.medical.core.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.medical.core.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.medical.core.model.InpatientDepositDetailEntity;
import com.ebaiyihui.medical.core.model.InpatientPayorderEntity;
import com.ebaiyihui.medical.core.model.OpBusinessOrderEntity;
import com.ebaiyihui.medical.core.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.medical.core.service.RefundService;
import com.ebaiyihui.medical.core.utils.HttpKit;
import com.ebaiyihui.medical.core.utils.StringUtil;
import com.ebaiyihui.medical.core.vo.reqvo.RefundOrderVoReq;
import com.ebaiyihui.medical.pojo.vo.OutreachRequest;
import com.ebaiyihui.medical.pojo.vo.OutreachResponse;
import com.ebaiyihui.medical.pojo.vo.RefundReqVO;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class RefundServiceImpl
implements RefundService {
    private static final Logger log = LoggerFactory.getLogger(RefundServiceImpl.class);
    public static final long THIRTY_MINUTES = 1800000L;
    public static final String PAY_SUCCESS = "Y";
    public static final String PAY_FAIDED = "N";
    public static final String HIS_REFUND = "hisRefund";
    public static final int REDIS_THIRTY_MINUTES = 1800;
    @Value(value="${refundUrl}")
    private String refundUrl;
    @Value(value="${mchCode}")
    private String mchCode;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private JedisCluster jedisCluster;

    public OutreachResponse<String> outpatientRefundForHis(OutreachRequest<RefundReqVO> refundReqVO) throws OutreachException {
        RefundReqVO body = (RefundReqVO)refundReqVO.getBody();
        if (null == body) {
            log.error("outpatientRefundForHis->\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u6b3e\u8bf7\u6c42body\u4e3a\u7a7a\uff01");
        }
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(body.getOrderNo());
        if (null == opBusinessOrderEntity) {
            log.error("outpatientRefundForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (!opBusinessOrderEntity.getStatus().equals(BusinessOrderStatusEnum.PAID.getValue())) {
            throw new OutreachException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(opBusinessOrderEntity.getOutPatientId());
        if (null == opRechargePaymentOrderEntity) {
            log.error("RoutpatientRefundForHis->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        this.checkRefundRequestParams(body, opBusinessOrderEntity, opRechargePaymentOrderEntity);
        BaseResponse baseResponse = this.outpatientPaymentRefund(opBusinessOrderEntity, opRechargePaymentOrderEntity);
        if (null == baseResponse) {
            log.error("refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a");
            return OutreachResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff01");
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error("refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)baseResponse.getMsg());
            return OutreachResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        opRechargePaymentOrderEntity.setRemark("his\u8c03\u7528\u9000\u6b3e\u8ba2\u5355\uff0c\u53d1\u8d77\u9000\u6b3e");
        opRechargePaymentOrderEntity.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setRefundType(Byte.valueOf(RefundTypeEnum.HIS_REFUND.getValue().byteValue()));
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        String redisKey = body.getOrderNo() + "_" + HIS_REFUND;
        this.jedisCluster.set(redisKey, body.getRefundSerialNo());
        this.jedisCluster.expire(redisKey, 1800);
        return OutreachResponse.success((Object)body.getRefundFee());
    }

    public OutreachResponse<String> inHospitalRefundForHis(OutreachRequest<RefundReqVO> refundReqVO) throws OutreachException {
        RefundReqVO body = (RefundReqVO)refundReqVO.getBody();
        if (null == body) {
            log.error("outpatientRefundForHis->\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u6b3e\u8bf7\u6c42body\u4e3a\u7a7a\uff01");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(body.getOrderNo());
        if (null == inpatientDepositDetailEntity) {
            log.error("RefundServiceImpl.checkParams->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receiptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u4f4f\u9662\u5145\u503c\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (inpatientDepositDetailEntity.getStatus().intValue() != InpatientDepositDetailStatusEnum.PAID.getValue().intValue()) {
            throw new OutreachException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
        if (null == inpatientPayorderEntity) {
            log.error("RefundServiceImpl.checkParams->\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2receiptId\u4e3a:{}", (Object)body.getOrderNo());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2\u4f4f\u9662\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        this.checkInHospitalRefundRequestParams(body, inpatientDepositDetailEntity, inpatientPayorderEntity);
        BaseResponse baseResponse = this.inHospitalPaymentRefund(inpatientDepositDetailEntity, inpatientPayorderEntity);
        if (null == baseResponse) {
            log.error("refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a");
            return OutreachResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff01");
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error("refundforHis->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)baseResponse.getMsg());
            return OutreachResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        inpatientPayorderEntity.setRemark("his\u8c03\u7528\u9000\u6b3e\u8ba2\u5355\uff0c\u5f85\u9000\u6b3e");
        inpatientPayorderEntity.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        inpatientPayorderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRefundType(Byte.valueOf(RefundTypeEnum.HIS_REFUND.getValue().byteValue()));
        this.inpatientPayorderEntityMapper.updateByPrimaryKeySelective(inpatientPayorderEntity);
        String redisKey = body.getOrderNo() + "_" + HIS_REFUND;
        this.jedisCluster.set(redisKey, body.getRefundSerialNo());
        this.jedisCluster.expire(redisKey, 1800);
        return OutreachResponse.success((Object)body.getRefundFee());
    }

    private void checkRefundRequestParams(RefundReqVO body, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) throws OutreachException {
        BigDecimal dealMoney = opRechargePaymentOrderEntity.getDealMoney();
        if (StringUtil.isBlank((String)body.getRefundFee())) {
            log.error("RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a");
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a\uff01");
        }
        BigDecimal regFee = BigDecimal.ZERO;
        try {
            regFee = new BigDecimal(body.getRefundFee());
        }
        catch (NumberFormatException e) {
            log.error("RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5!,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)body.getRefundFee());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (dealMoney.compareTo(regFee) == -1) {
            log.error("RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)regFee.toString());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d\uff01");
        }
        String payChannel = opRechargePaymentOrderEntity.getPaymentSeq();
        if (StringUtil.isBlank((String)body.getPayChannel())) {
            log.error("RefundServiceImpl.checkParams->\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a");
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a\uff01");
        }
        if (!body.getPayChannel().trim().equals(payChannel)) {
            log.error("RefundServiceImpl.checkParams->\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u652f\u4ed8\u6e20\u9053\u53c2\u6570\u4e3a:{}", (Object)body.getPayChannel());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff01");
        }
    }

    private BaseResponse<String> outpatientPaymentRefund(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        RefundOrderVoReq refundOrderVoReq = new RefundOrderVoReq();
        refundOrderVoReq.setPayChannel(opRechargePaymentOrderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.mchCode);
        refundOrderVoReq.setOutTradeNo(opRechargePaymentOrderEntity.getOutPatientId());
        refundOrderVoReq.setDealTradeNo(opRechargePaymentOrderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(new BigDecimal("0.01"));
        refundOrderVoReq.setRefundAmount(new BigDecimal("0.01"));
        log.info("RefundServiceImpl.refund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("RefundServiceImpl.refund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        return baseResponse;
    }

    private BaseResponse<String> refund(RefundOrderVoReq refundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.refundUrl, (String)JSON.toJSONString((Object)refundOrderVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("RefundServiceImpl.refund->\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    private void checkInHospitalRefundRequestParams(RefundReqVO body, InpatientDepositDetailEntity inpatientDepositDetailEntity, InpatientPayorderEntity inpatientPayorderEntity) throws OutreachException {
        if (StringUtil.isBlank((String)body.getRefundFee())) {
            log.error("RefundServiceImpl.checkParams->\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a");
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u4e3a\u7a7a\uff01");
        }
        BigDecimal regFee = BigDecimal.ZERO;
        try {
            regFee = new BigDecimal(body.getRefundFee());
        }
        catch (NumberFormatException e) {
            log.error("RefundServiceImpl.checkInHospiatlParams->\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5!,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)body.getRefundFee());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        BigDecimal dealMoney = inpatientPayorderEntity.getDealMoney();
        if (dealMoney.compareTo(regFee) == -1) {
            log.error("RefundServiceImpl.checkInHospitalParams->\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d,\u9000\u8d39\u91d1\u989d\u53c2\u6570\u4e3a\uff1a{}", (Object)regFee.toString());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u9000\u8d39\u91d1\u989d\u5927\u4e8e\u7f34\u8d39\u91d1\u989d\uff01");
        }
        String payChannel = inpatientPayorderEntity.getPaymentSeq();
        if (StringUtil.isBlank((String)body.getPayChannel())) {
            log.error("RefundServiceImpl.checkParams->\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a");
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a\uff01");
        }
        if (!body.getPayChannel().trim().equals(payChannel)) {
            log.error("RefundServiceImpl.checkInHospitalParams->\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u652f\u4ed8\u6e20\u9053\u53c2\u6570\u4e3a:{}", (Object)body.getPayChannel());
            throw new OutreachException("\u9000\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff01");
        }
    }

    private BaseResponse<String> inHospitalPaymentRefund(InpatientDepositDetailEntity inpatientDepositDetailEntity, InpatientPayorderEntity inpatientPayorderEntity) {
        RefundOrderVoReq refundOrderVoReq = new RefundOrderVoReq();
        refundOrderVoReq.setPayChannel(inpatientPayorderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.mchCode);
        refundOrderVoReq.setOutTradeNo(inpatientDepositDetailEntity.getOrderSeq());
        refundOrderVoReq.setDealTradeNo(inpatientPayorderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(inpatientDepositDetailEntity.getMoney());
        refundOrderVoReq.setRefundAmount(inpatientPayorderEntity.getDealMoney());
        log.info("inHospitalPaymentRefund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("inHospitalPaymentRefund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        return baseResponse;
    }
}

