/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.common.third;

import com.ebaiyihui.medicalcloud.common.third.PrescPdfPath;
import com.ebaiyihui.medicalcloud.config.PrescPdfConfig;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.pojo.vo.PresInfoDTO;
import com.ebaiyihui.medicalcloud.utils.OSSClientUtil;
import com.ebaiyihui.medicalcloud.utils.PdfUtil;
import com.ebaiyihui.medicalcloud.utils.QrcodeUtil;
import com.ebaiyihui.medicalcloud.utils.RandomUtils;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PrescPdf {
    private static final Logger log = LoggerFactory.getLogger(PrescPdf.class);
    public static final String PDF_PRIFIX = "byh-presc-";
    private List<PresInfoDTO> prescInfoList;
    private List<String> docList;
    private PrescPdfConfig pdfConfig;
    private List<PrescPdfPath> pdfPath;
    private String ossFile;
    private String fileName;
    private String ossPath;
    private String htmlPath;

    public PrescPdf(List<PresInfoDTO> prescInfos, PrescPdfConfig pdfConfig, String ossHost, String path) throws BusinessException {
        boolean empty = CollectionUtils.isEmpty(prescInfos);
        if (empty) {
            throw new BusinessException("\u5904\u65b9\u7b3a\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.prescInfoList = prescInfos;
        this.pdfConfig = pdfConfig;
        this.init(prescInfos, ossHost, path);
    }

    public boolean toPdf() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean genPdf = PdfUtil.genPdf((List)this.docList, (OutputStream)os);
        if (!genPdf) {
            return false;
        }
        ByteArrayInputStream instream = new ByteArrayInputStream(os.toByteArray());
        OSSClientUtil.uploadFile2OSS((InputStream)instream, (String)this.ossFile);
        return true;
    }

    private void init(List<PresInfoDTO> presInfoDTOS, String ossHost, String path) {
        this.docList = new ArrayList();
        this.pdfPath = new ArrayList();
        this.fileName = PDF_PRIFIX + presInfoDTOS.get(0).getMainId() + RandomUtils.generateRandom((int)6) + ".pdf";
        this.ossFile = this.pdfConfig.getPdfBasePath() + this.fileName;
        for (int i = 0; i < presInfoDTOS.size(); ++i) {
            PresInfoDTO presInfoDTO = presInfoDTOS.get(i);
            this.htmlPath = path + this.fileName;
            this.ossPath = OSSClientUtil.getViewUrl((String)ossHost, (String)this.ossFile);
            PrescPdfPath perscPdfPath = this.genPrescPdfPath(presInfoDTO);
            this.pdfPath.add(perscPdfPath);
            String doc = this.getDoc(presInfoDTO, presInfoDTOS.size(), i);
            this.docList.add(doc);
        }
    }

    private PrescPdfPath genPrescPdfPath(PresInfoDTO presInfoDTO) {
        PrescPdfPath prescPdfPath = new PrescPdfPath();
        prescPdfPath.setPresCode(presInfoDTO.getPresCode());
        prescPdfPath.setOssPath(this.ossPath);
        prescPdfPath.setHtmlPath(this.htmlPath);
        return prescPdfPath;
    }

    private String getDoc(PresInfoDTO presInfoDTO, int total, int index) {
        try {
            Template template = this.pdfConfig.getConfiguration().getTemplate("prescTemplate", "utf-8");
            StringWriter out = new StringWriter();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("vo", presInfoDTO);
            map.put("price", presInfoDTO.getPrePrice());
            map.put("icon", presInfoDTO.getPresPdfIcon());
            String qrcode = this.getQrcode(this.htmlPath);
            map.put("qrcode", qrcode);
            map.put("totalpage", total);
            map.put("currentPage", index + 1);
            template.process(map, (Writer)out);
            String doc = out.toString();
            return doc;
        }
        catch (TemplateException | IOException e) {
            log.error("\u6839\u636e\u6a21\u677f\u751f\u6210html\u5931\u8d25, presCode={}", e);
            throw new RuntimeException(e);
        }
    }

    private String getQrcode(String qrcodeContent) {
        int width = this.pdfConfig.getQrcodeWidth();
        int height = this.pdfConfig.getQrcodeHeight();
        BufferedImage genImage = QrcodeUtil.genImage((String)qrcodeContent, (int)width, (int)height);
        return QrcodeUtil.writeImageToString((BufferedImage)genImage);
    }

    public static String getZryhTemplateName(String basePath, String templateName) {
        byte[] downloadLocal = OSSClientUtil.downloadLocal((String)(basePath + templateName));
        return new String(downloadLocal, StandardCharsets.UTF_8);
    }

    public static String getPdfPrifix() {
        return PDF_PRIFIX;
    }

    public List<PresInfoDTO> getPrescInfoList() {
        return this.prescInfoList;
    }

    public void setPrescInfoList(List<PresInfoDTO> prescInfoList) {
        this.prescInfoList = prescInfoList;
    }

    public List<String> getDocList() {
        return this.docList;
    }

    public void setDocList(List<String> docList) {
        this.docList = docList;
    }

    public PrescPdfConfig getPdfConfig() {
        return this.pdfConfig;
    }

    public void setPdfConfig(PrescPdfConfig pdfConfig) {
        this.pdfConfig = pdfConfig;
    }

    public List<PrescPdfPath> getPdfPath() {
        return this.pdfPath;
    }

    public void setPdfPath(List<PrescPdfPath> pdfPath) {
        this.pdfPath = pdfPath;
    }

    public String getOssFile() {
        return this.ossFile;
    }

    public void setOssFile(String ossFile) {
        this.ossFile = ossFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getOssPath() {
        return this.ossPath;
    }

    public void setOssPath(String ossPath) {
        this.ossPath = ossPath;
    }

    public String getHtmlPath() {
        return this.htmlPath;
    }

    public void setHtmlPath(String htmlPath) {
        this.htmlPath = htmlPath;
    }

    public String toString() {
        return "PrescPdf [prescInfoList=" + this.prescInfoList + ", docList=" + this.docList + ", pdfConfig=" + this.pdfConfig + ", pdfPath=" + this.pdfPath + ", ossFile=" + this.ossFile + ", fileName=" + this.fileName + ", ossPath=" + this.ossPath + ", htmlPath=" + this.htmlPath + "]";
    }
}

