/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.presciption.PrescriptionReqVO;
import com.ebaiyihui.medicalcloud.service.MedicarePrescriptionService;
import com.ebaiyihui.medicalcloud.service.RscRecipePushService;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/thirdApi"})
public class ThirdApiController {
    private static final Logger log = LoggerFactory.getLogger(ThirdApiController.class);
    @Autowired
    MedicarePrescriptionService medicarePrescriptionService;
    @Autowired
    private RscRecipePushService rscRecipePushService;

    @ApiOperation(value="\u83b7\u53d6\u5904\u65b9\u5171\u4eab\u6d41\u8f6c\u5e73\u53f0HIS\u7cfb\u7edf\uff08RSC\uff09token", notes="\u83b7\u53d6token")
    @GetMapping(value={"/rsc/getRscAccessToken"})
    public BaseResponse<String> getRscAccessToken() throws Exception {
        String rscAccessToken = this.rscRecipePushService.getRscAccessToken("4c2vnna3mt5x03c85m", "k968wtkv2cjujkebmc4nuo85", "r4vxahx67t2ow8xdcc670dy0zdf827wa");
        log.info("========\u83b7\u53d6\u5904\u65b9\u5171\u4eab\u6d41\u8f6c\u5e73\u53f0HIS\u7cfb\u7edf\uff08RSC\uff09token:{}", (Object)(StringUtil.isNotEmpty((String)rscAccessToken) ? rscAccessToken : "\u5f53\u524d\u83b7\u53d6token\u6709\u8bef"));
        return BaseResponse.success((Object)rscAccessToken);
    }

    @ApiOperation(value="\u83b7\u53d6\u5904\u65b9\u5171\u4eab\u6d41\u8f6c\u5e73\u53f0HIS\u7cfb\u7edf\uff08RSC\uff09sign", notes="\u83b7\u53d6sign")
    @PostMapping(value={"/rsc/getRscSign"})
    public BaseResponse<String> getRscSign(@RequestBody Map<String, Object> map) {
        String rscSign = this.rscRecipePushService.getRscSign(map, "r4vxahx67t2ow8xdcc670dy0zdf827wa");
        log.info("========\u83b7\u53d6\u5904\u65b9\u5171\u4eab\u6d41\u8f6c\u5e73\u53f0HIS\u7cfb\u7edf\uff08RSC\uff09\u7b7e\u540d:{}", (Object)rscSign);
        return BaseResponse.success((Object)rscSign);
    }

    @ApiOperation(value="\u83b7\u53d6his\u5904\u65b9\u4e0a\u4f20\u5230\u7701\u4e2d\u5fc3", notes="\u83b7\u53d6his\u5904\u65b9\u4e0a\u4f20\u5230\u7701\u4e2d\u5fc3")
    @PostMapping(value={"/hisPresc/uploadPresc"})
    public String uploadPresc(@RequestBody PrescriptionReqVO prescriptionReqVO) {
        log.info("his\u5904\u65b9\u4e0a\u4f20\u5165\u53c2" + JSONObject.toJSONString((Object)prescriptionReqVO));
        if ("4201".equals(prescriptionReqVO.getMethod())) {
            String uploadPresc = this.medicarePrescriptionService.uploadPresc(prescriptionReqVO);
            log.info("========\u83b7\u53d6his\u5904\u65b9\u4e0a\u4f20\u5230\u7701\u4e2d\u5fc3:{}", (Object)uploadPresc);
            return uploadPresc;
        }
        if ("4202".equals(prescriptionReqVO.getMethod())) {
            String uploadPresc = this.medicarePrescriptionService.revokeHisPresc(prescriptionReqVO);
            log.info("========\u83b7\u53d6his\u5904\u65b9\u64a4\u9500:{}", (Object)uploadPresc);
            return uploadPresc;
        }
        return "";
    }
}

