/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.account.DoctorInfoRespVO;
import com.ebaiyihui.medicalcloud.common.constants.BusinessConstant;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.DrugMainManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.im.Message;
import com.ebaiyihui.medicalcloud.pojo.vo.AccountVO;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PushGroupMsgDataVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PushGroupMsgReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PushSingleMsgDataVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PushSingleMsgReqVO;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;

@Service
@EnableAsync
public class AsynManage {
    private static final Logger log = LoggerFactory.getLogger(AsynManage.class);
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private DrugMainManage drugMainManage;
    @Autowired
    private MosDrugMainMapper drugMainMapper;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    private static final String PERSONAL = "1";
    private static final String TEAM = "2";

    @Async
    public <T> void imPushMsgByMainId(String businessCode, String mainId, String hisRecipeNo, String appCode, String userId, String admissionId, T message, Integer messageType) {
        try {
            log.info("=====\u533b\u5631:{}\u5f00\u59cb\u53d1\u9001IM\u63a8\u9001", (Object)mainId);
            PushSingleMsgReqVO pushSingleMsgReqVO = new PushSingleMsgReqVO();
            pushSingleMsgReqVO.setBusiCode("zxzx");
            pushSingleMsgReqVO.setUniqueId(admissionId);
            ArrayList<PushSingleMsgDataVO> dataVOList = new ArrayList<PushSingleMsgDataVO>();
            PushSingleMsgDataVO pushSingleMsgDataVO = new PushSingleMsgDataVO();
            pushSingleMsgDataVO.setActionType("system");
            AccountVO toAccountVO = new AccountVO();
            toAccountVO.setAppCode(appCode);
            toAccountVO.setUserId(userId);
            pushSingleMsgDataVO.setToAccount(toAccountVO);
            DrugMainEntity mainEntity = this.drugMainMapper.queryById(mainId);
            Integer orderSource = null;
            if (mainEntity != null && Objects.equals(mainEntity.getPresOrgan(), "GNYFY")) {
                orderSource = mainEntity.getPrescriptionSource();
            }
            Message stringMessage = new Message();
            stringMessage.setBusinessCode(businessCode);
            stringMessage.setMainId(mainId);
            stringMessage.setMessageType(messageType);
            stringMessage.setData(message);
            stringMessage.setAdmissionId(admissionId);
            stringMessage.setHisRecipeNo(hisRecipeNo);
            stringMessage.setOrderSource(orderSource);
            pushSingleMsgDataVO.setMessage(JSON.toJSONString((Object)stringMessage));
            pushSingleMsgDataVO.setSyncFlag(BusinessConstant.COMMON_DELAY_TIME);
            dataVOList.add(pushSingleMsgDataVO);
            pushSingleMsgReqVO.setMsgData(dataVOList);
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("/cloud/imsys/impush/pushsinglemsg").toString();
            log.info("IM\u63a8\u9001\u8bf7\u6c42url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)pushSingleMsgReqVO));
            String dataStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)pushSingleMsgReqVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("IM\u63a8\u9001\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)dataStr);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AsynException(e.getMessage());
        }
    }

    private PushSingleMsgReqVO setSingleMsg(String appCode, String userId, String admissionId, Message stringMessage) {
        PushSingleMsgReqVO pushSingleMsgReqVO = new PushSingleMsgReqVO();
        pushSingleMsgReqVO.setBusiCode("zxzx");
        pushSingleMsgReqVO.setUniqueId(admissionId);
        ArrayList<PushSingleMsgDataVO> dataVOList = new ArrayList<PushSingleMsgDataVO>();
        PushSingleMsgDataVO pushSingleMsgDataVO = new PushSingleMsgDataVO();
        pushSingleMsgDataVO.setActionType("system");
        AccountVO toAccountVO = new AccountVO();
        toAccountVO.setAppCode(appCode);
        toAccountVO.setUserId(userId);
        pushSingleMsgDataVO.setToAccount(toAccountVO);
        pushSingleMsgDataVO.setMessage(JSON.toJSONString((Object)stringMessage));
        pushSingleMsgDataVO.setSyncFlag(BusinessConstant.COMMON_DELAY_TIME);
        dataVOList.add(pushSingleMsgDataVO);
        pushSingleMsgReqVO.setMsgData(dataVOList);
        return pushSingleMsgReqVO;
    }

    private PushGroupMsgReqVO setGroupMsg(String appCode, String userId, String admissionId, Message stringMessage, FromOutlineVO fromOutlineVO) {
        PushGroupMsgReqVO pushGroupMsgReqVO = new PushGroupMsgReqVO();
        pushGroupMsgReqVO.setBusiCode("zxzx");
        pushGroupMsgReqVO.setTreatmentId(admissionId);
        ArrayList<PushGroupMsgDataVO> msgGroupDatas = new ArrayList<PushGroupMsgDataVO>();
        ArrayList<AccountVO> toAccount = new ArrayList<AccountVO>();
        if ("EHOS_PATIENT".equals(appCode)) {
            AccountVO accountVO = new AccountVO();
            accountVO.setAppCode(appCode);
            accountVO.setUserId(userId);
            toAccount.add(accountVO);
        } else if ("EHOS_DOCTOR".equals(appCode)) {
            List teamDoctorIds = fromOutlineVO.getTeamDoctorIds();
            teamDoctorIds.forEach(e -> {
                DoctorInfoRespVO userIdByDoctorId = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(e)));
                AccountVO accountVO = new AccountVO();
                accountVO.setAppCode(appCode);
                accountVO.setUserId(userIdByDoctorId.getUserId());
                toAccount.add(accountVO);
            });
        }
        PushGroupMsgDataVO msgGroupData = new PushGroupMsgDataVO();
        msgGroupData.setActionType("system");
        msgGroupData.setToAccount(toAccount);
        msgGroupData.setMessage(JSON.toJSONString((Object)stringMessage));
        msgGroupData.setSyncFlag(BusinessConstant.COMMON_DELAY_TIME);
        msgGroupDatas.add(msgGroupData);
        pushGroupMsgReqVO.setMsgData(msgGroupDatas);
        return pushGroupMsgReqVO;
    }
}

