/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicalcloud.common.enums.ExpressFlagEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.mapper.DrugDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.his.LogisticsRecipeDetail;
import com.ebaiyihui.medicalcloud.pojo.vo.his.LogisticsRecipeItem;
import com.ebaiyihui.medicalcloud.pojo.vo.his.LogisticsRecipeReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.GetPrescriptionStatusReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.GetPriceInfoReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PrescriptionPreSettlementReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PrescriptionStatusItem;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.SettlementResult;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HisManage<T> {
    private static final Logger log = LoggerFactory.getLogger(HisManage.class);
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private MosDrugMainMapper drugMainMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper drugLogisticsOrderMapper;
    @Autowired
    private DrugDetailMapper drugDetailMapper;
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private MosDrugPrescriptionMapper drugPrescriptionMapper;
    @Autowired
    private HisLogService hisLogService;
    private static final Integer CARD_TYPE_SELF_EXPENSE = 1;
    private static final Integer CARD_TYPE_PUSH_EXPENSE = 2;
    public static final int ONE_THOUSAND_METERS = 10000;

    public <T, K> BaseResponse<T> sendHis(String url, FrontRequest<K> param, Class<T> responseClass) {
        try {
            url = new StringBuffer(this.nodeConfig.getHis()).append(url).toString();
            log.info("=======>\u8c03\u7528HIS--->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString(param));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString(param), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528HIS--->\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isBlank((String)result)) {
                return BaseResponse.error((String)"\u8c03\u7528his\u524d\u7f6e\u673a\u5f02\u5e38");
            }
            FrontResponse hisResponse = (FrontResponse)JsonUtil.convertObject((String)result, FrontResponse.class);
            if ("1".equals(hisResponse.getCode())) {
                Object body = JsonUtil.convertObject((String)JsonUtil.convertObject((Object)hisResponse.getBody()), responseClass);
                return BaseResponse.success((Object)body);
            }
            return BaseResponse.error((String)hisResponse.getMessage());
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528HIS\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            return BaseResponse.error((String)"\u8c03\u7528his\u524d\u7f6e\u673a\u5f02\u5e38");
        }
    }

    public Map<String, String> getHisRecipeStatus(List<String> recipes) {
        GetPrescriptionStatusReqVo reqVO = new GetPrescriptionStatusReqVo();
        reqVO.setRecipeNos(recipes);
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)reqVO);
        BaseResponse response = this.sendHis("/hyt-his/api/v1/prescription/getPrescriptionStatus", frontRequest, Object.class);
        if (response == null) {
            return null;
        }
        if (!response.isSuccess()) {
            return null;
        }
        DrugMainEntity mainEntity = this.drugMainMapper.getByHisRecipeNo(recipes.get(0));
        HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/prescription/getPrescriptionStatus", mainEntity.getOrganId());
        hisLogEntity.setResponse(JSONObject.toJSONString((Object)response));
        this.hisLogService.update(hisLogEntity);
        if (response.getData() != null && ((Map)response.getData()).containsKey("items")) {
            List list = (List)((Map)response.getData()).get("items");
            ObjectMapper mapper = new ObjectMapper();
            list = (List)mapper.convertValue((Object)list, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map<String, String> map = list.stream().collect(Collectors.toMap(PrescriptionStatusItem::getReceiptNo, PrescriptionStatusItem::getState));
            return map;
        }
        return null;
    }

    public LogisticsRecipeReqVO getLogisticsRecipeReqVO(String mainId, String address, String fetchMedicalCode) {
        LogisticsRecipeReqVO vo = new LogisticsRecipeReqVO();
        DrugMainEntity drugMainEntity = this.drugMainMapper.queryById(mainId);
        DrugPrescriptionEntity drugPrescriptionEntity = this.drugPrescriptionMapper.queryByMainId(mainId);
        MosDrugLogisticsOrderEntity orderEntity = this.drugLogisticsOrderMapper.selectByMainId(mainId);
        if (orderEntity == null) {
            vo.setPhoneNumber(drugMainEntity.getPatientPhone());
            vo.setReceive(drugMainEntity.getPatientName());
        } else {
            vo.setPhoneNumber(orderEntity.getDestPhone());
            vo.setReceive(orderEntity.getDestName());
            if (OrderTypeEnum.DRUG_ORDER.getValue().equals(drugMainEntity.getOrderType())) {
                vo.setExpressFlag(ExpressFlagEnum.TAKE.getValue().toString());
            } else if (Double.parseDouble(orderEntity.getDestDeliveryDistance()) > 10000.0 || drugMainEntity.getPatientNoType().equals(CARD_TYPE_SELF_EXPENSE)) {
                vo.setExpressFlag(ExpressFlagEnum.JD_DELIVERABLE.getValue().toString());
            } else {
                vo.setExpressFlag(ExpressFlagEnum.HH_DELIVERABLE.getValue().toString());
            }
        }
        ArrayList items = new ArrayList();
        ArrayList<LogisticsRecipeDetail> details = new ArrayList<LogisticsRecipeDetail>();
        vo.setPrescribeNo(drugPrescriptionEntity.getHisRecipeNo());
        vo.setPatientName(drugMainEntity.getPatientName());
        vo.setAddress(address);
        vo.setDrugReceivingCode(fetchMedicalCode);
        vo.setCreateDate(DateUtils.formatDateTime((Date)drugMainEntity.getxCreateTime()));
        if (drugMainEntity.getPaymentType() != null) {
            vo.setCollectionFlag(drugMainEntity.getPaymentType().toString());
        } else {
            vo.setCollectionFlag("1");
        }
        DrugDetailEntity entity = new DrugDetailEntity();
        entity.setMainId(mainId);
        List drugDetailList = this.drugDetailMapper.query(entity);
        drugDetailList.forEach(drug -> {
            LogisticsRecipeItem item = new LogisticsRecipeItem();
            DrugItemEntity drugItemEntity = this.drugItemMapper.getById(drug.getDrugId());
            item.setDrugCode(drugItemEntity.getCommonCode());
            item.setDrugManufactor(drugItemEntity.getManufacturer());
            item.setDrugSpec(drugItemEntity.getDrugSpec());
            item.setDrugName(drug.getDrugName());
            item.setDrugUnits(drug.getWholePackingUnit());
            item.setQuantity(drug.getAmount().toString());
            item.setItemId(drug.getxId());
            items.add(item);
        });
        LogisticsRecipeDetail detail = new LogisticsRecipeDetail();
        detail.setItem(items);
        details.add(detail);
        vo.setPrescribeDetail(details);
        vo.setItemNumber(String.valueOf(items.size()));
        vo.setNotes("\u5907\u6ce8");
        return vo;
    }

    public BaseResponse<?> queryPatientMark(GetPriceInfoReqVo getPriceInfoReqVo, Class<T> responseClass) {
        try {
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("/hyt-his/api/v1/prescription/getPriceInfo").toString();
            log.info("=======>\u8c03\u7528HIS--->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)getPriceInfoReqVo));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)getPriceInfoReqVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528HIS--->\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isBlank((String)result)) {
                return BaseResponse.error((String)"\u8c03\u7528his\u524d\u7f6e\u673a\u5f02\u5e38");
            }
            FrontResponse hisResponse = (FrontResponse)JsonUtil.convertObject((String)result, FrontResponse.class);
            if ("1".equals(hisResponse.getCode())) {
                Object body = JsonUtil.convertObject((String)JsonUtil.convertObject((Object)hisResponse.getBody()), responseClass);
                return BaseResponse.success((Object)body);
            }
            return BaseResponse.error((String)hisResponse.getMessage());
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528HIS\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            return BaseResponse.error((String)"\u8c03\u7528his\u524d\u7f6e\u673a\u5f02\u5e38");
        }
    }

    public BaseResponse<?> preSettlement(PrescriptionPreSettlementReqVo prescriptionPreSettlementReqVo, DrugMainEntity drugMainEntity) {
        try {
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("/hyt-his/api/v1/prescription/preSettlement").toString();
            log.info("=======>\u8c03\u7528HIS--->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)prescriptionPreSettlementReqVo));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)prescriptionPreSettlementReqVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528HIS--->\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isBlank((String)result)) {
                return BaseResponse.error((String)"\u8c03\u7528his\u524d\u7f6e\u673a\u5f02\u5e38");
            }
            String code = JSON.parseObject((String)result).getString("code");
            if (BaseResponse.success().getCode().equals(code) && JSON.parseObject((String)result).getJSONObject("data") != null) {
                SettlementResult settlementResult = (SettlementResult)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), SettlementResult.class);
                drugMainEntity.setTransactionId(settlementResult.getInvoiceNo());
                return BaseResponse.success();
            }
            return BaseResponse.error((String)JSON.parseObject((String)result).getString("msg"));
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528HIS\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            return BaseResponse.error((String)"\u8c03\u7528his\u524d\u7f6e\u673a\u5f02\u5e38");
        }
    }
}

