/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPriceMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUnitMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUsageMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.QueryDrugListReqVO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.QueryDrugListResVO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.QueryStoreListReqVO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.QueryStoreListResVO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPriceEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.medicalcloud.service.DrugItemService;
import com.ebaiyihui.medicalcloud.service.impl.DrugItemServiceImpl;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DrugItemServiceImpl
implements DrugItemService {
    private static final Logger log = LoggerFactory.getLogger(DrugItemServiceImpl.class);
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private MosDrugUnitMapper mosDrugUnitMapper;
    @Autowired
    private MosDrugPriceMapper mosDrugPriceMapper;
    @Autowired
    private MosDrugUsageMapper mosDrugUsageMapper;

    public DrugItemEntity getById(String id) {
        return this.drugItemMapper.getById(id);
    }

    public int insert(DrugItemEntity drugItemEntity) {
        return this.drugItemMapper.insert(drugItemEntity);
    }

    public int updateById(DrugItemEntity drugItemEntity) {
        return this.drugItemMapper.updateById(drugItemEntity);
    }

    public List<QueryStoreListResVO.BodyDTO.StoreInfoListDTO> queryStoreList() throws IOException {
        String responseJson;
        QueryStoreListReqVO reqVO = new QueryStoreListReqVO();
        reqVO.setMethod("111");
        FrontRequest request = new FrontRequest();
        request.setBody((Object)reqVO);
        try {
            responseJson = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryStoreList"), (String)JSON.toJSONString((Object)request));
        }
        catch (IOException e) {
            log.error("HTTP POST \u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)responseJson, (Type)typeRef.getType(), (Feature[])new Feature[0]);
        if (response == null || response.getBody() == null || ((QueryStoreListResVO)response.getBody()).getBody() == null || ((QueryStoreListResVO)response.getBody()).getBody().getStroreInfo() == null) {
            log.warn("\u836f\u623f===\u54cd\u5e94\u4e3a\u7a7a\u6216\u65e0\u6548");
            return new ArrayList<QueryStoreListResVO.BodyDTO.StoreInfoListDTO>();
        }
        List storeInfoList = ((QueryStoreListResVO)response.getBody()).getBody().getStroreInfo();
        if (storeInfoList.isEmpty()) {
            log.info("\u836f\u623f\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        } else {
            log.info("\u836f\u623f\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)storeInfoList));
        }
        return storeInfoList;
    }

    private List<QueryDrugListResVO.BodyDTO.DrugInfoListDTO> queryDrugs(QueryDrugListReqVO reqVO) throws IOException {
        String responseJson;
        FrontRequest request = new FrontRequest();
        request.setBody((Object)reqVO);
        log.info("\u67e5\u8be2\u836f\u54c1\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)reqVO));
        try {
            responseJson = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryDrugList"), (String)JSON.toJSONString((Object)request));
        }
        catch (IOException e) {
            log.error("HTTP POST \u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        log.info("\u67e5\u8be2\u836f\u54c1\u54cd\u5e94: {}", (Object)responseJson);
        2 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)responseJson, (Type)typeRef.getType(), (Feature[])new Feature[0]);
        if (response == null || response.getBody() == null || ((QueryDrugListResVO)response.getBody()).getBody() == null || ((QueryDrugListResVO)response.getBody()).getBody().getDrugInfos() == null) {
            log.warn("\u836f\u54c1==\u54cd\u5e94\u4e3a\u7a7a\u6216\u65e0\u6548");
            return new ArrayList<QueryDrugListResVO.BodyDTO.DrugInfoListDTO>();
        }
        List drugInfos = ((QueryDrugListResVO)response.getBody()).getBody().getDrugInfos();
        if (drugInfos.isEmpty()) {
            log.info("\u836f\u54c1\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        } else {
            log.info("\u836f\u623fcode: {},\u836f\u54c1\u6570\u91cf:{}", (Object)reqVO.getStoreCode(), (Object)JSON.toJSONString((Object)drugInfos.size()));
        }
        return drugInfos;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> synQueryDrugs() throws IOException {
        log.info("=================\u8d63\u5357\u533b\u5f00\u59cb\u540c\u6b65\u836f\u54c1\u4fe1\u606f=================");
        Map<String, DrugUnitEntity> wholePackingUnitMap = this.mosDrugUnitMapper.findDrugUnitByType(Integer.valueOf(1)).stream().collect(Collectors.toMap(DrugUnitEntity::getUnitName, a -> a, (k1, k2) -> k1));
        Map<String, DrugUnitEntity> minBillPackingUnitMap = this.mosDrugUnitMapper.findDrugUnitByType(Integer.valueOf(3)).stream().collect(Collectors.toMap(DrugUnitEntity::getUnitName, a -> a, (k1, k2) -> k1));
        Map<String, DrugUnitEntity> measureUnitMap = this.mosDrugUnitMapper.findDrugUnitByType(Integer.valueOf(4)).stream().collect(Collectors.toMap(DrugUnitEntity::getUnitName, a -> a, (k1, k2) -> k1));
        List storeInfoListDTOS = this.queryStoreList();
        if (storeInfoListDTOS.isEmpty()) {
            return BaseResponse.error((String)"\u836f\u623f\u4fe1\u606f\u4e3a\u7a7a");
        }
        storeInfoListDTOS.forEach(storeInfoListDTO -> {
            List drugInfoListDTOS;
            QueryDrugListReqVO queryDrugListReqVO = new QueryDrugListReqVO();
            queryDrugListReqVO.setStoreCode(storeInfoListDTO.getStoreCode());
            try {
                drugInfoListDTOS = this.queryDrugs(queryDrugListReqVO);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!drugInfoListDTOS.isEmpty()) {
                drugInfoListDTOS.forEach(drugInfoListDTO -> {
                    log.info("\u836f\u54c1\u4fe1\u606fHIS====\u300b{}", (Object)JSON.toJSONString((Object)drugInfoListDTO));
                    DrugItemEntity drugItemEntity = this.drugItemMapper.queryByCommonCodeNew(drugInfoListDTO.getCommonCode(), drugInfoListDTO.getProductCode(), drugInfoListDTO.getStoreCode());
                    if (drugItemEntity == null) {
                        DrugItemEntity add = new DrugItemEntity();
                        add.setxId(GenSeqUtils.getUniqueNo());
                        add.setProductName(drugInfoListDTO.getDrugName());
                        add.setProductCode(drugInfoListDTO.getProductCode());
                        add.setType(Integer.valueOf(drugInfoListDTO.getDrugType()));
                        add.setCommonCode(drugInfoListDTO.getCommonCode());
                        add.setCommonName(drugInfoListDTO.getCommonName());
                        add.setCommonName(drugInfoListDTO.getCommonName());
                        String wholePackingUnit = drugInfoListDTO.getWholePackingUnit();
                        if (wholePackingUnit.equals("\u5343\u514b")) {
                            wholePackingUnit = "kg";
                        }
                        if (wholePackingUnit.equals("\u514b")) {
                            wholePackingUnit = "g";
                        }
                        add.setStockPackingUnitId(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getxId());
                        add.setWholePackingUnitId(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getxId());
                        String minBillPackingUnit = drugInfoListDTO.getMinBillPackingUnit();
                        if (minBillPackingUnit.equals("\u5343\u514b")) {
                            minBillPackingUnit = "kg";
                        }
                        if (minBillPackingUnit.equals("\u514b")) {
                            minBillPackingUnit = "g";
                        }
                        add.setSpecPackingUnitId(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getxId());
                        add.setMinBillPackingUnitId(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getxId());
                        add.setMinBillPackingNum(new BigDecimal(drugInfoListDTO.getMinBillPackingUnitNum()));
                        String measureUnit = drugInfoListDTO.getMeasureUnit();
                        if (measureUnit.equals("wu")) {
                            measureUnit = "WU";
                        }
                        add.setMeasureUnitId(((DrugUnitEntity)measureUnitMap.get(measureUnit)).getxId());
                        add.setMeasureNum(new BigDecimal(drugInfoListDTO.getMeasureNum()));
                        add.setManufacturer(drugInfoListDTO.getManufacturer());
                        add.setStatus(Integer.valueOf(1));
                        add.setDrugSpec(drugInfoListDTO.getDrugSpec());
                        add.setAppCode("GNYFY");
                        BigDecimal itemPrice = new BigDecimal(drugInfoListDTO.getPrice());
                        if (Objects.equals(drugInfoListDTO.getDrugType(), "3")) {
                            itemPrice = itemPrice.divide(new BigDecimal(drugInfoListDTO.getMinBillPackingUnitNum()), 4, RoundingMode.HALF_UP);
                        }
                        add.setPrice(itemPrice);
                        add.setStockPackingUnitName(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getUnitName());
                        add.setWholePackingUnitName(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getUnitName());
                        add.setSpecPackingUnitName(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getUnitName());
                        add.setMinBillPackingUnitName(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getUnitName());
                        add.setMeasureUnitName(((DrugUnitEntity)measureUnitMap.get(measureUnit)).getUnitName());
                        add.setHospitalDrugSpec(drugInfoListDTO.getDrugSpec());
                        add.setStoreCode(drugInfoListDTO.getStoreCode());
                        add.setStoreName(drugInfoListDTO.getStoreName());
                        add.setDrugAttribute("1");
                        add.setxCreateTime(new Date());
                        add.setxUpdateTime(new Date());
                        add.setDrugAttribute("1");
                        log.info("\u65b0\u589e\u836f\u54c1=====\u300b:{}", (Object)JSON.toJSONString((Object)add.getCommonName()));
                        this.drugItemMapper.insert(add);
                        DrugPriceEntity priceEntity = new DrugPriceEntity();
                        priceEntity.setDrugId(add.getxId());
                        priceEntity.setPrice(add.getPrice());
                        priceEntity.setxId(GenSeqUtils.getUniqueNo());
                        priceEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                        priceEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                        this.mosDrugPriceMapper.insert(priceEntity);
                    } else {
                        drugItemEntity.setProductName(drugInfoListDTO.getDrugName());
                        drugItemEntity.setProductCode(drugInfoListDTO.getProductCode());
                        drugItemEntity.setType(Integer.valueOf(drugInfoListDTO.getDrugType()));
                        drugItemEntity.setCommonCode(drugInfoListDTO.getCommonCode());
                        drugItemEntity.setCommonName(drugInfoListDTO.getCommonName());
                        drugItemEntity.setCommonName(drugInfoListDTO.getCommonName());
                        String wholePackingUnit = drugInfoListDTO.getWholePackingUnit();
                        if (wholePackingUnit.equals("\u5343\u514b")) {
                            wholePackingUnit = "kg";
                        }
                        if (wholePackingUnit.equals("\u514b")) {
                            wholePackingUnit = "g";
                        }
                        drugItemEntity.setStockPackingUnitId(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getxId());
                        drugItemEntity.setWholePackingUnitId(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getxId());
                        String minBillPackingUnit = drugInfoListDTO.getMinBillPackingUnit();
                        if (minBillPackingUnit.equals("\u5343\u514b")) {
                            minBillPackingUnit = "kg";
                        }
                        if (minBillPackingUnit.equals("\u514b")) {
                            minBillPackingUnit = "g";
                        }
                        drugItemEntity.setSpecPackingUnitId(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getxId());
                        drugItemEntity.setMinBillPackingUnitId(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getxId());
                        drugItemEntity.setMinBillPackingNum(new BigDecimal(drugInfoListDTO.getMinBillPackingUnitNum()));
                        String measureUnit = drugInfoListDTO.getMeasureUnit();
                        if (measureUnit.equals("wu")) {
                            measureUnit = "WU";
                        }
                        drugItemEntity.setMeasureUnitId(((DrugUnitEntity)measureUnitMap.get(measureUnit)).getxId());
                        drugItemEntity.setMeasureNum(new BigDecimal(drugInfoListDTO.getMeasureNum()));
                        drugItemEntity.setManufacturer(drugInfoListDTO.getManufacturer());
                        drugItemEntity.setStatus(Integer.valueOf(1));
                        drugItemEntity.setDrugSpec(drugInfoListDTO.getDrugSpec());
                        drugItemEntity.setAppCode("GNYFY");
                        BigDecimal itemPrice = new BigDecimal(drugInfoListDTO.getPrice());
                        if (Objects.equals(drugItemEntity.getType(), 3)) {
                            itemPrice = itemPrice.divide(new BigDecimal(drugInfoListDTO.getMinBillPackingUnitNum()), 4, RoundingMode.HALF_UP);
                        }
                        drugItemEntity.setPrice(itemPrice);
                        drugItemEntity.setStockPackingUnitName(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getUnitName());
                        drugItemEntity.setWholePackingUnitName(((DrugUnitEntity)wholePackingUnitMap.get(wholePackingUnit)).getUnitName());
                        drugItemEntity.setSpecPackingUnitName(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getUnitName());
                        drugItemEntity.setMinBillPackingUnitName(((DrugUnitEntity)minBillPackingUnitMap.get(minBillPackingUnit)).getUnitName());
                        drugItemEntity.setMeasureUnitName(((DrugUnitEntity)measureUnitMap.get(measureUnit)).getUnitName());
                        drugItemEntity.setHospitalDrugSpec(drugInfoListDTO.getDrugSpec());
                        drugItemEntity.setStoreCode(drugInfoListDTO.getStoreCode());
                        drugItemEntity.setStoreName(drugInfoListDTO.getStoreName());
                        drugItemEntity.setDrugAttribute("1");
                        drugItemEntity.setxUpdateTime(new Date());
                        log.info("\u66f4\u65b0\u836f\u54c1=====\u300b:{}", (Object)JSON.toJSONString((Object)drugItemEntity.getCommonName()));
                        this.drugItemMapper.updateById(drugItemEntity);
                        DrugPriceEntity byDrugId = this.mosDrugPriceMapper.getByDrugId(drugItemEntity.getxId());
                        byDrugId.setPrice(drugItemEntity.getPrice());
                        this.mosDrugPriceMapper.update(byDrugId);
                    }
                });
            }
        });
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> verifyQyt(String drugId) {
        DrugItemEntity drugItem = this.drugItemMapper.getById(drugId);
        log.info("\u836f\u54c1===\u300b{}", (Object)JSON.toJSONString((Object)drugItem));
        if (drugItem == null) {
            return BaseResponse.error((String)"\u836f\u54c1\u4e0d\u5b58\u5728");
        }
        if (drugItem.getDrugAttribute() == null || Objects.equals(drugItem.getDrugAttribute(), "2")) {
            return BaseResponse.success();
        }
        if (Objects.equals(drugItem.getDrugAttribute(), "1")) {
            QueryDrugListReqVO queryDrugListReqVO = new QueryDrugListReqVO();
            queryDrugListReqVO.setDrugCode(drugItem.getProductCode());
            queryDrugListReqVO.setStoreCode(drugItem.getStoreCode());
            try {
                List drugInfoListDTOS = this.queryDrugs(queryDrugListReqVO);
                if (drugInfoListDTOS.isEmpty()) {
                    return BaseResponse.error((String)"\u67e5\u8be2his\u4e3a\u7a7a");
                }
                QueryDrugListResVO.BodyDTO.DrugInfoListDTO drugInfoListDTO = (QueryDrugListResVO.BodyDTO.DrugInfoListDTO)drugInfoListDTOS.get(0);
                if (drugInfoListDTO.getQyt() == null || Double.parseDouble(drugInfoListDTO.getQyt()) <= 0.0) {
                    return BaseResponse.error((String)"\u836f\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                return BaseResponse.success();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return BaseResponse.success();
    }
}

