/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import com.ebaiyihui.medicalcloud.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    public static void saveZip(String filePath, String zipPath, String name, HttpServletResponse response) {
        File zipFile = new File(zipPath + name + ".zip");
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            File[] files = new File(filePath).listFiles();
            byte[] buffer = new byte[1024];
            for (File file : files) {
                try (FileInputStream fis = new FileInputStream(file);){
                    int len;
                    zos.putNextEntry(new ZipEntry(file.getName()));
                    while ((len = fis.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                    }
                    zos.flush();
                    zos.closeEntry();
                }
                catch (Exception e) {
                    log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
            FileUtils.downloadZip((File)zipFile, (HttpServletResponse)response);
            FileUtils.deleteDir((String)filePath);
            FileUtils.deleteDir((String)zipPath);
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }
}

