/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.webservice.manage;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayTypeEnum;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.OutReachPayReqVO;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.XmlUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@WebService
@Service
public class CloudMedicalManage {
    private static final Logger log = LoggerFactory.getLogger(CloudMedicalManage.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;

    public BaseResponse payment(String xml) {
        OutReachPayReqVO outReachPayReqVO = (OutReachPayReqVO)XmlUtil.convertToJavaBean((String)xml, OutReachPayReqVO.class);
        log.info("\u533b\u4fdd\u652f\u4ed8\u56de\u8c03\u4fe1\u606f->{}", (Object)Objects.toString(outReachPayReqVO, null));
        List hisRecipeNoList = outReachPayReqVO.getRecipeNoVo().getHisRecipeNoList();
        for (String hisRecipeNo : hisRecipeNoList) {
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(hisRecipeNo);
            if (drugMainEntity == null) {
                log.error("\u5904\u65b9\u53f7->{}\u4e0d\u5b58\u5728\uff0c\u5904\u65b9\u652f\u4ed8\u4fe1\u606f->{}", (Object)hisRecipeNo, (Object)Objects.toString(outReachPayReqVO, null));
                continue;
            }
            DrugOrderEntity drugOrderEntity = new DrugOrderEntity();
            drugOrderEntity.setxCreateTime(new Date());
            drugOrderEntity.setxUpdateTime(new Date());
            drugOrderEntity.setMainId(drugMainEntity.getxId());
            drugOrderEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
            drugOrderEntity.setMerchantId(outReachPayReqVO.getMerID());
            drugOrderEntity.setBankTradeNo(outReachPayReqVO.getBankTransNO());
            if ("WX".equalsIgnoreCase(outReachPayReqVO.getPayMethod())) {
                drugOrderEntity.setPayMethod(PayTypeEnum.WECHAT_PAY.getValue());
            } else if ("ZFB".equalsIgnoreCase(outReachPayReqVO.getPayMethod())) {
                drugOrderEntity.setPayMethod(PayTypeEnum.ALI_PAY.getValue());
            } else {
                drugOrderEntity.setPayMethod(outReachPayReqVO.getPayMethod());
            }
            try {
                drugOrderEntity.setPayTime(DateUtils.parseDate((String)outReachPayReqVO.getFeeDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (ParseException e) {
                try {
                    drugOrderEntity.setPayTime(DateUtils.parseDate((String)outReachPayReqVO.getFeeDate(), (String)"yyyy-MM-dd"));
                }
                catch (ParseException e1) {
                    log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
            drugOrderEntity.setOrganCode(drugMainEntity.getPresOrgan());
            drugOrderEntity.setStatus(OrderStatusEnum.HIS_PAID.getValue());
            drugOrderEntity.setMainId(drugMainEntity.getxId());
            drugOrderEntity.setPayAmount(new BigDecimal(outReachPayReqVO.getSelfCost()));
            drugOrderEntity.setTotalDrugAmount(new BigDecimal(outReachPayReqVO.getTotalCost()));
            drugOrderEntity.setSelfAmount(new BigDecimal(outReachPayReqVO.getSelfCost()));
            drugOrderEntity.setFundAmount(new BigDecimal(outReachPayReqVO.getHealCost()));
            DrugOrderEntity oldDrugOrderEntity = this.mosDrugOrderMapper.queryByMainId(drugMainEntity.getxId());
            if (Objects.isNull(oldDrugOrderEntity)) {
                drugOrderEntity.setxId(GenSeqUtils.getUniqueNo());
                drugOrderEntity.setOrderSeq(GenSeqUtils.getUniqueNo());
                this.mosDrugOrderMapper.insert(drugOrderEntity);
            } else {
                drugOrderEntity.setxId(oldDrugOrderEntity.getxId());
                drugOrderEntity.setOrderSeq(GenSeqUtils.getUniqueNo());
                this.mosDrugOrderMapper.update(drugOrderEntity);
            }
            drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
            drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
            drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
            this.mosDrugMainMapper.update(drugMainEntity);
        }
        return BaseResponse.success();
    }
}

