/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.aop;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Configuration
public class LogRecordAspect {
    private static final Logger log = LoggerFactory.getLogger(LogRecordAspect.class);

    @Pointcut(value="execution(* com.ebaiyihui.medicalcloud.controller..*.*(..))")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        long startTime = System.currentTimeMillis();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String queryString = request.getQueryString();
        Object[] args = pjp.getArgs();
        String params = "";
        if (args.length > 0) {
            if ("POST".equals(method)) {
                Object object = args[0];
                if (Objects.nonNull(object)) {
                    Map map = LogRecordAspect.getKeyAndValue((Object)object);
                    params = JSON.toJSONString((Object)map);
                }
            } else if ("GET".equals(method)) {
                params = queryString;
            }
        }
        log.info("\n---------------------------------------\u8bf7\u6c42\u5f00\u59cb-------------------------------------------\n=======\u8bf7\u6c42\u5730\u5740: " + url + "    \u8bf7\u6c42\u65b9\u6cd5: " + method + "\n=======User-Agent: " + request.getHeader("User-Agent") + "\n=======Class Method: " + pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName() + "\n=======Cookies: " + Arrays.toString(request.getCookies()) + "\n=======\u8bf7\u6c42\u53c2\u6570: " + params);
        Object result = pjp.proceed();
        log.info("\n=======\u8017\u65f6 : " + (System.currentTimeMillis() - startTime) + "ms\n=======\u8fd4\u56de\u7ed3\u679c\u4e3a: " + JSON.toJSONString((Object)result) + "\n=======AppLogAspect.doAfterReturning()\n---------------------------------------\u8bf7\u6c42\u7ed3\u675f-------------------------------------------");
        return result;
    }

    public static Map<String, Object> getKeyAndValue(Object obj) {
        Field[] fs;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> userCla = obj.getClass();
        for (Field f : fs = userCla.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                Object val = f.get(obj);
                map.put(f.getName(), val);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        return map;
    }
}

