/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.log.util.StringUtil;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugRecordDto;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupCartDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupSaveReqDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugGroupEntity;
import com.ebaiyihui.medicalcloud.service.MosDrugGroupService;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5904\u65b9\u6a21\u677f"})
@RequestMapping(value={"/api/presTemplate/"})
public class PresTemplateController {
    private static final Logger log = LoggerFactory.getLogger(PresTemplateController.class);
    @Autowired
    private MosDrugGroupService mosDrugGroupService;
    @Autowired
    private RedisUtil redisUtil;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58\u5904\u65b9\u6a21\u677f", notes="\u4fdd\u5b58\u5904\u65b9\u6a21\u677f")
    public BaseResponse<Object> save(@RequestBody @Validated DrugGroupSaveReqDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugGroupService.savePresTemplate(dto);
    }

    @GetMapping(value={"list"})
    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u6a21\u677f\u5217\u8868", notes="\u67e5\u8be2\u5904\u65b9\u6a21\u677f\u5217\u8868")
    public BaseResponse<List<MosDrugGroupEntity>> presTemplateList(@RequestParam(value="doctorId", defaultValue="") String doctorId, @RequestParam(value="drugType", required=false) Integer drugType, @RequestParam(value="pageIndex", defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", defaultValue="15") Integer pageSize) {
        if (StringUtil.isBlank((String)doctorId)) {
            return BaseResponse.error((String)"doctorId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return this.mosDrugGroupService.presTemplateList(doctorId, drugType, pageIndex, pageSize);
    }

    @PostMapping(value={"/shopPingSaveTemple"})
    @ApiOperation(value="\u6a21\u677f\u52a0\u5165\u8d2d\u7269\u8f66", notes="\u5f15\u7528\u6a21\u677f\u52a0\u5165\u8d2d\u7269\u8f66\u4e2d")
    public BaseResponse<String> shopPingSaveTemple(@RequestBody DrugGroupCartDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        for (DrugRecordDto drugRecordDto : dto.getDrugRecordDto()) {
            if (drugRecordDto.getType() != null) continue;
            drugRecordDto.setType(DrugTypeEnum.WCTM.getValue());
        }
        log.info("==========>\u6a21\u677f\u52a0\u5165\u8d2d\u7269\u8f66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (CollectionUtils.isEmpty((Collection)dto.getDrugRecordDto())) {
            return BaseResponse.error((String)"\u8bf7\u9009\u62e9\u836f\u54c1");
        }
        String key = dto.getOrderNumber() + "_" + dto.getOrganCode() + "_" + dto.getDrugType();
        Object oldList = this.redisUtil.get(key);
        if (oldList == null) {
            List drugRecordDtoList = dto.getDrugRecordDto();
            Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
            if (b.booleanValue()) {
                return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        List drugRecordDtoList = JSONObject.parseArray((String)oldList.toString(), DrugRecordDto.class);
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            Iterator iterator = dto.getDrugRecordDto().iterator();
            while (iterator.hasNext()) {
                if (!((DrugRecordDto)iterator.next()).getDrugCode().equals(drugRecordDto.getDrugCode())) continue;
                iterator.remove();
            }
        }
        drugRecordDtoList.addAll(dto.getDrugRecordDto());
        Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
        if (b.booleanValue()) {
            return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

