/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.medicalcloud.pojo.vo.AddOrdersReqVo;
import com.ebaiyihui.medicalcloud.service.NcefyPrescriptionService;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddOrderPrescriptionRepeatReceiver {
    private static final Logger log = LoggerFactory.getLogger(AddOrderPrescriptionRepeatReceiver.class);
    @Autowired
    private NcefyPrescriptionService ncefyPrescriptionService;
    @Autowired
    private RedisUtil redisUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"prescription.add.order.repeat.test"})
    @RabbitHandler
    public void process(String mainInfo) {
        log.info("\u63a8\u9001\u5904\u65b9\u3001\u5f00\u59cb\u6d88\u8d39\u961f\u5217\u3001\u961f\u5217\u6d88\u8d39\u5185\u5bb9\u4e3a{}: ", (Object)mainInfo);
        if (StringUtils.isEmpty((String)mainInfo)) {
            log.info("\u961f\u5217\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        String[] infoArray = mainInfo.split("&&&-&&&");
        if (infoArray.length < 3) {
            log.info("\u961f\u5217\u5185\u5bb9\u53d1\u751f\u9519\u8bef");
            return;
        }
        String redisKey = mainInfo.substring(0, mainInfo.lastIndexOf("&&&-&&&"));
        log.info("\u5f00\u59cb\u4eceredis\u4e2d\u83b7\u53d6\uff0ckey\u4e3a{}", (Object)redisKey);
        String voString = (String)this.redisUtil.get(redisKey);
        if (StringUtils.isEmpty((String)voString)) {
            log.info("\u7f13\u5b58\u4e2d\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        AddOrdersReqVo addOrdersReqVo = (AddOrdersReqVo)JSON.parseObject((String)voString, AddOrdersReqVo.class);
        if (Objects.isNull(addOrdersReqVo)) {
            log.info("\u7f13\u5b58\u4e2d\u653e\u7f6e\u7684\u5bf9\u8c61JSON\u683c\u5f0f\u4e0d\u5bf9");
            this.redisUtil.del(new String[]{redisKey});
            return;
        }
        if (!infoArray[2].equalsIgnoreCase(addOrdersReqVo.getUuid())) {
            log.info("\u5f53\u524d\u961f\u5217\u4e2d\u7684UUID\u4e0eJSON\u5bf9\u8c61\u4e2d\u4e0d\u5339\u914d\uff0c\u4e3a{}\uff0c\u4e0d\u6d88\u8d39\uff0c\u9000\u51fa\u3002", (Object)infoArray[2]);
            return;
        }
        try {
            log.info("\u5f00\u59cb\u8bf7\u6c42\u63a8\u9001\u5904\u65b9\u4e1a\u52a1\u903b\u8f91\u65b9\u6cd5,\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)addOrdersReqVo));
            this.ncefyPrescriptionService.addOrders(addOrdersReqVo);
        }
        catch (Exception e) {
            try {
                log.error("\u5904\u7406\u63a8\u9001\u5904\u65b9\u4e1a\u52a1\u903b\u8f91\u53d1\u751f\u9519\u8bef\uff1a", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.redisUtil.del(new String[]{redisKey});
                throw throwable;
            }
            this.redisUtil.del(new String[]{redisKey});
            return;
        }
        this.redisUtil.del(new String[]{redisKey});
        log.info("mq\u6d88\u606f\u6d88\u8d39\u5b8c\u6bd5\uff0c\u5904\u65b9\u63a8\u9001\u6210\u529f~");
    }
}

