/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String DELAYED_QUEUE_NAME = "logistics.delayed.order.test";
    public static final String DELAYED_PRESCRIPTION_QUEUE_NAME = "prescription.delayed.order.test";
    public static final String ADD_PRESCRIPTION_ORDER_REPEAT_QUEUE_NAME = "prescription.add.order.repeat.test";
    public static final String PUSH_PRESCRIPTION_MAIN_ERROR_QUEUE_NAME = "prescription.push.main.error.test";
    public static final String EXCHANGE_NAME = "logistics.delayed_exchange";
    public static final String DELAY_ORDER_ROUTING_KEY = "logistics.delayed_order_routing_key";
    public static final String DELAY_PRESCRIPTION_ORDER_ROUTING_KEY = "prescription.delayed_order_routing_key";
    public static final String ADD_PRESCRIPTION_ORDER_REPEAT_ROUTING_KEY = "prescription.add_order_repeat_routing_key";
    public static final String PUSH_PRESCRIPTION_MAIN_ERROR_ROUTING_KEY = "prescription.push_main_error_routing_key";

    @Bean
    public Queue queue() {
        return new Queue(DELAYED_QUEUE_NAME);
    }

    @Bean
    public Queue prescriptionQueue() {
        return new Queue(DELAYED_PRESCRIPTION_QUEUE_NAME);
    }

    @Bean
    public Queue addOrderQueue() {
        return new Queue(ADD_PRESCRIPTION_ORDER_REPEAT_QUEUE_NAME);
    }

    @Bean
    public Queue pushMainQueue() {
        return new Queue(PUSH_PRESCRIPTION_MAIN_ERROR_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding bindingPrescription() {
        return BindingBuilder.bind((Queue)this.prescriptionQueue()).to((Exchange)this.customExchange()).with(DELAY_PRESCRIPTION_ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to((Exchange)this.customExchange()).with(DELAY_ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding bindingAddOrderRepeat() {
        return BindingBuilder.bind((Queue)this.addOrderQueue()).to((Exchange)this.customExchange()).with(ADD_PRESCRIPTION_ORDER_REPEAT_ROUTING_KEY).noargs();
    }

    @Bean
    Binding bindingPushMainError() {
        return BindingBuilder.bind((Queue)this.pushMainQueue()).to((Exchange)this.customExchange()).with(PUSH_PRESCRIPTION_MAIN_ERROR_ROUTING_KEY).noargs();
    }

    @Bean
    public TopicExchange shangRaoPushExchange() {
        return new TopicExchange("-node-push-topic-exchange");
    }
}

