/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.mapper.StoreDoctorRelMapper;
import com.ebaiyihui.medicalcloud.mapper.StoreHospitalRelMapper;
import com.ebaiyihui.medicalcloud.mapper.StoreStockRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.DrugItemResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.DrugStoreListResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.GetInHospitalStoreDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.QueryStoreListReqVO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.QueryStoreListResVO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.StockEditResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.store.StoreStockResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.StoreStockRelEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.detail.DrugstoreManageDetailReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.detail.DrugstoreManageDetailResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.page.DrugStoreManageListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.page.DrugStoreManageListResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.save.DrugstoreSaveData;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.save.DrugstoreSaveReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.save.StoreDoctorRelSaveData;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.save.StoreHospitalRelSaveData;
import com.ebaiyihui.medicalcloud.service.MosDrugstoreService;
import com.ebaiyihui.medicalcloud.service.impl.MosDrugstoreServiceImpl;
import com.ebaiyihui.medicalcloud.utils.AppCodeUtil;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.PageUtil;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MosDrugstoreServiceImpl
implements MosDrugstoreService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugstoreServiceImpl.class);
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;
    @Autowired
    private StoreStockRelMapper storeStockRelMapper;
    @Autowired
    private StoreHospitalRelMapper storeHospitalRelMapper;
    @Autowired
    private StoreDoctorRelMapper storeDoctorRelMapper;
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private RedisUtil redisUtil;

    public DrugstoreEntity queryById(String xId) {
        return this.mosDrugstoreMapper.queryById(xId);
    }

    public DrugstoreEntity insert(DrugstoreEntity mosDrugstore) {
        this.mosDrugstoreMapper.insert(mosDrugstore);
        return mosDrugstore;
    }

    public DrugstoreEntity update(DrugstoreEntity mosDrugstore) {
        this.mosDrugstoreMapper.update(mosDrugstore);
        return this.queryById(mosDrugstore.getxId());
    }

    public BaseResponse<List<DrugStoreListResDTO>> list(DrugStoreListResDTO param) {
        log.info("=======>\u60a3\u8005\u7aef\u836f\u623f\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)param));
        param.setOrganCode(AppCodeUtil.tranCode((String)param.getOrganCode()));
        List list = this.mosDrugstoreMapper.queryPatient(param);
        for (DrugStoreListResDTO dto : list) {
            if (!StringUtils.isNotEmpty((String)param.getMainId())) continue;
            System.out.println(dto.getxId());
            List storeStockRelEntities = this.storeStockRelMapper.queryStockByMainId(param.getMainId(), dto.getxId());
            for (StoreStockRelEntity storeStockRelEntity : storeStockRelEntities) {
                if (Integer.valueOf(storeStockRelEntity.getStatus()) == 0 || Integer.valueOf(storeStockRelEntity.getStockStatus()) == 0) {
                    dto.setStockStatus("\u90e8\u5206\u836f\u54c1\u5df2\u552e\u7a7a\uff0c\u8bf7\u8c28\u614e\u9009\u62e9\uff01");
                    continue;
                }
                dto.setStockStatus("");
            }
            if (!DateUtils.judgeBusinessTime((String)dto.getBusinessDay(), (String)dto.getBusinessTime())) {
                dto.setBusinessStatus("\u4e0d\u5728\u8425\u4e1a\u65f6\u95f4\u5185");
                continue;
            }
            dto.setBusinessStatus("");
        }
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<DrugstoreManageDetailResVO> manageDetail(DrugstoreManageDetailReqVO vo) {
        log.info("=======>\u7ba1\u7406\u7aef\u836f\u623f\u8be6\u60c5----->{}", (Object)JSON.toJSONString((Object)vo));
        DrugstoreManageDetailResVO resVO = new DrugstoreManageDetailResVO();
        DrugstoreEntity drugstoreEntity = new DrugstoreEntity();
        drugstoreEntity.setxId(vo.getxId());
        List list = this.mosDrugstoreMapper.query(drugstoreEntity);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            drugstoreEntity = (DrugstoreEntity)list.get(0);
            BeanUtils.copyProperties((Object)drugstoreEntity, (Object)resVO);
            List hospitalList = this.storeHospitalRelMapper.queryByStoreId(vo.getxId());
            List doctorList = this.storeDoctorRelMapper.queryByStoreId(vo.getxId());
            resVO.setHospitalList(hospitalList);
            resVO.setDoctorList(doctorList);
        }
        return BaseResponse.success((Object)resVO);
    }

    public BaseResponse<PageResult<DrugStoreManageListResVO>> managePagingList(DrugStoreManageListReqVO vo) {
        log.info("=======>\u5206\u9875\u836f\u623f\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
        int count = 0;
        int totalPage = 0;
        PageResult result = new PageResult();
        List list = new ArrayList();
        List statusList = vo.getOnlineStatus();
        if (CollectionUtils.isNotEmpty((Collection)statusList)) {
            PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
            list = this.mosDrugstoreMapper.managePageQuery(vo, statusList);
            count = this.mosDrugstoreMapper.managePageCount(vo, statusList);
            totalPage = PageUtil.getTotalPage((int)count, (int)vo.getPageSize());
        }
        result.setPageNum(vo.getPageNum().intValue());
        result.setPageSize(vo.getPageSize().intValue());
        result.setTotalPages(totalPage);
        result.setTotal(count);
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> save(DrugstoreSaveReqVO vo) {
        log.info("=======>\u4fdd\u5b58\u836f\u623f\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
        String storeId = null;
        int count = 0;
        DrugstoreSaveData storeParam = vo.getStoreParam();
        DrugstoreEntity entity = new DrugstoreEntity();
        entity.setAppCode(vo.getAppCode());
        BeanUtils.copyProperties((Object)storeParam, (Object)entity);
        List hospitalList = vo.getHospitalList();
        List doctorList = vo.getDoctorList();
        if (storeParam.getDistributionStatus() == 0) {
            storeParam.setExpressFee(BigDecimal.ZERO);
        }
        DrugstoreEntity drugstoreEntity = new DrugstoreEntity();
        drugstoreEntity.setStoreCode(storeParam.getStoreCode());
        drugstoreEntity.setAppCode(vo.getAppCode());
        List list = this.mosDrugstoreMapper.query(drugstoreEntity);
        if (StringUtils.isNotEmpty((String)storeParam.getxId())) {
            storeId = storeParam.getxId();
            DrugstoreEntity storeEntity = this.mosDrugstoreMapper.queryById(storeParam.getxId());
            if (storeEntity == null) {
                return BaseResponse.error((String)"\u836f\u623f\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (CollectionUtils.isNotEmpty((Collection)list) && !storeParam.getStoreCode().equals(storeEntity.getStoreCode())) {
                return BaseResponse.error((String)"\u836f\u623f\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d");
            }
            ArrayList<String> hospitalStoreIds = new ArrayList<String>();
            hospitalStoreIds.add(storeId);
            this.storeHospitalRelMapper.updateBatchByStoreId(hospitalStoreIds);
            ArrayList<String> doctorStoreIds = new ArrayList<String>();
            doctorStoreIds.add(storeId);
            this.storeDoctorRelMapper.updateBatchByStoreId(doctorStoreIds);
            this.mosDrugstoreMapper.update(entity);
        } else {
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return BaseResponse.error((String)"\u836f\u623f\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d");
            }
            storeId = UUIDUtils.getUUID();
            entity.setxId(storeId);
            this.mosDrugstoreMapper.insert(entity);
            ArrayList<StoreStockRelEntity> stockList = new ArrayList<StoreStockRelEntity>();
            List drugItemEntityList = this.drugItemMapper.getItemAndPriceList(Integer.valueOf(1), vo.getAppCode());
            for (DrugItemResultDTO itemResultDTO : drugItemEntityList) {
                StoreStockRelEntity stockRelEntity = new StoreStockRelEntity();
                stockRelEntity.setxId(UUIDUtils.getUUID());
                stockRelEntity.setStoreId(storeId);
                stockRelEntity.setDrugId(itemResultDTO.getDrugId());
                stockList.add(stockRelEntity);
            }
            if (CollectionUtils.isNotEmpty(stockList)) {
                count = this.storeStockRelMapper.insertBatch(stockList);
                log.info("======>\u6dfb\u52a0\u5e93\u5b58 - \u6dfb\u52a0\u6570\u91cf:{},\u6210\u529f\u6570\u91cf:{}", (Object)stockList.size(), (Object)count);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)hospitalList)) {
            for (StoreHospitalRelSaveData hospitalRelEntity : hospitalList) {
                hospitalRelEntity.setxId(UUIDUtils.getUUID());
                hospitalRelEntity.setStoreId(storeId);
            }
            count = this.storeHospitalRelMapper.insertBatch(hospitalList);
            log.info("======>\u6dfb\u52a0\u533b\u9662 - \u6dfb\u52a0\u6570\u91cf:{},\u6210\u529f\u6570\u91cf:{}", (Object)hospitalList.size(), (Object)count);
        }
        if (CollectionUtils.isNotEmpty((Collection)doctorList)) {
            for (StoreDoctorRelSaveData doctorRelEntity : doctorList) {
                doctorRelEntity.setxId(UUIDUtils.getUUID());
                doctorRelEntity.setStoreId(storeId);
            }
            count = this.storeDoctorRelMapper.insertBatch(doctorList);
            log.info("======>\u6dfb\u52a0\u836f\u5e08 - \u6dfb\u52a0\u6570\u91cf:{},\u6210\u529f\u6570\u91cf:{}", (Object)doctorList.size(), (Object)count);
        }
        return BaseResponse.success((Object)storeId);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> delete(List<String> storeIds) {
        log.info("=======>\u5220\u9664\u836f\u623f\u53c2\u6570----->{}", (Object)JSON.toJSONString(storeIds));
        int count = this.mosDrugstoreMapper.queryUnsignedOrderByIds(storeIds);
        if (count > 0) {
            return BaseResponse.error((String)"\u836f\u623f\u5b58\u5728\u672a\u7b7e\u6536\u7684\u8ba2\u5355\u4e0d\u53ef\u5220\u9664");
        }
        this.storeStockRelMapper.updateBatchByStoreId(storeIds);
        this.storeHospitalRelMapper.updateBatchByStoreId(storeIds);
        this.storeDoctorRelMapper.updateBatchByStoreId(storeIds);
        return BaseResponse.success((Object)this.mosDrugstoreMapper.updateStatusBatch(storeIds));
    }

    public BaseResponse<PageResult<StoreStockResDTO>> stockPagingList(PageResult<StoreStockResDTO> param) {
        log.info("=======>\u5206\u9875\u5e93\u5b58\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString(param));
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        String orderBy = StringUtils.isBlank((String)param.getOrderBy()) ? "x_create_time" : param.getOrderBy();
        param.setOrderBy(orderBy);
        List list = this.storeStockRelMapper.pageQuery(param);
        int count = this.storeStockRelMapper.count(param);
        int totalPage = PageUtil.getTotalPage((int)count, (int)param.getPageSize());
        param.setTotalPages(totalPage);
        param.setTotal(count);
        param.setContent(list);
        return BaseResponse.success(param);
    }

    public BaseResponse<Object> stockEdit(StockEditResDTO param) {
        StoreStockRelEntity entity = new StoreStockRelEntity();
        entity.setxId(param.getStockId());
        entity.setStockStatus(param.getStockStatus());
        return BaseResponse.success((Object)this.storeStockRelMapper.updateById(entity));
    }

    public BaseResponse<List<QueryStoreListResVO.BodyDTO.StoreInfoListDTO>> getInHospitalStore(GetInHospitalStoreDTO param) {
        String res;
        String key = "gnyfy_in_hospital_store_list";
        Object object = this.redisUtil.get(key);
        log.info("hospital_store_list key:{},value:{}", (Object)key, object);
        List storeInfoListDTOS = null;
        if (object != null) {
            storeInfoListDTOS = JSONObject.parseArray((String)object.toString(), QueryStoreListResVO.BodyDTO.StoreInfoListDTO.class);
        }
        if (storeInfoListDTOS != null) {
            return BaseResponse.success(storeInfoListDTOS);
        }
        QueryStoreListReqVO reqVO = new QueryStoreListReqVO();
        reqVO.setStoreCode(param.getStoreCode());
        FrontRequest request = new FrontRequest();
        request.setBody((Object)reqVO);
        try {
            res = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryStoreList"), (String)JSON.toJSONString((Object)request));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        1 icdCodeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)res, (Type)icdCodeTypeReference.getType(), (Feature[])new Feature[0]);
        if (response == null || response.getBody() == null) {
            log.info("\u672a\u83b7\u53d6\u5230his\u9662\u5185\u836f\u623f\u4fe1\u606f");
            return BaseResponse.success(new ArrayList());
        }
        List body = ((QueryStoreListResVO)response.getBody()).getBody().getStroreInfo();
        if (param.getKeyWords() != null && !param.getKeyWords().isEmpty()) {
            body = body.stream().filter(item -> item.getStoreName().contains(param.getKeyWords()) || item.getStoreCode().contains(param.getKeyWords())).collect(Collectors.toList());
        }
        log.info("\u83b7\u53d6\u5230his\u9662\u5185\u836f\u623f\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)body));
        this.redisUtil.set(key, (Object)JSON.toJSONString((Object)body), 86400L);
        return BaseResponse.success(body);
    }
}

