/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiSignUtil {
    private static final Logger log = LoggerFactory.getLogger(ApiSignUtil.class);
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String DEFAULT_CHARSET = "UTF-8";

    public static String getNoncestr() {
        return RandomUtil.randomString((int)32);
    }

    public static String getNoncestr(int length) {
        return RandomUtil.randomString((int)length);
    }

    public static boolean verifyMD5(Map<String, Object> signMap, String sign, String signNonce, String signKey) {
        if (signMap.isEmpty()) {
            return false;
        }
        return sign.toUpperCase().equals(ApiSignUtil.signStr(signMap, (String)signNonce, (String)signKey).toUpperCase());
    }

    public static String encodeByMD5(String str) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes());
            return ApiSignUtil.getFormattedText((byte[])messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeByMD5(String str, String charSet) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes(charSet));
            return ApiSignUtil.getFormattedText((byte[])messageDigest.digest()).toUpperCase();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (int j = 0; j < len; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public static String createLinkString(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = Convert.toStr((Object)params.get(key));
            if (NumberUtil.isDouble((String)value)) {
                DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
                Double doubleValue = Convert.toDouble((Object)value);
                value = decimalFormat.format(doubleValue);
            }
            if (StrUtil.isBlank((CharSequence)value)) continue;
            if (JSONObject.isValidObject((String)value)) {
                value = JSONUtil.toJsonStr((Object)params.get(key));
                value = ApiSignUtil.objectSort((String)value);
            }
            if (JSONArray.isValidArray((String)value)) {
                value = ApiSignUtil.arraySort((String)value);
            }
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    private static String objectSort(String text) {
        JSONObject jsonObj = JSONObject.parseObject((String)text);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : jsonObj.keySet()) {
            if (!StrUtil.isNotBlank((CharSequence)jsonObj.getString(key))) continue;
            map.put(key, jsonObj.get((Object)key));
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = jsonObj.getString(key);
            if (StrUtil.isBlank((CharSequence)value)) continue;
            if (JSONObject.isValidObject((String)value)) {
                sb.append(key).append("=").append(ApiSignUtil.objectSort((String)value));
            } else if (JSONArray.isValidArray((String)value)) {
                sb.append(key).append("=").append(ApiSignUtil.arraySort((String)value));
            } else {
                sb.append(key).append("=").append(value);
            }
            if (i >= keys.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String arraySort(String text) {
        JSONArray array = JSONArray.parseArray((String)text);
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < array.size(); ++i) {
            String value = Convert.toStr((Object)array.get(i));
            if (JSONObject.isValidObject((String)value)) {
                value = ApiSignUtil.objectSort((String)value);
            }
            if (i < array.size() - 1) {
                sb.append(value).append(",");
                continue;
            }
            sb.append(value);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String signStr(Map<String, Object> signMap, String nonce, String key) {
        signMap = ApiSignUtil.clearSign(signMap);
        String prestr = ApiSignUtil.createLinkString((Map)signMap);
        log.info("\u5f85\u7b7e\u540d\u4e32\uff1a{}", (Object)(prestr + "&Nonce=" + nonce + "&Key=" + key));
        String sign = ApiSignUtil.encodeByMD5((String)(prestr + "&Nonce=" + nonce + "&Key=" + key), (String)DEFAULT_CHARSET);
        return sign;
    }

    public static void signMap(Map<String, Object> signMap, String nonce, String key) {
        String sign = ApiSignUtil.signStr(signMap, (String)nonce, (String)key);
        signMap.put("Sign", sign);
    }

    public static String getPayGateSign(String key, Object o) throws IllegalAccessException {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> cls = o.getClass(); cls != null; cls = cls.getSuperclass()) {
            fieldList.addAll(Arrays.asList(cls.getDeclaredFields()));
        }
        for (Field f : fieldList) {
            f.setAccessible(true);
            if (f.get(o) == null || f.get(o).toString().equals("") || f.getName().equals("sign")) continue;
            String value = Convert.toStr((Object)f.get(o));
            if (NumberUtil.isDouble((String)value)) {
                DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
                Double doubleValue = Convert.toDouble((Object)value);
                value = decimalFormat.format(doubleValue);
            }
            list.add(f.getName() + "=" + value + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "Key=" + key;
        System.out.println(result);
        return ApiSignUtil.encodeByMD5((String)result, (String)DEFAULT_CHARSET);
    }

    public static String encodeHex(String str) {
        byte[] input = str.getBytes();
        try {
            input = str.getBytes(DEFAULT_CHARSET);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Hex.encodeHexString((byte[])input);
    }

    public static String decodeHex(String input) {
        try {
            byte[] output = Hex.decodeHex((char[])input.toCharArray());
            try {
                return new String(output, DEFAULT_CHARSET);
            }
            catch (Exception e) {
                return new String(output);
            }
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeBase64(String str) {
        byte[] input = str.getBytes();
        try {
            input = str.getBytes(DEFAULT_CHARSET);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Base64.encodeBase64String((byte[])input);
    }

    public static String decodeBase64(String input) {
        byte[] output = Base64.decodeBase64((String)input);
        try {
            return new String(output, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            return new String(output);
        }
    }

    public static Map<String, Object> clearSign(Map<String, Object> signMap) {
        signMap.remove("Sign");
        signMap.remove("Nonce");
        return signMap;
    }

    public static Map<String, Object> bean2Map(Object data) {
        Map map = new HashMap();
        try {
            map = BeanUtils.describe((Object)data);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bf9\u8c61\u8f6cmap\u5931\u8d25");
        }
        map.remove("class");
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.putAll(map);
        return newMap;
    }

    public static Map<String, Object> bean2MapFilterNull(Object data) {
        Map map = new HashMap();
        try {
            map = BeanUtils.describe((Object)data);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bf9\u8c61\u8f6cmap\u5931\u8d25");
        }
        map.remove("class");
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (!StrUtil.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            newMap.put((String)entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    public static String shaEncode(String inStr) throws Exception {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        byte[] byteArray = inStr.getBytes("UTF-8");
        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String encryptAES(byte[] contentBytes, byte[] keyBytes) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
            cipher.init(1, key);
            byte[] tmp = cipher.doFinal(contentBytes);
            return new String(Base64.encodeBase64((byte[])tmp));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptAES(byte[] contentBytes, byte[] keyBytes) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
            cipher.init(2, key);
            byte[] tmp = cipher.doFinal(Base64.decodeBase64((byte[])contentBytes));
            return tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRandomNum() {
        return StrUtil.fillBefore((String)("" + RandomUtil.randomInt((int)9999)), (char)'0', (int)4);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(encryptKey.getBytes());
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, random);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), "AES"));
            return cipher.doFinal(content.getBytes("utf-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sha1Encode(String inStr) throws Exception {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA1");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        byte[] byteArray = inStr.getBytes("UTF-8");
        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String sha512(String str) {
        return ApiSignUtil.sha((String)str, (String)"sha-512");
    }

    public static String sha(String str, String algorithm) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance(algorithm);
            mdTemp.update(str.getBytes("UTF-8"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            log.info("sha \u52a0\u5bc6\u5931\u8d25:{}", (Throwable)e);
            return null;
        }
    }
}

