/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

public class BASE64DecodedMultipartFile
implements MultipartFile {
    private final byte[] imgContent;
    private final String header;

    public BASE64DecodedMultipartFile(byte[] imgContent, String header) {
        this.imgContent = imgContent;
        this.header = header.split(";")[0];
    }

    public String getName() {
        return (double)System.currentTimeMillis() + Math.random() + "." + this.header.split("/")[1];
    }

    public String getOriginalFilename() {
        return System.currentTimeMillis() + (long)((int)Math.random() * 10000) + "." + this.header.split("/")[1];
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.imgContent;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        new FileOutputStream(dest).write(this.imgContent);
    }

    public static MultipartFile base64ToMultipart(String base64) {
        try {
            String[] baseStrs = base64.split(",");
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] b = decoder.decodeBuffer(baseStrs[1]);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            return new BASE64DecodedMultipartFile(b, baseStrs[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String stringToBase64(String string) {
        try {
            String s = Base64.getEncoder().encodeToString(string.trim().getBytes("utf-8"));
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

