/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static <T> List<T> convertCollection(String json, Class<? extends Collection> collection, Class<T> clazz) {
        try {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CollectionType javaType = mapper.getTypeFactory().constructCollectionType(collection, clazz);
            return (List)mapper.readValue(json, (JavaType)javaType);
        }
        catch (Exception var4) {
            log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)var4);
            return null;
        }
    }

    public static <T> T convertObject(String json, Class<T> clazz) {
        try {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception var3) {
            log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)var3);
            return null;
        }
    }

    public static String convertObject(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception var2) {
            log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)var2);
            return null;
        }
    }
}

