/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Configuration
public class LogRecordAspect {
    private static final Logger log = LoggerFactory.getLogger(LogRecordAspect.class);

    @Pointcut(value="execution(* com.ebaiyihui.medicalcloud.controller..*.*(..))")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String queryString = request.getQueryString();
        Object[] args = pjp.getArgs();
        String params = "";
        if (args.length > 0) {
            if ("POST".equals(method)) {
                Object object = args[0];
                if (Objects.nonNull(object)) {
                    Map map = LogRecordAspect.getKeyAndValue((Object)object);
                    params = JSON.toJSONString((Object)map);
                }
            } else if ("GET".equals(method)) {
                params = queryString;
            }
        }
        log.info("\u8bf7\u6c42\u5f00\u59cb===\u5730\u5740:{}======\u7c7b\u578b:{}======\u53c2\u6570:{}", new Object[]{url, method, params});
        Object result = pjp.proceed();
        log.info("\u8bf7\u6c42\u7ed3\u675f===\u8fd4\u56de\u503c{}", JSONObject.toJSON((Object)result));
        return result;
    }

    public static Map<String, Object> getKeyAndValue(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> userCla = obj.getClass();
        Field[] fs = userCla.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            Object val = new Object();
            try {
                val = f.get(obj);
                map.put(f.getName(), val);
                continue;
            }
            catch (IllegalArgumentException e) {
                log.error("ERROR", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                log.error("ERROR", (Throwable)e);
            }
        }
        return map;
    }
}

