/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.config;

import com.ebaiyihui.medicalcloud.utils.Base64Util;
import com.ebaiyihui.medicalcloud.utils.OSSClientUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="prescpdf")
public class PrescPdfConfig {
    private Configuration configuration;
    private String basePath;
    private String pdfBasePath;
    private String iconName;
    private int qrcodeWidth;
    private int qrcodeHeight;
    private List<String> slashNameList;
    private List<String> slashList;

    @Bean
    public Configuration initConfiguration() {
        this.configuration = new Configuration(Configuration.VERSION_2_3_25);
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        this.configuration.setTemplateLoader((TemplateLoader)stringLoader);
        return this.configuration;
    }

    public String getIcon() {
        byte[] downloadLocal = OSSClientUtil.downloadLocal((String)(this.basePath + this.iconName));
        return Base64Util.encodeBase64((byte[])downloadLocal);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public int getQrcodeWidth() {
        return this.qrcodeWidth;
    }

    public void setQrcodeWidth(int qrcodeWidth) {
        this.qrcodeWidth = qrcodeWidth;
    }

    public int getQrcodeHeight() {
        return this.qrcodeHeight;
    }

    public void setQrcodeHeight(int qrcodeHeight) {
        this.qrcodeHeight = qrcodeHeight;
    }

    public List<String> getSlashNameList() {
        return this.slashNameList;
    }

    public void setSlashNameList(List<String> slashNameList) {
        this.slashNameList = slashNameList;
    }

    public List<String> getSlashList() {
        if (this.slashList != null) {
            return this.slashList;
        }
        this.slashList = new ArrayList();
        for (String slashName : this.slashNameList) {
            byte[] slashImg = OSSClientUtil.downloadLocal((String)(this.basePath + slashName));
            String slashBase64 = Base64Util.encodeBase64((byte[])slashImg);
            this.slashList.add(slashBase64);
        }
        return this.slashList;
    }

    public void setSlashList(List<String> slashList) {
        this.slashList = slashList;
    }

    public String getPdfBasePath() {
        return this.pdfBasePath;
    }

    public void setPdfBasePath(String pdfBasePath) {
        this.pdfBasePath = pdfBasePath;
    }
}

