/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugCommentVO;
import com.ebaiyihui.medicalcloud.service.DrugCommentService;
import com.ebaiyihui.medicalcloud.utils.ExcelUtils;
import com.ebaiyihui.medicalcloud.utils.excel.DrugCommentExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u70b9\u8bc4\u4fe1\u606f API"})
@RequestMapping(value={"/api/comment"})
public class DrugCommentController {
    private static final Logger log = LoggerFactory.getLogger(DrugCommentController.class);
    @Autowired
    DrugCommentService drugCommentService;

    @RequestMapping(value={"/addComment"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6dfb\u52a0\u70b9\u8bc4\u4fe1\u606f", notes="\u6dfb\u52a0\u70b9\u8bc4\u4fe1\u606f")
    public BaseResponse addComment(@RequestBody @Validated DrugCommentVO drugCommentVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugCommentService.addComment(drugCommentVO);
    }

    @ApiOperation(value="\u5904\u65b9\u8ba2\u5355\u70b9\u8bc4\u4fe1\u606f\u6279\u91cf\u5bfc\u51fa\u4e3aExcel")
    @PostMapping(value={"/v1/exportCommentExcel"})
    public void exportCommentExcel(@RequestParam(value="mainIds", defaultValue="") List<String> mainIds, HttpServletResponse response) throws IOException {
        List list = this.drugCommentService.exportCommentExcel(mainIds);
        ExcelUtils.exportExcel((List)list, null, (String)"\u5904\u65b9\u8ba2\u5355\u53ca\u70b9\u8bc4\u4fe1\u606f", DrugCommentExcel.class, (String)"\u5904\u65b9\u8ba2\u5355\u53ca\u70b9\u8bc4\u4fe1\u606f", (HttpServletResponse)response);
    }
}

