/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.pojo.dto.LogisticsDetailResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.LogisticsResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.LogisticsDetailResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.LogisticsResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.HuaHongResultVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.LogisticsRecipeReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.AddressQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.CheckDeliveryRangeReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.ComfireSendReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.ExtraQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.LogisticExportReqVo;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.LogisticService;
import com.ebaiyihui.medicalcloud.service.MosDrugLogisticsOrderService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.utils.ExcelUtils;
import com.ebaiyihui.medicalcloud.utils.excel.LogisticInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7269\u6d41 API"})
@RequestMapping(value={"/api/logistics"})
public class LogisticsController {
    private static final Logger log = LoggerFactory.getLogger(LogisticsController.class);
    @Resource
    private LogisticService logisticService;
    @Autowired
    private MosDrugLogisticsOrderService mosDrugLogisticsOrderService;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private HisLogService hisLogService;

    @ApiOperation(value="\u7269\u6d41\u5217\u8868", notes="\u7269\u6d41\u5217\u8868")
    @PostMapping(value={"/getLogisticsList"})
    public BaseResponse<List<LogisticsResDTO>> getLogisticsList(@RequestBody @Validated LogisticsResVO logisticsResVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugLogisticsOrderService.getLogisticsList(logisticsResVO);
    }

    @ApiOperation(value="\u7269\u6d41\u8be6\u60c5", notes="\u7269\u6d41\u8be6\u60c5")
    @PostMapping(value={"/detail"})
    public BaseResponse<LogisticsDetailResDTO> logisticsDetail(@RequestBody @Validated LogisticsDetailResVO detailResVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugLogisticsOrderService.logisticsDetail(detailResVO);
    }

    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u8d85\u51fa\u914d\u9001\u8ddd\u79bb", notes="\u5224\u65ad\u662f\u5426\u8d85\u51fa\u914d\u9001\u8ddd\u79bb")
    @PostMapping(value={"/checkDeliveryRange"})
    public BaseResponse checkDeliveryRange(@RequestBody @Validated CheckDeliveryRangeReqVo checkDeliveryRangeReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugLogisticsOrderService.checkDeliveryRange(checkDeliveryRangeReqVo);
    }

    @ApiOperation(value="\u4e2d\u65e5\u7269\u6d41\u53d1\u8d27", notes="\u4e2d\u65e5\u7269\u6d41\u53d1\u8d27")
    @PostMapping(value={"/logisticsSend"})
    public BaseResponse<HuaHongResultVo> logisticsSend(@RequestParam(value="mainId") String mainId) {
        DrugMainEntity mainEntity = this.mosDrugMainService.queryById(mainId);
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderService.selectByMainId(mainEntity.getxId());
        LogisticsRecipeReqVO logisticsRecipeReqVO = this.hisManage.getLogisticsRecipeReqVO(mainEntity.getxId(), mosDrugLogisticsOrderEntity.getDestAddress(), mainEntity.getFetchMedicalCode());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)logisticsRecipeReqVO);
        BaseResponse huaHongResultResponse = this.hisManage.sendHis("/zryh-his/api/v1/logistics/synLogisticsRecipe", frontRequest, HuaHongResultVo.class);
        HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/logistics/synLogisticsRecipe", mainEntity.getOrganId());
        hisLogEntity.setResponse(JSONObject.toJSONString((Object)huaHongResultResponse));
        this.hisLogService.update(hisLogEntity);
        return huaHongResultResponse;
    }

    @PostMapping(value={"/v1/extra/query"})
    @ApiModelProperty(value="\u83b7\u53d6\u65f6\u6548\u8fd0\u8d39", notes="\u83b7\u53d6\u65f6\u6548\u8fd0\u8d39")
    public BaseResponse<String> extraQuery(@RequestBody @Validated ExtraQueryReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.logisticService.extraQuery(vo);
    }

    @PostMapping(value={"/v1/address/query"})
    @ApiModelProperty(value="\u83b7\u53d6\u533b\u9662\u5730\u5740", notes="\u83b7\u53d6\u533b\u9662\u5730\u5740")
    public BaseResponse<String> addressQuery(@RequestBody @Validated AddressQueryReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.logisticService.addressQuery(vo);
    }

    @GetMapping(value={"/v1/exportExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u7269\u6d41\u4fe1\u606fexcel", notes="\u5bfc\u51faexcel")
    public void exportExcel(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="status", defaultValue="0") Integer status, @RequestParam(value="timeType", defaultValue="0") Integer timeType, @RequestParam(value="startTime", defaultValue="") String startTime, @RequestParam(value="endTime", defaultValue="") String endTime, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="listId", defaultValue="") List<Long> listId, HttpServletResponse response) throws IOException {
        List list = this.logisticService.exportExcel(appCode, timeType, startTime, endTime, status, search, listId);
        ExcelUtils.exportExcel((List)list, null, (String)"\u7269\u6d41\u4fe1\u606f", LogisticInfo.class, (String)"\u7269\u6d41\u4fe1\u606f", (HttpServletResponse)response);
    }

    @PostMapping(value={"/v2/exportExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u7269\u6d41\u4fe1\u606fexcel", notes="\u5bfc\u51faexcel")
    public void exportExcelV2(@RequestBody LogisticExportReqVo logisticExportReqVo, HttpServletResponse response) throws IOException {
        List list = this.logisticService.exportExcel(logisticExportReqVo.getAppCode(), logisticExportReqVo.getTimeType(), logisticExportReqVo.getStartTime(), logisticExportReqVo.getEndTime(), logisticExportReqVo.getStatus(), logisticExportReqVo.getSearch(), logisticExportReqVo.getListId());
        ExcelUtils.exportExcel((List)list, null, (String)"\u7269\u6d41\u4fe1\u606f", LogisticInfo.class, (String)"\u7269\u6d41\u4fe1\u606f", (HttpServletResponse)response);
    }

    @PostMapping(value={"/v1/comfire"})
    @ApiOperation(value="\u786e\u8ba4\u53d1\u8d27", notes="\u786e\u8ba4\u53d1\u8d27")
    public BaseResponse<Object> confirmSend(@RequestBody @Validated ComfireSendReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.logisticService.confirmSend(vo);
    }
}

