/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.factory;

import com.ebaiyihui.medicalcloud.annotation.PresRoamProcessCode;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessService;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.beans.BeansException;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PresRoamProcessStrategyFactory
implements CommandLineRunner,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static HashMap<String, PresRoamProcessService> presRoamProcessCodeMap;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(String ... args) {
        this.initUserTypeStrategyMap();
    }

    private void initUserTypeStrategyMap() {
        Collection requestMethodList = this.applicationContext.getBeansOfType(PresRoamProcessService.class).values();
        presRoamProcessCodeMap = new HashMap(requestMethodList.size());
        for (PresRoamProcessService logisticsStrategyService : requestMethodList) {
            Class<?> aClass = logisticsStrategyService.getClass();
            PresRoamProcessCode annotation = aClass.getAnnotation(PresRoamProcessCode.class);
            if (annotation == null) continue;
            presRoamProcessCodeMap.put(annotation.value(), logisticsStrategyService);
        }
    }

    public static PresRoamProcessService getPresRoamProcessStrategy(String presRoamProcessCode) {
        PresRoamProcessService presRoamProcessService = (PresRoamProcessService)presRoamProcessCodeMap.get(presRoamProcessCode);
        return presRoamProcessService;
    }
}

