/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.dto.UcConfigurationDTO;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.medicalcloud.common.enums.DeviceTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.pojo.dto.doctor.LastLoginDeviceReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.YoumengClientCodeVO;
import com.ebaiyihui.medicalcloud.pojo.vo.YoumengConfigurationResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.GoeasyPushMsgWithUserIdReqVO;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.push.pojo.alisms.AliSmsSendAuthCodeReqPhoneVO;
import com.ebaiyihui.push.pojo.umeng.android.AndroidUnicastReqVO;
import com.ebaiyihui.push.pojo.umeng.ios.IOSUnicastReqVO;
import com.ebaiyihui.push.pojo.wechat.PushSubscribeMessageReqVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;

@Service
@EnableAsync
public class PushManage {
    private static final Logger log = LoggerFactory.getLogger(PushManage.class);
    @Autowired
    private NodeConfig nodeConfig;

    @Async
    public void iSMSPush(String appSdkType, String appCode, String signCode, String templateCode, String phone, Map param) {
        log.info("======>\u77ed\u4fe1\u63a8\u9001appSdkType={},appCode={},signCode={},templateCode={},phone={},param={}", new Object[]{appSdkType, appCode, signCode, templateCode, phone, JSON.toJSONString((Object)param)});
        String url = new StringBuffer(this.nodeConfig.getAddress()).append("cloud/push/alismsapi/sendAuthCodeWithPhone").toString();
        log.info("\u77ed\u4fe1\u63a8\u9001url----------->{}", (Object)url);
        try {
            AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
            aliSmsSendAuthCodeReqPhoneVO.setAppSdkType(appSdkType);
            UcConfigurationVO configurationVO = this.getClientCode(appCode, "sms");
            String clientCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getString("clientCode");
            aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(clientCode);
            aliSmsSendAuthCodeReqPhoneVO.setSignCode(signCode);
            aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(templateCode);
            aliSmsSendAuthCodeReqPhoneVO.setPhone(phone);
            aliSmsSendAuthCodeReqPhoneVO.setParams(param);
            log.info("=======>\u77ed\u4fe1\u63a8\u9001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
            String httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u77ed\u4fe1\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
        }
        catch (Exception e) {
            log.error("=======>\u77ed\u4fe1\u63a8\u9001 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
    }

    @Async
    public void iAppMsgPush(String userType, String appCode, String busiCode, String content, String title, String subTitle, String actionCode, String pushCode, String mainId, LastLoginDeviceReqVO vo) {
        log.info("APP\u6d88\u606f\u63a8\u9001\u53c2\u6570===>busiCode={},content={},title={},subTitle={},actionCode={},pushCode={},mainId={},vo={}", new Object[]{busiCode, content, title, subTitle, actionCode, pushCode, mainId, JSON.toJSONString((Object)vo)});
        try {
            String httpResult = "";
            if (vo != null && StringUtils.isNotEmpty((String)vo.getDeviceNumber()) && StringUtils.isNotEmpty((String)vo.getDeviceType())) {
                String url = new StringBuffer(this.nodeConfig.getAddress()).toString();
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("pushType", "umeng");
                param.put("businessCode", "YYY");
                param.put("actionCode", actionCode);
                param.put("pushCode", pushCode);
                param.put("mainId", mainId);
                if (DeviceTypeEnum.ANDROID.getValue().equals(vo.getDeviceType())) {
                    url = new StringBuffer(url).append("cloud/push/umapi/pushandroidunicast").toString();
                    AndroidUnicastReqVO reqVO = new AndroidUnicastReqVO();
                    reqVO.setText(content);
                    reqVO.setBusiCode(busiCode);
                    reqVO.setClientCode(this.getAppClientCode(appCode, "youmengPush", userType, vo.getDeviceType()));
                    reqVO.setDeviceTokens(vo.getDeviceNumber());
                    reqVO.setExtra(param);
                    reqVO.setTitle(subTitle);
                    reqVO.setTicker(title);
                    reqVO.setUserId(vo.getUserId());
                    reqVO.setDescription(title);
                    log.info("=======>APP\u6d88\u606f\u63a8\u9001------>url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)reqVO));
                    httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)reqVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
                    log.info("=======>APP\u6d88\u606f\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
                } else {
                    url = new StringBuffer(url).append("cloud/push/umapi/pushiosunicast").toString();
                    IOSUnicastReqVO reqVO = new IOSUnicastReqVO();
                    reqVO.setBody(content);
                    reqVO.setBusiCode(busiCode);
                    reqVO.setClientCode(this.getAppClientCode(appCode, "youmengPush", userType, vo.getDeviceType()));
                    reqVO.setDeviceTokens(vo.getDeviceNumber());
                    reqVO.setExtra(param);
                    reqVO.setSubTitle(subTitle);
                    reqVO.setTitle(title);
                    reqVO.setUserId(vo.getUserId());
                    reqVO.setDescription(title);
                    log.info("=======>APP\u6d88\u606f\u63a8\u9001------>url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)reqVO));
                    httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)reqVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
                    log.info("=======>APP\u6d88\u606f\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
                }
            }
        }
        catch (Exception e) {
            log.error("=======>APP\u6d88\u606f\u63a8\u9001 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
    }

    @Async
    public void iWeChatPush(String appCode, String templateCode, String openId, Map<String, Map<String, Object>> data, String page) {
        log.info("appCode={},templateCode={},openId={},data={}", new Object[]{appCode, templateCode, openId, templateCode, JSON.toJSONString(data)});
        try {
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("cloud/push/wechat_message/subscribe_push").toString();
            log.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u63a8\u9001url----------->{}", (Object)url);
            PushSubscribeMessageReqVO vo = new PushSubscribeMessageReqVO();
            vo.setOpenId(openId);
            UcConfigurationVO configurationVO = this.getClientCode(appCode, "weChatApplets");
            String clientCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getString("clientCode");
            vo.setClientCode(clientCode);
            vo.setTemplateCode(templateCode);
            vo.setData(data);
            vo.setPage(page);
            log.info("=======>\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u63a8\u9001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
            String httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)vo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
        }
        catch (Exception e) {
            log.error("=======>\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u63a8\u9001 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
    }

    @Async
    public void iGoEasyPush(String userId, String text, String busiCode) {
        log.info("userId={},text={},busiCode={}", new Object[]{userId, text, busiCode});
        try {
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("cloud/push/goeasy/pushgoeasyuserid").toString();
            log.info("goeasy\u63a8\u9001url----------->{}", (Object)url);
            GoeasyPushMsgWithUserIdReqVO vo = new GoeasyPushMsgWithUserIdReqVO();
            vo.setBusiCode(busiCode);
            vo.setBody(text);
            vo.setUserId(userId);
            log.info("=======>goeasy\u63a8\u9001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
            String httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)vo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>goeasy\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
        }
        catch (Exception e) {
            log.error("=======>goeasy\u63a8\u9001 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
    }

    public String getOpenId(String appCode, String userId) {
        log.info("\u83b7\u53d6openId\u53c2\u6570======>appCode={},userId={}", (Object)appCode, (Object)userId);
        try {
            UcWxAuthRespVo vo;
            boolean status = true;
            boolean type = false;
            String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/usercenter/node/account/getWxAuth").toString();
            log.info("\u83b7\u53d6openId\u7684url----------->{}", (Object)url);
            UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
            ucWxAuthReqVo.setStatus(Short.valueOf((short)(status ? 1 : 0)));
            ucWxAuthReqVo.setUserId(userId);
            ucWxAuthReqVo.setUserType(Short.valueOf((short)(type ? 1 : 0)));
            log.info("=======>\u83b7\u53d6openId\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)ucWxAuthReqVo));
            String httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)ucWxAuthReqVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u83b7\u53d6openId\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
            if (StringUtils.isNotEmpty((String)httpResult) && ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)httpResult).getString("code")) && null != JSONObject.parseObject((String)httpResult).getJSONObject("data") && StringUtils.isNotEmpty((String)(vo = (UcWxAuthRespVo)JSONObject.parseObject((String)JSONObject.parseObject((String)httpResult).getString("data"), UcWxAuthRespVo.class)).getWxOpenid())) {
                return vo.getWxOpenid();
            }
        }
        catch (Exception e) {
            log.error("=======>\u83b7\u53d6openId - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public UcConfigurationVO getClientCode(String appCode, String type) {
        log.info("\u83b7\u53d6\u63a8\u9001client_code\u53c2\u6570======>appCode={},type={}", (Object)appCode, (Object)type);
        try {
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("/cloud/doctoruser/configuration/getdetail").toString();
            log.info("\u83b7\u53d6\u63a8\u9001client_code\u7684url----------->{}", (Object)url);
            UcConfigurationDTO dto = new UcConfigurationDTO();
            dto.setAppCode(appCode);
            dto.setType(type);
            log.info("=======>\u83b7\u53d6\u63a8\u9001client_code\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
            String httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u83b7\u53d6\u63a8\u9001client_code\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
            if (StringUtils.isNotEmpty((String)httpResult) && ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)httpResult).getString("code")) && null != JSONObject.parseObject((String)httpResult).getJSONObject("data")) {
                UcConfigurationVO vo = (UcConfigurationVO)JSONObject.parseObject((String)JSONObject.parseObject((String)httpResult).getString("data"), UcConfigurationVO.class);
                return vo;
            }
        }
        catch (Exception e) {
            log.error("=======>\u83b7\u53d6\u63a8\u9001client_code - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public String getAppClientCode(String appCode, String type, String userType, String deviceType) {
        log.info("\u83b7\u53d6\u63a8\u9001client_code\u53c2\u6570======>appCode={},type={}", (Object)appCode, (Object)type);
        try {
            YoumengConfigurationResVO youmengConfigurationResVO;
            String clientCodeStr;
            List youmengClientCodeVOList;
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("/cloud/doctoruser/configuration/getdetail").toString();
            log.info("\u83b7\u53d6\u63a8\u9001client_code\u7684url----------->{}", (Object)url);
            UcConfigurationDTO dto = new UcConfigurationDTO();
            dto.setAppCode(appCode);
            dto.setType(type);
            log.info("=======>\u83b7\u53d6\u63a8\u9001client_code\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
            String httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u83b7\u53d6\u63a8\u9001client_code\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
            if (StringUtils.isNotEmpty((String)httpResult) && ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)httpResult).getString("code")) && null != JSONObject.parseObject((String)httpResult).getJSONObject("data") && CollectionUtils.isNotEmpty((Collection)(youmengClientCodeVOList = JSONArray.parseArray((String)(clientCodeStr = (youmengConfigurationResVO = (YoumengConfigurationResVO)JSONObject.parseObject((String)JSONObject.parseObject((String)httpResult).getString("data"), YoumengConfigurationResVO.class)).getClientCode()), YoumengClientCodeVO.class)))) {
                for (YoumengClientCodeVO youmengClientCodeVO : youmengClientCodeVOList) {
                    if (!userType.equalsIgnoreCase(youmengClientCodeVO.getUserType()) || !deviceType.equalsIgnoreCase(youmengClientCodeVO.getDeviceType())) continue;
                    return youmengClientCodeVO.getClientCode();
                }
            }
        }
        catch (Exception e) {
            log.error("=======>\u83b7\u53d6\u63a8\u9001client_code - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }
}

