/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.rabbitmq;

import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedLogisticsOrderReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedLogisticsOrderReceiver.class);
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;

    @RabbitListener(queues={"logistics.delayed.order.test"})
    @RabbitHandler
    public void process(String logisticsOrderSeq) {
        log.info("=========================logisticsOrderId: " + logisticsOrderSeq);
        List mosDrugLogisticsOrderRegEntityList = this.mosDrugLogisticsOrderRegMapper.selectByLogisticsOrderSeq(logisticsOrderSeq);
        log.info("mosDrugLogisticsOrderRegEntityList->{}", (Object)mosDrugLogisticsOrderRegEntityList.toString());
        mosDrugLogisticsOrderRegEntityList.stream().forEach(mosDrugLogisticsOrderRegEntity -> {
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mosDrugLogisticsOrderRegEntity.getMainId());
            if (Objects.nonNull(drugMainEntity) && (drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.SIGN_IN.getValue()) || this.specialNodeConfig.getNcdxdefsyy().equals(drugMainEntity.getHospitalNameFirstLetter()) && drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.SENT.getValue()))) {
                this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.FINISH.getValue(), mosDrugLogisticsOrderRegEntity.getMainId());
            }
        });
    }
}

