/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.rabbitmq;

import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.HospitalNamePinYinEnum;
import com.ebaiyihui.medicalcloud.common.enums.HytHisRecipeStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedPrescriptionOrderReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedPrescriptionOrderReceiver.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private MosDrugPrescriptionMapper drugPrescriptionMapper;

    @RabbitListener(queues={"prescription.delayed.order.test"})
    @RabbitHandler
    public void process(String mainId) {
        log.info("=====================orderSeq: " + mainId);
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
        log.info("mosDrugLogisticsOrderRegEntityList->{}", (Object)Objects.toString(drugMainEntity, null));
        if (drugMainEntity == null) {
            return;
        }
        if (HospitalNamePinYinEnum.NCDXDEFSYY.getValue().equals(drugMainEntity.getHospitalNameFirstLetter()) && DrugMainStatusEnum.TO_TAKE.getValue().equals(drugMainEntity.getItemStatus())) {
            this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.FINISH.getValue(), mainId);
            return;
        }
        if ((this.specialNodeConfig.getZryh().equals(drugMainEntity.getPresOrgan()) || this.specialNodeConfig.getHyt().equals(drugMainEntity.getPresOrgan())) && (DrugMainStatusEnum.UNDRUGS.getValue().equals(drugMainEntity.getItemStatus()) || DrugMainStatusEnum.HYT_UNPAID.getValue().equals(drugMainEntity.getItemStatus()) || DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus()) || DrugMainStatusEnum.TO_TAKE.getValue().equals(drugMainEntity.getItemStatus()))) {
            if (this.specialNodeConfig.getHyt().equals(drugMainEntity.getPresOrgan()) && DrugMainStatusEnum.TO_TAKE.getValue().equals(drugMainEntity.getItemStatus())) {
                Map map;
                DrugPrescriptionEntity drugPrescriptionEntity = this.drugPrescriptionMapper.queryByMainId(drugMainEntity.getxId());
                ArrayList<String> recipeNoList = new ArrayList<String>();
                recipeNoList.add(drugPrescriptionEntity.getHisRecipeNo());
                if (CollectionUtils.isNotEmpty(recipeNoList) && (map = this.hisManage.getHisRecipeStatus(recipeNoList)) != null) {
                    DrugMainEntity mainEntity = null;
                    if (HytHisRecipeStatusEnum.PAY.getValue().equals(map.get(drugPrescriptionEntity.getHisRecipeNo())) && OrderTypeEnum.DRUG_ORDER.getValue().equals(drugMainEntity.getOrderType())) {
                        mainEntity = new DrugMainEntity();
                        mainEntity.setxId(drugMainEntity.getxId());
                        mainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                    }
                    if (mainEntity != null) {
                        this.mosDrugMainMapper.update(mainEntity);
                        return;
                    }
                }
            }
            this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.USELESS.getValue(), mainId);
        } else if (drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.ZRYH_UNPAID.getValue()) || drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.DEPLOY_BACK.getValue()) || drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.HYT_UNPAID.getValue())) {
            this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.USELESS.getValue(), mainId);
        }
    }
}

