/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.BaseStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.SexEnum;
import com.ebaiyihui.medicalcloud.mapper.DrugCommentMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugCommentVO;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryDrugDetailDto;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugCommentEntity;
import com.ebaiyihui.medicalcloud.service.DrugCommentService;
import com.ebaiyihui.medicalcloud.utils.BeanHelper;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.excel.DrugCommentExcel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugCommentServiceImpl
implements DrugCommentService {
    @Autowired
    private DrugCommentMapper drugCommentMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;

    public BaseResponse addComment(DrugCommentVO drugCommentVO) {
        DrugCommentEntity drugCommentEntity = this.drugCommentMapper.queryByMainId(drugCommentVO.getMainId());
        boolean insertFlag = false;
        Date now = new Date();
        if (Objects.isNull(drugCommentEntity)) {
            drugCommentEntity = new DrugCommentEntity();
            drugCommentEntity.setxId(GenSeqUtils.getUniqueNo());
            drugCommentEntity.setxCreateTime(now);
            insertFlag = true;
        }
        drugCommentEntity.setxUpdateTime(now);
        drugCommentEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        drugCommentEntity.setMainId(drugCommentVO.getMainId());
        drugCommentEntity.setCommenter(drugCommentVO.getCommenter());
        drugCommentEntity.setOpinion(drugCommentVO.getOpinion());
        drugCommentEntity.setCommentInfo(drugCommentVO.getCommentInfo());
        drugCommentEntity.setRemark(drugCommentVO.getRemark());
        if (insertFlag) {
            this.drugCommentMapper.insert(drugCommentEntity);
        } else {
            this.drugCommentMapper.update(drugCommentEntity);
        }
        return BaseResponse.success();
    }

    public List<DrugCommentExcel> exportCommentExcel(List<String> mainIds) {
        List queryDrugDetailDtoList = this.mosDrugMainMapper.exportDrugDetailExcel(mainIds);
        ArrayList<DrugCommentExcel> result = new ArrayList<DrugCommentExcel>();
        if (queryDrugDetailDtoList != null && queryDrugDetailDtoList.size() > 0) {
            int index = 1;
            for (QueryDrugDetailDto queryDrugDetailDto : queryDrugDetailDtoList) {
                String opinionStr;
                String itemStatusStr;
                DrugCommentExcel drugCommentExcel = new DrugCommentExcel();
                drugCommentExcel.setId(String.valueOf(index++));
                drugCommentExcel.setPresCode(queryDrugDetailDto.getPresCode());
                switch (queryDrugDetailDto.getItemStatus()) {
                    case 80: {
                        itemStatusStr = "\u5df2\u9000\u6b3e";
                        break;
                    }
                    case 100: {
                        itemStatusStr = "\u5f85\u7b7e\u6536";
                        break;
                    }
                    default: {
                        itemStatusStr = DrugMainStatusEnum.getDesc((Integer)queryDrugDetailDto.getItemStatus());
                    }
                }
                drugCommentExcel.setItemStatus(itemStatusStr);
                drugCommentExcel.setPatientName(queryDrugDetailDto.getPatientName());
                drugCommentExcel.setPatientGender(queryDrugDetailDto.getPatientGender() == Short.valueOf(SexEnum.MALE.getValue() + "") ? "\u7537" : "\u5973");
                drugCommentExcel.setPatientAge(queryDrugDetailDto.getPatientAge());
                drugCommentExcel.setPatientNo(queryDrugDetailDto.getPatientNo());
                drugCommentExcel.setPatientPhone(queryDrugDetailDto.getPatientPhone());
                drugCommentExcel.setPatientCredNo(queryDrugDetailDto.getPatientCredNo());
                drugCommentExcel.setPresDoctorName(queryDrugDetailDto.getPresDoctorName());
                drugCommentExcel.setPresDoctorCode(queryDrugDetailDto.getPresDoctorCode());
                drugCommentExcel.setPresDoctorPhone(queryDrugDetailDto.getPresDoctorPhone());
                drugCommentExcel.setPresOrganName(queryDrugDetailDto.getPresOrganName());
                drugCommentExcel.setPresDeptName(queryDrugDetailDto.getPresDeptName());
                drugCommentExcel.setRecipeDate(DateUtils.formatDateTime((Date)queryDrugDetailDto.getXCreateTime()));
                drugCommentExcel.setVerifier(queryDrugDetailDto.getVerifier());
                drugCommentExcel.setVerifierCode(queryDrugDetailDto.getVerifierCode());
                drugCommentExcel.setVerifierPhone(queryDrugDetailDto.getVerifierPhone());
                drugCommentExcel.setVerifierDeptName(queryDrugDetailDto.getVerifierDeptName());
                drugCommentExcel.setDrugName(queryDrugDetailDto.getDrugName());
                drugCommentExcel.setDrugSpec(queryDrugDetailDto.getDrugSpec());
                drugCommentExcel.setManufacturer(queryDrugDetailDto.getManufacturer());
                drugCommentExcel.setDrugUsage("\u6bcf\u6b21" + String.valueOf(queryDrugDetailDto.getSingleDose() == null ? BigDecimal.ZERO : queryDrugDetailDto.getSingleDose()) + queryDrugDetailDto.getMeasureUnit() + "," + queryDrugDetailDto.getUsageDesc() + "," + queryDrugDetailDto.getFrequencyDesc());
                drugCommentExcel.setAmount(String.valueOf(queryDrugDetailDto.getAmount()));
                drugCommentExcel.setUnitPrice(String.valueOf(queryDrugDetailDto.getUnitPrice()));
                drugCommentExcel.setTotalPrice(String.valueOf(queryDrugDetailDto.getTotalPrice()));
                if (queryDrugDetailDto.getOpinion() == null) {
                    opinionStr = "\u672a\u70b9\u8bc4";
                } else {
                    switch (queryDrugDetailDto.getOpinion()) {
                        case 1: {
                            opinionStr = "\u5408\u7406";
                            break;
                        }
                        case 0: {
                            opinionStr = "\u4e0d\u5408\u7406";
                            break;
                        }
                        default: {
                            opinionStr = "\u672a\u70b9\u8bc4";
                        }
                    }
                }
                drugCommentExcel.setOpinion(opinionStr);
                if (Objects.nonNull(queryDrugDetailDto.getOpinion()) && queryDrugDetailDto.getOpinion() == 0) {
                    StringBuffer remark = new StringBuffer("\u7ecf\u70b9\u8bc4\u7684\u5904\u65b9\u4e3a");
                    remark.append(queryDrugDetailDto.getCommentInfo()).append("\u3002");
                    if (StringUtil.isNotEmpty((String)queryDrugDetailDto.getRemark())) {
                        remark.append(queryDrugDetailDto.getRemark());
                    }
                    drugCommentExcel.setRemark(remark.toString());
                }
                BeanHelper.nullToEmpty((Object)drugCommentExcel);
                result.add(drugCommentExcel);
            }
        }
        return result;
    }
}

