/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.enums.BaseStatusEnum;
import com.ebaiyihui.medicalcloud.mapper.HisLogMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.his.ResponseDrugResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HisLogServiceImpl
implements HisLogService {
    private static final Logger log = LoggerFactory.getLogger(HisLogServiceImpl.class);
    @Autowired
    private HisLogMapper hisLogMapper;

    public HisLogEntity queryById(String xId) {
        return this.hisLogMapper.queryById(xId);
    }

    public int insert(HisLogEntity hisLogEntity) {
        return this.hisLogMapper.insert(hisLogEntity);
    }

    public int update(HisLogEntity hisLogEntity) {
        return this.hisLogMapper.update(hisLogEntity);
    }

    public HisLogEntity savaEntity(FrontRequest frontRequest, String url, String hospitalId) {
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7");
        HisLogEntity hisLogEntity = new HisLogEntity();
        hisLogEntity.setxId(GenSeqUtils.getUniqueNo());
        hisLogEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        hisLogEntity.setInterfaceName(url);
        hisLogEntity.setOrganCode(hospitalId);
        hisLogEntity.setRequest(JSONObject.toJSONString((Object)frontRequest));
        String xId = hisLogEntity.getxId();
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)hisLogEntity));
        this.hisLogMapper.insert(hisLogEntity);
        hisLogEntity.setxId(xId);
        return hisLogEntity;
    }

    public HisLogEntity insertEntity(String xml, String url, String hospitalId) {
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7");
        HisLogEntity hisLogEntity = new HisLogEntity();
        hisLogEntity.setxId(GenSeqUtils.getUniqueNo());
        hisLogEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        hisLogEntity.setInterfaceName(url);
        hisLogEntity.setOrganCode(hospitalId);
        hisLogEntity.setRequest(xml);
        String xId = hisLogEntity.getxId();
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)hisLogEntity));
        this.hisLogMapper.insert(hisLogEntity);
        hisLogEntity.setxId(xId);
        return hisLogEntity;
    }

    public void updateEntity(HisLogEntity hisLogEntity, BaseResponse<ResponseDrugResDTO> baseResponse) {
        log.info("=======\u8bb0\u5f55\u4fee\u6539his\u63a5\u53e3\u65e5\u5fd7");
        hisLogEntity.setResponse(JSONObject.toJSONString(baseResponse));
        log.info("=======\u8bb0\u5f55\u4fee\u6539his\u63a5\u53e3\u65e5\u5fd7\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)hisLogEntity));
        this.hisLogMapper.update(hisLogEntity);
    }
}

