/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.enums.BaseStatusEnum;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.mapper.DiagnosticMapper;
import com.ebaiyihui.medicalcloud.mapper.IcdItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DiagnosticEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.IcdItemEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.AdmNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.ICDSearchEchoReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.ICDSearchEchoResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.ICDSearchNameReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.ICDSearchNameResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.RegisteredRecordReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.RegisteredRecordResVo;
import com.ebaiyihui.medicalcloud.service.IcdItemService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.PageUtil;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class IcdItemServiceImpl
implements IcdItemService {
    private static final Logger log = LoggerFactory.getLogger(IcdItemServiceImpl.class);
    @Autowired
    private IcdItemMapper icdItemMapper;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private DiagnosticMapper diagnosticMapper;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolExecutor;
    @Autowired
    private HisManage hisManage;
    public static final Integer ZERO = 0;
    public static final Integer ONE = 1;

    public IcdItemEntity queryById(String xId) {
        return this.icdItemMapper.getById(xId);
    }

    public int insert(IcdItemEntity icdItemEntity) {
        return this.icdItemMapper.insert(icdItemEntity);
    }

    public int update(IcdItemEntity icdItemEntity) {
        return this.icdItemMapper.update(icdItemEntity);
    }

    public BaseResponse<PageResult<ICDSearchNameResVO>> searchName(ICDSearchNameReqVO vo) {
        log.info("=======>ICD\u8bca\u65ad\u540d\u79f0\u641c\u7d22----->{}", (Object)JSON.toJSONString((Object)vo));
        PageResult result = new PageResult();
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List list = this.icdItemMapper.searchName(vo);
        int count = this.icdItemMapper.countSearchName(vo);
        int totalPage = PageUtil.getTotalPage((int)count, (int)vo.getPageSize());
        result.setPageSize(vo.getPageSize().intValue());
        result.setPageNum(vo.getPageNum().intValue());
        result.setTotalPages(totalPage);
        result.setTotal(count);
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<ICDSearchEchoResVO>> searchEcho(ICDSearchEchoReqVO vo) {
        log.info("=======>ICD\u8bca\u65ad\u56de\u663e----->{}", (Object)JSON.toJSONString((Object)vo));
        ArrayList<ICDSearchEchoResVO> list = new ArrayList<ICDSearchEchoResVO>();
        String icdCode = this.icdItemMapper.searchEcho(vo);
        if (StringUtils.isNotEmpty((String)icdCode)) {
            String[] icdCodes;
            for (String code : icdCodes = icdCode.split(";")) {
                IcdItemEntity entity = this.icdItemMapper.getByIcdCode(code);
                ICDSearchEchoResVO resVO = new ICDSearchEchoResVO();
                if (entity == null) continue;
                resVO.setId(entity.getxId());
                resVO.setCode(code);
                resVO.setName(entity.getIcdName());
                list.add(resVO);
            }
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<Object> admNotify(AdmNotifyReqVO vo) {
        this.threadPoolExecutor.execute(() -> {
            List outpatientMainRelList = this.mosOutpatientMainRelMapper.getByAdmissionId(vo.getAdmId());
            if (CollectionUtils.isNotEmpty((Collection)outpatientMainRelList)) {
                return;
            }
            DiagnosticEntity historyDiagnosticEntity = this.diagnosticMapper.getByAdmId(vo.getAdmId());
            if (Objects.nonNull(historyDiagnosticEntity)) {
                return;
            }
            RegisteredRecordReqVo reqVO = new RegisteredRecordReqVo();
            reqVO.setPatientIdCard(vo.getIdCard());
            reqVO.setPatientName(vo.getName());
            reqVO.setDeptCode(vo.getDeptCode());
            reqVO.setDoctorCode(vo.getDoctorCode());
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)reqVO);
            BaseResponse response = this.hisManage.sendHis("/hyt-his/api/v1/registered/getRegisteredRecord", frontRequest, Object.class);
            if (response == null) {
                return;
            }
            List list = (List)response.getData();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            List registeredRecordResVoList = (List)mapper.convertValue((Object)list, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List resVOList = registeredRecordResVoList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getDiagnose())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(resVOList)) {
                return;
            }
            RegisteredRecordResVo resVo = (RegisteredRecordResVo)resVOList.get(resVOList.size() - 1);
            String diagnose = resVo.getDiagnose();
            String icdCode = resVo.getIcdCode();
            if (StringUtils.isEmpty((String)diagnose) || StringUtils.isEmpty((String)icdCode)) {
                return;
            }
            String newDiagnostic = diagnose.replaceAll(",", ";");
            String newIcdCode = icdCode.replaceAll(",", ";");
            DiagnosticEntity diagnosticEntity = new DiagnosticEntity();
            diagnosticEntity.setIcdName(newDiagnostic);
            diagnosticEntity.setIcdCode(newIcdCode);
            diagnosticEntity.setDiagnostic(newDiagnostic);
            diagnosticEntity.setxId(GenSeqUtils.getUniqueNo());
            diagnosticEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            diagnosticEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            diagnosticEntity.setAdmId(vo.getAdmId());
            diagnosticEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
            diagnosticEntity.setOrganCode("HYT");
            diagnosticEntity.setDoctorCode(vo.getDoctorCode());
            diagnosticEntity.setDeptCode(vo.getDeptCode());
            diagnosticEntity.setAdmType(ONE);
            this.diagnosticMapper.insert(diagnosticEntity);
        });
        return BaseResponse.success();
    }
}

