/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.RationalUseDrugEnum;
import com.ebaiyihui.medicalcloud.manage.MeiZhManage;
import com.ebaiyihui.medicalcloud.pojo.vo.meizhong.AuditResultResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.meizhong.RationalUseDrugReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.meizhong.RationalUseDrugResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.meizhong.ResultList;
import com.ebaiyihui.medicalcloud.service.MeiZhService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeiZhServiceImpl
implements MeiZhService {
    private static final Logger log = LoggerFactory.getLogger(MeiZhServiceImpl.class);
    @Autowired
    private MeiZhManage meiZhManage;
    public static final String SERIOUS = "1";
    public static final String COMMONLY = "2";
    public static final String OTHER = "3";
    public static final int ZERO = 0;
    public static final int ONE = 1;

    public BaseResponse<AuditResultResVo> rationalUseDrug(RationalUseDrugReqVo rationalUseDrugReqVo) {
        String result = this.meiZhManage.sendMeiZh("json/loadMess", (Object)rationalUseDrugReqVo);
        RationalUseDrugResVo rationalUseDrugResVo = (RationalUseDrugResVo)JSON.parseObject((String)result, RationalUseDrugResVo.class);
        if (Objects.nonNull(rationalUseDrugResVo) && SERIOUS.equals(rationalUseDrugResVo.getFlag())) {
            log.info("\u8c03\u7528\u7f8e\u4e2d\u5609\u548c\u5408\u7406\u7528\u836f\u8fd4\u56de\u5931\u8d25\u4fe1\u606f:{}", (Object)rationalUseDrugResVo.getFlag());
            return BaseResponse.success();
        }
        List resultList = rationalUseDrugResVo.getResultList();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            log.info("============\u4e0a\u6d77\u7f8e\u4e2d\u5609\u548c\u5904\u65b9\u5408\u7406==========");
            return BaseResponse.success((Object)new AuditResultResVo());
        }
        AuditResultResVo auditResultResVo = new AuditResultResVo();
        StringBuffer reason = new StringBuffer();
        resultList.stream().forEach(item -> reason.append(item.getMsgDesp()).append(";"));
        String substring = reason.substring(0, reason.length() - 1);
        log.info("===========:{}", (Object)substring);
        auditResultResVo.setReason(substring);
        Optional<ResultList> min = resultList.stream().min(Comparator.comparing(ResultList::getProblemLevel));
        ResultList resultList1 = null;
        if (min.isPresent()) {
            resultList1 = min.get();
            switch (resultList1.getProblemLevel()) {
                case "1": {
                    auditResultResVo.setDesc(RationalUseDrugEnum.SERIOUS.getDesc());
                    break;
                }
                case "2": {
                    auditResultResVo.setDesc(RationalUseDrugEnum.COMMONLY.getDesc());
                    break;
                }
                case "3": {
                    auditResultResVo.setDesc(RationalUseDrugEnum.OTHER.getDesc());
                    break;
                }
            }
            auditResultResVo.setLevel(resultList1.getProblemLevel());
        }
        log.info("\u5408\u7406\u7528\u836f\u8fd4\u56de\u7ed9\u524d\u7aef\u7684\u53c2\u6570\u503c:{}", (Object)JSON.toJSONString((Object)auditResultResVo));
        return BaseResponse.success((Object)auditResultResVo);
    }
}

