/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.mapper.DrugFrequencyMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugGroupItemRelMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugGroupMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPriceMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUnitMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUsageMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugRecordDto;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupDetailDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupItemSaveData;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupListDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupQueryReqDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupSaveReqDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUsageEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugGroupEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugGroupItemRelEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.DrugItemGroupQueryVO;
import com.ebaiyihui.medicalcloud.service.MosDrugGroupService;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="mosDrugGroupService")
public class MosDrugGroupServiceImpl
implements MosDrugGroupService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugGroupServiceImpl.class);
    @Autowired
    private MosDrugGroupMapper mosDrugGroupMapper;
    @Autowired
    private MosDrugGroupItemRelMapper mosDrugGroupItemRelMapper;
    @Autowired
    private MosDrugPriceMapper drugPriceMapper;
    @Autowired
    private DrugFrequencyMapper drugFrequencyMapper;
    @Autowired
    private MosDrugUsageMapper drugUsageMapper;
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private MosDrugUnitMapper mosDrugUnitMapper;

    public MosDrugGroupEntity queryById(String xId) {
        return this.mosDrugGroupMapper.queryById(xId);
    }

    public List<MosDrugGroupEntity> queryAllByLimit(int offset, int limit) {
        return this.mosDrugGroupMapper.queryAllByLimit(offset, limit);
    }

    public MosDrugGroupEntity insert(MosDrugGroupEntity mosDrugGroup) {
        this.mosDrugGroupMapper.insert(mosDrugGroup);
        return mosDrugGroup;
    }

    public MosDrugGroupEntity update(MosDrugGroupEntity mosDrugGroup) {
        this.mosDrugGroupMapper.update(mosDrugGroup);
        return this.queryById(mosDrugGroup.getXId());
    }

    public boolean deleteById(String xId) {
        return this.mosDrugGroupMapper.deleteById(xId) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> save(DrugGroupSaveReqDTO vo) {
        log.info("=======>\u4fdd\u5b58\u836f\u54c1\u7ec4\u5957\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
        MosDrugGroupEntity entity = new MosDrugGroupEntity();
        entity.setDoctorId(vo.getDoctorId());
        entity.setGroupName(vo.getGroupName());
        List mosDrugGroupEntities = this.mosDrugGroupMapper.queryAll(entity);
        if (CollectionUtils.isEmpty((Collection)vo.getItems())) {
            return BaseResponse.error((String)"\u8bf7\u9009\u62e9\u836f\u54c1");
        }
        if (!CollectionUtils.isEmpty((Collection)mosDrugGroupEntities)) {
            return BaseResponse.error((String)"\u5904\u65b9\u6a21\u677f\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        List<String> commonCodeList = vo.getItems().stream().map(v -> v.getCommonCode()).collect(Collectors.toList());
        Long count = commonCodeList.stream().distinct().count();
        if (count < (long)commonCodeList.size()) {
            return BaseResponse.error((String)"\u5904\u65b9\u6a21\u677f\u5185\u836f\u54c1\u9879\u91cd\u590d");
        }
        List voList = this.mosDrugGroupMapper.queryByDoctorId(vo.getDoctorId());
        for (DrugItemGroupQueryVO drugItemGroupQueryVO : voList) {
            String[] commonCodes;
            if (commonCodeList.size() != drugItemGroupQueryVO.getDrugCount() || !this.commonCodeEquals(commonCodes = drugItemGroupQueryVO.getCommonCode().split(";"), commonCodeList.toArray(new String[commonCodeList.size()]))) continue;
            return BaseResponse.error((String)"\u60a8\u5df2\u4fdd\u5b58\u8fc7\u8fd9\u4e2a\u5904\u65b9\u6a21\u677f\u4e86");
        }
        if (vo.getDrugType() == null) {
            vo.setDrugType(DrugTypeEnum.WM.getValue());
        }
        String groupId = GenSeqUtils.getUniqueNo();
        entity.setXId(groupId);
        entity.setXRemark("\u5305\u542b" + ((DrugGroupItemSaveData)vo.getItems().get(0)).getDrugName() + "\u7b49" + vo.getItems().size() + "\u79cd\u836f\u54c1");
        entity.setDrugType(vo.getDrugType());
        this.mosDrugGroupMapper.insert(entity);
        ArrayList<MosDrugGroupItemRelEntity> groupItemRelList = new ArrayList<MosDrugGroupItemRelEntity>();
        for (DrugGroupItemSaveData itemData : vo.getItems()) {
            MosDrugGroupItemRelEntity groupItemRelEntity = new MosDrugGroupItemRelEntity();
            groupItemRelEntity.setXId(GenSeqUtils.getUniqueNo());
            groupItemRelEntity.setUsageId(itemData.getUsageId());
            groupItemRelEntity.setReasonId(itemData.getReasonId());
            groupItemRelEntity.setFrequencyId(itemData.getFrequencyId());
            groupItemRelEntity.setDrugId(itemData.getDrugId());
            groupItemRelEntity.setCommonCode(itemData.getCommonCode());
            groupItemRelEntity.setDrugDosage(itemData.getDrugAmount());
            groupItemRelEntity.setDrugName(itemData.getDrugName());
            groupItemRelEntity.setDrugRemark(itemData.getDrugRemark());
            groupItemRelEntity.setDrugSpecs(itemData.getDrugSpecs());
            groupItemRelEntity.setUsageDesc(itemData.getDrugUsage());
            groupItemRelEntity.setSingleDose(itemData.getSingleDose());
            groupItemRelEntity.setCycle(itemData.getCycle());
            groupItemRelEntity.setMinBillPackingUnit(itemData.getMinBillPackingUnit());
            groupItemRelEntity.setWholePackingUnit(itemData.getWholePackingUnit());
            groupItemRelEntity.setDrugUsageDesc(itemData.getDrugUsageDesc());
            groupItemRelEntity.setFrequencyDesc(itemData.getFrequencyDesc());
            groupItemRelEntity.setReason(itemData.getReason());
            groupItemRelEntity.setMeasureNum(itemData.getMeasureNum());
            groupItemRelEntity.setMinBillPackingNum(itemData.getMinBillPackingNum());
            groupItemRelEntity.setGroupId(groupId);
            groupItemRelEntity.setMeasureUnit(itemData.getMeasureUnit());
            groupItemRelList.add(groupItemRelEntity);
        }
        return BaseResponse.success((Object)this.mosDrugGroupItemRelMapper.insertBatch(groupItemRelList));
    }

    public BaseResponse<Object> query(DrugGroupQueryReqDTO dto) {
        log.info("=======>\u67e5\u8be2\u7ec4\u5957\u662f\u5426\u5b58\u5728\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)dto));
        if (CollectionUtils.isEmpty((Collection)dto.getItems())) {
            return BaseResponse.error((String)"\u8bf7\u9009\u62e9\u836f\u54c1");
        }
        List<String> commonCodeList = dto.getItems().stream().map(v -> v.getCommonCode()).collect(Collectors.toList());
        Long count = commonCodeList.stream().distinct().count();
        if (count < (long)commonCodeList.size()) {
            return BaseResponse.error((String)"\u5904\u65b9\u6a21\u677f\u5185\u836f\u54c1\u9879\u91cd\u590d");
        }
        List voList = this.mosDrugGroupMapper.queryByDoctorId(dto.getDoctorId());
        for (DrugItemGroupQueryVO drugItemGroupQueryVO : voList) {
            String[] commonCodes;
            if (commonCodeList.size() != drugItemGroupQueryVO.getDrugCount() || !this.commonCodeEquals(commonCodes = drugItemGroupQueryVO.getCommonCode().split(";"), commonCodeList.toArray(new String[commonCodeList.size()]))) continue;
            return BaseResponse.error((String)"\u60a8\u5df2\u4fdd\u5b58\u8fc7\u8fd9\u4e2a\u5904\u65b9\u6a21\u677f\u4e86");
        }
        return BaseResponse.success();
    }

    public boolean commonCodeEquals(String[] args1, String[] args2) {
        List<String> list = Arrays.asList(args1);
        Collections.sort(list);
        args1 = list.toArray(args1);
        list = Arrays.asList(args2);
        Collections.sort(list);
        args2 = list.toArray(args2);
        return Arrays.deepEquals(args1, args2);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> delete(String groupId) {
        MosDrugGroupEntity mosDrugGroupEntity = this.mosDrugGroupMapper.queryById(groupId);
        if (mosDrugGroupEntity == null) {
            log.info("\u8be5\u5904\u65b9\u6a21\u677f\u4e0d\u5b58\u5728,groupId:{}", (Object)groupId);
            return BaseResponse.success((Object)"\u8be5\u5904\u65b9\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        mosDrugGroupEntity.setStatus(Integer.valueOf(0));
        int i = this.mosDrugGroupMapper.update(mosDrugGroupEntity);
        if (i == 0) {
            log.error("\u5220\u9664\u5904\u65b9\u6a21\u677f\u8868\u5931\u8d25");
            return BaseResponse.error((String)"no");
        }
        this.mosDrugGroupItemRelMapper.updateStatusByGroupId(groupId);
        return BaseResponse.success((Object)"\u5220\u9664\u5904\u65b9\u6a21\u677f\u6210\u529f");
    }

    public BaseResponse<List<DrugGroupListDTO>> listByDoctorId(String doctorId, Integer drugType, Integer pageIndex, Integer pageSize) {
        ArrayList<DrugGroupListDTO> drugGroupListDTOS = new ArrayList<DrugGroupListDTO>();
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List drugGroupEntities = this.mosDrugGroupMapper.getListByDoctorId(doctorId, drugType);
        if (CollectionUtils.isEmpty((Collection)drugGroupEntities)) {
            return BaseResponse.success(drugGroupListDTOS);
        }
        for (MosDrugGroupEntity mosDrugGroupEntity : drugGroupEntities) {
            DrugGroupListDTO drugGroupListDTO = new DrugGroupListDTO();
            drugGroupListDTO.setGroupId(mosDrugGroupEntity.getXId());
            drugGroupListDTO.setGroupName(mosDrugGroupEntity.getGroupName());
            List mosDrugGroupItemRelEntities = this.mosDrugGroupItemRelMapper.getListGroupId(mosDrugGroupEntity.getXId());
            if (!CollectionUtils.isEmpty((Collection)mosDrugGroupItemRelEntities)) {
                drugGroupListDTO.setContext("\u5305\u542b" + ((MosDrugGroupItemRelEntity)mosDrugGroupItemRelEntities.get(0)).getDrugName() + "\u7b49" + mosDrugGroupItemRelEntities.size() + "\u79cd\u836f\u54c1");
            }
            drugGroupListDTOS.add(drugGroupListDTO);
        }
        return BaseResponse.success(drugGroupListDTOS);
    }

    public BaseResponse<DrugGroupDetailDTO> detailByGroupId(String groupId) {
        DrugGroupDetailDTO drugGroupDetailDTO = new DrugGroupDetailDTO();
        MosDrugGroupEntity mosDrugGroupEntity = this.mosDrugGroupMapper.queryById(groupId);
        if (mosDrugGroupEntity == null) {
            log.error("\u5904\u65b9\u6a21\u677f\u4e0d\u5b58\u5728groupId:{}", (Object)groupId);
            return BaseResponse.error((String)"\u5904\u65b9\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        drugGroupDetailDTO.setGroupId(mosDrugGroupEntity.getXId());
        drugGroupDetailDTO.setGroupName(mosDrugGroupEntity.getGroupName());
        drugGroupDetailDTO.setDrugType(mosDrugGroupEntity.getDrugType());
        ArrayList<DrugRecordDto> drugRecordDtos = new ArrayList<DrugRecordDto>();
        ArrayList<String> ids = new ArrayList<String>();
        List mosDrugGroupItemRelEntities = this.mosDrugGroupItemRelMapper.getListGroupId(groupId);
        if (!CollectionUtils.isEmpty((Collection)mosDrugGroupItemRelEntities)) {
            for (MosDrugGroupItemRelEntity mosDrugGroupItemRelEntity : mosDrugGroupItemRelEntities) {
                DrugRecordDto drugRecordDto = new DrugRecordDto();
                if (StringUtil.isNotEmpty((String)mosDrugGroupItemRelEntity.getSingleDose())) {
                    BigDecimal bigDecimal = new BigDecimal(mosDrugGroupItemRelEntity.getSingleDose());
                    bigDecimal = bigDecimal.setScale(4, 4);
                    drugRecordDto.setSingleDoes(new BigDecimal(StringUtil.getNoZeros((String)bigDecimal.toString())));
                } else {
                    drugRecordDto.setSingleDoes(BigDecimal.ZERO);
                }
                drugRecordDto.setDrugCode(mosDrugGroupItemRelEntity.getCommonCode());
                drugRecordDto.setMinBillPackingUnit(mosDrugGroupItemRelEntity.getMinBillPackingUnit());
                drugRecordDto.setCommonName(mosDrugGroupItemRelEntity.getDrugName());
                BigDecimal price = this.getDrugPrice(mosDrugGroupItemRelEntity.getDrugId());
                drugRecordDto.setPrice(price);
                drugRecordDto.setDrugDosage(new BigDecimal(StringUtil.getNoZeros((String)mosDrugGroupItemRelEntity.getDrugDosage())));
                drugRecordDto.setMeasureUnit(mosDrugGroupItemRelEntity.getMeasureUnit());
                drugRecordDto.setUsageDesc(StringUtil.getNoZeros((String)mosDrugGroupItemRelEntity.getDrugDosage()) + mosDrugGroupItemRelEntity.getMeasureUnit());
                if (!DrugTypeEnum.CM.getValue().equals(mosDrugGroupEntity.getDrugType())) {
                    DrugUnitEntity drugUnitEntity;
                    drugRecordDto.setDrugSpec(mosDrugGroupItemRelEntity.getDrugSpecs());
                    drugRecordDto.setWholePackingUnit(mosDrugGroupItemRelEntity.getWholePackingUnit());
                    drugRecordDto.setCycle(mosDrugGroupItemRelEntity.getCycle());
                    drugRecordDto.setUsageId(mosDrugGroupItemRelEntity.getUsageId());
                    DrugUsageEntity drugUsageEntity = this.drugUsageMapper.queryById(mosDrugGroupItemRelEntity.getUsageId());
                    drugRecordDto.setDrugUsageDesc(mosDrugGroupItemRelEntity.getDrugUsageDesc());
                    drugRecordDto.setFrequencyId(mosDrugGroupItemRelEntity.getFrequencyId());
                    drugRecordDto.setFrequencyDesc(mosDrugGroupItemRelEntity.getFrequencyDesc());
                    drugRecordDto.setReasonId(mosDrugGroupItemRelEntity.getReasonId());
                    drugRecordDto.setMinBillPackingNum(mosDrugGroupItemRelEntity.getMinBillPackingNum());
                    DrugItemEntity drugItemEntity = this.drugItemMapper.getById(mosDrugGroupItemRelEntity.getDrugId());
                    if (drugItemEntity != null && (drugUnitEntity = this.mosDrugUnitMapper.queryById(drugItemEntity.getMeasureUnitId())) != null) {
                        drugRecordDto.setMeasureUnit(drugUnitEntity.getUnitName());
                    }
                    drugRecordDto.setUsageDesc(mosDrugGroupItemRelEntity.getFrequencyDesc() + ",\u6bcf\u6b21" + drugRecordDto.getSingleDoes() + drugRecordDto.getMeasureUnit() + "," + drugUsageEntity.getUsageDesc());
                    drugRecordDto.setPriceDrugDosage(drugRecordDto.getPrice() + "," + drugRecordDto.getDrugDosage());
                    drugRecordDto.setReason(mosDrugGroupItemRelEntity.getReason());
                    drugRecordDto.setMeasureNum(new BigDecimal(StringUtil.getNoZeros((String)mosDrugGroupItemRelEntity.getMeasureNum().toString())));
                }
                drugRecordDto.setRemark(mosDrugGroupItemRelEntity.getDrugRemark());
                drugRecordDto.setxId(mosDrugGroupItemRelEntity.getDrugId());
                drugRecordDto.setDrugType(mosDrugGroupEntity.getDrugType());
                ids.add(mosDrugGroupItemRelEntity.getDrugId());
                drugRecordDtos.add(drugRecordDto);
            }
            int count = this.drugItemMapper.getValidDrugItemCount(ids);
            if (count < mosDrugGroupItemRelEntities.size()) {
                return BaseResponse.error((String)"\u6a21\u677f\u5305\u542b\u5df2\u5931\u6548\u7684\u836f\u54c1\u6682\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u5220\u9664\u8be5\u6a21\u677f");
            }
            drugGroupDetailDTO.setDrugRecordDtos(drugRecordDtos);
        }
        return BaseResponse.success((Object)drugGroupDetailDTO);
    }

    public BigDecimal getDrugPrice(String drugId) {
        BigDecimal price = this.drugPriceMapper.getDrugPrice(drugId);
        return price;
    }
}

