/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.doctoruser.api.pojo.vo.account.DoctorInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.annotation.PresRoamProcessCode;
import com.ebaiyihui.medicalcloud.common.enums.DoctorTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.HospitalNamePinYinEnum;
import com.ebaiyihui.medicalcloud.common.enums.MerchantTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayChannelEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayStatusEnum;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.OrderPayManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.DrugDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.MerchantConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugOrderDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.PharmaceutistResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.FeeItemVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PrescriptionPreSettlementReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PrescriptionPreSettlementResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PriceInfoFeeItem;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.QueryPrescriptionReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.QueryPrescriptionResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.TransModelVo;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDrugItemReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDrugItemResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyResultVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundResVo;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessService;
import com.ebaiyihui.medicalcloud.service.hyt.HytPrescriptionService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@PresRoamProcessCode(value="HYT_PROCESS")
@Service
public class PresRoamHytProcessServiceImpl
implements PresRoamProcessService {
    private static final Logger log = LoggerFactory.getLogger(PresRoamHytProcessServiceImpl.class);
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugLogisticsOrderMapper drugLogisticsOrderMapper;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private MosDrugOrderService drugOrderService;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper drugOrderMapper;
    @Autowired
    private MosDrugPrescriptionMapper drugPrescriptionMapper;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private DrugDetailMapper drugDetailMapper;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private MosDrugLogisticsOrderRegMapper drugLogisticsOrderRegMapper;
    @Autowired
    private HytPrescriptionService hytPrescriptionService;
    @Autowired
    private HisLogService hisLogService;
    private static final String HIS_RECIPE_DATA_KEY = "queryPrescriptionList";

    public BaseResponse<Object> createTradeOrder(DrugPayReqVO vo) {
        String mainId = (String)vo.getMainIds().get(0);
        DrugOrderDTO dto = this.drugOrderMapper.queryOrderByMainId(mainId);
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(vo.getPayChannel()) && StringUtils.isEmpty((String)vo.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fopenId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (dto == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (BigDecimal.ZERO.equals(dto.getPrice())) {
            return BaseResponse.error((String)"\u836f\u54c1\u8d39\u7528\u4e0d\u80fd\u4e3a0\u5143");
        }
        if (dto.getOrderStatus() != null) {
            if (dto.getOrderStatus().equals(OrderStatusEnum.PAID.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u652f\u4ed8,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (dto.getOrderStatus().equals(OrderStatusEnum.PAYING.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (dto.getOrderStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u8fc7\u671f");
            }
        }
        MosOutpatientMainRelEntity mosOutpatientMainRelEntity = this.mosOutpatientMainRelMapper.getByMainId(mainId);
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
        DrugPrescriptionEntity drugPrescriptionEntity = this.drugPrescriptionMapper.queryByMainId(mainId);
        QueryPrescriptionReqVO reqVO = new QueryPrescriptionReqVO();
        reqVO.setClinicCode(mosOutpatientMainRelEntity.getHisRegNo());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)reqVO);
        BaseResponse response = this.hisManage.sendHis("/hyt-his/api/v1/card/queryPrescription", frontRequest, Object.class);
        HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/card/queryPrescription", drugMainEntity.getOrganId());
        hisLogEntity.setResponse(JSONObject.toJSONString((Object)response));
        this.hisLogService.update(hisLogEntity);
        if (response.getData() == null || !((Map)response.getData()).containsKey(HIS_RECIPE_DATA_KEY)) {
            return BaseResponse.error((String)"\u67e5\u8be2\u5904\u65b9\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        List queryPrescriptionList = (List)((Map)response.getData()).get(HIS_RECIPE_DATA_KEY);
        ObjectMapper mapper = new ObjectMapper();
        queryPrescriptionList = (List)mapper.convertValue((Object)queryPrescriptionList, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isEmpty(queryPrescriptionList = queryPrescriptionList.stream().filter(queryPrescription -> queryPrescription.getRecipeNO().equals(drugPrescriptionEntity.getHisRecipeNo())).collect(Collectors.toList()))) {
            return BaseResponse.error((String)"\u5904\u65b9\u5185\u5bb9\u6709\u66f4\u65b0\uff0c\u8bf7\u524d\u5f80\u804a\u5929\u9875\u9762\u4e0e\u533b\u751f\u8054\u7cfb\uff0c\u786e\u8ba4\u5904\u65b9\u540e\u518d\u8fdb\u884c\u652f\u4ed8");
        }
        boolean isPresWhetherSame = this.presWhetherSame(queryPrescriptionList);
        if (isPresWhetherSame) {
            return BaseResponse.error((String)"\u60a8\u597d\uff0c\u60a8\u7684\u5904\u65b9\u5185\u5bb9\u5df2\u66f4\u65b0\uff0c\u8bf7\u524d\u5f80\u804a\u5929\u9875\u9762\u4e0e\u533b\u751f\u8054\u7cfb\uff0c\u786e\u8ba4\u5904\u65b9\u540e\u518d\u8fdb\u884c\u652f\u4ed8");
        }
        DrugOrderEntity orderEntity = new DrugOrderEntity();
        orderEntity.setPayMethod(vo.getPayMethod());
        orderEntity.setPayAmount(dto.getPrice());
        orderEntity.setChannelCode(vo.getPayChannel());
        orderEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        if (Objects.nonNull(dto.getOrderStatus()) && dto.getOrderStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
            log.info("======>\u836f\u54c1\u652f\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)dto));
            orderEntity.setxId(dto.getOrderId());
            this.drugOrderMapper.update(orderEntity);
            log.info("======>\u836f\u54c1\u652f\u4ed8\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderEntity));
        } else {
            MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantType(dto.getPresOrgan(), Integer.valueOf(1));
            String orderSeq = GenSeqUtils.genOrderSeq((String)"");
            orderEntity.setxId(GenSeqUtils.getUniqueNo());
            orderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            orderEntity.setMainId(dto.getMainId());
            orderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
            orderEntity.setOrderSeq(orderSeq);
            orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
            orderEntity.setOrganCode(dto.getPresOrgan());
            orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
            this.drugOrderMapper.insert(orderEntity);
        }
        PrescriptionPreSettlementReqVo prescriptionPreSettlementReqVo = new PrescriptionPreSettlementReqVo();
        TransModelVo transModelVo = new TransModelVo();
        transModelVo.setBankTransNO("");
        transModelVo.setTransNO("");
        prescriptionPreSettlementReqVo.setTransModelVo(transModelVo);
        prescriptionPreSettlementReqVo.setClinicNO(mosOutpatientMainRelEntity.getHisRegNo());
        QueryPrescriptionResVO prescriptionResVO = (QueryPrescriptionResVO)queryPrescriptionList.get(0);
        ArrayList<PriceInfoFeeItem> priceInfoFeeItemList = new ArrayList<PriceInfoFeeItem>();
        for (FeeItemVO feeItemVO : prescriptionResVO.getFeeItem().getFeeItemList()) {
            PriceInfoFeeItem priceInfoFeeItem = this.getPriceInfoFeeItem(feeItemVO);
            priceInfoFeeItemList.add(priceInfoFeeItem);
        }
        prescriptionPreSettlementReqVo.setFeeItems(priceInfoFeeItemList);
        FrontRequest preSettlementFrontRequest = new FrontRequest();
        preSettlementFrontRequest.setBody((Object)prescriptionPreSettlementReqVo);
        BaseResponse baseResponse = this.hisManage.sendHis("/hyt-his/api/v1/prescription/preSettlement", preSettlementFrontRequest, PrescriptionPreSettlementResVo.class);
        log.info("\u9884\u7ed3\u7b97\u63a5\u53e3his\u8fd4\u56de\u4fe1\u606f->{}", (Object)baseResponse.toString());
        HisLogEntity logEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/prescription/preSettlement", drugMainEntity.getOrganId());
        logEntity.setResponse(JSONObject.toJSONString((Object)baseResponse));
        this.hisLogService.update(logEntity);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(mainId);
        drugOrderEntity.setInvoiceNo(((PrescriptionPreSettlementResVo)baseResponse.getData()).getInvoiceNo());
        this.mosDrugOrderMapper.update(drugOrderEntity);
        drugMainEntity.setItemStatus(DrugMainStatusEnum.ZRYH_UNPAID.getValue());
        this.mosDrugMainMapper.update(drugMainEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> orderNotify(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        log.info("=======\u8fdb\u5165\u591a\u5904\u65b9\u652f\u4ed8\u56de\u8c03->{}", (Object)Objects.toString(payNotifyReqVO, null));
        List drugOrderEntityList = this.mosDrugOrderMapper.queryListByOrderSeq(payNotifyReqVO.getOutTradeNo());
        List<Object> mainIdList = new ArrayList();
        int amount = 0;
        Long logisticsOrderId = null;
        MosOutpatientMainRelEntity mosOutpatientMainRelEntity = null;
        if (CollectionUtils.isNotEmpty((Collection)drugOrderEntityList)) {
            mosOutpatientMainRelEntity = this.mosOutpatientMainRelMapper.getByMainId(((DrugOrderEntity)drugOrderEntityList.get(0)).getMainId());
            List presDetailDtoList = this.drugPrescriptionMapper.queryMultiPresList(((DrugOrderEntity)drugOrderEntityList.get(0)).getMainId(), null, null, DoctorTypeEnum.PATIENT.getValue());
            mainIdList = presDetailDtoList.stream().filter(item -> Integer.valueOf(item.getOwnFlag()) == 3).map(v -> v.getMainId()).distinct().collect(Collectors.toList());
        }
        DrugMainEntity mainEntity = this.drugMainService.queryById(((DrugOrderEntity)drugOrderEntityList.get(0)).getMainId());
        for (DrugOrderEntity orderEntity : drugOrderEntityList) {
            List logisticsOrderList;
            int count;
            ArrayList<String> mainIds = new ArrayList<String>();
            mainIds.add(orderEntity.getMainId());
            List drugPrescriptionList = this.drugPrescriptionMapper.queryByMainIds(mainIds);
            orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
            orderEntity.setPayTime(payNotifyReqVO.getPayTime());
            orderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
            orderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
            orderEntity.setMchId("");
            this.drugOrderService.update(orderEntity);
            if (mainEntity.getHospitalNameFirstLetter().equals(HospitalNamePinYinEnum.HNHTYY.getValue())) {
                mainEntity.setItemStatus(DrugMainStatusEnum.HYT_UNPAID.getValue());
            } else {
                mainEntity.setItemStatus(DrugMainStatusEnum.ZRYH_CONFIRM.getValue());
            }
            QueryPrescriptionReqVO reqVO = new QueryPrescriptionReqVO();
            reqVO.setClinicCode(mosOutpatientMainRelEntity.getHisRegNo());
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)reqVO);
            BaseResponse response = this.hisManage.sendHis("/hyt-his/api/v1/card/queryPrescription", frontRequest, Object.class);
            HisLogEntity logEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/card/queryPrescription", mainEntity.getOrganId());
            logEntity.setResponse(JSONObject.toJSONString((Object)response));
            this.hisLogService.update(logEntity);
            TransModelVo transModelVo = new TransModelVo();
            transModelVo.setBankTransNO(orderEntity.getBankTradeNo());
            transModelVo.setTransNO(orderEntity.getOrderSeq());
            PrescriptionPreSettlementReqVo prescriptionPreSettlementReqVo = new PrescriptionPreSettlementReqVo();
            prescriptionPreSettlementReqVo.setClinicNO(mosOutpatientMainRelEntity.getHisRegNo());
            prescriptionPreSettlementReqVo.setTransModelVo(transModelVo);
            if ("WECHAT".equals(orderEntity.getPayMethod())) {
                prescriptionPreSettlementReqVo.setPayMode("WX");
            }
            PayNotifyResultVo payNotifyResultVo = (PayNotifyResultVo)JSON.parseObject((String)payNotifyReqVO.getNotifyResultStr(), PayNotifyResultVo.class);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String format = simpleDateFormat.format(orderEntity.getPayTime());
            String transInfo = "SUCCESS|OK|" + payNotifyResultVo.getAppid() + "|" + payNotifyReqVO.getMchId() + "|" + payNotifyResultVo.getNonceStr() + "|" + payNotifyResultVo.getSign() + "|SUCCESS|" + payNotifyResultVo.getOpenid() + "|" + payNotifyResultVo.getIsSubscribe() + "|" + payNotifyResultVo.getTradeType() + "|" + payNotifyResultVo.getBankType() + "|" + orderEntity.getPayAmount().multiply(new BigDecimal(100)) + "|" + payNotifyResultVo.getFeeType() + "|" + payNotifyResultVo.getTransactionId() + "|" + orderEntity.getDealSeq() + "||" + format + "|SUCCESS|" + orderEntity.getPayAmount().multiply(new BigDecimal(100)) + "|1|" + orderEntity.getInvoiceNo() + "|" + mosOutpatientMainRelEntity.getMedicalRecordNo() + "|1|1";
            prescriptionPreSettlementReqVo.setTransInfo(transInfo);
            if (response.getData() != null && ((Map)response.getData()).containsKey(HIS_RECIPE_DATA_KEY)) {
                List queryPrescriptionList = (List)((Map)response.getData()).get(HIS_RECIPE_DATA_KEY);
                List<Object> resVOList = new ArrayList();
                ObjectMapper mapper = new ObjectMapper();
                queryPrescriptionList = (List)mapper.convertValue((Object)queryPrescriptionList, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                ArrayList<PriceInfoFeeItem> priceInfoFeeItemList = new ArrayList<PriceInfoFeeItem>();
                for (DrugPrescriptionEntity drugPrescriptionEntity : drugPrescriptionList) {
                    resVOList = queryPrescriptionList.stream().filter(queryPrescription -> queryPrescription.getRecipeNO().equals(drugPrescriptionEntity.getHisRecipeNo())).collect(Collectors.toList());
                    for (QueryPrescriptionResVO queryPrescriptionResVO : resVOList) {
                        for (FeeItemVO feeItemVO : queryPrescriptionResVO.getFeeItem().getFeeItemList()) {
                            PriceInfoFeeItem priceInfoFeeItem = this.getPriceInfoFeeItem(feeItemVO);
                            priceInfoFeeItemList.add(priceInfoFeeItem);
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(priceInfoFeeItemList)) {
                    prescriptionPreSettlementReqVo.setFeeItems(priceInfoFeeItemList);
                    FrontRequest preSettlementFrontRequest = new FrontRequest();
                    preSettlementFrontRequest.setBody((Object)prescriptionPreSettlementReqVo);
                    BaseResponse baseResponse = this.hisManage.sendHis("/hyt-his/api/v1/prescription/settlement", preSettlementFrontRequest, PrescriptionPreSettlementReqVo.class);
                    HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/prescription/settlement", drugMainEntity.getOrganId());
                    hisLogEntity.setResponse(JSONObject.toJSONString((Object)baseResponse));
                    this.hisLogService.update(hisLogEntity);
                    log.info("\u7ed9his\u540c\u6b65\u652f\u4ed8\u4fe1\u606f->{}", (Object)baseResponse.toString());
                }
            }
            PresDrugItemReqVO presDrugItemReqVO = new PresDrugItemReqVO();
            presDrugItemReqVO.setMainId(orderEntity.getMainId());
            if (this.hytPrescriptionService.drugItemDetail(presDrugItemReqVO).getData() != null && ((PresDrugItemResVO)this.hytPrescriptionService.drugItemDetail(presDrugItemReqVO).getData()).getMedicalMainIds() != null) {
                ((PresDrugItemResVO)this.hytPrescriptionService.drugItemDetail(presDrugItemReqVO).getData()).getMedicalMainIds().stream().forEach(mainId -> {
                    DrugMainEntity tempMainEntity = new DrugMainEntity();
                    tempMainEntity.setxId(orderEntity.getMainId());
                    tempMainEntity.setItemStatus(DrugMainStatusEnum.HYT_UNPAID.getValue());
                    this.drugMainService.update(tempMainEntity);
                });
            }
            if ((count = this.mosDrugMainMapper.getToSendCount(mosOutpatientMainRelEntity.getHisRegNo(), DrugMainStatusEnum.TO_SEND.getValue(), Integer.valueOf(2))) > 0 && CollectionUtils.isNotEmpty((Collection)(logisticsOrderList = this.mosDrugMainMapper.getToSendCountLogisticsEntity(mosOutpatientMainRelEntity.getHisRegNo(), DrugMainStatusEnum.TO_SEND.getValue())))) {
                logisticsOrderId = ((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getId();
                MosDrugLogisticsOrderRegEntity regEntity = new MosDrugLogisticsOrderRegEntity();
                regEntity.setLogisticsOrderId(((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getId());
                regEntity.setMainId(drugMainEntity.getxId());
                regEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                regEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.drugLogisticsOrderRegMapper.insert(regEntity);
                mainEntity.setItemStatus(DrugMainStatusEnum.TO_SEND.getValue());
                ++amount;
                DrugMainEntity finalDrugMainEntity = mainEntity;
                new Thread(() -> {
                    try {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", ((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getId().toString());
                        map.put("body", "\u7269\u6d41\u7f16\u53f7\uff1a" + ((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getOrderSeq() + "\u7684\u8ba2\u5355\u5185\u5bb9\u6709\u65b0\u7684\u5904\u65b9\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u8fdb\u884c\u786e\u8ba4\u3002");
                        map.put("type", "yyy");
                        map.put("title", "\u5904\u65b9\u5408\u5e76\u53d1\u8d27");
                        map.put("subTitle", "\u5904\u65b9\u5408\u5e76\u53d1\u8d27");
                        map.put("pushCode", "1");
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("order", ((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getOrderSeq());
                        UcConfigurationVO configurationVO = this.pushManage.getClientCode(finalDrugMainEntity.getPresOrgan(), "sms");
                        String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
                        List pharmaceutistList = this.doctorRetmoteManage.getPharmaceutist(finalDrugMainEntity.getAppCode());
                        log.info("===>\u67e5\u8be2\u836f\u5e08\u4fe1\u606f====>", (Object)JSON.toJSONString((Object)pharmaceutistList));
                        if (CollectionUtils.isNotEmpty((Collection)pharmaceutistList)) {
                            for (PharmaceutistResVO resVO : pharmaceutistList) {
                                String userId;
                                DoctorInfoRespVO doctorInfoRespVO = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(resVO.getDoctorCode())));
                                if (doctorInfoRespVO != null && StringUtils.isNotEmpty((String)(userId = doctorInfoRespVO.getUserId()))) {
                                    this.pushManage.iGoEasyPush(userId, JSON.toJSONString(map), "yyy_logistics_merge");
                                }
                                this.pushManage.iSMSPush("ali", finalDrugMainEntity.getPresOrgan(), signCode, "yyy_tjcf", finalDrugMainEntity.getPresDoctorPhone(), param);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        throw new AsynException(e.getMessage());
                    }
                }).start();
            }
            this.drugMainService.update(drugMainEntity);
        }
        if (CollectionUtils.isNotEmpty(mainIdList)) {
            for (String item2 : mainIdList) {
                DrugMainEntity tempMainEntity = new DrugMainEntity();
                tempMainEntity.setxId(item2);
                tempMainEntity.setItemStatus(DrugMainStatusEnum.HYT_UNPAID.getValue());
                if (amount > 0 && logisticsOrderId != null) {
                    MosDrugLogisticsOrderRegEntity regEntity = new MosDrugLogisticsOrderRegEntity();
                    regEntity.setLogisticsOrderId(logisticsOrderId);
                    regEntity.setMainId(item2);
                    regEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                    regEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                    this.drugLogisticsOrderRegMapper.insert(regEntity);
                    tempMainEntity.setItemStatus(DrugMainStatusEnum.TO_SEND.getValue());
                }
                this.drugMainService.update(tempMainEntity);
            }
        }
        log.info("======>\u8ba2\u5355:{}====\u652f\u4ed8\u56de\u8c03\u6210\u529f", (Object)payNotifyReqVO.getOutTradeNo());
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    public BaseResponse<String> applyRefundSecond(BaseOperationDto dto, DrugMainEntity drugMainEntity) {
        MosDrugLogisticsOrderEntity logisticsOrderEntity;
        if (drugMainEntity.getOrderType() != null && OrderTypeEnum.COURIER_ORDER.getValue().equals(drugMainEntity.getOrderType()) && (logisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainIdAndStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue())) != null) {
            if (OrderStatusEnum.REFUNDING.getValue().equals(logisticsOrderEntity.getOrderStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(logisticsOrderEntity.getOrderStatus())) {
                return BaseResponse.success((Object)"\u6b64\u8ba2\u5355\u7269\u6d41\u8d39\u7528\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            RefundReqVO logisticsRefundReqVO = new RefundReqVO();
            logisticsRefundReqVO.setOrderSeq(logisticsOrderEntity.getOrderSeq());
            logisticsRefundReqVO.setDealSeq(logisticsOrderEntity.getDealSeq());
            logisticsRefundReqVO.setMerchantId(logisticsOrderEntity.getMchId());
            logisticsRefundReqVO.setPayMethod(logisticsOrderEntity.getPayMethod());
            logisticsRefundReqVO.setPayAmount(logisticsOrderEntity.getPayAmount());
            logisticsRefundReqVO.setMerchantType(MerchantTypeEnum.LOGISTICS.getValue());
            RefundResVo logisticsRefundResVo = this.orderPayManage.applyRefundServer(logisticsRefundReqVO);
            if (!logisticsRefundResVo.isFlag()) {
                return BaseResponse.error((String)("\u7269\u6d41\u9000\u6b3e" + logisticsRefundResVo.getMsg()));
            }
            logisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDING.getValue());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(logisticsOrderEntity);
        }
        new Thread(() -> {
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", drugMainEntity.getPresDoctorName());
            data.put("doctorName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", " \u7269\u6d41\u8d39\u9000\u6b3e");
            data.put("issue", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u5df2\u8fdb\u884c\u9000\u6b3e\uff0c\u6b3e\u9879\u5c06\u572824\u5c0f\u65f6\u5185\u9000\u56de\u539f\u8d26\u6237");
            data.put("info", map3);
            this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + drugMainEntity.getxId());
        }).start();
        return BaseResponse.success();
    }

    private PriceInfoFeeItem getPriceInfoFeeItem(FeeItemVO feeItemVO) {
        PriceInfoFeeItem priceInfoFeeItem = new PriceInfoFeeItem();
        priceInfoFeeItem.setCenteritemGrade(feeItemVO.getCenteritemgrade());
        priceInfoFeeItem.setComBo(feeItemVO.getComBo());
        priceInfoFeeItem.setCost(feeItemVO.getCost());
        priceInfoFeeItem.setDoctName(feeItemVO.getDoctName());
        priceInfoFeeItem.setDoseOnce(feeItemVO.getDoseNoce());
        priceInfoFeeItem.setDoseUnit(feeItemVO.getDoseUnit());
        priceInfoFeeItem.setDrugFlag(feeItemVO.getDrugFlag());
        priceInfoFeeItem.setExecDept(feeItemVO.getExecDept());
        priceInfoFeeItem.setFeeDate(feeItemVO.getFeeDate());
        priceInfoFeeItem.setFeeName(feeItemVO.getFeeName());
        priceInfoFeeItem.setItemCode(feeItemVO.getItemCode());
        priceInfoFeeItem.setItemName(feeItemVO.getItemName());
        priceInfoFeeItem.setMoOrder(feeItemVO.getMoOrder());
        priceInfoFeeItem.setPrice(feeItemVO.getPrice());
        priceInfoFeeItem.setPriceUnit(feeItemVO.getPriceUnit());
        priceInfoFeeItem.setQty(feeItemVO.getQty());
        priceInfoFeeItem.setRecipeNO(feeItemVO.getRecipeNO());
        priceInfoFeeItem.setSeqNO(feeItemVO.getSeqNO());
        priceInfoFeeItem.setSpecs(feeItemVO.getSpecs());
        priceInfoFeeItem.setStockDept(feeItemVO.getStockDept());
        return priceInfoFeeItem;
    }

    private boolean presWhetherSame(List<QueryPrescriptionResVO> queryPrescriptionResVOList) {
        for (QueryPrescriptionResVO prescriptionResVO : queryPrescriptionResVOList) {
            log.info("=====his\u67e5\u8be2\u7684\u5904\u65b9\u4fe1\u606f" + prescriptionResVO.toString());
            List feeItemList = prescriptionResVO.getFeeItem().getFeeItemList();
            DrugPrescriptionEntity drugPrescriptionEntity = this.drugPrescriptionMapper.getByHisRecipeNo(prescriptionResVO.getRecipeNO());
            List detailEntityList = this.drugDetailMapper.getByPresId(drugPrescriptionEntity.getxId());
            log.info("========\u67e5\u8be2\u51fa\u7684\u836f\u54c1\u4fe1\u606f" + JSONObject.toJSONString((Object)detailEntityList));
            if (feeItemList.size() != detailEntityList.size()) {
                log.info("=========his\u836f\u54c1\u7684\u6570\u91cf\u4e0d\u76f8\u540c");
                return true;
            }
            Map<String, DrugDetailEntity> drugMainEntityMap = detailEntityList.stream().collect(Collectors.toMap(DrugDetailEntity::getDrugCommonCode, drugDetailEntity -> drugDetailEntity));
            for (FeeItemVO feeItemVO : feeItemList) {
                DrugDetailEntity drugDetailEntity2 = drugMainEntityMap.get(feeItemVO.getItemCode());
                if (feeItemVO.getDays().equals(drugDetailEntity2.getDuration().toString()) && new BigDecimal(feeItemVO.getDoseNoce()).setScale(4).equals(drugDetailEntity2.getSingleDose().setScale(4)) && feeItemVO.getDoseUnit().equals(drugDetailEntity2.getMeasureUnit()) && new BigDecimal(feeItemVO.getPrice()).setScale(2).equals(drugDetailEntity2.getUnitPrice().setScale(2)) && new BigDecimal(feeItemVO.getQty()).setScale(4).equals(drugDetailEntity2.getAmount().setScale(4)) && new BigDecimal(feeItemVO.getCost()).setScale(4).equals(drugDetailEntity2.getTotalPrice().setScale(4)) && feeItemVO.getSpecs().equals(drugDetailEntity2.getDrugSpec()) && feeItemVO.getUseName().equals(drugDetailEntity2.getUsageDesc()) && feeItemVO.getFreqName().equals(drugDetailEntity2.getFrequencyDesc())) continue;
                log.info("=========his\u836f\u54c1\u7684\u4fe1\u606f\u4e0d\u76f8\u540c->{}", (Object)drugDetailEntity2.toString());
                return true;
            }
        }
        return false;
    }

    public void refundNotify(DrugMainEntity drugMainEntity, RefundCallBackReqVo refundNotifyReqVO) {
        log.info("=========\u822a\u533b\u901a\u9000\u6b3e:{}", (Object)JSON.toJSONString((Object)refundNotifyReqVO));
    }
}

