/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.mapper.UserAddressMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.UserAddressReq;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.UserAddressEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.OutAddressResVO;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.UserAddressService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.DistanceUtil;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAddressServiceImpl
implements UserAddressService {
    private static final Logger log = LoggerFactory.getLogger(UserAddressServiceImpl.class);
    @Autowired
    private UserAddressMapper userAddressMapper;
    @Autowired
    private MosDrugMainService drugMainService;

    public UserAddressEntity queryById(String xId) {
        return null;
    }

    public UserAddressEntity insert(UserAddressEntity userAddressEntity) {
        this.userAddressMapper.insert(userAddressEntity);
        return this.queryById(userAddressEntity.getxId());
    }

    public int update(UserAddressEntity userAddressEntity) {
        return this.userAddressMapper.update(userAddressEntity);
    }

    public BaseResponse<UserAddressEntity> saveUserShipAddress(UserAddressReq userAddressReq) {
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(userAddressReq.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u6ca1\u6709\u6b64\u5904\u65b9\uff0c\u8bf7\u786e\u8ba4\u5904\u65b9id\u662f\u5426\u6b63\u786e");
        }
        UserAddressEntity userAddressEntity = this.userAddressMapper.queryByMainId(userAddressReq.getMainId());
        if (userAddressEntity == null) {
            userAddressEntity = new UserAddressEntity();
            userAddressEntity.setAreaInfo(userAddressReq.getAreaInfo());
            userAddressEntity.setDetailAddress(userAddressReq.getDetailAddress());
            userAddressEntity.setReceiver(userAddressReq.getUserName());
            userAddressEntity.setTelephone(userAddressReq.getTelphone());
            userAddressEntity.setxId(GenSeqUtils.getUniqueNo());
            userAddressEntity.setCommaAreaInfo(userAddressReq.getCommaAreaInfo());
            userAddressEntity.setMainId(userAddressReq.getMainId());
            userAddressEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            userAddressEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            if (StringUtils.isNotEmpty((String)userAddressReq.getInvoiceTitle())) {
                userAddressEntity.setInvoiceTitle(userAddressReq.getInvoiceTitle());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getInvoiceNum())) {
                userAddressEntity.setInvoiceNum(userAddressReq.getInvoiceNum());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getAddressId())) {
                userAddressEntity.setAddressId(userAddressReq.getAddressId());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getLatitude())) {
                userAddressEntity.setLatitude(userAddressReq.getLatitude());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getLongitude())) {
                userAddressEntity.setLongitude(userAddressReq.getLongitude());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getLongitude()) && StringUtils.isNotEmpty((String)userAddressReq.getLatitude())) {
                Double deliveryDistance = DistanceUtil.distance((double)39.974106, (double)116.428726, (double)Double.parseDouble(userAddressReq.getLatitude()), (double)Double.parseDouble(userAddressReq.getLongitude()));
                log.info("\u8ba1\u7b97\u8ddd\u79bbdeliveryDistance: " + deliveryDistance);
                userAddressEntity.setDeliveryDistance(deliveryDistance.toString());
            }
            this.insert(userAddressEntity);
        } else {
            userAddressEntity.setDetailAddress(userAddressReq.getDetailAddress());
            userAddressEntity.setCommaAreaInfo(userAddressReq.getCommaAreaInfo());
            userAddressEntity.setAreaInfo(userAddressReq.getAreaInfo());
            userAddressEntity.setTelephone(userAddressReq.getTelphone());
            userAddressEntity.setReceiver(userAddressReq.getUserName());
            if (StringUtils.isNotEmpty((String)userAddressReq.getInvoiceTitle())) {
                userAddressEntity.setInvoiceTitle(userAddressReq.getInvoiceTitle());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getInvoiceNum())) {
                userAddressEntity.setInvoiceNum(userAddressReq.getInvoiceNum());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getAddressId())) {
                userAddressEntity.setAddressId(userAddressReq.getAddressId());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getLatitude())) {
                userAddressEntity.setLatitude(userAddressReq.getLatitude());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getLongitude())) {
                userAddressEntity.setLongitude(userAddressReq.getLongitude());
            }
            if (StringUtils.isNotEmpty((String)userAddressReq.getLongitude()) && StringUtils.isNotEmpty((String)userAddressReq.getLatitude())) {
                Double deliveryDistance = DistanceUtil.distance((double)39.974106, (double)116.428726, (double)Double.parseDouble(userAddressReq.getLatitude()), (double)Double.parseDouble(userAddressReq.getLongitude()));
                log.info("\u8ba1\u7b97\u8ddd\u79bbdeliveryDistance: " + deliveryDistance);
                userAddressEntity.setDeliveryDistance(deliveryDistance.toString());
            }
            userAddressEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.update(userAddressEntity);
        }
        return BaseResponse.success((Object)userAddressEntity);
    }

    public BaseResponse<List<OutAddressResVO>> getOutpatientAddress(List<String> orderIds) {
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty(orderIds)) {
            list = this.userAddressMapper.queryByOrderIds(orderIds);
        }
        return BaseResponse.success(list);
    }

    public UserAddressEntity queryByMainId(String mainId) {
        return this.userAddressMapper.queryByMainId(mainId);
    }

    public BaseResponse<UserAddressEntity> getPresAddress(String mainId) {
        UserAddressEntity userAddressEntity = this.queryByMainId(mainId);
        if (userAddressEntity != null) {
            return BaseResponse.success((Object)userAddressEntity);
        }
        return BaseResponse.error((String)"\u6b64\u5904\u65b9\u6ca1\u6709\u6536\u8d27\u5730\u5740");
    }
}

