/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl.hyt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.doctoruser.api.pojo.vo.account.DoctorInfoRespVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.constants.BusinessConstant;
import com.ebaiyihui.medicalcloud.common.enums.AppCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.BusinessCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DistributionTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DoctorTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.HytHisRecipeStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PushCodeInfoEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserTypeEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.manage.AsynManage;
import com.ebaiyihui.medicalcloud.manage.Camanage;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.DrugMainManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.LogisticsManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsRouteMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugVerifierMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsRouteEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.im.MessageData;
import com.ebaiyihui.medicalcloud.pojo.vo.DocWorkInfoDto;
import com.ebaiyihui.medicalcloud.pojo.vo.PharmaceutistResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.SyncPresReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FeedDetailVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalOrderFeedResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.AuditMainListDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.AuditMainListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.AuditMainListResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.AuditMainReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.ConfirmMedicalReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.DoctorMainListDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.DoctorMainListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.DoctorMainListResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.DoctorWebMainListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.DoctorWebMainListResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.MainDetailReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.MainDetailResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.ManageMainListDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.ManageMainListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.ManageMainListResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.MultirecipeDetailReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PatientMainListDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PatientMainListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PatientMainListResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDetailDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDrugDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDrugItemData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDrugItemReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDrugItemResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.QueryMainIdsReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendDrugItemData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendMainDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.TipReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.TipResVO;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.service.hyt.HytPrescriptionService;
import com.ebaiyihui.medicalcloud.utils.BeanHelper;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.PageUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HytPrescriptionServiceImpl
implements HytPrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(HytPrescriptionServiceImpl.class);
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper logisticsOrderRegMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private DrugMainManage drugMainManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private SpecialNodeConfig nodeConfig;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private LogisticsManage logisticsManage;
    @Autowired
    private MosDrugLogisticsRouteMapper mosDrugLogisticsRouteMapper;
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private AsynManage asynManage;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private Camanage camanage;
    @Autowired
    private MosDrugVerifierMapper verifierMapper;
    @Autowired
    private DrugItemMapper drugItemMapper;
    public static final int ZERO = 0;
    public static final int ONE = 1;
    public static final Integer PASS_STATUS = 200;
    public static final String DOCTOR_TYPE = "doctor";
    private static List<String> unitList = new ArrayList();

    public BaseResponse<Object> syncHytPres(SyncPresReqVO vo) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<MainDetailResVO> queryMainDetail(MainDetailReqVO vo) {
        log.info("======>\u533b\u5631\u8be6\u60c5 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        ArrayList presDetailList = new ArrayList();
        MainDetailResVO resVo = this.mosDrugMainMapper.queryMainDetail(vo.getMainId());
        if (resVo == null) {
            return BaseResponse.success();
        }
        List presDetailDtoList = this.mosDrugPrescriptionMapper.queryMultiPresList(vo.getMainId(), resVo.getHisRegNo(), resVo.getItemStatus(), vo.getType());
        List hisRecipeNos = presDetailDtoList.stream().map(PresDetailDataDTO::getHisRecipeNo).distinct().collect(Collectors.toList());
        if (StringUtils.isNotEmpty((String)vo.getHisRecipeNo()) && !resVo.getItemStatus().equals(DrugMainStatusEnum.UNDRUGS.getValue()) && !resVo.getItemStatus().equals(DrugMainStatusEnum.ZRYH_UNPAID.getValue())) {
            hisRecipeNos = hisRecipeNos.stream().filter(item -> vo.getHisRecipeNo().equals(item)).collect(Collectors.toList());
        }
        hisRecipeNos.stream().forEach(hisRecipeNo -> {
            PresDetailData presDetailData = new PresDetailData();
            ArrayList drugDetailList = new ArrayList();
            presDetailDtoList.stream().forEach(item -> {
                boolean flag = false;
                if (hisRecipeNo.equals(item.getHisRecipeNo())) {
                    PresDrugDetailData drugDetailData = new PresDrugDetailData();
                    BeanUtils.copyProperties((Object)item, (Object)drugDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item));
                    if (!flag) {
                        BeanUtils.copyProperties((Object)item, (Object)presDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item));
                        flag = true;
                    }
                    drugDetailList.add(drugDetailData);
                }
            });
            if (CollectionUtils.isNotEmpty(drugDetailList)) {
                drugDetailList.stream().forEach(item -> {
                    DrugItemEntity drugItemEntity;
                    if (unitList.contains(item.getWholePackingUnit()) && DrugTypeEnum.CM.getValue().equals(presDetailData.getPresType()) && Objects.nonNull(drugItemEntity = this.drugItemMapper.queryByCommonCode(item.getCommonCode(), resVo.getAppCode())) && Objects.nonNull(drugItemEntity.getMeasureNum())) {
                        item.setSingleDose(item.getSingleDose().divide(drugItemEntity.getMeasureNum()));
                        item.setMeasureUnit(item.getWholePackingUnit() + "[" + item.getDrugSpec() + "]");
                    }
                    item.setUnitPrice(new BigDecimal(item.getUnitPrice()).setScale(2, 4).toString());
                    item.setTotalPrice(new BigDecimal(item.getTotalPrice()).setScale(2, 4).toString());
                });
                presDetailData.setDrugDetailList(drugDetailList);
                if (presDetailData != null) {
                    presDetailList.add(presDetailData);
                }
            }
        });
        if (CollectionUtils.isNotEmpty(presDetailList)) {
            resVo.setPresDetailList(presDetailList);
        }
        if (StringUtils.isNotEmpty((String)vo.getType())) {
            List outLineList;
            if (DoctorTypeEnum.PATIENT.getValue().equals(vo.getType())) {
                int mergeCount;
                DoctorEntityInfoVO doctorVo = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(resVo.getPresDoctorId())));
                if (doctorVo != null) {
                    resVo.setPresDoctorAvatar(doctorVo.getHeadPortrait());
                    resVo.setProfession(doctorVo.getProfession());
                }
                if ((mergeCount = this.mosDrugMainMapper.getToSendCount(resVo.getHisRegNo(), DrugMainStatusEnum.TO_SEND.getValue(), Integer.valueOf(2))) > 0) {
                    resVo.setLogisticsFlag(Boolean.valueOf(true));
                } else {
                    resVo.setLogisticsFlag(Boolean.valueOf(false));
                }
                int logisticsUnpaidCount = this.mosDrugMainMapper.getToSendCount(resVo.getHisRegNo(), DrugMainStatusEnum.HYT_UNPAID.getValue(), null);
                if (logisticsUnpaidCount > 0 && (resVo.getItemStatus() == 20 || resVo.getItemStatus() == 50)) {
                    QueryMainIdsReqVO queryMainIdsReqVO = new QueryMainIdsReqVO();
                    queryMainIdsReqVO.setHisRegNo(resVo.getHisRegNo());
                    queryMainIdsReqVO.setStatus(DrugMainStatusEnum.HYT_UNPAID.getValue());
                    List mainIds = this.mosDrugPrescriptionMapper.queryMultiMainIds(queryMainIdsReqVO);
                    if (CollectionUtils.isNotEmpty((Collection)mainIds)) {
                        resVo.setLogisticsUnpaidMainId((String)mainIds.get(0));
                    }
                    resVo.setLogisticsUnpaidFlag(Boolean.valueOf(true));
                } else {
                    resVo.setLogisticsUnpaidFlag(Boolean.valueOf(false));
                }
                if (resVo.getLogisticsOrderId() != null && resVo.getItemStatus() > DrugMainStatusEnum.TO_SEND.getValue() && !DrugMainStatusEnum.GET_MEDICINE.getValue().equals(resVo.getItemStatus())) {
                    List routeList = new ArrayList();
                    routeList = resVo.getDistributionType() != null && (DistributionTypeEnum.CITY_EXPRESS.getValue().equals(resVo.getDistributionType()) || DistributionTypeEnum.CROSS_POINT.getValue().equals(resVo.getDistributionType())) ? this.queryLogisticsRoute(resVo, resVo.getStoreId(), resVo.getDistributionType()) : (List)this.drugMainService.queryLogisticsRoute(resVo.getLogisticsOrderId()).getData();
                    if (CollectionUtils.isNotEmpty(routeList)) {
                        routeList.stream().forEach(mosDrugLogisticsRouteEntity -> {
                            resVo.setDeliveryName(mosDrugLogisticsRouteEntity.getDeliveryName());
                            resVo.setDeliveryPhone(mosDrugLogisticsRouteEntity.getDeliveryPhone());
                        });
                        MosDrugLogisticsRouteEntity mosDrugLogisticsRouteEntity2 = (MosDrugLogisticsRouteEntity)routeList.get(routeList.size() - 1);
                        if (!DrugMainStatusEnum.FINISH.getValue().equals(resVo.getItemStatus())) {
                            if ("15".equals(mosDrugLogisticsRouteEntity2.getOpCode())) {
                                resVo.setItemStatus(DrugMainStatusEnum.TO_DELIVERY.getValue());
                            }
                            if ("17".equals(mosDrugLogisticsRouteEntity2.getOpCode())) {
                                resVo.setItemStatus(DrugMainStatusEnum.SIGN_IN.getValue());
                            }
                        }
                        resVo.setLogisticsRouteRemark(mosDrugLogisticsRouteEntity2.getRemark());
                    }
                }
            }
            if (DoctorTypeEnum.SYSTEM.getValue().equals(vo.getType()) && StringUtils.isNotEmpty((String)resVo.getPatientId()) && CollectionUtils.isNotEmpty((Collection)(outLineList = this.drugMainManage.getOutLineList(resVo.getPatientId(), resVo.getAppCode())))) {
                resVo.setOutList(outLineList);
            }
        }
        if (DrugMainStatusEnum.TO_TAKE.getValue().equals(resVo.getItemStatus())) {
            Map map = null;
            List recipeNoList = resVo.getPresDetailList().stream().map(v -> v.getHisRecipeNo()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(recipeNoList) && (map = this.hisManage.getHisRecipeStatus(recipeNoList)) != null) {
                for (String item2 : recipeNoList) {
                    if (!HytHisRecipeStatusEnum.PAY.getValue().equals(map.get(item2))) continue;
                    DrugMainEntity drugMainEntity = new DrugMainEntity();
                    drugMainEntity.setxId(vo.getMainId());
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                    this.mosDrugMainMapper.update(drugMainEntity);
                    resVo.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                }
            }
        }
        return BaseResponse.success((Object)resVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PresDrugItemResVO> drugItemDetail(PresDrugItemReqVO vo) {
        log.info("======>\u652f\u4ed8\u836f\u54c1\u6e05\u5355 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        BigDecimal payAmount = BigDecimal.ZERO;
        PresDrugItemResVO resVo = new PresDrugItemResVO();
        ArrayList presDrugItemList = new ArrayList();
        List presDetailDtoList = this.mosDrugPrescriptionMapper.queryMultiPresList(vo.getMainId(), null, null, DoctorTypeEnum.PATIENT.getValue());
        log.info("======>\u652f\u4ed8\u836f\u54c1\u6e05\u5355 - \u5b9e\u4f53:{}", (Object)JSON.toJSONString((Object)presDetailDtoList));
        if (CollectionUtils.isEmpty((Collection)presDetailDtoList)) {
            return BaseResponse.success();
        }
        resVo.setHisRegNo(((PresDetailDataDTO)presDetailDtoList.get(0)).getHisRegNo());
        List ownMainIds = presDetailDtoList.stream().filter(item -> Integer.valueOf(item.getOwnFlag()) == 0).map(PresDetailDataDTO::getMainId).distinct().collect(Collectors.toList());
        List medicalMainIds = presDetailDtoList.stream().filter(item -> Integer.valueOf(item.getOwnFlag()) == 3).map(PresDetailDataDTO::getMainId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ownMainIds)) {
            resVo.setOwnMainIds(ownMainIds);
        }
        if (CollectionUtils.isNotEmpty(medicalMainIds)) {
            resVo.setMedicalMainIds(medicalMainIds);
        }
        List hisRecipeNos = presDetailDtoList.stream().map(PresDetailDataDTO::getHisRecipeNo).distinct().collect(Collectors.toList());
        hisRecipeNos.stream().forEach(hisRecipeNo -> {
            PresDrugItemData presDrugItemData = new PresDrugItemData();
            ArrayList drugDetailList = new ArrayList();
            presDetailDtoList.stream().forEach(item -> {
                boolean flag = false;
                if (hisRecipeNo.equals(item.getHisRecipeNo())) {
                    PresDrugDetailData drugDetailData = new PresDrugDetailData();
                    BeanUtils.copyProperties((Object)item, (Object)drugDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item));
                    if (!flag) {
                        BeanUtils.copyProperties((Object)item, (Object)presDrugItemData, (String[])BeanHelper.getNullPropertyNames((Object)item));
                        flag = true;
                    }
                    drugDetailList.add(drugDetailData);
                }
            });
            if (CollectionUtils.isNotEmpty(drugDetailList)) {
                drugDetailList.stream().forEach(item -> {
                    DrugItemEntity drugItemEntity;
                    if (unitList.contains(item.getWholePackingUnit()) && DrugTypeEnum.CM.getValue().equals(presDrugItemData.getPresType()) && Objects.nonNull(drugItemEntity = this.drugItemMapper.queryByCommonCode(item.getCommonCode(), AppCodeEnum.HYT.getValue())) && Objects.nonNull(drugItemEntity.getMeasureNum())) {
                        item.setSingleDose(item.getSingleDose().divide(drugItemEntity.getMeasureNum()));
                        item.setMeasureUnit(item.getWholePackingUnit() + "[" + item.getDrugSpec() + "]");
                    }
                    item.setUnitPrice(new BigDecimal(item.getUnitPrice()).setScale(2, 4).toString());
                    item.setTotalPrice(new BigDecimal(item.getTotalPrice()).setScale(2, 4).toString());
                });
                presDrugItemData.setDrugDetailList(drugDetailList);
                if (presDrugItemData != null) {
                    presDrugItemList.add(presDrugItemData);
                }
            }
        });
        if (CollectionUtils.isNotEmpty(presDrugItemList)) {
            resVo.setDrugItemList(presDrugItemList);
            List countList = presDrugItemList.stream().filter(item -> Integer.valueOf(item.getOwnFlag()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(countList)) {
                payAmount = countList.stream().map(v -> new BigDecimal(v.getPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            resVo.setPayAmount(payAmount.toString());
        }
        return BaseResponse.success((Object)resVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<SendPresDetailResVO> sendPresDetail(SendPresDetailReqVO vo) {
        log.info("======>\u5904\u65b9\u53d1\u8d27\u7ba1\u7406\u8ba2\u5355\u8be6\u60c5 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        boolean drugFlag = false;
        SendPresDetailResVO resVO = new SendPresDetailResVO();
        ArrayList<SendDrugItemData> sendDrugItemList = new ArrayList<SendDrugItemData>();
        ArrayList<SendMainDetailData> sendMainList = new ArrayList<SendMainDetailData>();
        List sendPresDetailDtoList = this.mosDrugLogisticsOrderMapper.queryMultiPresList(vo.getLogisticsId());
        if (CollectionUtils.isEmpty((Collection)sendPresDetailDtoList)) {
            return BaseResponse.success();
        }
        BeanUtils.copyProperties(sendPresDetailDtoList.get(0), (Object)resVO, (String[])BeanHelper.getNullPropertyNames(sendPresDetailDtoList.get(0)));
        List mainIds = sendPresDetailDtoList.stream().map(SendPresDetailDataDTO::getMainId).distinct().collect(Collectors.toList());
        for (String mainId : mainIds) {
            boolean mainFlag = false;
            ArrayList<String> recipeNos = new ArrayList<String>();
            SendMainDetailData sendMainDetailData = new SendMainDetailData();
            ArrayList<SendPresDetailData> sendPresDetailList = new ArrayList<SendPresDetailData>();
            for (SendPresDetailDataDTO item2 : sendPresDetailDtoList) {
                if (!drugFlag) {
                    SendDrugItemData sendDrugItemData = new SendDrugItemData();
                    BeanUtils.copyProperties((Object)item2, (Object)sendDrugItemData, (String[])BeanHelper.getNullPropertyNames((Object)item2));
                    sendDrugItemList.add(sendDrugItemData);
                }
                if (!mainId.equals(item2.getMainId())) continue;
                if (!mainFlag) {
                    BeanUtils.copyProperties((Object)item2, (Object)sendMainDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item2));
                    mainFlag = true;
                }
                if (recipeNos.contains(item2.getHisRecipeNo())) continue;
                SendPresDetailData sendPresDetailData = new SendPresDetailData();
                BeanUtils.copyProperties((Object)item2, (Object)sendPresDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item2));
                sendPresDetailList.add(sendPresDetailData);
                recipeNos.add(item2.getHisRecipeNo());
            }
            if (CollectionUtils.isNotEmpty(sendPresDetailList)) {
                sendMainDetailData.setSendPresDetailList(sendPresDetailList);
            }
            if (Objects.nonNull(sendMainDetailData)) {
                sendMainList.add(sendMainDetailData);
            }
            drugFlag = true;
        }
        if (CollectionUtils.isNotEmpty(sendDrugItemList)) {
            sendDrugItemList.stream().forEach(item -> {
                DrugItemEntity drugItemEntity;
                if (unitList.contains(item.getWholePackingUnit()) && DrugTypeEnum.CM.getValue().equals(Integer.valueOf(item.getPresType())) && Objects.nonNull(drugItemEntity = this.drugItemMapper.queryByCommonCode(item.getCommonCode(), AppCodeEnum.HYT.getValue())) && Objects.nonNull(drugItemEntity.getMeasureNum())) {
                    item.setSingleDose(item.getSingleDose().divide(drugItemEntity.getMeasureNum()));
                    item.setMeasureUnit(item.getWholePackingUnit() + "[" + item.getDrugSpec() + "]");
                }
                if (DrugTypeEnum.WCTM.getValue().equals(Integer.valueOf(item.getPresType()))) {
                    item.setUnitPrice(new BigDecimal(item.getUnitPrice()).setScale(2, 4).toString());
                    item.setTotalPrice(new BigDecimal(item.getTotalPrice()).setScale(2, 4).toString());
                }
            });
            resVO.setSendDrugItemList(sendDrugItemList);
        }
        if (CollectionUtils.isNotEmpty(sendMainList)) {
            resVO.setSendMainDetailList(sendMainList);
        }
        return BaseResponse.success((Object)resVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PageResult<PatientMainListResVO>> patientMainList(PatientMainListReqVO vo) {
        List recipeNoList;
        log.info("======>\u60a3\u8005\u7aef\u533b\u5631\u5217\u8868 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        Map map = null;
        ArrayList<PatientMainListResVO> resultList = new ArrayList<PatientMainListResVO>();
        if (CollectionUtils.isEmpty((Collection)vo.getPatientIdList())) {
            return BaseResponse.success();
        }
        PageResult result = new PageResult();
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List list = this.mosDrugMainMapper.queryMainByPatient(vo.getPatientIdList(), vo.getAppCode(), vo.getKeyword());
        if (CollectionUtils.isNotEmpty((Collection)list) && this.nodeConfig.getHyt().equals(vo.getAppCode()) && CollectionUtils.isNotEmpty(recipeNoList = list.stream().map(v -> v.getHisRecipeNo()).collect(Collectors.toList()))) {
            map = this.hisManage.getHisRecipeStatus(recipeNoList);
        }
        for (PatientMainListDataDTO dto : list) {
            PatientMainListResVO resVO = new PatientMainListResVO();
            if (map != null) {
                DrugMainEntity drugMainEntity = null;
                DrugOrderEntity drugOrderEntity = null;
                if (HytHisRecipeStatusEnum.REFUND.getValue().equals(map.get(dto.getHisRecipeNo()))) {
                    drugMainEntity = new DrugMainEntity();
                    drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(dto.getMainId());
                    drugMainEntity.setxId(dto.getMainId());
                    dto.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                    if (drugOrderEntity != null) {
                        drugOrderEntity.setxId(dto.getOrderId());
                        drugOrderEntity.setStatus(OrderStatusEnum.HIS_REFUNDED.getValue());
                    }
                }
                if (HytHisRecipeStatusEnum.PAY.getValue().equals(map.get(dto.getHisRecipeNo())) && OrderTypeEnum.DRUG_ORDER.getValue().toString().equals(dto.getOrderType())) {
                    drugMainEntity = new DrugMainEntity();
                    drugMainEntity.setxId(dto.getMainId());
                    dto.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                }
                if (drugMainEntity != null) {
                    this.mosDrugMainMapper.update(drugMainEntity);
                }
                if (drugOrderEntity != null) {
                    this.mosDrugOrderMapper.update(drugOrderEntity);
                }
            }
            if (dto.getDrugSpeciesNum() == 1) {
                dto.setDrugDesc("\u542b" + dto.getDrugName() + "\u5171" + dto.getDrugSpeciesNum() + "\u79cd\u836f\u54c1");
            } else {
                dto.setDrugDesc("\u542b" + dto.getDrugName() + "...\u7b49\u5171" + dto.getDrugSpeciesNum() + "\u79cd\u836f\u54c1");
            }
            BeanUtils.copyProperties((Object)dto, (Object)resVO, (String[])BeanHelper.getNullPropertyNames((Object)dto));
            resultList.add(resVO);
        }
        result.setPageNum(vo.getPageNum().intValue());
        result.setPageSize(vo.getPageSize().intValue());
        result.setContent(resultList);
        return BaseResponse.success((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PageResult<DoctorMainListResVO>> doctorMainList(DoctorMainListReqVO vo) {
        log.info("======>\u533b\u751f\u7aef\u533b\u5631\u5217\u8868 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        ArrayList<DoctorMainListResVO> resultList = new ArrayList<DoctorMainListResVO>();
        PageResult result = new PageResult();
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List list = this.mosDrugMainMapper.queryMainByDoctor(vo);
        for (DoctorMainListDataDTO dto : list) {
            DoctorMainListResVO resVO = new DoctorMainListResVO();
            if (dto.getDrugSpeciesNum() == 1) {
                dto.setDrugDesc("\u542b" + dto.getDrugName() + "\u5171" + dto.getDrugSpeciesNum() + "\u79cd\u836f\u54c1");
            } else {
                dto.setDrugDesc("\u542b" + dto.getDrugName() + "...\u7b49\u5171" + dto.getDrugSpeciesNum() + "\u79cd\u836f\u54c1");
            }
            BeanUtils.copyProperties((Object)dto, (Object)resVO, (String[])BeanHelper.getNullPropertyNames((Object)dto));
            resultList.add(resVO);
        }
        result.setPageNum(vo.getPageNum().intValue());
        result.setPageSize(vo.getPageSize().intValue());
        result.setContent(resultList);
        return BaseResponse.success((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PageResult<DoctorWebMainListResVO>> doctorWebMainList(DoctorWebMainListReqVO vo) {
        log.info("======>\u533b\u751fWEB\u7aef\u533b\u5631\u5217\u8868 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        ArrayList<DoctorWebMainListResVO> resVoList = new ArrayList<DoctorWebMainListResVO>();
        PageResult result = new PageResult();
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List dtoList = this.mosDrugMainMapper.queryDoctorWebMainList(vo);
        for (DoctorWebMainListResVO dto : dtoList) {
            DoctorWebMainListResVO resVO = new DoctorWebMainListResVO();
            BeanUtils.copyProperties((Object)dto, (Object)resVO, (String[])BeanHelper.getNullPropertyNames((Object)dto));
            resVoList.add(resVO);
        }
        int count = this.mosDrugMainMapper.countDoctorWebMainList(vo);
        int totalPage = PageUtil.getTotalPage((int)count, (int)vo.getPageSize());
        result.setPageNum(vo.getPageNum().intValue());
        result.setPageSize(vo.getPageSize().intValue());
        result.setTotalPages(totalPage);
        result.setTotal(count);
        result.setContent(resVoList);
        return BaseResponse.success((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PageResult<ManageMainListResVO>> manageMainList(ManageMainListReqVO vo) {
        Object recipeNoList;
        log.info("======>\u7ba1\u7406\u7aef\u533b\u5631\u5217\u8868 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        Map map = null;
        ArrayList<ManageMainListResVO> resVoList = new ArrayList<ManageMainListResVO>();
        PageResult result = new PageResult();
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List dtoList = this.mosDrugMainMapper.queryManageMainList(vo);
        if (CollectionUtils.isNotEmpty((Collection)dtoList) && this.nodeConfig.getHyt().equals(vo.getAppCode()) && CollectionUtils.isNotEmpty((Collection)(recipeNoList = dtoList.stream().map(v -> v.getHisRecipeNo()).collect(Collectors.toList())))) {
            map = this.hisManage.getHisRecipeStatus((List)recipeNoList);
        }
        for (ManageMainListDataDTO dto : dtoList) {
            ManageMainListResVO resVO = new ManageMainListResVO();
            if (map != null) {
                DrugMainEntity drugMainEntity = null;
                DrugOrderEntity drugOrderEntity = null;
                if (HytHisRecipeStatusEnum.REFUND.getValue().equals(map.get(dto.getHisRecipeNo()))) {
                    drugMainEntity = new DrugMainEntity();
                    drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(dto.getMainId());
                    drugMainEntity.setxId(dto.getMainId());
                    dto.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                    if (drugOrderEntity != null) {
                        drugOrderEntity.setxId(dto.getOrderId());
                        drugOrderEntity.setStatus(OrderStatusEnum.HIS_REFUNDED.getValue());
                    }
                }
                if (HytHisRecipeStatusEnum.PAY.getValue().equals(map.get(dto.getHisRecipeNo())) && OrderTypeEnum.DRUG_ORDER.getValue().equals(dto.getOrderType())) {
                    drugMainEntity = new DrugMainEntity();
                    drugMainEntity.setxId(dto.getMainId());
                    dto.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                }
                if (drugMainEntity != null) {
                    this.mosDrugMainMapper.update(drugMainEntity);
                }
                if (drugOrderEntity != null) {
                    this.mosDrugOrderMapper.update(drugOrderEntity);
                }
            }
            BeanUtils.copyProperties((Object)dto, (Object)resVO, (String[])BeanHelper.getNullPropertyNames((Object)dto));
            resVoList.add(resVO);
        }
        int count = this.mosDrugMainMapper.countManageMainList(vo);
        int totalPage = PageUtil.getTotalPage((int)count, (int)vo.getPageSize());
        result.setPageNum(vo.getPageNum().intValue());
        result.setPageSize(vo.getPageSize().intValue());
        result.setTotalPages(totalPage);
        result.setTotal(count);
        result.setContent(resVoList);
        return BaseResponse.success((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<List<String>> queryMainIds(QueryMainIdsReqVO vo) {
        log.info("======>\u67e5\u8be2mainIds - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        List mainIds = this.mosDrugPrescriptionMapper.queryMultiMainIds(vo);
        return BaseResponse.success((Object)mainIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> confirmMedical(ConfirmMedicalReqVO vo) {
        List logisticsOrderList;
        log.info("======>\u533b\u4fdd\u786e\u8ba4 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        if (CollectionUtils.isEmpty((Collection)vo.getMainIds())) {
            return BaseResponse.error((String)"\u533b\u5631\u4fe1\u606f\u7f3a\u5931");
        }
        vo.getMainIds().stream().forEach(mainId -> {
            DrugMainEntity mainEntity = new DrugMainEntity();
            mainEntity.setxId(mainId);
            mainEntity.setItemStatus(DrugMainStatusEnum.HYT_UNPAID.getValue());
            this.drugMainService.update(mainEntity);
        });
        DrugMainEntity drugMainEntity = this.drugMainService.queryById((String)vo.getMainIds().get(0));
        int count = this.mosDrugMainMapper.getToSendCount(vo.getHisRegNo(), DrugMainStatusEnum.TO_SEND.getValue(), Integer.valueOf(2));
        if (count > 0 && CollectionUtils.isNotEmpty((Collection)(logisticsOrderList = this.mosDrugMainMapper.getToSendCountLogisticsEntity(vo.getHisRegNo(), DrugMainStatusEnum.TO_SEND.getValue())))) {
            vo.getMainIds().stream().forEach(mainId -> {
                DrugMainEntity mainEntity = new DrugMainEntity();
                MosDrugLogisticsOrderRegEntity regEntity = new MosDrugLogisticsOrderRegEntity();
                regEntity.setLogisticsOrderId(((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getId());
                regEntity.setMainId(mainId);
                regEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                regEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.logisticsOrderRegMapper.insert(regEntity);
                mainEntity.setxId(mainId);
                mainEntity.setItemStatus(DrugMainStatusEnum.TO_SEND.getValue());
                this.drugMainService.update(mainEntity);
            });
            new Thread(() -> {
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", ((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getId().toString());
                    map.put("body", "\u7269\u6d41\u7f16\u53f7\uff1a" + ((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getOrderSeq() + "\u7684\u8ba2\u5355\u5185\u5bb9\u6709\u65b0\u7684\u5904\u65b9\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u8fdb\u884c\u786e\u8ba4\u3002");
                    map.put("type", "yyy");
                    map.put("title", "\u5904\u65b9\u5408\u5e76\u53d1\u8d27");
                    map.put("subTitle", "\u5904\u65b9\u5408\u5e76\u53d1\u8d27");
                    map.put("pushCode", "1");
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("order", ((MosDrugLogisticsOrderEntity)logisticsOrderList.get(0)).getOrderSeq());
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
                    List pharmaceutistList = this.doctorRetmoteManage.getPharmaceutist(drugMainEntity.getAppCode());
                    log.info("===>\u67e5\u8be2\u836f\u5e08\u4fe1\u606f:{}====>", (Object)JSON.toJSONString((Object)pharmaceutistList));
                    if (CollectionUtils.isNotEmpty((Collection)pharmaceutistList)) {
                        for (PharmaceutistResVO resVO : pharmaceutistList) {
                            String userId;
                            DoctorInfoRespVO doctorInfoRespVO = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(resVO.getDoctorCode())));
                            if (doctorInfoRespVO != null && StringUtils.isNotEmpty((String)(userId = doctorInfoRespVO.getUserId()))) {
                                this.pushManage.iGoEasyPush(userId, JSON.toJSONString(map), "yyy_logistics_merge");
                            }
                            this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_tjcf", drugMainEntity.getPresDoctorPhone(), param);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new AsynException(e.getMessage());
                }
            }).start();
        }
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<TipResVO> queryTips(TipReqVO vo) {
        log.info("======>\u67e5\u8be2\u63d0\u793a - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        TipResVO resVo = new TipResVO();
        if (vo.getStatus() != null && vo.getStatus() == 10) {
            int count = this.mosDrugMainMapper.getPayCountByItemStatus(vo.getHisRegNo());
            if (count > 0) {
                resVo.setPayFlag(Boolean.valueOf(true));
            } else {
                resVo.setPayFlag(Boolean.valueOf(false));
            }
        }
        return BaseResponse.success((Object)resVo);
    }

    private List<MosDrugLogisticsRouteEntity> queryLogisticsRoute(MainDetailResVO resVO, String storeId, Integer distributionType) {
        Integer itemStatus = null;
        List<MosDrugLogisticsRouteEntity> mosDrugLogisticsRouteEntityList = this.mosDrugLogisticsRouteMapper.selectListByLogisticsOrderId(resVO.getLogisticsOrderId());
        List codeList = mosDrugLogisticsRouteEntityList.stream().map(v -> Integer.valueOf(v.getOpCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)mosDrugLogisticsRouteEntityList) || !codeList.contains(17)) {
            DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(storeId);
            BaseResponse baseResponse = this.logisticsManage.localOrderFeed(resVO.getLogisticsOrderSeq(), drugstoreEntity, distributionType);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(baseResponse.getCode())) {
                List feedList = ((LocalOrderFeedResVO)baseResponse.getData()).getFeed();
                List localCodeList = feedList.stream().map(v -> (int)v.getOrderStatus()).collect(Collectors.toList());
                List drugMainEntityList = this.mosDrugMainMapper.getListByLogisticsOrderId(resVO.getLogisticsOrderId());
                for (FeedDetailVO feedDetailVO : feedList) {
                    if (codeList.contains(feedDetailVO.getOrderStatus())) continue;
                    MosDrugLogisticsRouteEntity routeEntity = new MosDrugLogisticsRouteEntity();
                    routeEntity.setOpCode(feedDetailVO.getOrderStatus().toString());
                    routeEntity.setRemark(feedDetailVO.getContent());
                    routeEntity.setAcceptTotalTime(feedDetailVO.getCreateTime());
                    routeEntity.setLogisticsOrderId(resVO.getLogisticsOrderId());
                    routeEntity.setMailNo(resVO.getMainNo());
                    routeEntity.setDeliveryName(feedDetailVO.getOperatorName());
                    routeEntity.setDeliveryPhone(feedDetailVO.getOperatorPhone());
                    this.mosDrugLogisticsRouteMapper.insertSelective(routeEntity);
                    mosDrugLogisticsRouteEntityList.add(routeEntity);
                    if (localCodeList.contains(15)) {
                        itemStatus = DrugMainStatusEnum.TO_DELIVERY.getValue();
                    }
                    if (!localCodeList.contains(17)) continue;
                    itemStatus = DrugMainStatusEnum.SIGN_IN.getValue();
                }
                if (itemStatus != null) {
                    for (DrugMainEntity drugMainEntity : drugMainEntityList) {
                        DrugMainEntity mainEntity = new DrugMainEntity();
                        mainEntity.setxId(drugMainEntity.getxId());
                        mainEntity.setItemStatus(itemStatus);
                        this.mosDrugMainMapper.update(mainEntity);
                    }
                }
            }
        }
        mosDrugLogisticsRouteEntityList = mosDrugLogisticsRouteEntityList.stream().sorted(Comparator.comparing(MosDrugLogisticsRouteEntity::getAcceptTotalTime)).collect(Collectors.toList());
        return mosDrugLogisticsRouteEntityList;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PageResult<AuditMainListResVO>> auditMainList(AuditMainListReqVO vo) {
        StringBuilder type = new StringBuilder();
        ArrayList<AuditMainListResVO> resultList = new ArrayList<AuditMainListResVO>();
        PageResult result = new PageResult();
        if (StringUtils.isNotEmpty((String)vo.getDoctorId())) {
            List infoDtos = this.doctorRetmoteManage.getDocWorkInfoService(vo.getOrganId(), vo.getDoctorId());
            if (CollectionUtils.isNotEmpty((Collection)infoDtos)) {
                for (DocWorkInfoDto infoDto : infoDtos) {
                    if ("cfglzy".equalsIgnoreCase(infoDto.getServiceCode()) && Integer.valueOf(1).equals(infoDto.getAuthStatus()) && Integer.valueOf(1).equals(infoDto.getStatus())) {
                        type.append("3,");
                        break;
                    }
                    if (!"cfgl".equalsIgnoreCase(infoDto.getServiceCode()) || !Integer.valueOf(1).equals(infoDto.getAuthStatus()) || !Integer.valueOf(1).equals(infoDto.getStatus())) continue;
                    type.append("4,");
                }
            }
            type = new StringBuilder(StringUtils.isEmpty((String)type.toString()) ? "-1" : type.substring(0, type.length() - 1));
        }
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List list = this.mosDrugMainMapper.queryMainByAudit(vo, type.toString());
        for (AuditMainListDataDTO dto : list) {
            AuditMainListResVO resVO = new AuditMainListResVO();
            if (dto.getDrugSpeciesNum() == 1) {
                dto.setDrugDesc("\u542b" + dto.getDrugName() + "\u5171" + dto.getDrugSpeciesNum() + "\u79cd\u836f\u54c1");
            } else {
                dto.setDrugDesc("\u542b" + dto.getDrugName() + "...\u7b49\u5171" + dto.getDrugSpeciesNum() + "\u79cd\u836f\u54c1");
            }
            if (!(DrugMainStatusEnum.USELESS.getValue().equals(dto.getItemStatus()) || DrugMainStatusEnum.APPROVING.getValue().equals(dto.getItemStatus()) || DrugMainStatusEnum.PHARMACIST_BACK.getValue().equals(dto.getItemStatus()))) {
                dto.setItemStatus(PASS_STATUS);
            }
            BeanUtils.copyProperties((Object)dto, (Object)resVO, (String[])BeanHelper.getNullPropertyNames((Object)dto));
            resultList.add(resVO);
        }
        PageInfo info = new PageInfo(list);
        result.setContent(resultList);
        result.setPageSize(vo.getPageSize().intValue());
        result.setPageNum(vo.getPageNum().intValue());
        result.setTotal(new Long(info.getTotal()).intValue());
        result.setTotalPages(info.getPages());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<Object> auditMain(AuditMainReqVO vo) {
        Integer itemStatus = null;
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        if (Objects.isNull(mainEntity)) {
            return BaseResponse.error((String)"\u533b\u5631\u4e0d\u5b58\u5728");
        }
        MosOutpatientMainRelEntity outpatientMainRelEntity = this.mosOutpatientMainRelMapper.getByMainId(vo.getMainId());
        boolean isAuditedPres = this.isAuditedPres(mainEntity.getItemStatus());
        if (isAuditedPres) {
            return BaseResponse.error((String)"\u8be5\u5904\u65b9\u5df2\u7ecf\u88ab\u5ba1\u6838\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c");
        }
        itemStatus = vo.getOperation().equals(1) ? DrugMainStatusEnum.UNDRUGS.getValue() : DrugMainStatusEnum.PHARMACIST_BACK.getValue();
        mainEntity.setItemStatus(itemStatus);
        this.mosDrugMainMapper.update(mainEntity);
        this.drugMainService.saveDrugExtend(vo.getMainId(), vo.getOperationUser(), vo.getOperationCode(), vo.getDoctorSign(), vo.getContent(), vo.getOperation());
        this.drugMainService.addRemark(vo.getMainId(), vo.getContent(), vo.getOperationUser(), RemarkTypeEnum.VERIFIER.getValue());
        List drugPrescriptionList = this.mosDrugPrescriptionMapper.queryByMainIds(Arrays.asList(vo.getMainId()));
        for (DrugPrescriptionEntity drugPrescriptionEntity : drugPrescriptionList) {
            if (vo.getOperation().equals(1)) {
                try {
                    this.prescriptionPdfService.setPresPdf(vo.getMainId(), drugPrescriptionEntity.getxId());
                    this.prescriptionPdfService.setPresPdf(vo.getMainId(), null);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            new Thread(() -> {
                String auditImMsg = "";
                String auditAppMsg = "";
                String doctorUserId = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(mainEntity.getPresDoctorId()))).getUserId();
                if (vo.getOperation().equals(1)) {
                    auditImMsg = "\u60a8\u7684\u5904\u65b9\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u5c06\u81ea\u52a8\u53d1\u9001\u7ed9\u60a3\u8005";
                    auditAppMsg = "\u60a8\u7684\u5904\u65b9\u5df2\u901a\u8fc7\u836f\u5e08\u5ba1\u6838\uff0c\u5c06\u81ea\u52a8\u53d1\u9001\u7ed9\u60a3\u8005\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b";
                    LinkedHashMap data = new LinkedHashMap();
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("value", mainEntity.getPresDoctorName());
                    data.put("doctorName", map1);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("value", "\u5904\u65b9\u5df2\u5f00\u5177");
                    data.put("issue", map2);
                    HashMap<String, String> map3 = new HashMap<String, String>();
                    map3.put("value", "\u60a8\u7684\u5904\u65b9\u5df2\u5f00\u5177\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8be6\u60c5");
                    data.put("info", map3);
                    this.pushManage.iWeChatPush(mainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(mainEntity.getPresOrgan(), mainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + mainEntity.getxId());
                    String patientMsg = "\u533b\u751f\u7ed9\u60a8\u5f00\u5177\u4e86\u4e00\u4e2a\u5904\u65b9,\u5904\u65b9\u8be6\u60c5\u8bf7\u67e5\u770b" + mainEntity.getxId();
                    this.asynManage.imPushMsgByMainId(BusinessCodeEnum.OBTAIN.getValue(), mainEntity.getxId(), drugPrescriptionEntity.getHisRecipeNo(), "EHOS_PATIENT", mainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)patientMsg, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                    String doctorMsg = "\u60a8\u7ed9\u60a3\u8005" + mainEntity.getPatientName() + "\u5f00\u5177\u4e86\u4e00\u4e2a\u5904\u65b9,\u5904\u65b9\u8be6\u60c5\u8bf7\u67e5\u770b" + mainEntity.getxId();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("msg", (Object)doctorMsg);
                    jsonObject.put("mainId", (Object)mainEntity.getxId());
                    jsonObject.put("presType", (Object)(DrugTypeEnum.getDesc((Integer)mainEntity.getPresType()) + "\u5904\u65b9"));
                    jsonObject.put("hisRecipeNo", (Object)drugPrescriptionEntity.getHisRecipeNo());
                    this.asynManage.imPushMsgByMainId(BusinessCodeEnum.OBTAIN.getValue(), mainEntity.getxId(), drugPrescriptionEntity.getHisRecipeNo(), "EHOS_DOCTOR", doctorUserId, outpatientMainRelEntity.getAdmissionId(), (Object)jsonObject, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                } else {
                    auditImMsg = "\u4f60\u7684\u5904\u65b9\u672a\u901a\u8fc7\u836f\u5e08\u5ba1\u6838\uff0c\u8bf7\u60a8\u6838\u5bf9\u539f\u56e0\u540e\u91cd\u65b0\u5f00\u5177\u5904\u65b9";
                    auditAppMsg = "\u4f60\u7684\u5904\u65b9\u672a\u901a\u8fc7\u836f\u5e08\u5ba1\u6838\uff0c\u8bf7\u60a8\u6838\u5bf9\u539f\u56e0\u540e\u91cd\u65b0\u5f00\u5177\u5904\u65b9\uff0c\u70b9\u51fb\u67e5\u770b";
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
                    this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy-yssh", mainEntity.getPresDoctorPhone(), new HashMap());
                }
                MessageData dataDoctor = new MessageData();
                dataDoctor.setText(auditImMsg);
                this.asynManage.imPushMsgByMainId(BusinessCodeEnum.CHECK.getValue(), mainEntity.getxId(), "", "EHOS_DOCTOR", doctorUserId, outpatientMainRelEntity.getAdmissionId(), (Object)dataDoctor, BusinessConstant.SERVICE_SYSTEM_POINT_TYPE);
                this.pushManage.iAppMsgPush(UserEnum.DOCTOR.getDesc(), mainEntity.getPresOrgan(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getBusiCode(), auditAppMsg, "\u5904\u65b9\u5ba1\u6838\u63d0\u9192", PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getDesc(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getActionCode(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getValueCode().toString(), mainEntity.getxId(), this.doctorRetmoteManage.getDevice(doctorUserId, UserTypeEnum.DOCTOR.getValue(), mainEntity.getPresOrgan()));
            }).start();
        }
        return BaseResponse.success();
    }

    private synchronized boolean isAuditedPres(Integer itemStatus) {
        return !DrugMainStatusEnum.APPROVING.getValue().equals(itemStatus);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> pdf() {
        ArrayList<String> strList = new ArrayList<String>();
        List list = this.mosDrugMainMapper.queryForHytPdf();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DrugMainEntity drugMainEntity : list) {
                String stamp = this.camanage.getStamp(drugMainEntity.getPresDoctorId(), drugMainEntity.getPresOrgan());
                if (StringUtils.isEmpty((String)stamp)) {
                    strList.add(drugMainEntity.getPresDoctorId());
                    continue;
                }
                drugMainEntity.setDoctorSign(stamp);
                this.mosDrugMainMapper.update(drugMainEntity);
                log.info("=======\u533b\u5631ID:{}", (Object)drugMainEntity.getxId());
                List presList = this.mosDrugPrescriptionMapper.queryByMainIds(Arrays.asList(drugMainEntity.getxId()));
                for (DrugPrescriptionEntity drugPrescriptionEntity : presList) {
                    this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), drugPrescriptionEntity.getxId());
                }
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
        }
        log.info("=======CA\u7b7e\u7ae0\u7f3a\u5931\u533b\u751fID\u96c6\u5408\uff1a{}", (Object)Arrays.toString(strList.toArray()));
        return null;
    }

    public BaseResponse<List<PresDetailData>> getMainByAdmIdDetail(MultirecipeDetailReqVO vo) {
        List list = new ArrayList();
        List mosOutpatientMainRelEntityList = this.mosOutpatientMainRelMapper.getPrescriptionDetail(vo.getOrderId(), vo.getAdmissionId());
        if (CollectionUtils.isNotEmpty((Collection)mosOutpatientMainRelEntityList)) {
            for (MosOutpatientMainRelEntity mosOutpatientMainRelEntity : mosOutpatientMainRelEntityList) {
                MainDetailReqVO mainDetailReqVO = new MainDetailReqVO();
                mainDetailReqVO.setMainId(mosOutpatientMainRelEntity.getMainId());
                mainDetailReqVO.setType(DOCTOR_TYPE);
                BaseResponse baseResponse = this.queryMainDetail(mainDetailReqVO);
                list.addAll(((MainDetailResVO)baseResponse.getData()).getPresDetailList());
            }
        }
        list = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PresDetailData>(Comparator.comparing(PresDetailData::getHisRecipeNo))), ArrayList::new));
        return BaseResponse.success(list);
    }

    static {
        unitList.add("\u888b");
        unitList.add("\u6761");
    }
}

