/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.task;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.enums.BaseStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DosageFormEnum;
import com.ebaiyihui.medicalcloud.common.enums.HYTDrugTypeEnum;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.his.ResponseDrugDetailResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.his.ResponseDrugResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.DrugListReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.OrganizationResDTO;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DrugItemTask {
    private static final Logger log = LoggerFactory.getLogger(DrugItemTask.class);
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private HisLogService hisLogService;
    private static final String DEPTCODE = "6692";

    public void DrugSynchronization() {
        log.info("========\u8fdb\u5165\u540c\u6b65\u822a\u5929\u836f\u54c1\u63a5\u53e3");
        String hospitalName = "\u822a\u5929\u4e2d\u5fc3\u533b\u9662";
        OrganizationResDTO organizationResDTO = this.doctorRetmoteManage.getByHospitalName(hospitalName);
        DrugListReqVo drugListReqVo = new DrugListReqVo();
        drugListReqVo.setDeptCode(DEPTCODE);
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)drugListReqVo);
        BaseResponse baseResponse = this.hisManage.sendHis("/hyt-his/api/v1/drug/getDrugList", frontRequest, ResponseDrugResDTO.class);
        HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/drug/getDrugList", organizationResDTO.getId().toString());
        this.hisLogService.updateEntity(hisLogEntity, baseResponse);
        if (Objects.nonNull(baseResponse.getData())) {
            for (ResponseDrugDetailResDTO responseDrugDetailResDTO : ((ResponseDrugResDTO)baseResponse.getData()).getResponseDrugDetailList().getDrugDetailList()) {
                DrugItemEntity drugItemEntity = this.drugItemMapper.queryByCommonCode(responseDrugDetailResDTO.getDrugId(), "HYT");
                if (Objects.isNull(drugItemEntity)) {
                    this.savaDrugItemEntity(responseDrugDetailResDTO, organizationResDTO);
                    continue;
                }
                this.updateDrugItemEntity(drugItemEntity, responseDrugDetailResDTO, organizationResDTO);
            }
        }
    }

    private void updateDrugItemEntity(DrugItemEntity drugItemEntity, ResponseDrugDetailResDTO responseDrugDetailResDTO, OrganizationResDTO organizationResDTO) {
        drugItemEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugItemEntity.setQyt(responseDrugDetailResDTO.getCounts());
        drugItemEntity.setDrugDeptCode(responseDrugDetailResDTO.getDrugDeptCode());
        drugItemEntity.setHospitalId(organizationResDTO.getId().toString());
        drugItemEntity.setHospitalName(organizationResDTO.getOrganName());
        drugItemEntity.setSpecPackingUnitName(responseDrugDetailResDTO.getMinBillPackingUnit());
        drugItemEntity.setDrugProperty(responseDrugDetailResDTO.getDrugProperty());
        drugItemEntity.setDrugApprovalNumber(responseDrugDetailResDTO.getDrugAppprovalNumber());
        drugItemEntity.setPrice(new BigDecimal(responseDrugDetailResDTO.getPrice()));
        drugItemEntity.setMinBillPackingUnitName(responseDrugDetailResDTO.getMinBillPackingUnit());
        drugItemEntity.setMeasureUnitName(responseDrugDetailResDTO.getMeasureUnit());
        if (DosageFormEnum.JL.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            drugItemEntity.setDosageForm(DosageFormEnum.JL.getDisplay());
        } else if (DosageFormEnum.YL.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            drugItemEntity.setDosageForm(DosageFormEnum.YL.getDisplay());
        } else if (DosageFormEnum.BL.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            drugItemEntity.setDosageForm(DosageFormEnum.BL.getDisplay());
        } else if (DosageFormEnum.HNS.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            drugItemEntity.setDosageForm(DosageFormEnum.HNS.getDisplay());
        } else {
            drugItemEntity.setDosageForm(DosageFormEnum.ZH.getDisplay());
        }
        drugItemEntity.setWholePackingUnitName(responseDrugDetailResDTO.getWholePackingUnit());
        log.info("======\u836f\u54c1\u540c\u6b65\u4fee\u6539:{}", (Object)JSONObject.toJSONString((Object)drugItemEntity));
        this.drugItemMapper.updateById(drugItemEntity);
    }

    private void savaDrugItemEntity(ResponseDrugDetailResDTO responseDrugDetailResDTO, OrganizationResDTO organizationResDTO) {
        DrugItemEntity entity = new DrugItemEntity();
        entity.setxId(GenSeqUtils.getUniqueNo());
        entity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        entity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        entity.setProductName(responseDrugDetailResDTO.getDrugName());
        entity.setProductCode(responseDrugDetailResDTO.getProductCode());
        if (HYTDrugTypeEnum.XY.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.XY.getValue());
        } else if (HYTDrugTypeEnum.ZCY.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.ZCY.getValue());
        } else if (HYTDrugTypeEnum.CY.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.CY.getValue());
        } else if (HYTDrugTypeEnum.WSCL.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.WSCL.getValue());
        } else if (HYTDrugTypeEnum.ZZYP.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.ZZYP.getValue());
        } else if (HYTDrugTypeEnum.HYYP.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.HYYP.getValue());
        } else if (HYTDrugTypeEnum.ZJYP.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.ZJYP.getValue());
        } else if (HYTDrugTypeEnum.FSY.getDesc().equals(responseDrugDetailResDTO.getDrugType())) {
            entity.setType(HYTDrugTypeEnum.FSY.getValue());
        } else {
            entity.setType(HYTDrugTypeEnum.YLY.getValue());
        }
        entity.setCommonName(responseDrugDetailResDTO.getCommonName());
        entity.setCommonCode(responseDrugDetailResDTO.getDrugId());
        entity.setWholePackingNum(new BigDecimal(responseDrugDetailResDTO.getWholePackingNum()));
        entity.setWholePackingUnitName(responseDrugDetailResDTO.getWholePackingUnit());
        entity.setSpecPackingUnitName(responseDrugDetailResDTO.getMinBillPackingUnit());
        entity.setMinBillPackingNum(new BigDecimal(responseDrugDetailResDTO.getWholePackingNum()));
        entity.setMinBillPackingUnitName(responseDrugDetailResDTO.getMinBillPackingUnit());
        entity.setMeasureNum(new BigDecimal(responseDrugDetailResDTO.getMeasureNum()));
        entity.setMeasureUnitName(responseDrugDetailResDTO.getMeasureUnit());
        entity.setManufacturer(responseDrugDetailResDTO.getManufacturer());
        if (DosageFormEnum.JL.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            entity.setDosageForm(DosageFormEnum.JL.getDisplay());
        } else if (DosageFormEnum.YL.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            entity.setDosageForm(DosageFormEnum.YL.getDisplay());
        } else if (DosageFormEnum.BL.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            entity.setDosageForm(DosageFormEnum.BL.getDisplay());
        } else if (DosageFormEnum.HNS.getValue().equals(responseDrugDetailResDTO.getDosageForm())) {
            entity.setDosageForm(DosageFormEnum.HNS.getDisplay());
        } else {
            entity.setDosageForm(DosageFormEnum.ZH.getDisplay());
        }
        entity.setSocialSecurityClass(responseDrugDetailResDTO.getSocialSecurityClass());
        entity.setStorageConditions(responseDrugDetailResDTO.getStorageConditions());
        entity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        entity.setDrugSpec(responseDrugDetailResDTO.getDrugSpec());
        entity.setAppCode(organizationResDTO.getAppCode());
        entity.setDrugProperty(responseDrugDetailResDTO.getDrugProperty());
        entity.setPrice(new BigDecimal(responseDrugDetailResDTO.getPrice()));
        entity.setDrugDeptCode(responseDrugDetailResDTO.getDrugDeptCode());
        entity.setQyt(responseDrugDetailResDTO.getCounts());
        entity.setHospitalId(organizationResDTO.getId().toString());
        entity.setHospitalName(organizationResDTO.getOrganName());
        entity.setDrugApprovalNumber(responseDrugDetailResDTO.getDrugAppprovalNumber());
        log.info("======\u836f\u54c1\u540c\u6b65\u65b0\u589e:{}", (Object)JSONObject.toJSONString((Object)entity));
        this.drugItemMapper.insert(entity);
    }
}

