/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.task;

import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.common.enums.AppCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.HytHisRecipeStatusEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.pojo.dto.HytRecipeDataDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosSynchPresRecordEntity;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosSynchPresRecordService;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DrugMainTask {
    private static final Logger log = LoggerFactory.getLogger(DrugMainTask.class);
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private MosSynchPresRecordService mosSynchPresRecordService;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private HisManage hisManage;

    public void drugMainTimeOut() {
        log.info("\u5904\u65b9\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb==========>");
        String mainStatus = DrugMainStatusEnum.ZRYH_UNPAID.getValue() + "";
        List drugMainEntityList = this.drugMainService.getByAppCodeAndItemStatus(this.specialNodeConfig.getZryh(), mainStatus);
        if (CollectionUtils.isNotEmpty((Collection)drugMainEntityList)) {
            for (DrugMainEntity drugMainEntity : drugMainEntityList) {
                if (!DateTimeUtil.addHour((Date)drugMainEntity.getxCreateTime(), (int)72).before(new Date())) continue;
                drugMainEntity.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
                drugMainEntity.setxRemark("\u4e2d\u65e5\u53cb\u597d\u8282\u70b9\u7cfb\u7edf\u81ea\u52a8\u8bbe\u7f6e\u8fc7\u671f\u5904\u65b9");
                this.drugMainService.update(drugMainEntity);
                try {
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_yfgq", drugMainEntity.getPatientPhone(), null);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    LinkedHashMap data = new LinkedHashMap();
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("value", drugMainEntity.getPresDoctorName());
                    data.put("doctorName", map1);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("value", "\u5904\u65b9\u5df2\u8fc7\u671f");
                    data.put("issue", map2);
                    HashMap<String, String> map3 = new HashMap<String, String>();
                    map3.put("value", "\u60a8\u7684\u5904\u65b9\u5df2\u8fc7\u671f\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u5904\u65b9\u8be6\u60c5");
                    data.put("info", map3);
                    HashMap map4 = new HashMap();
                    map3.put("value", drugMainEntity.getxId());
                    data.put("mainId", map4);
                    if (drugMainEntity.getPresOrgan().equals(this.specialNodeConfig.getZryh())) {
                        this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + drugMainEntity.getxId());
                        continue;
                    }
                    this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + drugMainEntity.getxId());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        log.info("\u5904\u65b9\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f======");
    }

    public void synchronPres() {
        List mosSynchPresRecordEntityList = this.mosSynchPresRecordService.getByResponseCodeAndTimes();
        if (CollectionUtils.isNotEmpty((Collection)mosSynchPresRecordEntityList)) {
            for (MosSynchPresRecordEntity synchPresRecordEntity : mosSynchPresRecordEntityList) {
                Integer times = synchPresRecordEntity.getCompensateTimes();
                String url = this.nodeConfig.getAddHospitalPrescription();
                HashMap<String, String> headMap = new HashMap<String, String>();
                headMap.put("projectCode", "ZRYHYY");
                log.info("\u7ed9\u56fd\u836f\u534e\u6cf0\u540c\u6b65\u5904\u65b9\u7684\u8bf7\u6c42\u662f:{}======header\u662f:{}===\u53c2\u6570\u662f:{}", new Object[]{url, headMap, synchPresRecordEntity.getRequestBody()});
                try {
                    String resData = HttpUtils.post((String)url, headMap, (String)synchPresRecordEntity.getRequestBody());
                    log.info("\u5904\u65b9:{}\u540c\u6b65\u56fd\u836f\u534e\u6cf0\u5904\u65b9\u8fd4\u56de\u7684\u7ed3\u679c\u662f:{}", (Object)synchPresRecordEntity.getMainId(), (Object)resData);
                    Integer code = JSONObject.parseObject((String)resData).getInteger("code");
                    String responseMessge = JSONObject.parseObject((String)resData).getString("message");
                    String responseData = JSONObject.parseObject((String)resData).getString("responseData");
                    times = times + 1;
                    this.mosSynchPresRecordService.updateTimesResponseDataAndMessage(synchPresRecordEntity.getId(), code, responseMessge, responseData, times);
                }
                catch (Exception e) {
                    log.error("ERROR", (Throwable)e);
                }
            }
        }
    }

    public void reminderPayLogisticsAmountInAm() {
        List drugMainEntityList = this.drugMainService.selectByItemStatusAndAppCode(DrugMainStatusEnum.ZRYH_CONFIRM.getValue(), "HYT");
        log.info("drugMainEntityList->{}", (Object)Objects.toString(drugMainEntityList.toString(), null));
        if (!CollectionUtils.isEmpty((Collection)drugMainEntityList)) {
            drugMainEntityList.stream().forEach(drugMainEntity -> new Thread(() -> {
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", drugMainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u8bf7\u9009\u62e9\u53d6\u836f\u65b9\u5f0f");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>(1);
                map3.put("value", "\u5c1a\u672a\u9009\u62e9\u53d6\u836f\u65b9\u5f0f\uff0c\u8bf7\u524d\u5f80\u5c0f\u7a0b\u5e8f\u9009\u62e9\u3002");
                data.put("info", map3);
                this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + drugMainEntity.getxId());
                try {
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    HashMap<String, String> hash = new HashMap<String, String>();
                    hash.put("doctorName", drugMainEntity.getPresDoctorName());
                    this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy-xzqyfs", drugMainEntity.getPatientPhone(), new HashMap());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new AsynException(e.getMessage());
                }
            }).start());
        }
    }

    public void hytSyncStatus() {
        HashSet<String> mainIds = new HashSet<String>();
        List recipeDataList = this.drugMainService.getRecipeByAppCodeAndItemStatus(AppCodeEnum.HYT.getValue(), DrugMainStatusEnum.TO_TAKE.getValue().toString());
        if (CollectionUtils.isNotEmpty((Collection)recipeDataList)) {
            List hisRecipeNos = recipeDataList.stream().map(HytRecipeDataDTO::getHisRecipeNo).distinct().collect(Collectors.toList());
            Map<String, String> mainMap = recipeDataList.stream().collect(Collectors.toMap(HytRecipeDataDTO::getHisRecipeNo, HytRecipeDataDTO::getMainId));
            Map map = this.hisManage.getHisRecipeStatus(hisRecipeNos);
            if (map != null) {
                for (String item2 : hisRecipeNos) {
                    if (!HytHisRecipeStatusEnum.PAY.getValue().equals(map.get(item2))) continue;
                    mainIds.add(mainMap.get(item2));
                }
                if (CollectionUtils.isNotEmpty(mainIds)) {
                    mainIds.stream().forEach(item -> {
                        DrugMainEntity drugMainEntity = new DrugMainEntity();
                        drugMainEntity.setxId(item);
                        drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                        this.drugMainService.update(drugMainEntity);
                    });
                }
            }
        }
    }
}

