/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class QrcodeUtil {
    private static final Logger log = LoggerFactory.getLogger(QrcodeUtil.class);
    private static String format = "png";
    private static String charset = "utf-8";
    private static int margin = 0;

    public static BufferedImage genImage(String data, int width, int height) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, charset);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, margin);
        BitMatrix matrix = null;
        try {
            matrix = new MultiFormatWriter().encode(data, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            log.error("\u4e8c\u7ef4\u7801\u6570\u636e\u77e9\u9635\u751f\u6210\u5931\u8d25 \u4e8c\u7ef4\u7801\u6570\u636e{}", (Object)data, (Object)e);
            return null;
        }
        log.debug("\u539f\u751f\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f");
        return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
    }

    public static String writeImageToString(BufferedImage combinedImage) {
        String imageData = null;
        try {
            log.debug("\u5c06\u56fe\u7247\u6570\u636e\u8fdb\u884cbase64\u7f16\u7801");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)combinedImage, format, baos);
            byte[] byteArray = baos.toByteArray();
            imageData = Base64Utils.encodeToString((byte[])byteArray);
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u6570\u636e\u8f6c\u5b57\u7b26\u4e32\u5f02\u5e38", (Throwable)e);
            return null;
        }
        log.debug("\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f");
        return imageData;
    }
}

