/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    public static final int ONE_THOUSAND = 1000;
    public static final String X_DELAY = "x-delay";

    public static void senderDelayedLogisticsOrder(RabbitTemplate rabbitTemplate, String logisticsOrderSeq, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange", "logistics.delayed_order_routing_key", (Object)logisticsOrderSeq, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)(orderExpireTime * 1000));
            log.info("send logistics order message to rabbitmq: " + logisticsOrderSeq);
            return message;
        });
    }

    public static void senderDelayedPrescriptionOrder(RabbitTemplate rabbitTemplate, String mainId, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange", "prescription.delayed_order_routing_key", (Object)mainId, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)(orderExpireTime * 1000));
            log.info("send prescription order message to rabbitmq: " + mainId);
            return message;
        });
    }

    public static void senderRegistryPrescriptionOrder(RabbitTemplate rabbitTemplate, String info, Integer orderExpireTime) {
        log.info("\u5357\u5927\u4e8c\u5904\u65b9\u63a8\u9001\uff0c\u63a8\u5165\u6d88\u606f\u961f\u5217\uff0ckey\u4e3a\uff1a{}", (Object)info);
        rabbitTemplate.convertAndSend("logistics.delayed_exchange", "prescription.add_order_repeat_routing_key", (Object)info, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)(orderExpireTime * 1000));
            log.info("send registry prescription order message to rabbitmq: " + info);
            return message;
        });
    }
}

