/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils.id;

import com.ebaiyihui.medicalcloud.exception.IdGenerationException;
import com.ebaiyihui.medicalcloud.utils.ReflectHelper;
import com.ebaiyihui.medicalcloud.utils.id.FunctionGenerator;
import com.ebaiyihui.medicalcloud.utils.id.IdentifierGenerator;
import com.ebaiyihui.medicalcloud.utils.id.NumberGenerator;
import com.ebaiyihui.medicalcloud.utils.id.UUIDGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public final class IdentifierGeneratorFactory {
    private static final HashMap<String, Class<?>> GENERATORS = new HashMap();
    private static final Map<String, IdentifierGenerator> INSTANCES = new ConcurrentHashMap();

    private IdentifierGeneratorFactory() {
    }

    public static IdentifierGenerator get(String strategy) {
        IdentifierGenerator generator = (IdentifierGenerator)INSTANCES.get(strategy);
        if (generator == null) {
            generator = IdentifierGeneratorFactory.create((String)strategy);
            INSTANCES.put(strategy, generator);
        }
        return generator;
    }

    public static IdentifierGenerator create(String strategy) throws IdGenerationException {
        try {
            int idx = strategy.indexOf(46);
            String strategyKey = strategy;
            String extra = null;
            if (idx != -1) {
                strategyKey = strategy.substring(0, idx);
                extra = strategy.substring(idx + 1);
            }
            Class clazz = IdentifierGeneratorFactory.getIdentifierGeneratorClass((String)strategyKey);
            IdentifierGenerator generator = (IdentifierGenerator)clazz.newInstance();
            generator.setExtra(extra);
            return generator;
        }
        catch (Exception e) {
            throw new IdGenerationException("could not instantiate id generator", (Throwable)e);
        }
    }

    public static Class<?> getIdentifierGeneratorClass(String strategy) {
        Class clazz = (Class)GENERATORS.get(strategy);
        try {
            if (clazz == null) {
                clazz = ReflectHelper.classForName((String)strategy);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IdGenerationException("could not interpret id generator strategy: " + strategy);
        }
        return clazz;
    }

    public static String getUniqueValue() {
        return IdentifierGeneratorFactory.get((String)"uuid").generate().toString();
    }

    static {
        GENERATORS.put("uuid", UUIDGenerator.class);
        GENERATORS.put("function", FunctionGenerator.class);
        GENERATORS.put("number", NumberGenerator.class);
    }
}

