/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.webservice.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.constants.BusinessConstant;
import com.ebaiyihui.medicalcloud.common.enums.AppCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.BaseStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.BusinessCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.HisExpressTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.medicalcloud.common.enums.PushCodeInfoEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserTypeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.manage.AsynManage;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.DrugMainManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DiagnosticEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PharmaceutistResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PresDetailVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.DiagnosisReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.LogisticsRecipeReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.RecipeDiagnoseResultResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.AuditPrescriptionResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.OutPresDetail;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.OutPresDetailVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.PresDetailResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.RecipeResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.RecipeVO;
import com.ebaiyihui.medicalcloud.service.DiagnosticService;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.MosDrugUnitService;
import com.ebaiyihui.medicalcloud.service.MosOutpatientMainRelService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HanyuPinyinUtil;
import com.ebaiyihui.medicalcloud.utils.RandomUtils;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.XmlUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jws.WebService;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@WebService
@Service
public class OutReachManage {
    private static final Logger log = LoggerFactory.getLogger(OutReachManage.class);
    public static final Integer FEE_TYPE_OWN_EXPENSE = 1;
    public static final int FEE_TYPE_PUBLIC_MEDICAL = 2;
    private static final Integer CARD_TYPE_OWN_EXPENSE = 1;
    private static final Integer CARD_TYPE_MEDICARE_CARD = 2;
    public static final int ONE_THOUSAND_METERS = 10000;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private AsynManage asynManage;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private MosOutpatientMainRelService mosOutpatientMainRelService;
    @Autowired
    private DrugMainManage drugMainManage;
    @Autowired
    private DiagnosticService diagnosticService;
    @Autowired
    private MosOutpatientMainRelService outpatientMainRelService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private DrugDetailService drugDetailService;
    @Autowired
    private MosDrugUnitService drugUnitService;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private HisLogService hisLogService;

    @Transactional(rollbackFor={Exception.class})
    public void synHisPrescription(String xml) {
        RecipeVO recipeVO = (RecipeVO)XmlUtil.convertToJavaBean((String)xml, RecipeVO.class);
        for (RecipeResVO recipeResVO : recipeVO.getResVOS()) {
            recipeResVO.setExpressFlag(HisExpressTypeEnum.TRIPARTITE_PHARMACY.getValue().toString());
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("/zryh-his/api/v1/recipe/queryRecipeDetail").toString();
            PresDetailResVO presDetailResVO = new PresDetailResVO();
            presDetailResVO.setHisRegNo(recipeResVO.getHisRegNo());
            presDetailResVO.setRecipeNo(recipeResVO.getRecipeNo());
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u7684url\u662f:{}====\u8bf7\u6c42\u524d\u7f6e\u673a\u7684\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)presDetailResVO));
            OutPresDetailVO outPresDetailVO = null;
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)presDetailResVO);
            BaseResponse outPresDetailResponse = this.hisManage.sendHis("/zryh-his/api/v1/recipe/queryRecipeDetail", frontRequest, OutPresDetailVO.class);
            DrugMainEntity mainEntity = this.mosDrugMainMapper.getByHisRecipeNo(recipeResVO.getRecipeNo());
            HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/recipe/queryRecipeDetail", mainEntity.getOrganId());
            hisLogEntity.setResponse(JSONObject.toJSONString((Object)outPresDetailResponse));
            this.hisLogService.update(hisLogEntity);
            if (!outPresDetailResponse.isSuccess()) {
                log.info("\u67e5\u8be2\u836f\u54c1\u8be6\u60c5\u5931\u8d25->{}", (Object)outPresDetailResponse.toString());
                break;
            }
            outPresDetailVO = (OutPresDetailVO)outPresDetailResponse.getData();
            MosOutpatientMainRelEntity mosOutpatientMainRelEntity = this.mosOutpatientMainRelService.getByHisRegNoLimitFirst(recipeResVO.getHisRegNo());
            FromOutlineVO fromOutlineVO = this.drugMainManage.getOutLineInfo(mosOutpatientMainRelEntity.getOrderId(), mosOutpatientMainRelEntity.getAdmissionId(), mosOutpatientMainRelEntity.getAppCode());
            DrugMainEntity oldDrugMainEntity = this.mosDrugMainMapper.queryById(mosOutpatientMainRelEntity.getMainId());
            DrugMainEntity drugMainEntity = this.saveDrugMain(oldDrugMainEntity, fromOutlineVO, recipeResVO, outPresDetailVO);
            mosOutpatientMainRelEntity.setXId(GenSeqUtils.getUniqueNo());
            mosOutpatientMainRelEntity.setHisRegNo(recipeResVO.getHisRegNo());
            mosOutpatientMainRelEntity.setMainId(drugMainEntity.getxId());
            this.outpatientMainRelService.insert(mosOutpatientMainRelEntity);
            DiagnosticEntity diagnosticEntity = this.saveDiagnostic(drugMainEntity, recipeResVO);
            DrugPrescriptionEntity drugPrescriptionEntity = this.savePrescription(drugMainEntity, diagnosticEntity, outPresDetailVO, recipeResVO);
            this.saveDrugsItemDetail(outPresDetailVO, drugMainEntity, drugPrescriptionEntity);
            this.mosDrugMainService.addRemark(drugMainEntity.getxId(), "", fromOutlineVO.getPresDoctorName(), RemarkTypeEnum.ADD_PRES.getValue());
            PresDetailVO presDetailVO = new PresDetailVO();
            BeanUtils.copyProperties((Object)drugMainEntity, (Object)presDetailVO);
            presDetailVO.setDiseaseTags(fromOutlineVO.getTags());
            presDetailVO.setDiseaseDescription(fromOutlineVO.getDescription());
            presDetailVO.setNeedHelp(fromOutlineVO.getQuestion());
            try {
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
            catch (Exception e) {
                log.error("=============\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25================");
            }
            List outPresDetailList = outPresDetailVO.getList();
            this.threadPoolTaskExecutor.execute(() -> {
                List list;
                int drugCount = 0;
                String drugName = "";
                String presType = "";
                if (CollectionUtils.isNotEmpty((Collection)outPresDetailList)) {
                    drugCount = outPresDetailList.size();
                    drugName = ((OutPresDetail)outPresDetailList.get(0)).getItemName();
                }
                String drugDesc = drugCount == 1 ? "\u542b" + drugName + "\u5171" + drugCount + "\u79cd\u836f\u54c1" : "\u542b" + drugName + "...\u7b49\u5171" + drugCount + "\u79cd\u836f\u54c1";
                String patientMsg = "\u533b\u751f\u7ed9\u60a8\u5f00\u5177\u4e86\u4e00\u4e2a\u5904\u65b9,\u5904\u65b9\u8be6\u60c5\u8bf7\u67e5\u770b";
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("msg", (Object)patientMsg);
                jsonObject.put("mainId", (Object)drugMainEntity.getxId());
                jsonObject.put("prescriptionId", (Object)drugPrescriptionEntity.getxId());
                jsonObject.put("presType", (Object)(presType + "\u5904\u65b9"));
                jsonObject.put("expressFlagDesc", (Object)HisExpressTypeEnum.getByValue((int)Integer.valueOf(recipeResVO.getExpressFlag())).getDisplay());
                jsonObject.put("diagnostic", (Object)diagnosticEntity.getDiagnostic());
                jsonObject.put("drugDesc", (Object)drugDesc);
                this.asynManage.imPushMsgByMainId(BusinessCodeEnum.OBTAIN.getValue(), drugMainEntity.getxId(), "", "EHOS_PATIENT", drugMainEntity.getPatientUserId(), mosOutpatientMainRelEntity.getAdmissionId(), (Object)jsonObject, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                if (Integer.valueOf(recipeResVO.getExpressFlag()) == 2 && CollectionUtils.isNotEmpty((Collection)(list = this.doctorRetmoteManage.getPharmaceutist(drugMainEntity.getPresOrgan())))) {
                    for (PharmaceutistResVO resVO : list) {
                        this.pushManage.iAppMsgPush(UserEnum.DOCTOR.getDesc(), drugMainEntity.getPresOrgan(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getBusiCode(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u5904\u65b9\u5f85\u5ba1\u6838\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b", "\u5904\u65b9\u5ba1\u6838\u63d0\u9192", PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getDesc(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getActionCode(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getValueCode().toString(), "", this.doctorRetmoteManage.getDevice(this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(resVO.getDoctorCode()))).getUserId(), UserTypeEnum.DOCTOR.getValue(), AppCodeEnum.ZRYH.getValue()));
                    }
                }
            });
        }
    }

    private void saveDrugsItemDetail(OutPresDetailVO outPresDetailVO, DrugMainEntity drugMainEntity, DrugPrescriptionEntity drugPrescriptionEntity) {
        for (OutPresDetail outPresDetail : outPresDetailVO.getList()) {
            DrugDetailEntity drugDetailEntity = new DrugDetailEntity();
            drugDetailEntity.setxId(GenSeqUtils.getUniqueNo());
            drugDetailEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugDetailEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugDetailEntity.setOrganCode(drugMainEntity.getPresOrgan());
            drugDetailEntity.setMainId(drugMainEntity.getxId());
            drugDetailEntity.setPresId(drugPrescriptionEntity.getxId());
            if (!DrugTypeEnum.CM.getValue().equals(drugMainEntity.getPresType())) {
                DrugItemEntity drugItemEntity = this.drugItemMapper.queryByCommonCode(outPresDetail.getItemCode(), drugMainEntity.getAppCode());
                if (Objects.nonNull(drugItemEntity)) {
                    drugDetailEntity.setDrugId(drugItemEntity.getxId());
                    drugDetailEntity.setMinBillPackingNum(drugItemEntity.getMinBillPackingNum());
                    DrugUnitEntity minPack = this.drugUnitService.queryById(drugItemEntity.getMinBillPackingUnitId());
                    drugDetailEntity.setMinBillPackingUnit(minPack.getUnitName());
                    drugDetailEntity.setMeasureNum(drugItemEntity.getMeasureNum());
                    drugDetailEntity.setManufacturer(drugItemEntity.getManufacturer());
                } else {
                    drugDetailEntity.setDrugId("");
                    drugDetailEntity.setMinBillPackingNum(new BigDecimal(""));
                    drugDetailEntity.setMinBillPackingUnit("1");
                    drugDetailEntity.setMeasureNum(new BigDecimal(""));
                    drugDetailEntity.setManufacturer("");
                }
                drugDetailEntity.setDrugCommonCode(outPresDetail.getItemCode());
                drugDetailEntity.setDrugName(outPresDetail.getItemName());
                drugDetailEntity.setSingleDose(new BigDecimal(outPresDetail.getDosage()));
                drugDetailEntity.setMeasureUnit(outPresDetail.getDosageUnit());
                drugDetailEntity.setAmount(new BigDecimal(outPresDetail.getCount()));
                drugDetailEntity.setFrequencyDesc(outPresDetail.getFrequencyName());
                drugDetailEntity.setUsageDesc(outPresDetail.getUsageName());
                drugDetailEntity.setDuration(Integer.valueOf(outPresDetail.getDays()));
                drugDetailEntity.setWholePackingUnit(outPresDetail.getUnit());
                drugDetailEntity.setDrugSpec(outPresDetail.getSpecification());
            }
            drugDetailEntity.setUnitPrice(new BigDecimal(outPresDetail.getUnitPrice()));
            drugDetailEntity.setTotalPrice(new BigDecimal(outPresDetail.getFee()));
            this.drugDetailService.insert(drugDetailEntity);
        }
    }

    private DrugPrescriptionEntity savePrescription(DrugMainEntity drugMainEntity, DiagnosticEntity diagnosticEntity, OutPresDetailVO outPresDetailVO, RecipeResVO recipeResVO) {
        DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
        drugPrescriptionEntity.setxId(GenSeqUtils.getUniqueNo());
        drugPrescriptionEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugPrescriptionEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugPrescriptionEntity.setMainId(drugMainEntity.getxId());
        drugPrescriptionEntity.setHisRecipeNo(recipeResVO.getRecipeNo());
        drugPrescriptionEntity.setRecipeDate(recipeResVO.getRecipeDate());
        drugPrescriptionEntity.setAdmId(diagnosticEntity.getxId());
        if (CollectionUtils.isNotEmpty((Collection)outPresDetailVO.getList())) {
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (OutPresDetail outPresDetail : outPresDetailVO.getList()) {
                totalPrice = totalPrice.add(new BigDecimal(outPresDetail.getFee()));
            }
            log.info("\u836f\u54c1\u7684\u4ef7\u683c\u662f:{}", (Object)totalPrice);
            drugPrescriptionEntity.setStorePrice(totalPrice.setScale(4, 4));
            drugPrescriptionEntity.setPrice(totalPrice.setScale(2, 4));
        }
        return this.mosDrugPrescriptionService.insert(drugPrescriptionEntity);
    }

    private DiagnosticEntity saveDiagnostic(DrugMainEntity drugMainEntity, RecipeResVO recipeResVO) {
        DiagnosticEntity diagnosticEntity = new DiagnosticEntity();
        diagnosticEntity.setxId(GenSeqUtils.getUniqueNo());
        diagnosticEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        diagnosticEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        diagnosticEntity.setDoctorCode(drugMainEntity.getPresDoctorCode());
        diagnosticEntity.setDoctorName(drugMainEntity.getPresDoctorName());
        diagnosticEntity.setOrganCode(drugMainEntity.getPresOrgan());
        diagnosticEntity.setAdmId(GenSeqUtils.getUniqueNo());
        diagnosticEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        DiagnosisReqVO diagnosisReqVO = new DiagnosisReqVO();
        diagnosisReqVO.setHisRegNo(recipeResVO.getHisRegNo());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)diagnosisReqVO);
        BaseResponse baseResponse = this.hisManage.sendHis("/zryh-his/api/v1/recipe/get_diagnosis", frontRequest, RecipeDiagnoseResultResVO.class);
        HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/recipe/get_diagnosis", drugMainEntity.getOrganId());
        hisLogEntity.setResponse(JSONObject.toJSONString((Object)baseResponse));
        this.hisLogService.update(hisLogEntity);
        if (baseResponse.isSuccess()) {
            RecipeDiagnoseResultResVO recipeDiagnoseResultResVO = (RecipeDiagnoseResultResVO)baseResponse.getData();
            List diagnosisResVOList = recipeDiagnoseResultResVO.getList();
            List icdCodeList = diagnosisResVOList.stream().map(diagnosisRes -> diagnosisRes.getICDCode()).collect(Collectors.toList());
            String icdCodes = String.join((CharSequence)";", icdCodeList);
            List icdNameList = diagnosisResVOList.stream().map(diagnosisRes -> diagnosisRes.getICDName()).collect(Collectors.toList());
            String icdNames = String.join((CharSequence)";", icdNameList);
            diagnosticEntity.setDiagnostic(icdNames);
            diagnosticEntity.setIcdCode(icdCodes);
            diagnosticEntity.setIcdName(icdNames);
        }
        return this.diagnosticService.insert(diagnosticEntity);
    }

    private DrugMainEntity saveDrugMain(DrugMainEntity oldDrugMainEntity, FromOutlineVO fromOutlineVO, RecipeResVO recipeResVO, OutPresDetailVO outPresDetailVO) {
        DrugMainEntity drugMainEntity = new DrugMainEntity();
        drugMainEntity.setxId(GenSeqUtils.getUniqueNo());
        drugMainEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugMainEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugMainEntity.setPresOrgan(oldDrugMainEntity.getAppCode());
        drugMainEntity.setTransactionId(UUIDUtils.getUUID());
        drugMainEntity.setOrganId(oldDrugMainEntity.getOrganId());
        drugMainEntity.setPresOrgan(oldDrugMainEntity.getPresOrgan());
        drugMainEntity.setPresDoctorId(fromOutlineVO.getPresDoctorId());
        drugMainEntity.setPresDoctorCode(fromOutlineVO.getPresDoctorCode());
        drugMainEntity.setStdFirstDeptName(oldDrugMainEntity.getStdFirstDeptName());
        drugMainEntity.setStdSecondDeptName(oldDrugMainEntity.getStdSecondDeptName());
        drugMainEntity.setPresDoctorName(fromOutlineVO.getPresDoctorName());
        drugMainEntity.setPresDeptCode(fromOutlineVO.getPresDeptCode());
        drugMainEntity.setPresDoctorPhone("");
        drugMainEntity.setPresDeptName(fromOutlineVO.getPresDeptName());
        drugMainEntity.setPresOrganName(oldDrugMainEntity.getPresOrganName());
        drugMainEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        drugMainEntity.setDrugSpeciesNum(Integer.valueOf(outPresDetailVO.getList().size()));
        if (HisExpressTypeEnum.NON_DELIVERABLE.getValue().equals(recipeResVO.getExpressFlag())) {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
        } else if (HisExpressTypeEnum.DELIVERABLE.getValue().equals(recipeResVO.getExpressFlag())) {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.UNDRUGS.getValue());
        } else {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.APPROVING.getValue());
        }
        drugMainEntity.setRefundStatus(BaseStatusEnum.VALID_STATUS.getValue());
        drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)DateTimeUtil.parseTime((String)recipeResVO.getRecipeDate(), (String)"yyyy-MM-dd HH:mm:ss"), (int)3));
        drugMainEntity.setPatientId(fromOutlineVO.getPatientId());
        drugMainEntity.setPatientUserId(fromOutlineVO.getPatientUserId());
        drugMainEntity.setPatientName(fromOutlineVO.getPatientName());
        drugMainEntity.setPatientNoType(oldDrugMainEntity.getPatientNoType());
        drugMainEntity.setPatientNo(fromOutlineVO.getPatientNo());
        drugMainEntity.setPatientGender(Integer.valueOf(Integer.parseInt(fromOutlineVO.getPatientGender())));
        drugMainEntity.setPatientPhone(oldDrugMainEntity.getPatientPhone());
        drugMainEntity.setPatientCredNo(oldDrugMainEntity.getPatientCredNo());
        drugMainEntity.setPresType(Integer.valueOf(recipeResVO.getRecipeType()));
        drugMainEntity.setServCode(StringUtils.isEmpty((String)fromOutlineVO.getServCode()) ? "" : fromOutlineVO.getServCode());
        drugMainEntity.setServCodeName(StringUtils.isEmpty((String)fromOutlineVO.getServCodeName()) ? "" : fromOutlineVO.getServCodeName());
        drugMainEntity.setPatientPhone(oldDrugMainEntity.getPatientPhone());
        drugMainEntity.setPatientCredNo(oldDrugMainEntity.getPatientCredNo());
        drugMainEntity.setPatientNoType(oldDrugMainEntity.getPatientNoType());
        drugMainEntity.setPatientAge(oldDrugMainEntity.getPatientAge());
        drugMainEntity.setExpressFlag(Integer.valueOf(recipeResVO.getExpressFlag()));
        drugMainEntity.setDrugFlag(Integer.valueOf(recipeResVO.getDrugFlag()));
        drugMainEntity.setPrescriptionSource(PrescriptionSourceEnum.HIS.getValue());
        drugMainEntity.setHospitalNameFirstLetter(HanyuPinyinUtil.getFirstLetters((String)drugMainEntity.getPresOrganName(), (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE));
        return this.mosDrugMainService.insert(drugMainEntity);
    }

    public void auditPrescription(String xml) {
        AuditPrescriptionResVo auditPrescriptionResVo = (AuditPrescriptionResVo)XmlUtil.convertToJavaBean((String)xml, AuditPrescriptionResVo.class);
        List auditPrescriptionVoList = auditPrescriptionResVo.getAuditPrescriptionVoList();
        log.info("\u5ba1\u6838\u5904\u65b9\u5165\u53c2:{}", (Object)auditPrescriptionVoList.toString());
        auditPrescriptionVoList.stream().forEach(auditPrescriptionVo -> {
            DrugMainEntity mainEntity = this.mosDrugMainMapper.getByHisRecipeNo(auditPrescriptionVo.getRecipeNo());
            mainEntity.setFeeType(Integer.valueOf(2));
            MosOutpatientMainRelEntity outpatientMainRelEntity = this.mosOutpatientMainRelService.getByMainId(mainEntity.getxId());
            Integer itemStatus = auditPrescriptionVo.getIsChecked().equals(1) ? DrugMainStatusEnum.ZRYH_UNPAID.getValue() : DrugMainStatusEnum.PHARMACIST_BACK.getValue();
            MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(mainEntity.getxId());
            if (itemStatus.equals(DrugMainStatusEnum.ZRYH_UNPAID.getValue())) {
                HisLogEntity hisLogEntity;
                FrontRequest frontRequest;
                LogisticsRecipeReqVO logisticsRecipeReqVO;
                String code;
                if (Double.valueOf(mosDrugLogisticsOrderEntity.getDestDeliveryDistance()) < 10000.0 && mainEntity.getPatientNoType().equals(CARD_TYPE_MEDICARE_CARD) && mainEntity.getFeeType().equals(FEE_TYPE_OWN_EXPENSE) && mainEntity.getOrderType().equals(OrderTypeEnum.COURIER_ORDER.getValue())) {
                    code = RandomUtils.generateRandom((int)6);
                    mainEntity.setFetchMedicalCode(code);
                    logisticsRecipeReqVO = this.hisManage.getLogisticsRecipeReqVO(mainEntity.getxId(), mosDrugLogisticsOrderEntity.getDestAddress(), code);
                    frontRequest = new FrontRequest();
                    frontRequest.setBody((Object)logisticsRecipeReqVO);
                    this.hisManage.sendHis("/zryh-his/api/v1/logistics/synLogisticsRecipe", frontRequest, Object.class);
                    hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/logistics/synLogisticsRecipe", mainEntity.getOrganId());
                }
                if (mainEntity.getOrderType().equals(OrderTypeEnum.DRUG_ORDER.getValue())) {
                    code = RandomUtils.generateRandom((int)6);
                    mainEntity.setFetchMedicalCode(code);
                    logisticsRecipeReqVO = this.hisManage.getLogisticsRecipeReqVO(mainEntity.getxId(), "\u4e2d\u65e5\u53cb\u597d\u533b\u9662\u95e8\u8bca\u4e8c\u697c\u9001\u836f\u5230\u5bb6\u7a97\u53e3\u81ea\u53d6", code);
                    frontRequest = new FrontRequest();
                    frontRequest.setBody((Object)logisticsRecipeReqVO);
                    this.hisManage.sendHis("/zryh-his/api/v1/logistics/synLogisticsRecipe", frontRequest, Object.class);
                    hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/logistics/synLogisticsRecipe", mainEntity.getOrganId());
                }
                mainEntity.setItemStatus(itemStatus);
                this.mosDrugMainService.update(mainEntity);
                this.mosDrugMainService.saveDrugExtend(mainEntity.getxId(), "", "", "", auditPrescriptionVo.getReason(), Integer.valueOf(auditPrescriptionVo.getIsChecked()));
            }
            mainEntity.setItemStatus(itemStatus);
            this.mosDrugMainService.update(mainEntity);
            this.mosDrugMainService.saveDrugExtend(mainEntity.getxId(), "", "", "", auditPrescriptionVo.getReason(), Integer.valueOf(auditPrescriptionVo.getIsChecked()));
            this.mosDrugMainService.addRemark(mainEntity.getxId(), auditPrescriptionVo.getReason(), "his", RemarkTypeEnum.VERIFIER.getValue());
            this.threadPoolTaskExecutor.execute(() -> {
                if (DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(itemStatus) && mainEntity.getFeeType().equals(FEE_TYPE_OWN_EXPENSE)) {
                    LinkedHashMap data = new LinkedHashMap();
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("value", mainEntity.getPresDoctorName());
                    data.put("doctorName", map1);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("value", "\u5904\u65b9\u5ba1\u6838\u901a\u8fc7");
                    data.put("issue", map2);
                    HashMap<String, String> map3 = new HashMap<String, String>();
                    map3.put("value", "\u60a8\u7684\u5904\u65b9\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8be6\u60c5");
                    data.put("info", map3);
                    this.pushManage.iWeChatPush(mainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(mainEntity.getPresOrgan(), mainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + mainEntity.getxId());
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
                    if (Double.valueOf(mosDrugLogisticsOrderEntity.getDestDeliveryDistance()) > 10000.0 || mainEntity.getFeeType().equals(2) || mainEntity.getPatientNoType().equals(CARD_TYPE_OWN_EXPENSE)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("doctorName", mainEntity.getPresDoctorName());
                        map.put("medical", "\u836f\u5e08");
                        String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                        this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzshtg", mainEntity.getPatientPhone(), map);
                    } else if (mainEntity.getPatientNoType().equals(CARD_TYPE_MEDICARE_CARD)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("doctor", mainEntity.getPresDoctorName());
                        map.put("code", mainEntity.getFetchMedicalCode());
                        String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                        this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzapps", mainEntity.getPatientPhone(), map);
                    } else if (OrderTypeEnum.DRUG_ORDER.equals((Object)mainEntity.getOrderType())) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("doctorName", mainEntity.getPresDoctorName());
                        map.put("medical", "\u836f\u5e08");
                        map.put("code", mainEntity.getFetchMedicalCode());
                        String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                        this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzqy", mainEntity.getPatientPhone(), map);
                    }
                    this.prescriptionPdfService.setPresPdf(mainEntity.getxId(), null);
                } else if (mainEntity.getFeeType().equals(2) && DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(itemStatus)) {
                    List list = this.doctorRetmoteManage.getPharmaceutist(mainEntity.getPresOrgan());
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        for (PharmaceutistResVO resVO : list) {
                            this.pushManage.iAppMsgPush(UserEnum.DOCTOR.getDesc(), mainEntity.getPresOrgan(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getBusiCode(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u5904\u65b9\u5f85\u5ba1\u6838\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b", "\u5904\u65b9\u5ba1\u6838\u63d0\u9192", PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getDesc(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getActionCode(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getValueCode().toString(), mainEntity.getxId(), this.doctorRetmoteManage.getDevice(this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(resVO.getDoctorCode()))).getUserId(), UserTypeEnum.DOCTOR.getValue(), AppCodeEnum.ZRYH.getValue()));
                        }
                    }
                } else {
                    String doctorPhone = this.doctorRetmoteManage.getDoctorPhone(Long.valueOf(Long.parseLong(mainEntity.getPresDoctorId())));
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("patientName", mainEntity.getPatientName());
                    map.put("orderId", auditPrescriptionVo.getRecipeNo());
                    if (StringUtil.isNotEmpty((String)doctorPhone)) {
                        this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_yscfshwtg", doctorPhone, map);
                    }
                    LinkedHashMap data = new LinkedHashMap();
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("value", mainEntity.getPresDoctorName());
                    data.put("doctorName", map1);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("value", "\u5904\u65b9\u5ba1\u6838\u672a\u901a\u8fc7");
                    data.put("issue", map2);
                    HashMap<String, String> map3 = new HashMap<String, String>();
                    map3.put("value", "\u60a8\u7684\u5904\u65b9\u672a\u5ba1\u6838\u901a\u8fc7\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8be6\u60c5");
                    data.put("info", map3);
                    this.pushManage.iWeChatPush(mainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(mainEntity.getPresOrgan(), mainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + mainEntity.getxId());
                    signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    HashMap patientMap = new HashMap();
                    map.put("doctorName", mainEntity.getPresDoctorName());
                    map.put("phoneNumber", "010-84205927");
                    this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzcfshwtg", mainEntity.getPatientPhone(), patientMap);
                    String patientMsg = "\u5904\u65b9\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u8bf7\u7b49\u5f85\u533b\u751f\u91cd\u65b0\u5f00\u5177\u5904\u65b9";
                    this.asynManage.imPushMsgByMainId(BusinessCodeEnum.OBTAIN.getValue(), mainEntity.getxId(), "", "EHOS_PATIENT", mainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)patientMsg, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                }
            });
        });
    }
}

