<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width,initial-scale=1.0"/>
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests"/>
    <link rel="icon" href="https://cdn2019.oss-cn-beijing.aliyuncs.com/webStatic/favicon.png"/>
    <title></title>
    <style>
        *{
            margin: 0;
            padding: 0;
        }
        #listPrint{
            /*padding: 85px 70px 0;*/
            padding: 5px;
        }
        .print-header{
            border: 2px solid #1A2F6C;
            border-radius: 25px;
            color: #1A2F6C;
            padding: 44px 0 25px 0;
            margin-bottom: 64px;
        }
        .print-header:after{
            display: block;
            clear: both;
            content:'';
            visibility: hidden;
            height: 0;
        }
        .header-l,.header-r{
            padding-left: 33px;
            float: left;
            max-width: 50%;
            box-sizing: border-box;
        }
        .hospital-box{
            text-align: center;
            margin-bottom: 26px;
            padding-top: 25px;
        }
        .header-l .hospital-logo{
            width: 125px;
            height: auto;
            display: inline-block;
        }
        .header-l .doctor-name{
            margin-bottom: 18px;
        }
        .patient-name,
        .header-l .doctor-name{
            /*padding-left: 10px;*/
            font-size: 17px;
        }
        .receive-box{
            /* display: flex; */
        }
        .receive-box:after{
            display: block;
            clear: both;
            content:'';
            visibility: hidden;
            height: 0;
        }
        .receive-box .receive-label{
            float: left;
        }
        .header-r .print-title{
            font-size: 48px;
        }
        .bias-line{
            padding-top: 30px;
            padding-bottom: 50px;
            width: 70%;
            margin: 0 auto;
        }
        .bias-line p{
            transform: rotate(-6deg);
            border-top: 2px solid #707070;
        }
        .header-r .print-main-id{
            margin-bottom: 3px;
            color: #231815;
            font-size: 14px;
            padding-right: 20px;
        }
        .header-r .total-price{
            font-size: 14px;
        }
        .bill-title, .bill-id{
            font-size: 14px;
        }
        .bill-id{
            margin-bottom: 17px;
        }
        .bill-title span,
        .bill-id span{
            color: #C51E1E;
        }
        .receive-label{
            font-size: 17px;
        }
        .receive-value{
            font-size: 12px;
            margin-bottom: 10px;
        }
        .print-body{
            border: 1px solid #1A2F6C;
            padding: 44px 60px 24px;
            color: #231815;
        }
        .diagnose{
            border-bottom: 1px solid #231815;
            margin-bottom: 34px;
        }
        .diagnose .diagnose-title{
            font-size: 22px;
            margin-bottom: 16px;
        }
        .diagnose .diagnose-value{
            font-size: 15px
        }
        .drug-list{
            margin-bottom: 50px;
            font-size: 15px;
        }
        .drug-list.chinese-medicine{
            /* display: flex;
            flex-wrap: wrap; */
        }
        .drug-list.chinese-medicine:after{
            display: block;
            clear: both;
            content:'';
            visibility: hidden;
            height: 0;
        }
        .drug-list .item{
            margin-bottom: 40px;
            display: inline-block;
            float: left;
        }
        .drug-list .item .item-name{
            margin-right: 30px;
        }
        .drug-list .item .item-num{
            margin-right: 50px;
            display: inline-block;
        }
        .drug-list.western-medicine .western-medicine-item{
            margin-bottom: 20px;
        }
        .drug-list.western-medicine .western-medicine-item:after{
            display: block;
            clear: both;
            content: '';
            visibility: hidden;
            height: 0;
        }
        .drug-list.western-medicine .western-medicine-item > div{
            margin-right: 2%;
            float:left;
            width: 23.5%;
        }
        .drug-list.western-medicine .western-medicine-item div .name{
            font-size: 12px;
        }
        .prescribe-box{
            margin-bottom: 30px;
            font-size: 20px;
        }
        .bottom-tip{
            font-size: 15px;
        }
        .bottom-tip span:last-child{
            float: right;
        }
    </style>
</head>
<body style = "font-family:SimSun; font-size:12px;">
<div id="listPrint">
    <div class="print-header">
        <div class="header-l">
            <div class="hospital-box">
                <img src="${orderDetail.hospitalLogo}" class="hospital-logo" />
            </div>
            <p class="doctor-name">开方医生：${orderDetail.presDoctorName}</p>
            <p class="doctor-name">患者姓名：${orderDetail.patientName}</p>
            <p class="patient-name">就诊卡号：${orderDetail.patientNo}</p>
        </div>
        <div class="header-r">
            <p class="print-title">打印清单</p>
            <p class="print-main-id">医嘱订单号：${orderDetail.presCode}</p>
            <p class="bill-title">发票抬头：<span>${orderDetail.invoiceTitle}</span></p>
            <p class="bill-id">发票税号：<span>${orderDetail.invoiceNum}</span></p>
            <p class="total-price">金额：¥ ${orderDetail.price}</p>
            <p class="total-price" style="margin-bottom: 16px;">微信流水号：${orderDetail.bankTradeNo}</p>
            <div class="receive-box">
                <div class="receive-label" style="margin-right: 60px;">
                    收件人<p class="receive-value">${orderDetail.receiver}</p>
                </div>
                <div class="receive-label">
                    收件电话<p class="receive-value">${orderDetail.telephone}</p>
                </div>
            </div>
            <p class="receive-label">收件地址</p>
            <p class="receive-value">${orderDetail.address}</p>
            <p class="patient-name" style="padding-left:0;">身份证号：${orderDetail.patientCredNo}</p>
        </div>
    </div>
    <div class="print-body">
        <div class="diagnose">
            <p class="diagnose-title">诊断描述：</p>
            <p class="diagnose-value">${orderDetail.diagnostic}</p>
        </div>
          <#if orderDetail.presType ==3>
            <div class="drug-list chinese-medicine">
                 <#list orderDetail.drugDetailData as item>
				   <div class="item">
                       <span class="item-name">${item.drugName}</span>
                       <span class="item-num">${item.amount}${item.amountUnit}</span>
                   </div>
                 </#list>
            </div>
          </#if>
          <#if orderDetail.presType !=3>
            <div class="drug-list western-medicine">
				<#list orderDetail.drugDetailData as item>
                    <div class="western-medicine-item">
                        <div>${item.drugName}</div>
                        <div>
                            <p class="label" style="width: 90px;">用法用量：</p>
                            <p class="name">${item.dosage}</p>
                        </div>
                        <div>
                            <p class="label">规格：</p>
                            <p class="name">${item.drugSpec}</p>
                        </div>
                        <div style="margin-right: 0;">
                            <p class="label" style="width: 90px;">取药数量：</p>
                            <p class="name">${item.amount}${item.amountUnit}</p>
                        </div>
                    </div>
                </#list>
            </div>
          </#if>

        <div class="prescribe-box">
            <p class="prescribe-title">处方备注：</p>
            <span class="prescribe-value">${orderDetail.presRemark}</span>
        </div>
        <div class="bottom-tip">
            <span>医嘱时间：${orderDetail.drugOrderTimeStr}</span>
            <span>支付时间：${orderDetail.payTimeStr}</span>
        </div>
    </div>
</div>
</body>
</html>