/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelDrugReqDto;
import com.ebaiyihui.medicalcloud.service.DualChannelPrescriptionService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53cc\u901a\u9053\u5f00\u836f"})
@RequestMapping(value={"/api/dualChannel"})
public class DualChannelPrescriptionController {
    private static final Logger log = LoggerFactory.getLogger(DualChannelPrescriptionController.class);
    @Autowired
    private DualChannelPrescriptionService dualChannelService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private MosDrugMainService mosDrugMainService;

    @ApiOperation(value="\u53cc\u901a\u9053\u5f00\u5177\u5904\u65b9", notes="\u53cc\u901a\u9053\u5f00\u5177\u5904\u65b9")
    @PostMapping(value={"/drugObtainPres"})
    public BaseResponse<Object> drugObtainPres(@RequestBody @Validated DualChannelDrugReqDto obtainPresReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugPrescriptionService.dualChannelDrugObtainPres(obtainPresReq);
    }

    @ApiOperation(value="\u53cc\u901a\u9053\u67e5\u8be2\u5904\u65b9\u4fe1\u606f", notes="\u53cc\u901a\u9053\u67e5\u8be2\u5904\u65b9\u4fe1\u606f")
    @GetMapping(value={"/queryPrescInfo"})
    public BaseResponse<Object> queryPrescInfo(@RequestParam(value="mainId", defaultValue="") String mainId) {
        DrugMainEntity mainEntity = this.mosDrugMainService.queryById(mainId);
        if (Objects.isNull(mainEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5904\u65b9\u4fe1\u606f\uff01");
        }
        if (!Objects.isNull(mainEntity.getDrugFlag()) && 1 == mainEntity.getDrugFlag()) {
            return BaseResponse.success((Object)"1");
        }
        return BaseResponse.success((Object)"0");
    }
}

