/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionBbMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionHospitalMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.InspectOrderShoppingDto;
import com.ebaiyihui.medicalcloud.pojo.dto.InspectRecordDto;
import com.ebaiyihui.medicalcloud.pojo.dto.InspectionOrderCartDto;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionBbEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionExtendEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionHospitalEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionItemEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.FindInspectionListVo;
import com.ebaiyihui.medicalcloud.pojo.vo.GetBbReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetClassifyListResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetImplementDeptReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetImplementDeptResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetOtherFeeReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetOtherFeeResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.InspectionListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.InspectionListResDTO;
import com.ebaiyihui.medicalcloud.service.InspectionService;
import com.ebaiyihui.medicalcloud.utils.AppCodeUtil;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/inspection"})
@RestController
@Api(tags={"\u68c0\u9a8c\u68c0\u67e5API"})
public class InspectionController {
    private static final Logger log = LoggerFactory.getLogger(InspectionController.class);
    @Resource
    private InspectionService inspectionService;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private MosInspectionHospitalMapper mosInspectionHospitalMapper;
    @Resource
    private MosInspectionBbMapper mosInspectionBbMapper;

    @RequestMapping(value={"/getClassifyList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5206\u7c7b\u4fe1\u606f", notes="\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5206\u7c7b\u4fe1\u606f")
    public BaseResponse<List<GetClassifyListResDTO>> getClassifyList(@RequestBody InspectionListReqVO param) {
        return this.inspectionService.getClassifyList(param);
    }

    @RequestMapping(value={"/queryItemByClassifyId"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee", notes="\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee")
    public BaseResponse<List<MosInspectionItemEntity>> queryItemByClassifyId(@RequestParam(value="classifyId") String classifyId) {
        return this.inspectionService.queryItemByClassifyId(classifyId);
    }

    @RequestMapping(value={"/queryItemList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee", notes="queryItemList")
    public BaseResponse<PageResult<InspectionListResDTO>> queryItemList(@RequestBody PageResult<InspectionListReqVO> param) throws IOException {
        return this.inspectionService.queryItemListPage(param);
    }

    @RequestMapping(value={"/getOtherFee"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u68c0\u9a8c\u9879\u76ee\u8bd5\u7ba1\u8d39\u7528", notes="\u67e5\u8be2\u68c0\u9a8c\u9879\u76ee\u8bd5\u7ba1\u8d39\u7528")
    public BaseResponse<GetOtherFeeResVO> getOtherFee(@RequestBody GetOtherFeeReqVO param) {
        return this.inspectionService.getOtherFee(param.getMainId());
    }

    @RequestMapping(value={"/getExtendsInfo"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u68c0\u67e5\u5355\u6269\u5c55\u4fe1\u606f", notes="\u67e5\u8be2\u68c0\u67e5\u5355\u6269\u5c55\u4fe1\u606f")
    public BaseResponse<List<MosInspectionExtendEntity>> getExtendsInfo(@RequestParam(value="appCode") String appCode) {
        return this.inspectionService.getExtendsInfo(appCode);
    }

    @RequestMapping(value={"/getBb"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u68c0\u9a8c\u5355\u6807\u672c", notes="\u67e5\u8be2\u68c0\u9a8c\u5355\u6807\u672c")
    public BaseResponse<List<MosInspectionBbEntity>> getBb(@RequestBody GetBbReqVO reqVO) {
        return this.inspectionService.getBb(reqVO);
    }

    @RequestMapping(value={"/getImplementDept"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u6267\u884c\u79d1\u5ba4", notes="\u67e5\u8be2\u6267\u884c\u79d1\u5ba4")
    public BaseResponse<List<GetImplementDeptResVO>> getImplementDept(@RequestBody @Validated GetImplementDeptReqVO reqVO) {
        return this.inspectionService.getImplementDept(reqVO);
    }

    @RequestMapping(value={"/getHospital"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u9662\u533a\u4ee3\u7801", notes="\u83b7\u53d6\u9662\u533a\u4ee3\u7801-\u8d63\u5357-\u5f00\u5177\u68c0\u67e5\u5355")
    public BaseResponse<List<MosInspectionHospitalEntity>> getHospital() {
        return BaseResponse.success((Object)this.mosInspectionHospitalMapper.selectList("GNYFY"));
    }

    @RequestMapping(value={"/saveInspectRecord"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fdd\u5b58\u68c0\u9a8c\u68c0\u67e5\u8bb0\u5f55", notes="\u4fdd\u5b58\u68c0\u9a8c\u68c0\u67e5\u8bb0\u5f55")
    public BaseResponse<String> saveInspectRecord(@RequestBody InspectionOrderCartDto inspectionOrderCartDto) {
        log.info("==========>\u4fdd\u5b58\u68c0\u9a8c\u68c0\u67e5\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)inspectionOrderCartDto));
        if (inspectionOrderCartDto.getOrderNumber() == null || inspectionOrderCartDto.getOrderNumber().equals("")) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (inspectionOrderCartDto.getAppCode() == null || inspectionOrderCartDto.getAppCode().equals("")) {
            inspectionOrderCartDto.setAppCode(inspectionOrderCartDto.getOrganCode());
        }
        log.info("==========\u5f00\u5355\u7c7b\u578b\u7c7b\u578b{}", (Object)inspectionOrderCartDto.getInspectRecordDto().getType());
        inspectionOrderCartDto.setOrganCode(inspectionOrderCartDto.getAppCode());
        String key = inspectionOrderCartDto.getOrderNumber() + "_" + inspectionOrderCartDto.getAppCode() + "_" + inspectionOrderCartDto.getInspectRecordDto().getType();
        Object o = this.redisUtil.get(key);
        if (o == null) {
            ArrayList<InspectRecordDto> inspectRecordDtos = new ArrayList<InspectRecordDto>();
            inspectRecordDtos.add(inspectionOrderCartDto.getInspectRecordDto());
            boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString(inspectRecordDtos));
            if (b) {
                return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        List inspectRecordDtoList = JSONObject.parseArray((String)o.toString(), InspectRecordDto.class);
        inspectRecordDtoList.add(inspectionOrderCartDto.getInspectRecordDto());
        boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)inspectRecordDtoList));
        if (b) {
            return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @PostMapping(value={"/v1/deleteInspectRecordDetail"})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1\u8d2d\u7269\u8f66\u4fe1\u606f", notes="\u5220\u9664\u836f\u54c1\u8d2d\u7269\u8f66\u4fe1\u606f")
    public BaseResponse<String> deleteDrugRecordDetail(@RequestBody FindInspectionListVo vo) {
        if (vo.getOrderNumber() == null || vo.getOrderNumber().isEmpty()) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (vo.getAppCode() == null || vo.getAppCode().isEmpty()) {
            vo.setAppCode(vo.getOrganCode());
        }
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        String key = vo.getOrderNumber() + "_" + vo.getAppCode() + "_" + vo.getType();
        Object o = this.redisUtil.get(key);
        if (o == null) {
            return BaseResponse.success();
        }
        List inspectRecordDtos = JSONObject.parseArray((String)o.toString(), InspectRecordDto.class);
        inspectRecordDtos.removeIf(inspectRecordDto -> inspectRecordDto.getItemId().equals(vo.getItemId()));
        boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)inspectRecordDtos));
        if (b) {
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @PostMapping(value={"/v1/findInspectRecord"})
    @ApiOperation(value="\u67e5\u770b\u68c0\u9a8c\u68c0\u67e5\u8d2d\u7269\u8f66", notes="\u67e5\u770b\u68c0\u9a8c\u68c0\u67e5\u8d2d\u7269\u8f66")
    public BaseResponse<InspectOrderShoppingDto> findDrugRecord(@RequestBody FindInspectionListVo vo) {
        if (vo.getOrderNumber() == null || vo.getOrderNumber().isEmpty()) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (vo.getAppCode() == null || vo.getAppCode().isEmpty()) {
            vo.setAppCode(vo.getOrganCode());
        }
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        String key = vo.getOrderNumber() + "_" + vo.getAppCode() + "_" + vo.getType();
        BigDecimal totalPrice = BigDecimal.valueOf(0.0);
        InspectOrderShoppingDto inspectOrderShoppingDto = new InspectOrderShoppingDto();
        Object o = this.redisUtil.get(key);
        if (o == null) {
            InspectOrderShoppingDto dto = new InspectOrderShoppingDto();
            return BaseResponse.success((Object)dto);
        }
        List inspectRecordDtos = JSONObject.parseArray((String)this.redisUtil.get(key).toString(), InspectRecordDto.class);
        if (inspectRecordDtos == null) {
            InspectOrderShoppingDto dto = new InspectOrderShoppingDto();
            return BaseResponse.success((Object)dto);
        }
        for (InspectRecordDto inspectRecordDto : inspectRecordDtos) {
            MosInspectionBbEntity gnyfy;
            BigDecimal money = Optional.ofNullable(inspectRecordDto.getMoney()).map(BigDecimal::new).orElse(BigDecimal.ZERO);
            totalPrice = totalPrice.add(money).setScale(2);
            if (inspectRecordDto.getBbdm() == null || (gnyfy = this.mosInspectionBbMapper.selectByDm(String.valueOf(inspectRecordDto.getBbdm()), "GNYFY")) == null) continue;
            inspectRecordDto.setBbdmName(gnyfy.getBbName());
        }
        inspectOrderShoppingDto.setInspectRecordDtoList(inspectRecordDtos);
        inspectOrderShoppingDto.setTotalPrice(totalPrice);
        return BaseResponse.success((Object)inspectOrderShoppingDto);
    }

    @GetMapping(value={"/v1/syncRequisition"})
    @ApiOperation(value="\u540c\u6b65\u68c0\u67e5\u68c0\u9a8c\u6cbb\u7597\u9879\u76ee", notes="\u540c\u6b65\u68c0\u67e5\u68c0\u9a8c\u6cbb\u7597\u9879\u76ee")
    public void syncRequisition() {
        List<String> types = Arrays.asList("399298578", "399298577", "399298622");
        for (String type : types) {
            this.inspectionService.syncRequisition(type);
        }
    }

    @GetMapping(value={"/v1/syncRequisitionInfo"})
    @ApiOperation(value="\u540c\u6b65\u68c0\u67e5\u68c0\u9a8c\u6cbb\u7597\u9879\u76ee\u8be6\u7ec6\u4fe1\u606f", notes="\u540c\u6b65\u68c0\u67e5\u68c0\u9a8c\u6cbb\u7597\u9879\u76ee\u8be6\u7ec6\u4fe1\u606f")
    public void syncRequisitionInfo() {
        List<Integer> types = Arrays.asList(2, 3, 4);
        for (Integer type : types) {
            this.inspectionService.syncRequisitionInfo(type);
        }
    }
}

