/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayStatusEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.manage.OrderPayManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionDetailMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.HisApplyRefundDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.FlatAccountReq;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.PayOrderDtoReq;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.ReconciliationReq;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.ReconciliationVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsRefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.OrderPayService;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u652f\u4ed8 API"})
@RequestMapping(value={"/api/order/pay"})
@RestController
public class OrderPayController {
    private static final Logger log = LoggerFactory.getLogger(OrderPayController.class);
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private MosDrugOrderService drugOrderService;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper drugOrderMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private RedisUtil redisUtil;
    private static final String RETURNCODE = "SUCCESS";
    @Autowired
    @Lazy
    private MosInspectionDetailMapper mosInspectionDetailMapper;
    @Autowired
    private DrugDetailService drugDetailService;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;

    @ApiOperation(value="\u521b\u5efa\u652f\u4ed8\u4ea4\u6613", notes="\u521b\u5efa\u4ea4\u6613")
    @PostMapping(value={"/v1/createTrade"})
    public BaseResponse<?> createTrade(@RequestBody @Validated PayOrderDtoReq payOrderDtoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayManage.createTrade(payOrderDtoReq);
    }

    @ApiOperation(value="\u836f\u54c1\u652f\u4ed8", notes="\u521b\u5efa\u836f\u54c1\u652f\u4ed8\u4ea4\u6613")
    @PostMapping(value={"/v1/createTrade/drug"})
    public BaseResponse<?> createTradeDrug(@RequestBody @Validated DrugPayReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        if (CollectionUtils.isEmpty((Collection)vo.getMainIds())) {
            return this.orderPayService.createTradeDrug(vo);
        }
        log.info("=======\u836f\u54c1\u591a\u5904\u65b9\u652f\u4ed8");
        return this.orderPayService.createTradeDrugItem(vo);
    }

    @ApiOperation(value="\u836f\u54c1\u652f\u4ed8\u6210\u529f\u524d\u7aef\u56de\u8c03", notes="\u836f\u54c1\u652f\u4ed8\u6210\u529f\u524d\u7aef\u56de\u8c03")
    @PostMapping(value={"/v1/createTradeCallBack/drug"})
    public BaseResponse createTradeCallBack(DrugPayReqVO vo) {
        List mainIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)vo.getMainIds())) {
            mainIds.add(vo.getMainId());
        } else {
            mainIds = vo.getMainIds();
        }
        if (CollectionUtils.isEmpty(mainIds)) {
            for (String mainId : mainIds) {
                DrugOrderEntity drugOrderEntity;
                if (!Objects.nonNull(mainId) || !Objects.nonNull(drugOrderEntity = this.drugOrderService.queryByMainId(mainId)) || !OrderStatusEnum.TOPAY.getValue().equals(drugOrderEntity.getStatus())) continue;
                drugOrderEntity.setStatus(OrderStatusEnum.PAYING.getValue());
                this.drugOrderService.update(drugOrderEntity);
            }
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u7269\u6d41\u652f\u4ed8", notes="\u521b\u5efa\u7269\u6d41\u652f\u4ed8\u4ea4\u6613")
    @PostMapping(value={"/v1/createTrade/logistics"})
    public BaseResponse<?> createTradeLogistics(@RequestBody @Validated LogisticsPayReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById((String)vo.getMainIds().get(0));
        log.info("===========\u533b\u5631\u4fe1\u606f" + JSONObject.toJSONString((Object)drugMainEntity));
        return this.orderPayService.createTradeLogistics(vo);
    }

    @ApiOperation(value="\u7269\u6d41\u652f\u4ed8\u56de\u8c03", notes="\u7269\u6d41\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/v1/logistics/payCall"})
    public BaseResponse<?> logisticsPayCall(@RequestBody PayNotifyReqVO payNotifyReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayService.logisticsPayCall(payNotifyReqVO);
    }

    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03", notes="\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/v1/notifyurl"})
    public BaseResponse<String> notifyurl(@RequestBody PayNotifyReqVO payNotifyReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        Object object = this.redisUtil.get(payNotifyReqVO.getDealTradeNo() + "_pay");
        log.info("======>>\u652f\u4ed8\u56de\u8c03,redis\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u8ba2\u5355:{}", object);
        if (object != null) {
            return BaseResponse.success((Object)RETURNCODE);
        }
        this.redisUtil.set(payNotifyReqVO.getDealTradeNo() + "_pay", (Object)JSONObject.toJSONString((Object)payNotifyReqVO), 86400L);
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByOrderSeq(payNotifyReqVO.getOutTradeNo());
        if (drugOrderEntity == null) {
            log.error("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugOrderEntity.getMainId());
        if (drugMainEntity == null) {
            log.error("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u533b\u5631\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        if (PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getReturnCode()) && PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getResultCode())) {
            log.info("====\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u652f\u4ed8\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)payNotifyReqVO));
            return this.orderPayManage.orderNotify(payNotifyReqVO, drugOrderEntity, drugMainEntity);
        }
        return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
    }

    @ApiOperation(value="\u53d1\u8d77\u9000\u6b3e", notes="\u53d1\u8d77\u9000\u6b3e")
    @PostMapping(value={"/v1/applyRefund"})
    public BaseResponse<String> applyRefund(@RequestBody BaseOperationDto baseOperationDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        return this.orderPayManage.applyRefund(baseOperationDto);
    }

    @ApiOperation(value="HIS\u53d1\u8d77\u9000\u6b3e", notes="HIS\u53d1\u8d77\u9000\u6b3e")
    @PostMapping(value={"/v1/hisApplyRefund"})
    public BaseResponse<String> hisApplyRefund(@RequestBody HisApplyRefundDto hisApplyRefundDto, BindingResult bindingResult) {
        BaseOperationDto baseOperationDto;
        BigDecimal totalAmount;
        ArrayList detailEntityArrayList;
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByBankTradeNo(hisApplyRefundDto.getSysAppointmentId());
        if (drugOrderEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        BigDecimal refundMoneyBD = new BigDecimal(hisApplyRefundDto.getRefundMoney()).setScale(2, RoundingMode.HALF_UP);
        ArrayList<String> presDetailNoList = new ArrayList<String>(Arrays.asList(hisApplyRefundDto.getPresDetailNo().split(",")));
        DrugMainEntity mainEntity = this.drugMainService.queryById(drugOrderEntity.getMainId());
        if (mainEntity.getPresType() == 5 || mainEntity.getPresType() == 6 || mainEntity.getPresType() == 7) {
            detailEntityArrayList = new ArrayList();
            presDetailNoList.forEach(presDetailNo -> {
                MosInspectionDetailEntity detailEntity = this.mosInspectionDetailMapper.selectByHisDetailNo(presDetailNo);
                detailEntityArrayList.add(detailEntity);
            });
            totalAmount = detailEntityArrayList.stream().map(MosInspectionDetailEntity::getPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("\u8ba1\u7b97\u540e\u603b\u4ef7\uff1a{}", (Object)totalAmount);
            if (refundMoneyBD.compareTo(totalAmount) != 0) {
                return BaseResponse.error((String)("\u9000\u6b3e\u91d1\u989d\u4e0e\u68c0\u9a8c\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u660e\u7ec6\u603b\u989d\u4e3a\uff1a" + totalAmount));
            }
        } else {
            detailEntityArrayList = new ArrayList();
            presDetailNoList.forEach(presDetailNo -> {
                DrugDetailEntity drugDetailEntity = this.drugDetailService.selectByHisDetailNo(presDetailNo);
                detailEntityArrayList.add(drugDetailEntity);
            });
            totalAmount = detailEntityArrayList.stream().map(DrugDetailEntity::getTotalPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            Integer ageNum = 1;
            if (mainEntity.getPresType() == 3) {
                DrugPrescriptionEntity prescriptionEntity = this.mosDrugPrescriptionMapper.queryByMainId(mainEntity.getxId());
                ageNum = prescriptionEntity.getAgeNum();
            }
            log.info("\u4e2d\u836f\u5904\u65b9\u5242\u6570:{}\uff0c\u603b\u4ef7\uff1a{}", (Object)ageNum, (Object)totalAmount);
            totalAmount = totalAmount.multiply(new BigDecimal(ageNum)).setScale(2, RoundingMode.HALF_UP);
            if (refundMoneyBD.compareTo(totalAmount) != 0) {
                return BaseResponse.error((String)("\u9000\u6b3e\u91d1\u989d\u4e0e\u68c0\u9a8c\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u660e\u7ec6\u603b\u989d\u4e3a\uff1a" + totalAmount));
            }
        }
        if (drugOrderEntity.getPayAmount().compareTo(refundMoneyBD) == 0) {
            baseOperationDto = new BaseOperationDto();
            baseOperationDto.setContent("HIS\u53d1\u8d77\u9000\u6b3e");
            baseOperationDto.setMainId(drugOrderEntity.getMainId());
            baseOperationDto.setOprationUser("HIS");
            BaseResponse response = this.orderPayManage.applyRefund(baseOperationDto);
            if (response.isSuccess()) {
                this.redisUtil.set("refund_all_:" + hisApplyRefundDto.getSysAppointmentId(), (Object)hisApplyRefundDto.getPresDetailNo(), 86400L);
            }
            return response;
        }
        baseOperationDto = new BaseOperationDto();
        baseOperationDto.setContent("HIS\u53d1\u8d77\u9000\u6b3e");
        baseOperationDto.setMainId(drugOrderEntity.getMainId());
        baseOperationDto.setOprationUser("HIS");
        baseOperationDto.setAmount(new BigDecimal(hisApplyRefundDto.getRefundMoney()));
        BaseResponse applyRefundPart = this.orderPayManage.applyRefundPart(baseOperationDto);
        if (applyRefundPart.isSuccess()) {
            this.redisUtil.set("refund_part_:" + hisApplyRefundDto.getSysAppointmentId(), (Object)hisApplyRefundDto.getPresDetailNo(), 86400L);
        }
        return applyRefundPart;
    }

    @ApiOperation(value="\u7533\u8bf7\u9000\u6b3e", notes="\u836f\u54c1\u8d39\u7269\u6d41\u8d39\u7533\u8bf7\u9000\u6b3e")
    @PostMapping(value={"/v2/applyRefund"})
    public BaseResponse<String> applyRefundSecond(@RequestBody BaseOperationDto dto, BindingResult bindingResult) {
        DrugOrderEntity drugOrderEntity;
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(dto.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!this.specialNodeConfig.getHyt().equals(drugMainEntity.getPresOrgan()) && (drugOrderEntity = this.drugOrderMapper.queryByMainIdAndOrderStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue())) == null) {
            return BaseResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38");
        }
        return this.orderPayService.applyRefundSecond(dto);
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03", notes="\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/v1/refund"})
    public BaseResponse<String> refund(@RequestBody RefundCallBackReqVo refundNotifyReqVO, BindingResult bindingResult) {
        Object object = this.redisUtil.get(refundNotifyReqVO.getDealTradeNo() + "_refund");
        log.info("======>>\u9000\u6b3e\u56de\u8c03,redis\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u8ba2\u5355:{}", object);
        if (object != null) {
            return BaseResponse.success((Object)RETURNCODE);
        }
        this.redisUtil.set(refundNotifyReqVO.getDealTradeNo() + "_refund", (Object)JSONObject.toJSONString((Object)refundNotifyReqVO), 86400L);
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByOrderSeq(refundNotifyReqVO.getOutTradeNo());
        if (drugOrderEntity == null) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        return this.orderPayManage.refundNotify(refundNotifyReqVO);
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03-\u90e8\u5206", notes="\u9000\u6b3e\u56de\u8c03-\u90e8\u5206")
    @PostMapping(value={"/v1/refundPart"})
    public BaseResponse<String> refundPart(@RequestBody RefundCallBackReqVo refundNotifyReqVO, BindingResult bindingResult) {
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByOrderSeq(refundNotifyReqVO.getOutTradeNo());
        if (drugOrderEntity == null) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        return this.orderPayManage.refundNotifyPart(refundNotifyReqVO);
    }

    @ApiOperation(value="\u7269\u6d41\u9000\u6b3e\u56de\u8c03", notes="\u7269\u6d41\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/v1/refund/logistics"})
    public BaseResponse<?> refundLogistics(@RequestBody RefundCallBackReqVo vo, BindingResult bindingResult) {
        return this.orderPayService.refundLogistics(vo);
    }

    @ApiOperation(value="\u5bf9\u8d26\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u7684\u6570\u636e", notes="\u5bf9\u8d26\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u7684\u6570\u636e")
    @PostMapping(value={"/v1/queryOrderData"})
    public BaseResponse<List<ReconciliationVO>> queryOrderData(@RequestBody @Validated ReconciliationReq reconciliationReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayManage.queryReconciliationData(reconciliationReq.getDate(), reconciliationReq.getOrganCode());
    }

    @ApiOperation(value="\u5bf9\u8d26\u5e73\u53f0\u5e73\u8d26", notes="\u5bf9\u8d26\u5e73\u53f0\u5e73\u8d26")
    @PostMapping(value={"/v1/flatAccount"})
    public BaseResponse<String> flatAccount(@RequestBody FlatAccountReq flatAccountReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayManage.flatAccount(flatAccountReq);
    }

    @ApiOperation(value="\u7533\u8bf7\u7269\u6d41\u9000\u6b3e", notes="\u7533\u8bf7\u7269\u6d41\u9000\u6b3e")
    @PostMapping(value={"/v1/apply/refund/logistics"})
    public BaseResponse<?> applyRefundLogistics(@RequestBody LogisticsRefundReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayService.applyRefundLogistics(vo);
    }
}

