/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PresExportReqVo;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prescription"})
public class PrescriptionPdfController {
    @Autowired
    PrescriptionPdfService prescriptionPdfService;
    @Autowired
    MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;

    @PostMapping(value={"/v1/reloadTemplate"})
    public String reloadTemplate(String mainId, String presId) {
        this.prescriptionPdfService.setPresPdf(mainId, presId);
        DrugPrescriptionEntity entity = this.mosDrugPrescriptionService.queryByMainId(mainId);
        if (entity == null) {
            return "ERROR";
        }
        return entity.getHtmlUrl();
    }

    @ApiOperation(value="\u8865\u5168\u533b\u751f\u7b7e\u540d\u5e76\u91cd\u65b0\u751f\u6210\u5904\u65b9\u7b3a", notes="\u8865\u5168\u533b\u751f\u7b7e\u540d\u5e76\u91cd\u65b0\u751f\u6210\u5904\u65b9\u7b3a")
    @GetMapping(value={"/v1/completionSignReloadTemplate"})
    public BaseResponse<String> completionSignReloadTemplate(@RequestParam String presId) {
        try {
            DrugPrescriptionEntity prescription = this.mosDrugPrescriptionService.queryById(presId);
            if (prescription == null) {
                return BaseResponse.error((String)"\u5904\u65b9\u4e0d\u5b58\u5728");
            }
            DrugMainEntity mainEntity = this.mosDrugMainMapper.getById(prescription.getMainId());
            if (mainEntity == null) {
                return BaseResponse.error((String)"\u533b\u5631\u4e0d\u5b58\u5728");
            }
            Optional<DrugMainEntity> doctorWithSign = this.mosDrugMainMapper.getByDoctorNameAndId(mainEntity.getPresDoctorName(), mainEntity.getPresDoctorId()).stream().filter(entity -> entity.getDoctorSign() != null).findFirst();
            if (!doctorWithSign.isPresent()) {
                return BaseResponse.error((String)"\u67e5\u8be2\u533b\u751f\u7b7e\u540d\u4e3a\u7a7a");
            }
            mainEntity.setDoctorSign(doctorWithSign.get().getDoctorSign());
            int updateCount = this.mosDrugMainMapper.update(mainEntity);
            if (updateCount == 0) {
                return BaseResponse.error((String)"\u8865\u7b7e\u533b\u751f\u7b7e\u540d\u5931\u8d25");
            }
            this.prescriptionPdfService.setPresPdf(mainEntity.getxId(), presId);
            return BaseResponse.success((Object)this.mosDrugPrescriptionService.queryByMainId(mainEntity.getxId()).getHtmlUrl());
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    @GetMapping(value={"/v1/exportBatchPrescriptionPdf"})
    @ApiOperation(value="\u6e05\u5355\u6253\u5370")
    public void exportBatchPrescriptionPdf(String mainIds, HttpServletResponse response) {
        this.prescriptionPdfService.exportBatchPrescriptionPdf(mainIds, response);
    }

    @PostMapping(value={"/v2/exportBatchPrescriptionPdf"})
    @ApiOperation(value="\u6e05\u5355\u6253\u5370")
    public void exportBatchPrescriptionPdfV2(@RequestBody PresExportReqVo presExportReqVo, HttpServletResponse response) {
        this.prescriptionPdfService.exportBatchPrescriptionPdf(presExportReqVo.getMainIds(), response);
    }
}

