/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.medicalcloud.common.constants.URLConstant;
import com.ebaiyihui.medicalcloud.common.enums.DrugAttributeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugRemarkEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugSaleChannelEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeNewEnum;
import com.ebaiyihui.medicalcloud.common.enums.InsuranceTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.SpecialNewTypeEnum;
import com.ebaiyihui.medicalcloud.manage.DrugMainManage;
import com.ebaiyihui.medicalcloud.mapper.DrugAliasMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugItemBarCodeMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugItemUsageRelMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPriceMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUnitMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUsageMapper;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.BMDrugItemResDto;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.CheckPatientDrugsReqDto;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.DrugItemListV2DTO;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.QueryDrugByBarCodeVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.BMAddDrugItemVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.BMPageDrugListVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.DrugIteamListReqVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.HospitalDrugVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.SyncHospitalDrugVO;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemQueryResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DrugProductCodeDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.BaseEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugAliasEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemUsageRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPriceEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUsageEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugItemBarCodeEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.PageDrugListVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PageResultRes;
import com.ebaiyihui.medicalcloud.service.BMDrugItemService;
import com.ebaiyihui.medicalcloud.service.MosDrugItemBarCodeService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.ExcelUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.excel.ExportDrugItemExcel;
import com.ebaiyihui.medicalcloud.utils.excel.ImportDrugItemErrorExcel;
import com.ebaiyihui.medicalcloud.utils.excel.ImportDrugItemExcel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BMDrugItemServiceImpl
implements BMDrugItemService {
    private static final Logger log = LoggerFactory.getLogger(BMDrugItemServiceImpl.class);
    public static final int ONE = 1;
    public static final int ZERO = 0;
    @Resource
    private DrugItemMapper drugItemMapper;
    @Resource
    private MosDrugPriceMapper mosDrugPriceMapper;
    @Resource
    private DrugAliasMapper drugAliasMapper;
    @Resource
    private MosDrugItemUsageRelMapper mosDrugItemUsageRelMapper;
    @Resource
    private MosDrugUsageMapper mosDrugUsageMapper;
    @Resource
    private MosDrugItemBarCodeMapper barCodeMapper;
    @Resource
    private MosDrugItemBarCodeService mosDrugItemBarCodeService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolExecutor;
    @Resource
    private MosDrugUnitMapper mosDrugUnitMapper;
    @Resource
    private MosDrugMainMapper mosDrugMainMapper;
    @Resource
    private DrugDetailMapper drugDetailMapper;
    @Resource
    private DrugMainManage drugMainManage;

    public BaseResponse<PageResult<BMDrugItemResDto>> bmFindDrugItemList(BMPageDrugListVO vo) {
        PageHelper.startPage((int)vo.getPageIndex(), (int)vo.getPageSize());
        List list = this.drugItemMapper.getPageList(vo);
        PageInfo pageInfo = new PageInfo(list);
        List pageList = pageInfo.getList();
        pageList.forEach(bean -> {
            DrugUsageEntity drugUsageEntity;
            DrugItemUsageRelEntity byDrugId;
            List drugBarCodeList;
            List drugAliasEntities;
            if (bean.getDrugAttribute() != null) {
                bean.setDrugAttributeName(DrugAttributeEnum.getValue((Integer)bean.getDrugAttribute()));
            }
            if (bean.getDrugSaleChannel() != null) {
                bean.setDrugSaleChannelName(DrugSaleChannelEnum.getValue((Integer)bean.getDrugSaleChannel()));
            }
            if (bean.getType() != null) {
                bean.setTypeName(DrugTypeNewEnum.getValue((Integer)bean.getType()));
            }
            if (bean.getDrugRemark() != null) {
                bean.setDrugRemarkName(DrugRemarkEnum.getValue((Integer)bean.getDrugRemark()));
            }
            if (bean.getInsuranceType() != null) {
                bean.setInsuranceTypeName(InsuranceTypeEnum.getValue((Integer)bean.getInsuranceType()));
            }
            if (bean.getSpecialNewType() != null) {
                bean.setSpecialNewTypeName(SpecialNewTypeEnum.getValue((Integer)bean.getSpecialNewType()));
            }
            if ((drugAliasEntities = this.drugAliasMapper.getByDrugId(bean.getDrugItemId())) != null && !drugAliasEntities.isEmpty()) {
                String drugAliases = drugAliasEntities.stream().map(DrugAliasEntity::getDrugAlias).distinct().collect(Collectors.joining(","));
                bean.setDrugAlias(drugAliases);
            }
            if ((drugBarCodeList = this.barCodeMapper.getByDrugId(bean.getDrugItemId())) != null && !drugBarCodeList.isEmpty()) {
                String barCode = drugBarCodeList.stream().map(MosDrugItemBarCodeEntity::getBarCode).distinct().collect(Collectors.joining(","));
                bean.setDrugBarCode(barCode);
            }
            if ((byDrugId = this.mosDrugItemUsageRelMapper.getByDrugId(bean.getDrugItemId())) != null && StringUtils.isNotEmpty((String)byDrugId.getUsageId()) && (drugUsageEntity = this.mosDrugUsageMapper.queryById(byDrugId.getUsageId())) != null) {
                bean.setUsageId(drugUsageEntity.getxId());
                bean.setUsageDesc(drugUsageEntity.getUsageDesc());
            }
        });
        PageResultRes pageResultRes = new PageResultRes();
        pageResultRes.setPageNum(vo.getPageIndex().intValue());
        pageResultRes.setPageSize(vo.getPageSize().intValue());
        pageResultRes.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResultRes.setContent(pageList);
        return BaseResponse.success((Object)pageResultRes);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> bmAddDrugItem(BMAddDrugItemVO vo) {
        List byBarCode;
        DrugItemEntity drugItemEntityByCommonCode = this.drugItemMapper.getByCommonCodeNew(vo.getAppCode(), vo.getHospitalId(), vo.getCommonCode());
        if (drugItemEntityByCommonCode != null) {
            return BaseResponse.error((String)"\u836f\u54c1\u81ea\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        if (CollUtil.isNotEmpty((Collection)vo.getDrugBarCodeList()) && CollUtil.isNotEmpty((Collection)(byBarCode = this.mosDrugItemBarCodeService.getByBarCodes(vo.getHospitalId(), vo.getDrugBarCodeList())))) {
            return BaseResponse.error((String)"\u836f\u54c1\u6761\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        DrugItemEntity byName = this.drugItemMapper.getByName(vo.getAppCode(), vo.getHospitalId(), vo.getCommonName() + vo.getManufacturer(), vo.getDrugSpec());
        if (byName != null) {
            return BaseResponse.error((String)"\u836f\u54c1\u540d\u79f0+\u89c4\u683c+\u751f\u4ea7\u4f01\u4e1a\u4e0d\u80fd\u91cd\u590d");
        }
        String drugId = this.saveDrug(vo);
        this.saveUsageRel(drugId, vo);
        this.saveDrugAlias(vo.getDrugAlias(), vo.getCommonCode(), vo.getAppCode(), drugId);
        this.saveDrugPrice(drugId, vo);
        this.saveDrugBarCode(vo.getHospitalId(), drugId, vo.getDrugBarCodeList());
        return BaseResponse.success((Object)"\u65b0\u589e\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> bmDeleteDrugItemById(String drugId) {
        DrugItemEntity drugItemEntity = this.drugItemMapper.getById(drugId);
        if (drugItemEntity == null) {
            return BaseResponse.error((String)"\u8981\u5220\u9664\u7684\u836f\u54c1\u4e0d\u5b58\u5728");
        }
        this.drugItemMapper.deleteById(drugId);
        this.mosDrugItemUsageRelMapper.deleteByDrugId(drugId);
        this.drugAliasMapper.deleteByDrugId(drugId);
        this.mosDrugItemBarCodeService.deleteByDrugId(drugId);
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> bmUpdateDrugItem(BMAddDrugItemVO vo) {
        DrugItemEntity byName;
        List byBarCode;
        Set drugIdSet;
        String drugItemId = vo.getDrugItemId();
        DrugItemEntity drugItemEntity = this.drugItemMapper.getById(drugItemId);
        log.info("\u8981\u4fee\u6539\u7684\u836f\u54c1\u4fe1\u606f1:{}", (Object)JSON.toJSONString((Object)drugItemEntity));
        if (drugItemEntity == null) {
            return BaseResponse.error((String)"\u8981\u4fee\u6539\u7684\u836f\u54c1\u4e0d\u5b58\u5728");
        }
        DrugItemEntity drugItemEntityByCommonCode = this.drugItemMapper.getByCommonCodeNew(vo.getAppCode(), vo.getHospitalId(), vo.getCommonCode());
        if (drugItemEntityByCommonCode != null && !drugItemEntityByCommonCode.getxId().equals(drugItemId)) {
            return BaseResponse.error((String)"\u836f\u54c1\u81ea\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        if (CollUtil.isNotEmpty((Collection)vo.getDrugBarCodeList()) && CollUtil.isNotEmpty(drugIdSet = (byBarCode = this.mosDrugItemBarCodeService.getByBarCodes(vo.getHospitalId(), vo.getDrugBarCodeList())).stream().map(MosDrugItemBarCodeEntity::getDrugId).collect(Collectors.toSet()))) {
            if (drugIdSet.size() > 1) {
                return BaseResponse.error((String)"\u836f\u54c1\u6761\u7801\u4e0d\u80fd\u91cd\u590d");
            }
            MosDrugItemBarCodeEntity mosDrugItemBarCodeEntity = (MosDrugItemBarCodeEntity)byBarCode.get(0);
            if (!mosDrugItemBarCodeEntity.getDrugId().equals(drugItemId)) {
                return BaseResponse.error((String)"\u836f\u54c1\u6761\u7801\u4e0d\u80fd\u91cd\u590d");
            }
        }
        if ((byName = this.drugItemMapper.getByName(vo.getAppCode(), vo.getHospitalId(), vo.getCommonName() + vo.getManufacturer(), vo.getDrugSpec())) != null && !byName.getxId().equals(drugItemId)) {
            return BaseResponse.error((String)"\u836f\u54c1\u540d\u79f0+\u89c4\u683c+\u751f\u4ea7\u4f01\u4e1a\u4e0d\u80fd\u91cd\u590d");
        }
        this.updateDrug(drugItemEntity, vo);
        this.updateUsage(drugItemId, vo);
        this.updateAlias(vo);
        this.updatePrice(vo);
        this.updateBarCode(vo);
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public BaseResponse<BMAddDrugItemVO> bmFindDrugItemById(String drugId) {
        List barCodeList;
        DrugItemEntity entity = this.drugItemMapper.getById(drugId);
        if (entity == null || entity.getStatus() == 0) {
            return BaseResponse.error((String)"\u836f\u54c1\u4e0d\u5b58\u5728");
        }
        BMAddDrugItemVO drugItemDto = (BMAddDrugItemVO)BeanUtil.copyProperties((Object)entity, BMAddDrugItemVO.class, (String[])new String[0]);
        List list = this.drugAliasMapper.getByDrugId(drugId);
        drugItemDto.setDrugAlias(list.stream().map(DrugAliasEntity::getDrugAlias).collect(Collectors.toList()));
        DrugItemUsageRelEntity byDrugId = this.mosDrugItemUsageRelMapper.getByDrugId(drugId);
        if (byDrugId != null) {
            drugItemDto.setUsageId(byDrugId.getUsageId());
        }
        if (CollUtil.isNotEmpty((Collection)(barCodeList = this.mosDrugItemBarCodeService.getByDrugId(drugId)))) {
            drugItemDto.setDrugBarCodes(barCodeList.stream().map(MosDrugItemBarCodeEntity::getBarCode).collect(Collectors.joining(",")));
            drugItemDto.setDrugBarCodeList(barCodeList.stream().map(MosDrugItemBarCodeEntity::getBarCode).collect(Collectors.toList()));
        }
        return BaseResponse.success((Object)drugItemDto);
    }

    public BaseResponse<String> bmImportItem(String appCode, String hospitalId, String hospitalName, Boolean update, Integer drugType, String pharmaceuticalCompanyId, MultipartFile file, HttpServletResponse response) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u836f\u54c1\uff0cappCode:{}, hospitalId:{}, hospitalName:{}, update:{}, drugType:{}, pharmaceuticalCompanyId:{}", new Object[]{appCode, hospitalId, hospitalName, update, drugType, pharmaceuticalCompanyId});
        try {
            log.info("\u5f00\u59cb\u89e3\u6790excel");
            List importDrugItemExcels = ExcelUtils.importExcel((MultipartFile)file, (Integer)0, (Integer)2, ImportDrugItemExcel.class);
            log.info("\u5f00\u59cb\u6821\u9a8c\u6570\u636e\u683c\u5f0f\uff0cimportDrugItemExcels.size:{}", (Object)importDrugItemExcels.size());
            List errorList = this.checkFormat(importDrugItemExcels);
            log.info("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
            this.batchImport(appCode, hospitalId, hospitalName, update, importDrugItemExcels, errorList, drugType);
            if (drugType == 2 && StringUtils.isNotEmpty((String)pharmaceuticalCompanyId)) {
                log.info("\u5f00\u59cb\u540c\u6b65\u836f\u54c1\u5230\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0, importDrugItemExcels.size:{}", (Object)importDrugItemExcels.size());
                this.threadPoolExecutor.execute(() -> this.syncHospitalDrug(appCode, hospitalId, hospitalName, pharmaceuticalCompanyId, importDrugItemExcels));
            }
            if (CollUtil.isNotEmpty((Collection)errorList)) {
                log.info("\u5f00\u59cb\u5904\u7406\u9519\u8bef\u6570\u636e");
                ExcelUtils.exportExcel((List)errorList, null, (String)"\u836f\u54c1\u5bfc\u5165\u9519\u8bef\u6570\u636e", ImportDrugItemErrorExcel.class, (String)"\u836f\u54c1\u5bfc\u5165\u9519\u8bef\u6570\u636e", (HttpServletResponse)response);
            }
            log.info("\u5bfc\u5165\u5b8c\u6210");
            return BaseResponse.success((Object)"\u5bfc\u5165\u6210\u529f");
        }
        catch (IOException e) {
            log.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"\u5bfc\u5165\u5931\u8d25");
        }
    }

    public BaseResponse<List<BMDrugItemResDto>> queryByBarCodes(String appCode, String hospitalId, Set<String> barCodeSet) {
        List list = this.drugItemMapper.queryByBarCodes(appCode, hospitalId, barCodeSet);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<String> export(PageDrugListVO vo, HttpServletResponse response) {
        List list = this.drugItemMapper.getExcelPageList(vo);
        ArrayList excelList = new ArrayList();
        list.forEach(bean -> {
            ExportDrugItemExcel excel = new ExportDrugItemExcel();
            excel.setHospitalName(bean.getHospitalName());
            excel.setCommonName(bean.getCommonName());
            excel.setCommonCode(bean.getCommonCode());
            excel.setProductName(bean.getProductName());
            excel.setDrugAlias(bean.getDrugAlias());
            excel.setManufacturer(bean.getManufacturer());
            excel.setDrugApprovalNumber(bean.getDrugApprovalNumber());
            excel.setDrugBarCode(bean.getDrugBarCode());
            excel.setDosageForm(bean.getDosageForm());
            excel.setUsage(bean.getUsageDesc());
            excel.setStorageConditions(bean.getStorageConditions());
            excel.setPrice(bean.getPrice());
            excel.setDrugAttributeName(DrugAttributeEnum.getValue((Integer)bean.getDrugAttribute()));
            excel.setDrugSaleChannelName(DrugSaleChannelEnum.getValue((Integer)bean.getDrugSaleChannel()));
            excel.setDrugRemarkName(DrugRemarkEnum.getValue((Integer)bean.getDrugRemark()));
            excel.setTypeName(DrugTypeNewEnum.getValue((Integer)bean.getType()));
            excel.setDrugProperty(bean.getDrugProperty());
            excel.setInsuranceTypeName(InsuranceTypeEnum.getValue((Integer)bean.getInsuranceType()));
            excel.setSpecialNewTypeName(SpecialNewTypeEnum.getValue((Integer)bean.getSpecialNewType()));
            excel.setDrugSpec(bean.getDrugSpec());
            excel.setWholePackingUnitId(bean.getWholePackingUnitName());
            excel.setMinBillPackingUnitId(bean.getMinBillPackingUnitName());
            excel.setMinBillPackingNum(bean.getMinBillPackingNum());
            excel.setMeasureUnitId(bean.getMeasureUnitName());
            excel.setMeasureNum(bean.getMeasureNum());
            excelList.add(excel);
        });
        try {
            ExcelUtils.exportExcel(excelList, (String)"\u836f\u54c1\u4fe1\u606f", (String)"\u836f\u54c1\u4fe1\u606f", ExportDrugItemExcel.class, (String)"\u836f\u54c1\u4fe1\u606f", (boolean)true, (HttpServletResponse)response);
            return BaseResponse.success((Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u9519\u8bef", (Throwable)e);
            return BaseResponse.error((String)"\u5bfc\u51fa\u5931\u8d25");
        }
    }

    public BaseResponse<String> checkPatientDrugs(CheckPatientDrugsReqDto reqDto) {
        log.info("\u5f00\u59cb\u6821\u9a8c\u60a3\u8005\u836f\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)reqDto));
        DrugItemEntity drugItem = this.drugItemMapper.getById(reqDto.getDrugId());
        log.info("\u67e5\u8be2\u836f\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)drugItem));
        if (drugItem == null) {
            return BaseResponse.error((String)"\u836f\u54c1\u4e0d\u5b58\u5728");
        }
        String productCode = drugItem.getProductCode();
        if (StringUtils.isEmpty((String)productCode)) {
            return BaseResponse.success((Object)"\u836f\u54c1\u53ef\u8d2d\u4e70");
        }
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryByUserIdLatest(reqDto.getPatientId());
        if (mainEntity == null) {
            return BaseResponse.success((Object)"\u836f\u54c1\u53ef\u8d2d\u4e70");
        }
        List drugDetailList = this.drugDetailMapper.getProductCodeByMainId(mainEntity.getxId());
        log.info("\u67e5\u8be2\u60a3\u8005\u5386\u53f2\u7528\u836f\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)drugDetailList));
        List collected = drugDetailList.stream().filter(drugProductCodeDTO -> productCode.equals(drugProductCodeDTO.getProductCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collected)) {
            return BaseResponse.success((Object)"\u836f\u54c1\u53ef\u8d2d\u4e70");
        }
        List drugResList = collected.stream().filter(drugProductCodeDTO -> {
            LocalDate startDate = drugProductCodeDTO.getxCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return ChronoUnit.DAYS.between(startDate, LocalDate.now()) < (long)drugProductCodeDTO.getDuration().intValue();
        }).collect(Collectors.toList());
        if (!drugResList.isEmpty()) {
            log.info("\u8be5\u60a3\u8005\u5df2\u8d2d\u4e70\u8fc7\u8be5\u836f\u54c1\uff0c\u8bf7\u52ff\u91cd\u590d\u8d2d\u4e70==\u836f\u54c1\u4fe1\u606f{}", (Object)JSON.toJSONString(drugResList));
            DrugProductCodeDTO drugDetail = (DrugProductCodeDTO)drugResList.get(0);
            return BaseResponse.error((String)(drugDetail.getDrugName() + "\u836f\u54c1\u4e0a\u6b21\u8d2d\u4e70\u65f6\u95f4\u4e3a" + DateUtils.getYMD((Date)drugDetail.getxCreateTime()) + ",\u4e14\u7528\u836f\u5929\u6570\u662f" + drugDetail.getDuration() + "\u5929,\u8bf7\u52ff\u91cd\u590d\u8d2d\u4e70"));
        }
        return BaseResponse.success((Object)"\u836f\u54c1\u53ef\u8d2d\u4e70");
    }

    public DrugItemQueryResultDTO queryDrugByBarCode(QueryDrugByBarCodeVO req) {
        DrugItemListV2DTO drugItemListV2DTO;
        log.info("\u6839\u636e\u6761\u7801\u67e5\u8be2\u836f\u54c1\u5165\u53c2===\u300b,{}", (Object)JSON.toJSONString((Object)req));
        MosDrugItemBarCodeEntity byBarCode = this.mosDrugItemBarCodeService.getByBarCode(req.getBarCode());
        log.info("byBarCode===>,{}", (Object)JSON.toJSONString((Object)byBarCode));
        if (byBarCode == null) {
            return null;
        }
        DrugItemEntity drugItemEntity = this.drugItemMapper.getById(byBarCode.getDrugId());
        log.info("drugItemEntity===>,{}", (Object)JSON.toJSONString((Object)drugItemEntity));
        if (drugItemEntity == null) {
            return null;
        }
        DrugIteamListReqVO reqVO = new DrugIteamListReqVO();
        reqVO.setAppCode(drugItemEntity.getAppCode());
        reqVO.setDrugType(Integer.valueOf(drugItemEntity.getType() == 4 ? 1 : drugItemEntity.getType()));
        reqVO.setPharmaceuticalCompanyId(req.getPharmaceuticalCompanyId());
        reqVO.setSearchParams(drugItemEntity.getCommonName());
        List preDrugs = this.drugMainManage.getPreDrugs(reqVO);
        if (CollectionUtils.isNotEmpty((Collection)preDrugs) && (drugItemListV2DTO = (DrugItemListV2DTO)preDrugs.stream().filter(drug -> drug.getHospitalDrugId().equals(drugItemEntity.getxId())).findFirst().orElse(null)) != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(drugItemListV2DTO.getHospitalDrugId());
            List byDrugIds = this.drugItemMapper.getByDrugIds(ids, drugItemEntity.getAppCode());
            if (CollectionUtils.isNotEmpty((Collection)byDrugIds)) {
                return (DrugItemQueryResultDTO)byDrugIds.get(0);
            }
        }
        return null;
    }

    private void syncHospitalDrug(String appCode, String hospitalId, String hospitalName, String pharmaceuticalCompanyId, List<ImportDrugItemExcel> importDrugItemExcels) {
        try {
            SyncHospitalDrugVO syncHospitalDrugVO = new SyncHospitalDrugVO();
            syncHospitalDrugVO.setAppCode(appCode);
            syncHospitalDrugVO.setHospitalId(hospitalId);
            syncHospitalDrugVO.setPharmaceuticalCompanyId(pharmaceuticalCompanyId);
            syncHospitalDrugVO.setStatus(Integer.valueOf(1));
            ArrayList drugList = new ArrayList();
            importDrugItemExcels.forEach(bean -> {
                BMDrugItemResDto dto = new BMDrugItemResDto();
                dto.setDrugItemId(bean.getXId());
                dto.setHospitalId(hospitalId);
                dto.setHospitalName(hospitalName);
                dto.setCommonCode(bean.getCommonCode());
                dto.setCommonName(bean.getCommonName());
                dto.setProductName(bean.getProductName());
                dto.setDrugAlias(bean.getDrugAlias());
                dto.setManufacturer(bean.getManufacturer());
                dto.setDrugApprovalNumber(bean.getDrugApprovalNumber());
                dto.setDrugBarCode(bean.getDrugBarCode());
                dto.setDosageForm(bean.getDosageForm());
                dto.setUsageId(bean.getUsageId());
                dto.setUsageDesc(bean.getUsage());
                dto.setStorageConditions(bean.getStorageConditions());
                dto.setPrice(bean.getPrice());
                dto.setDrugRemark(bean.getDrugRemark());
                dto.setDrugRemarkName(bean.getDrugRemarkName());
                dto.setType(bean.getType());
                dto.setTypeName(bean.getTypeName());
                dto.setDrugProperty(bean.getDrugProperty());
                dto.setInsuranceType(bean.getInsuranceType());
                dto.setInsuranceTypeName(bean.getInsuranceTypeName());
                dto.setSpecialNewType(bean.getSpecialNewType());
                dto.setSpecialNewTypeName(bean.getSpecialNewTypeName());
                dto.setDrugSpec(bean.getDrugSpec());
                dto.setWholePackingUnitId(bean.getWholePackingUnitId());
                dto.setWholePackingUnitName(bean.getWholePackingUnit());
                dto.setMinBillPackingUnitId(bean.getMinBillPackingUnitId());
                dto.setMinBillPackingUnitName(bean.getMinBillPackingUnit());
                dto.setMinBillPackingNum(new BigDecimal(bean.getMinBillPackingNum()));
                dto.setMeasureUnitId(bean.getMeasureUnitId());
                dto.setMeasureUnitName(bean.getMeasureUnit());
                dto.setMeasureNum(new BigDecimal(bean.getMeasureNum()));
                drugList.add(dto);
            });
            syncHospitalDrugVO.setDrugList(drugList);
            String jsonString = JSONObject.toJSONString((Object)syncHospitalDrugVO);
            log.info("\u5f00\u59cb\u8c03\u7528\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u63a5\u53e3");
            String syncHospitalDrugUrl = URLConstant.SYNC_HOSPITAL_DRUG_URL;
            String url = "https://ihos.chinachdu.com/" + syncHospitalDrugUrl;
            String result = HttpUtils.doPost((String)url, (String)jsonString, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u540c\u6b65\u836f\u54c1\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            JSONObject res = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            if (!ReturnCodeEnum.SUCCEED.getValue().equals(res.get((Object)"code"))) {
                log.error("\u540c\u6b65\u836f\u54c1\u5230\u836f\u5546\u5f02\u5e38\uff0cerror\uff1a{}", res.get((Object)"msg"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    private void batchImport(String appCode, String hospitalId, String hospitalName, Boolean update, List<ImportDrugItemExcel> importDrugItemExcels, List<ImportDrugItemErrorExcel> errorList, Integer drugType) {
        if (CollUtil.isEmpty(importDrugItemExcels)) {
            return;
        }
        Set wholePackingUnitSet = importDrugItemExcels.stream().map(a -> a.getWholePackingUnit().trim()).collect(Collectors.toSet());
        Map<String, DrugUnitEntity> wholePackingUnitMap = this.mosDrugUnitMapper.queryUnitByType(Integer.valueOf(1), wholePackingUnitSet).stream().collect(Collectors.toMap(DrugUnitEntity::getUnitName, a -> a, (k1, k2) -> k1));
        Set minBillPackingUnitSet = importDrugItemExcels.stream().map(a -> a.getMinBillPackingUnit().trim()).collect(Collectors.toSet());
        Map<String, DrugUnitEntity> minBillPackingUnitMap = this.mosDrugUnitMapper.queryUnitByType(Integer.valueOf(3), minBillPackingUnitSet).stream().collect(Collectors.toMap(DrugUnitEntity::getUnitName, a -> a, (k1, k2) -> k1));
        Set measureUnitSet = importDrugItemExcels.stream().map(a -> a.getMeasureUnit().trim()).collect(Collectors.toSet());
        Map<String, DrugUnitEntity> measureUnitMap = this.mosDrugUnitMapper.queryUnitByType(Integer.valueOf(4), measureUnitSet).stream().collect(Collectors.toMap(DrugUnitEntity::getUnitName, a -> a, (k1, k2) -> k1));
        List dbList = this.drugItemMapper.getAllByHospital(appCode, hospitalId);
        Map<String, HospitalDrugVO> commonCodeMap = dbList.stream().collect(Collectors.toMap(HospitalDrugVO::getCommonCode, a -> a, (k1, k2) -> k1));
        Map<String, HospitalDrugVO> nameMap = dbList.stream().collect(Collectors.toMap(a -> a.getCommonName() + a.getDrugSpec() + a.getManufacturer() + a.getPrice().setScale(2, RoundingMode.HALF_UP).toString(), a -> a, (k1, k2) -> k1));
        Map barCodeMap = this.coverMap(dbList);
        Map<String, DrugUsageEntity> drugUsageMap = null;
        Set usageSet = importDrugItemExcels.stream().filter(a -> StringUtil.isNotEmpty((String)a.getUsage())).map(a -> a.getUsage().trim()).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(usageSet)) {
            drugUsageMap = this.mosDrugUsageMapper.getByDescSet(usageSet, null).stream().collect(Collectors.toMap(DrugUsageEntity::getUsageDesc, a -> a, (k1, k2) -> k1));
        }
        List aliasList = this.drugAliasMapper.getByOrganCode(appCode);
        Map<String, List<DrugAliasEntity>> aliasMap = aliasList.stream().collect(Collectors.groupingBy(a -> a.getDrugId().trim()));
        ArrayList<DrugItemEntity> insertItemList = new ArrayList<DrugItemEntity>();
        ArrayList<DrugItemEntity> updateItemList = new ArrayList<DrugItemEntity>();
        ArrayList insertBarCodeList = new ArrayList();
        ArrayList insertDrugPriceList = new ArrayList();
        ArrayList updateDrugPriceList = new ArrayList();
        ArrayList insertDrguUsageRelList = new ArrayList();
        ArrayList updateDrguUsageRelList = new ArrayList();
        ArrayList insertAliasList = new ArrayList();
        ArrayList deleteAliasList = new ArrayList();
        Iterator<ImportDrugItemExcel> iterator = importDrugItemExcels.iterator();
        while (iterator.hasNext()) {
            DrugItemEntity entity;
            String drugBarCode;
            ImportDrugItemExcel bean = iterator.next();
            String nameKey = bean.getCommonName() + bean.getDrugSpec() + bean.getManufacturer() + bean.getPrice().setScale(2, RoundingMode.HALF_UP).toString();
            HashSet<String> idSet = new HashSet<String>();
            HospitalDrugVO hospitalDrugVO = new HospitalDrugVO();
            if (drugType == 1 && commonCodeMap.containsKey(bean.getCommonCode())) {
                hospitalDrugVO = commonCodeMap.get(bean.getCommonCode());
                idSet.add(hospitalDrugVO.getXId());
            }
            if (nameMap.containsKey(nameKey)) {
                hospitalDrugVO = nameMap.get(nameKey);
                idSet.add(hospitalDrugVO.getXId());
            }
            if (StringUtil.isNotEmpty((String)(drugBarCode = bean.getDrugBarCode()))) {
                for (String barCode : drugBarCode.split(",")) {
                    if (!barCodeMap.containsKey(barCode)) continue;
                    hospitalDrugVO = (HospitalDrugVO)barCodeMap.get(barCode);
                    idSet.add(hospitalDrugVO.getXId());
                }
            }
            StringJoiner sj = new StringJoiner(";");
            if (!idSet.isEmpty()) {
                if (!update.booleanValue()) {
                    log.info("\u5ffd\u7565\u7684\uff1a{}", (Object)JSONObject.toJSONString((Object)bean));
                    iterator.remove();
                    continue;
                }
                entity = new DrugItemEntity();
                if (idSet.size() > 1) {
                    sj.add("\u836f\u54c1\u4fe1\u606f\u5339\u914d\u5230\u591a\u6761\u5df2\u5b58\u5728\u6570\u636e");
                } else {
                    String xId = hospitalDrugVO.getXId();
                    bean.setXId(xId);
                    entity.setxId(xId);
                    entity.setxCreateTime(hospitalDrugVO.getCreateTime());
                    this.buildDrugInfo(entity, hospitalDrugVO, bean, appCode, hospitalId, hospitalName, drugType);
                    this.buildBarCode(hospitalDrugVO, bean, entity, insertBarCodeList, hospitalId);
                    this.buildUnit(sj, entity, bean, wholePackingUnitMap, minBillPackingUnitMap, measureUnitMap);
                    this.buildUsage(sj, entity, bean, drugUsageMap, insertDrguUsageRelList, updateDrguUsageRelList);
                    this.buildAlias(bean, appCode, insertAliasList, deleteAliasList, aliasMap);
                    this.buildUpdatePrice(entity, bean, updateDrugPriceList);
                }
                if (sj.length() > 0) {
                    log.info(sj.toString());
                    ImportDrugItemErrorExcel errorExcel = (ImportDrugItemErrorExcel)BeanUtil.copyProperties((Object)bean, ImportDrugItemErrorExcel.class, (String[])new String[0]);
                    errorExcel.setRemark(sj.toString());
                    errorList.add(errorExcel);
                    iterator.remove();
                    continue;
                }
                updateItemList.add(entity);
                continue;
            }
            entity = new DrugItemEntity();
            String xid = UUIDUtils.getUUID();
            bean.setXId(xid);
            entity.setxId(xid);
            entity.setxCreateTime(new Date());
            this.buildDrugInfo(entity, null, bean, appCode, hospitalId, hospitalName, drugType);
            this.buildBarCode(null, bean, entity, insertBarCodeList, hospitalId);
            this.buildUnit(sj, entity, bean, wholePackingUnitMap, minBillPackingUnitMap, measureUnitMap);
            this.buildUsage(sj, entity, bean, drugUsageMap, insertDrguUsageRelList, updateDrguUsageRelList);
            this.buildAlias(bean, appCode, insertAliasList, deleteAliasList, aliasMap);
            this.buildInsertPrice(entity, bean, insertDrugPriceList);
            if (sj.length() > 0) {
                log.info(sj.toString());
                ImportDrugItemErrorExcel errorExcel = (ImportDrugItemErrorExcel)BeanUtil.copyProperties((Object)bean, ImportDrugItemErrorExcel.class, (String[])new String[0]);
                errorExcel.setRemark(sj.toString());
                errorList.add(errorExcel);
                iterator.remove();
                continue;
            }
            insertItemList.add(entity);
        }
        log.info("insertItemList.size:{}", (Object)insertItemList.size());
        if (CollectionUtils.isNotEmpty(insertItemList)) {
            this.drugItemMapper.insertBatchBM(insertItemList);
        }
        log.info("updateItemList.size:{}", (Object)updateItemList.size());
        if (CollectionUtils.isNotEmpty(updateItemList)) {
            updateItemList.forEach(item -> this.drugItemMapper.oneUpdateById(item));
        }
        log.info("insertBarCodeList.size:{}", (Object)insertBarCodeList.size());
        if (CollUtil.isNotEmpty(insertBarCodeList)) {
            this.mosDrugItemBarCodeService.batchInsert(insertBarCodeList);
        }
        log.info("insertDrugPriceList.size:{}", (Object)insertDrugPriceList.size());
        if (CollUtil.isNotEmpty(insertDrugPriceList)) {
            this.mosDrugPriceMapper.insertBatch(insertDrugPriceList);
        }
        log.info("updateDrugPriceList.size:{}", (Object)updateDrugPriceList.size());
        if (CollectionUtils.isNotEmpty(updateDrugPriceList)) {
            updateDrugPriceList.forEach(item -> this.mosDrugPriceMapper.update(item));
        }
        log.info("insertAliasList.size():{}", (Object)insertAliasList.size());
        if (CollectionUtils.isNotEmpty(insertAliasList)) {
            this.drugAliasMapper.insertBatch(insertAliasList);
        }
        log.info("deleteAliasList.size:{}", (Object)deleteAliasList.size());
        if (CollectionUtils.isNotEmpty(deleteAliasList)) {
            this.drugAliasMapper.deleteByIds(deleteAliasList);
        }
        log.info("insertDrguUsageRelList.size:{}", (Object)insertDrguUsageRelList.size());
        if (CollectionUtils.isNotEmpty(insertDrguUsageRelList)) {
            this.mosDrugItemUsageRelMapper.insertBatch(insertDrguUsageRelList);
        }
        log.info("updateDrguUsageRelList.size:{}", (Object)updateDrguUsageRelList.size());
        if (CollectionUtils.isNotEmpty(updateDrguUsageRelList)) {
            updateDrguUsageRelList.forEach(item -> this.mosDrugItemUsageRelMapper.update(item));
        }
    }

    private void buildDrugInfo(DrugItemEntity entity, HospitalDrugVO hospitalDrugVO, ImportDrugItemExcel bean, String appCode, String hospitalId, String hospitalName, Integer drugType) {
        entity.setxUpdateTime(new Date());
        entity.setProductName(bean.getProductName());
        entity.setProductCode(bean.getProductCode());
        entity.setType(bean.getType());
        entity.setCommonName(bean.getCommonName());
        entity.setManufacturer(bean.getManufacturer());
        entity.setDosageForm(bean.getDosageForm());
        entity.setSocialSecurityClass("");
        entity.setStorageConditions(bean.getStorageConditions());
        entity.setStatus(Integer.valueOf(1));
        entity.setDrugSpec(bean.getDrugSpec());
        entity.setAppCode(appCode);
        entity.setDrugApprovalNumber(bean.getDrugApprovalNumber());
        entity.setDrugProperty(bean.getDrugProperty());
        entity.setDrugDeptCode("");
        entity.setQyt("");
        entity.setHospitalId(hospitalId);
        entity.setHospitalName(hospitalName);
        entity.setHospitalDrugSpec("");
        entity.setSpecialDrugFlag("");
        entity.setDrugRemark(bean.getDrugRemark());
        if (drugType == 1) {
            if (hospitalDrugVO != null) {
                if (Objects.equals(hospitalDrugVO.getDrugAttribute(), DrugAttributeEnum.YW.getCode())) {
                    entity.setDrugAttribute(String.valueOf(DrugAttributeEnum.YNYW.getCode()));
                } else {
                    entity.setDrugAttribute(String.valueOf(hospitalDrugVO.getDrugAttribute()));
                }
            } else {
                entity.setDrugAttribute(String.valueOf(DrugAttributeEnum.YN.getCode()));
            }
            entity.setCommonCode(bean.getCommonCode());
            entity.setPrice(bean.getPrice());
        } else if (hospitalDrugVO != null) {
            if (Objects.equals(hospitalDrugVO.getDrugAttribute(), DrugAttributeEnum.YN.getCode())) {
                entity.setDrugAttribute(String.valueOf(DrugAttributeEnum.YNYW.getCode()));
            } else {
                entity.setDrugAttribute(String.valueOf(hospitalDrugVO.getDrugAttribute()));
            }
            entity.setCommonCode(hospitalDrugVO.getCommonCode());
            entity.setPrice(hospitalDrugVO.getPrice());
        } else {
            entity.setDrugAttribute(String.valueOf(DrugAttributeEnum.YW.getCode()));
            entity.setCommonCode(UUIDUtils.getUUID());
            entity.setPrice(bean.getPrice());
        }
        entity.setDrugSaleChannel(bean.getDrugSaleChannel().intValue());
        entity.setSpecialNewType(bean.getSpecialNewType().intValue());
        entity.setInsuranceType(bean.getInsuranceType().intValue());
        entity.setWholePackingNum(new BigDecimal(bean.getMinBillPackingNum()));
        entity.setMinBillPackingNum(new BigDecimal(bean.getMinBillPackingNum()));
        entity.setMeasureNum(new BigDecimal(bean.getMeasureNum()));
    }

    private void buildBarCode(HospitalDrugVO hospitalDrugVO, ImportDrugItemExcel bean, DrugItemEntity entity, List<MosDrugItemBarCodeEntity> insertBarCodeList, String hospitalId) {
        block5: {
            block6: {
                block4: {
                    if (hospitalDrugVO != null) break block4;
                    if (!StringUtils.isNotEmpty((String)bean.getDrugBarCode())) break block5;
                    for (String barCode : bean.getDrugBarCode().split(",")) {
                        MosDrugItemBarCodeEntity barCodeEntity = new MosDrugItemBarCodeEntity();
                        barCodeEntity.setHospitalId(hospitalId);
                        barCodeEntity.setBarCode(barCode);
                        barCodeEntity.setDrugId(entity.getxId());
                        insertBarCodeList.add(barCodeEntity);
                    }
                    break block5;
                }
                if (!StringUtils.isEmpty((String)hospitalDrugVO.getDrugBarCode())) break block6;
                if (!StringUtils.isNotEmpty((String)bean.getDrugBarCode())) break block5;
                for (String barCode : bean.getDrugBarCode().split(",")) {
                    MosDrugItemBarCodeEntity barCodeEntity = new MosDrugItemBarCodeEntity();
                    barCodeEntity.setHospitalId(hospitalId);
                    barCodeEntity.setBarCode(barCode);
                    barCodeEntity.setDrugId(entity.getxId());
                    insertBarCodeList.add(barCodeEntity);
                }
                break block5;
            }
            if (StringUtils.isNotEmpty((String)bean.getDrugBarCode())) {
                Set dbSet = Arrays.stream(hospitalDrugVO.getDrugBarCode().split(",")).collect(Collectors.toSet());
                for (String barCode : bean.getDrugBarCode().split(",")) {
                    if (dbSet.contains(barCode)) continue;
                    MosDrugItemBarCodeEntity barCodeEntity = new MosDrugItemBarCodeEntity();
                    barCodeEntity.setHospitalId(hospitalId);
                    barCodeEntity.setBarCode(barCode);
                    barCodeEntity.setDrugId(entity.getxId());
                    insertBarCodeList.add(barCodeEntity);
                }
            }
        }
    }

    private void buildUnit(StringJoiner sj, DrugItemEntity entity, ImportDrugItemExcel bean, Map<String, DrugUnitEntity> wholePackingUnitMap, Map<String, DrugUnitEntity> minBillPackingUnitMap, Map<String, DrugUnitEntity> measureUnitMap) {
        DrugUnitEntity drugUnitEntity;
        if (wholePackingUnitMap.containsKey(bean.getWholePackingUnit().trim())) {
            drugUnitEntity = wholePackingUnitMap.get(bean.getWholePackingUnit().trim());
            entity.setWholePackingUnitId(drugUnitEntity.getxId());
            bean.setWholePackingUnitId(drugUnitEntity.getxId());
            entity.setWholePackingUnitName(drugUnitEntity.getUnitName());
        } else {
            sj.add("\u6574\u5305\u88c5\u5355\u4f4d\u4e0d\u5b58\u5728");
        }
        if (minBillPackingUnitMap.containsKey(bean.getMinBillPackingUnit().trim())) {
            drugUnitEntity = minBillPackingUnitMap.get(bean.getMinBillPackingUnit().trim());
            entity.setStockPackingUnitId(drugUnitEntity.getxId());
            entity.setStockPackingUnitName(drugUnitEntity.getUnitName());
            entity.setSpecPackingUnitId(drugUnitEntity.getxId());
            entity.setSpecPackingUnitName(drugUnitEntity.getUnitName());
            entity.setMinBillPackingUnitId(drugUnitEntity.getxId());
            bean.setMinBillPackingUnitId(drugUnitEntity.getxId());
            entity.setMinBillPackingUnitName(drugUnitEntity.getUnitName());
        } else {
            sj.add("\u6700\u5c0f\u8ba1\u8d39\u5355\u4f4d\u4e0d\u5b58\u5728");
        }
        if (measureUnitMap.containsKey(bean.getMeasureUnit().trim())) {
            drugUnitEntity = measureUnitMap.get(bean.getMeasureUnit().trim());
            entity.setMeasureUnitId(drugUnitEntity.getxId());
            bean.setMeasureUnitId(drugUnitEntity.getxId());
            entity.setMeasureUnitName(drugUnitEntity.getUnitName());
        } else {
            sj.add("\u6700\u5c0f\u5355\u4f4d\u4e0d\u5b58\u5728");
        }
    }

    private void buildUsage(StringJoiner sj, DrugItemEntity entity, ImportDrugItemExcel bean, Map<String, DrugUsageEntity> drugUsageMap, List<DrugItemUsageRelEntity> insertDrguUsageRelList, List<DrugItemUsageRelEntity> updateDrguUsageRelList) {
        if (StringUtils.isNotEmpty((String)bean.getUsage())) {
            if (drugUsageMap != null && drugUsageMap.containsKey(bean.getUsage().trim())) {
                DrugItemUsageRelEntity usageRel = this.mosDrugItemUsageRelMapper.getByDrugId(entity.getxId());
                DrugUsageEntity drugUsageEntity = drugUsageMap.get(bean.getUsage().trim());
                bean.setUsageId(drugUsageEntity.getxId());
                if (usageRel == null) {
                    DrugItemUsageRelEntity usageRelEntity = new DrugItemUsageRelEntity();
                    usageRelEntity.setStatus(Integer.valueOf(1));
                    usageRelEntity.setDrugId(entity.getxId());
                    usageRelEntity.setUsageId(drugUsageEntity.getxId());
                    usageRelEntity.setxId(UUIDUtils.getUUID());
                    usageRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                    usageRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                    insertDrguUsageRelList.add(usageRelEntity);
                } else {
                    usageRel.setUsageId(drugUsageEntity.getxId());
                    updateDrguUsageRelList.add(usageRel);
                }
            } else {
                sj.add("\u670d\u7528\u65b9\u5f0f\u4e0d\u5b58\u5728");
            }
        }
    }

    private void buildAlias(ImportDrugItemExcel bean, String appCode, List<DrugAliasEntity> insertAliasList, List<String> deleteAliasList, Map<String, List<DrugAliasEntity>> dbAliasMap) {
        String excelAlias = bean.getDrugAlias();
        String drugId = bean.getXId();
        if (dbAliasMap != null && dbAliasMap.containsKey(drugId)) {
            List<DrugAliasEntity> dbAliasList = dbAliasMap.get(drugId);
            if (StringUtils.isEmpty((String)excelAlias)) {
                deleteAliasList.addAll(dbAliasList.stream().map(BaseEntity::getxId).collect(Collectors.toList()));
            } else {
                Set<String> excelAliasSet = Arrays.stream(excelAlias.split(",")).map(String::trim).collect(Collectors.toSet());
                dbAliasList.forEach(dbDrugAlias -> {
                    if (!excelAliasSet.contains(dbDrugAlias.getDrugAlias())) {
                        deleteAliasList.add(dbDrugAlias.getxId());
                    }
                });
                Map<String, DrugAliasEntity> dbMap = dbAliasList.stream().collect(Collectors.toMap(a -> a.getDrugAlias().trim(), a -> a, (k1, k2) -> k1));
                excelAliasSet.forEach(excelAliasName -> {
                    if (!dbMap.containsKey(excelAliasName)) {
                        DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
                        drugAliasEntity.setDrugAlias(excelAliasName);
                        drugAliasEntity.setDrugCode(drugId);
                        drugAliasEntity.setOrganCode(appCode);
                        drugAliasEntity.setDrugId(drugId);
                        drugAliasEntity.setStatus(Integer.valueOf(1));
                        drugAliasEntity.setxId(UUIDUtils.getUUID());
                        drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                        drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                        insertAliasList.add(drugAliasEntity);
                    }
                });
            }
        } else if (StringUtils.isNotEmpty((String)excelAlias)) {
            Set<String> excelAliasSet = Arrays.stream(excelAlias.split(",")).map(String::trim).collect(Collectors.toSet());
            excelAliasSet.forEach(excelAliasName -> {
                DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
                drugAliasEntity.setDrugAlias(excelAliasName);
                drugAliasEntity.setDrugCode(drugId);
                drugAliasEntity.setOrganCode(appCode);
                drugAliasEntity.setDrugId(drugId);
                drugAliasEntity.setStatus(Integer.valueOf(1));
                drugAliasEntity.setxId(UUIDUtils.getUUID());
                drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                insertAliasList.add(drugAliasEntity);
            });
        }
    }

    private void buildUpdatePrice(DrugItemEntity entity, ImportDrugItemExcel bean, List<DrugPriceEntity> updateDrugPriceList) {
        DrugPriceEntity drugPrice = new DrugPriceEntity();
        drugPrice.setDrugId(entity.getxId());
        drugPrice.setPrice(bean.getPrice());
        drugPrice.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        updateDrugPriceList.add(drugPrice);
    }

    private void buildInsertPrice(DrugItemEntity entity, ImportDrugItemExcel bean, List<DrugPriceEntity> insertDrugPriceList) {
        DrugPriceEntity drugPrice = new DrugPriceEntity();
        drugPrice.setxId(UUIDUtils.getUUID());
        drugPrice.setDrugId(entity.getxId());
        drugPrice.setPrice(bean.getPrice());
        drugPrice.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugPrice.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        insertDrugPriceList.add(drugPrice);
    }

    private Map<String, HospitalDrugVO> coverMap(List<HospitalDrugVO> dbList) {
        HashMap<String, HospitalDrugVO> map = new HashMap<String, HospitalDrugVO>();
        dbList.forEach(bean -> {
            String drugBarCode = bean.getDrugBarCode();
            if (StringUtil.isNotEmpty((String)drugBarCode)) {
                for (String barCode : drugBarCode.split(",")) {
                    map.put(barCode, (HospitalDrugVO)bean);
                }
            }
        });
        return map;
    }

    private List<ImportDrugItemErrorExcel> checkFormat(List<ImportDrugItemExcel> importDrugItemExcels) {
        ArrayList<ImportDrugItemErrorExcel> errorList = new ArrayList<ImportDrugItemErrorExcel>();
        Iterator<ImportDrugItemExcel> iterator = importDrugItemExcels.iterator();
        HashSet<String> barCodeSet = new HashSet<String>();
        HashSet<String> commonCodeSet = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        while (iterator.hasNext()) {
            ImportDrugItemExcel bean = iterator.next();
            StringJoiner sj = new StringJoiner(";");
            if (StringUtils.isNotEmpty((String)bean.getDrugBarCode())) {
                for (String barcode : bean.getDrugBarCode().split(",")) {
                    if (!barCodeSet.contains(barcode)) {
                        if (StrUtil.isNumeric((CharSequence)barcode)) {
                            barCodeSet.add(barcode);
                            continue;
                        }
                        sj.add("\u6761\u7801\u53ea\u652f\u6301\u6570\u5b57");
                        break;
                    }
                    sj.add("\u6761\u7801\u91cd\u590d");
                }
            }
            if (!commonCodeSet.contains(bean.getCommonCode())) {
                commonCodeSet.add(bean.getCommonCode());
            } else {
                sj.add("\u81ea\u7f16\u7801\u91cd\u590d");
            }
            String nameKey = bean.getCommonName() + bean.getDrugSpec() + bean.getManufacturer();
            if (!nameSet.contains(nameKey)) {
                nameSet.add(nameKey);
            } else {
                sj.add("\u540d\u79f0+\u89c4\u683c+\u751f\u4ea7\u4f01\u4e1a\u91cd\u590d");
            }
            if (StringUtils.isEmpty((String)bean.getCommonName())) {
                sj.add("\u901a\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (bean.getCommonName().length() > 40) {
                sj.add("\u901a\u7528\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516540\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isEmpty((String)bean.getCommonCode())) {
                sj.add("\u836f\u54c1\u81ea\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (bean.getCommonCode().length() > 30) {
                sj.add("\u836f\u54c1\u81ea\u7f16\u7801\u6700\u591a\u53ef\u8f93\u516530\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isNotEmpty((String)bean.getProductName()) && bean.getProductName().length() > 40) {
                sj.add("\u5546\u54c1\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516540\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isEmpty((String)bean.getManufacturer())) {
                sj.add("\u751f\u4ea7\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (bean.getManufacturer().length() > 100) {
                sj.add("\u751f\u4ea7\u4f01\u4e1a\u6700\u591a\u53ef\u8f93\u5165100\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isEmpty((String)bean.getDrugApprovalNumber())) {
                sj.add("\u6279\u51c6\u6587\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (bean.getDrugApprovalNumber().length() > 40) {
                sj.add("\u6279\u51c6\u6587\u53f7\u6700\u591a\u53ef\u8f93\u516540\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isNotEmpty((String)bean.getDrugBarCode()) && bean.getDrugBarCode().length() > 30) {
                sj.add("\u6761\u5f62\u7801\u6700\u591a\u53ef\u8f93\u516530\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isNotEmpty((String)bean.getDosageForm()) && bean.getDosageForm().length() > 10) {
                sj.add("\u836f\u54c1\u5242\u578b\u6700\u591a\u53ef\u8f93\u516510\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isNotEmpty((String)bean.getStorageConditions()) && bean.getStorageConditions().length() > 40) {
                sj.add("\u8d2e\u5b58\u6761\u4ef6\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u6587\u5b57");
            }
            if (bean.getPrice() == null) {
                sj.add("\u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)bean.getDrugSaleChannelName())) {
                sj.add("\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (DrugSaleChannelEnum.getCodeByValue((String)bean.getDrugSaleChannelName()) == 0) {
                sj.add("\u9500\u552e\u6e20\u9053\u4e0d\u5b58\u5728");
            } else {
                bean.setDrugSaleChannel(DrugSaleChannelEnum.getCodeByValue((String)bean.getDrugSaleChannelName()));
            }
            if (StringUtils.isEmpty((String)bean.getDrugRemarkName())) {
                sj.add("\u836f\u54c1\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (DrugRemarkEnum.getCodeByValue((String)bean.getDrugRemarkName()) == 0) {
                sj.add("\u836f\u54c1\u6807\u8bc6\u4e0d\u5b58\u5728");
            } else {
                bean.setDrugRemark(DrugRemarkEnum.getCodeByValue((String)bean.getDrugRemarkName()));
            }
            if (StringUtils.isEmpty((String)bean.getTypeName())) {
                sj.add("\u836f\u54c1\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (DrugTypeNewEnum.getCodeByValue((String)bean.getTypeName()) == 0) {
                sj.add("\u836f\u54c1\u7c7b\u522b\u4e0d\u5b58\u5728");
            } else {
                bean.setType(DrugTypeNewEnum.getCodeByValue((String)bean.getTypeName()));
            }
            if (StringUtils.isEmpty((String)bean.getDrugProperty())) {
                sj.add("\u836f\u54c1\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotEmpty((String)bean.getInsuranceTypeName()) && InsuranceTypeEnum.getCodeByValue((String)bean.getInsuranceTypeName()) == 0) {
                sj.add("\u533b\u4fdd\u7c7b\u578b\u4e0d\u5b58\u5728");
            } else {
                bean.setInsuranceType(InsuranceTypeEnum.getCodeByValue((String)bean.getInsuranceTypeName()));
            }
            if (StringUtils.isNotEmpty((String)bean.getSpecialNewTypeName()) && SpecialNewTypeEnum.getCodeByValue((String)bean.getSpecialNewTypeName()) == 0) {
                sj.add("\u65b0\u7279\u836f\u5206\u7c7b\u4e0d\u5b58\u5728");
            } else {
                bean.setSpecialNewType(SpecialNewTypeEnum.getCodeByValue((String)bean.getSpecialNewTypeName()));
            }
            if (StringUtils.isEmpty((String)bean.getDrugSpec())) {
                sj.add("\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (bean.getDrugSpec().length() > 50) {
                sj.add("\u89c4\u683c\u4fe1\u606f\u6700\u591a\u53ef\u8f93\u516550\u4e2a\u6587\u5b57");
            }
            if (StringUtils.isEmpty((String)bean.getWholePackingUnit())) {
                sj.add("\u6574\u5305\u88c5\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)bean.getMinBillPackingNum())) {
                sj.add("\u6574\u5305\u88c5\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!NumberUtil.isNumber((CharSequence)bean.getMinBillPackingNum())) {
                sj.add("\u6574\u5305\u88c5\u6570\u91cf\u53ea\u80fd\u662f\u6570\u5b57");
            }
            if (StringUtils.isEmpty((String)bean.getMinBillPackingUnit())) {
                sj.add("\u6700\u5c0f\u8ba1\u8d39\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)bean.getMeasureNum())) {
                sj.add("\u6700\u5c0f\u5355\u4f4d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!NumberUtil.isNumber((CharSequence)bean.getMeasureNum())) {
                sj.add("\u6700\u5c0f\u5355\u4f4d\u6570\u91cf\u53ea\u80fd\u662f\u6570\u5b57");
            }
            if (StringUtils.isEmpty((String)bean.getMeasureUnit())) {
                sj.add("\u6700\u5c0f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (sj.length() <= 0) continue;
            ImportDrugItemErrorExcel errorExcel = (ImportDrugItemErrorExcel)BeanUtil.copyProperties((Object)bean, ImportDrugItemErrorExcel.class, (String[])new String[0]);
            errorExcel.setRemark(sj.toString());
            errorList.add(errorExcel);
            iterator.remove();
        }
        return errorList;
    }

    private void updatePrice(BMAddDrugItemVO vo) {
        DrugPriceEntity drugPriceEntity = this.mosDrugPriceMapper.getByDrugId(vo.getDrugItemId());
        drugPriceEntity.setPrice(vo.getPrice());
        this.mosDrugPriceMapper.update(drugPriceEntity);
    }

    private void updateBarCode(BMAddDrugItemVO vo) {
        ArrayList<MosDrugItemBarCodeEntity> insertList = new ArrayList<MosDrugItemBarCodeEntity>();
        ArrayList<Integer> deleteList = new ArrayList<Integer>();
        if (CollUtil.isEmpty((Collection)vo.getDrugBarCodeList())) {
            List byDrugId = this.mosDrugItemBarCodeService.getByDrugId(vo.getDrugItemId());
            byDrugId.forEach(bean -> deleteList.add(bean.getId()));
        } else {
            List byBarCode = this.mosDrugItemBarCodeService.getByDrugId(vo.getDrugItemId());
            if (CollUtil.isNotEmpty((Collection)byBarCode)) {
                for (Object barCode : byBarCode) {
                    if (vo.getDrugBarCodeList().contains(barCode.getBarCode())) continue;
                    deleteList.add(barCode.getId());
                }
                Set codeSet = byBarCode.stream().map(MosDrugItemBarCodeEntity::getBarCode).collect(Collectors.toSet());
                for (String code : vo.getDrugBarCodeList()) {
                    if (codeSet.contains(code)) continue;
                    MosDrugItemBarCodeEntity entity = new MosDrugItemBarCodeEntity();
                    entity.setHospitalId(vo.getHospitalId());
                    entity.setDrugId(vo.getDrugItemId());
                    entity.setBarCode(code);
                    insertList.add(entity);
                }
            } else {
                for (String code : vo.getDrugBarCodeList()) {
                    MosDrugItemBarCodeEntity entity = new MosDrugItemBarCodeEntity();
                    entity.setHospitalId(vo.getHospitalId());
                    entity.setDrugId(vo.getDrugItemId());
                    entity.setBarCode(code);
                    insertList.add(entity);
                }
            }
        }
        if (CollUtil.isNotEmpty(insertList)) {
            this.mosDrugItemBarCodeService.batchInsert(insertList);
        }
        if (CollUtil.isNotEmpty(deleteList)) {
            this.mosDrugItemBarCodeService.batchDelete(deleteList);
        }
    }

    private void updateAlias(BMAddDrugItemVO vo) {
        if (CollUtil.isEmpty((Collection)vo.getDrugAlias())) {
            return;
        }
        String drugItemId = vo.getDrugItemId();
        List list = this.drugAliasMapper.getByDrugId(drugItemId);
        if (CollUtil.isEmpty((Collection)list)) {
            this.saveDrugAlias(vo.getDrugAlias(), vo.getCommonCode(), vo.getAppCode(), drugItemId);
        } else {
            List names = vo.getDrugAlias();
            this.compareAlias(names, list);
            if (!names.isEmpty()) {
                this.saveDrugAlias(names, vo.getCommonCode(), vo.getAppCode(), drugItemId);
            }
            if (!list.isEmpty()) {
                for (DrugAliasEntity entityda : list) {
                    entityda.setStatus(Integer.valueOf(0));
                    this.drugAliasMapper.updateById(entityda);
                }
            }
        }
    }

    private void compareAlias(List<String> listAlias, List<DrugAliasEntity> listEntity) {
        for (int i = 0; i < listAlias.size(); ++i) {
            for (int j = 0; j < listEntity.size() && !CollectionUtils.isEmpty(listAlias) && !CollectionUtils.isEmpty(listAlias); ++j) {
                if (!listAlias.get(i).equals(listEntity.get(j).getDrugAlias())) continue;
                listAlias.remove(i);
                listEntity.remove(j);
            }
        }
    }

    private void updateUsage(String drugItemId, BMAddDrugItemVO vo) {
        DrugItemUsageRelEntity usageRelEntity = this.mosDrugItemUsageRelMapper.getByDrugId(drugItemId);
        if (usageRelEntity == null) {
            this.saveUsageRel(drugItemId, vo);
        } else {
            usageRelEntity.setUsageId(vo.getUsageId());
            this.mosDrugItemUsageRelMapper.update(usageRelEntity);
        }
    }

    private void updateDrug(DrugItemEntity drugItemEntity, BMAddDrugItemVO vo) {
        BeanUtil.copyProperties((Object)vo, (Object)drugItemEntity, (String[])new String[0]);
        drugItemEntity.setxId(vo.getDrugItemId());
        drugItemEntity.setStockPackingUnitId(vo.getMinBillPackingUnitId());
        drugItemEntity.setStockPackingUnitName(vo.getMinBillPackingUnitName());
        drugItemEntity.setWholePackingNum(vo.getMinBillPackingNum());
        drugItemEntity.setSpecPackingUnitId(vo.getMinBillPackingUnitId());
        drugItemEntity.setSpecPackingUnitName(vo.getMinBillPackingUnitName());
        log.info("\u8981\u4fee\u6539\u7684\u836f\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)drugItemEntity));
        this.drugItemMapper.updateById(drugItemEntity);
    }

    private String saveDrug(BMAddDrugItemVO vo) {
        DrugItemEntity entity = (DrugItemEntity)BeanUtil.copyProperties((Object)vo, DrugItemEntity.class, (String[])new String[0]);
        entity.setStockPackingUnitId(vo.getMinBillPackingUnitId());
        entity.setStockPackingUnitName(vo.getMinBillPackingUnitName());
        entity.setWholePackingNum(vo.getMinBillPackingNum());
        entity.setSpecPackingUnitId(vo.getMinBillPackingUnitId());
        entity.setSpecPackingUnitName(vo.getMinBillPackingUnitName());
        String xId = UUIDUtils.getUUID();
        entity.setxId(xId);
        entity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        entity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        entity.setStatus(Integer.valueOf(1));
        entity.setProductCode(vo.getProductCode());
        this.drugItemMapper.insert(entity);
        return xId;
    }

    private void saveUsageRel(String drugId, BMAddDrugItemVO vo) {
        DrugItemUsageRelEntity usageRelEntity = new DrugItemUsageRelEntity();
        usageRelEntity.setStatus(Integer.valueOf(1));
        usageRelEntity.setDrugId(drugId);
        usageRelEntity.setUsageId(vo.getUsageId());
        usageRelEntity.setxId(UUIDUtils.getUUID());
        usageRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        usageRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.mosDrugItemUsageRelMapper.insert(usageRelEntity);
    }

    private void saveDrugAlias(List<String> list, String commonCode, String appCode, String drugId) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        ArrayList<DrugAliasEntity> aliaList = new ArrayList<DrugAliasEntity>();
        for (String drugAlia : list) {
            DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
            drugAliasEntity.setDrugAlias(drugAlia);
            drugAliasEntity.setDrugCode(commonCode);
            drugAliasEntity.setOrganCode(appCode);
            drugAliasEntity.setDrugId(drugId);
            drugAliasEntity.setStatus(Integer.valueOf(1));
            drugAliasEntity.setxId(UUIDUtils.getUUID());
            drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            aliaList.add(drugAliasEntity);
        }
        this.drugAliasMapper.insertBatch(aliaList);
    }

    private void saveDrugPrice(String drugId, BMAddDrugItemVO vo) {
        DrugPriceEntity priceEntity = new DrugPriceEntity();
        priceEntity.setDrugId(drugId);
        priceEntity.setPrice(vo.getPrice());
        priceEntity.setxId(UUIDUtils.getUUID());
        priceEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        priceEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.mosDrugPriceMapper.insert(priceEntity);
    }

    private void saveDrugBarCode(String hospitalId, String drugId, List<String> drugBarCodeList) {
        if (CollUtil.isEmpty(drugBarCodeList)) {
            return;
        }
        ArrayList list = new ArrayList();
        drugBarCodeList.forEach(barcode -> {
            MosDrugItemBarCodeEntity entity = new MosDrugItemBarCodeEntity();
            entity.setHospitalId(hospitalId);
            entity.setDrugId(drugId);
            entity.setBarCode(barcode);
            list.add(entity);
        });
        this.mosDrugItemBarCodeService.batchInsert(list);
    }
}

